/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.internal.core.scanner.lib;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.EnumConstantSignature;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.jboss.tools.common.model.project.ext.IValueInfo;
import org.jboss.tools.common.model.project.ext.impl.ValueInfo;
import org.jboss.tools.seam.core.BeanType;
import org.jboss.tools.seam.core.BijectedAttributeType;
import org.jboss.tools.seam.core.SeamComponentMethodType;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.AbstractContextVariable;
import org.jboss.tools.seam.internal.core.BijectedAttribute;
import org.jboss.tools.seam.internal.core.DataModelSelectionAttribute;
import org.jboss.tools.seam.internal.core.SeamAnnotatedFactory;
import org.jboss.tools.seam.internal.core.SeamComponentMethod;
import org.jboss.tools.seam.internal.core.SeamJavaComponentDeclaration;
import org.jboss.tools.seam.internal.core.SeamMessages;
import org.jboss.tools.seam.internal.core.scanner.LoadedDeclarations;
import org.jboss.tools.seam.internal.core.scanner.Util;
import org.jboss.tools.seam.internal.core.scanner.java.SeamAnnotations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeScanner
implements SeamAnnotations {
    public boolean isLikelyComponentSource(ClassFileReader cls) {
        return cls != null && this.isSeamAnnotatedClass(cls);
    }

    public LoadedDeclarations parse(IType type, ClassFileReader cls, IPath path) {
        if (!this.isLikelyComponentSource(cls)) {
            return null;
        }
        LoadedDeclarations ds = new LoadedDeclarations();
        SeamJavaComponentDeclaration component = new SeamJavaComponentDeclaration();
        component.setSourcePath(path);
        component.setId(type);
        component.setType(type);
        component.setClassName(type.getFullyQualifiedName());
        this.process(cls, component, ds);
        ds.getComponents().add(component);
        int i = 0;
        while (i < ds.getFactories().size()) {
            AbstractContextVariable f = (AbstractContextVariable)((Object)ds.getFactories().get(i));
            f.setSourcePath(path);
            f.getId();
            ++i;
        }
        return ds;
    }

    boolean isSeamAnnotatedClass(ClassFileReader cls) {
        if (cls == null || (cls.getModifiers() & 0x200) > 0) {
            return false;
        }
        IBinaryAnnotation[] as = cls.getAnnotations();
        if (as != null) {
            int i = 0;
            while (i < as.length) {
                String type = TypeScanner.getTypeName(as[i]);
                if (Util.isSeamAnnotationType(type)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String getTypeName(IBinaryAnnotation a) {
        if (a.getTypeName() == null) {
            return "";
        }
        String t = new String(a.getTypeName());
        if (t.startsWith("L") && t.endsWith(";")) {
            t = t.substring(1, t.length() - 1);
        }
        t = t.replace('/', '.');
        return t;
    }

    Map<String, IBinaryAnnotation> getSeamAnnotations(IBinaryAnnotation[] as) {
        if (as == null || as.length == 0) {
            return null;
        }
        HashMap<String, IBinaryAnnotation> map = null;
        int i = 0;
        while (i < as.length) {
            String type = TypeScanner.getTypeName(as[i]);
            if (Util.isSeamAnnotationType(type)) {
                if (map == null) {
                    map = new HashMap<String, IBinaryAnnotation>();
                }
                map.put(type, as[i]);
            }
            ++i;
        }
        return map;
    }

    private void process(ClassFileReader cls, SeamJavaComponentDeclaration component, LoadedDeclarations ds) {
        int i;
        Map<String, IBinaryAnnotation> map = this.getSeamAnnotations(cls.getAnnotations());
        if (map != null) {
            String scope;
            String name;
            IBinaryAnnotation a = map.get("org.jboss.seam.annotations.Name");
            if (a != null && (name = TypeScanner.getValue(a, "value")) != null) {
                component.setName(name);
            }
            if ((a = map.get("org.jboss.seam.annotations.Scope")) != null && (scope = TypeScanner.getValue(a, "value")) != null) {
                component.setScope(scope.toString());
            }
            if ((a = map.get("org.jboss.seam.annotations.Install")) != null) {
                String precedence = TypeScanner.getValue(a, "precedence");
                try {
                    i = Integer.parseInt(precedence);
                    component.setPrecedence(i);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        HashMap<BeanType, IValueInfo> types = new HashMap<BeanType, IValueInfo>();
        int i2 = 0;
        while (i2 < BeanType.values().length) {
            BeanType t = BeanType.values()[i2];
            IBinaryAnnotation a = map.get(t.getAnnotationType());
            if (a != null) {
                ValueInfo v = new ValueInfo();
                v.setValue("true");
                types.put(t, (IValueInfo)v);
            }
            ++i2;
        }
        if (!types.isEmpty()) {
            component.setTypes(types);
        }
        IBinaryMethod[] ms = null;
        try {
            ms = cls.getMethods();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        if (ms != null) {
            i = 0;
            while (i < ms.length) {
                this.process(ms[i], component, ds);
                ++i;
            }
        }
        IBinaryField[] fs = null;
        try {
            fs = cls.getFields();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        if (fs != null) {
            int i3 = 0;
            while (i3 < fs.length) {
                ++i3;
            }
        }
    }

    private void process(IBinaryMethod m, SeamJavaComponentDeclaration component, LoadedDeclarations ds) {
        Map<String, IBinaryAnnotation> map = this.getSeamAnnotations(m.getAnnotations());
        if (map == null || map.isEmpty()) {
            return;
        }
        IBinaryAnnotation a = map.get("org.jboss.seam.annotations.Factory");
        if (a != null) {
            this.processFactory(m, a, component, ds);
        }
        this.processBijection(m, map, component, ds);
        this.processComponentMethod(m, map, component, ds);
    }

    private void processFactory(IBinaryMethod m, IBinaryAnnotation a, SeamJavaComponentDeclaration component, LoadedDeclarations ds) {
        String autoCreate;
        if (a == null) {
            return;
        }
        String name = TypeScanner.getValue(a, "value");
        if (name == null || name.length() == 0) {
            name = new String(m.getSelector());
        }
        SeamAnnotatedFactory factory = "org.jboss.seam.international.messages".equals(name) && new String(m.getSelector()).equals("getMessages") ? new SeamMessages() : new SeamAnnotatedFactory();
        factory.setParentDeclaration(component);
        factory.setSourcePath(component.getSourcePath());
        ds.getFactories().add(factory);
        IMethod im = this.findIMethod(component, m);
        factory.setId(im);
        factory.setSourceMember((IMember)im);
        factory.setName(name);
        String scope = TypeScanner.getValue(a, "scope");
        if (scope != null) {
            factory.setScopeAsString(scope.toString());
        }
        if ((autoCreate = TypeScanner.getValue(a, "autoCreate")) instanceof Boolean) {
            factory.setAutoCreate((Boolean)((Object)autoCreate));
        }
    }

    private void processBijection(IBinaryMethod m, Map<String, IBinaryAnnotation> map, SeamJavaComponentDeclaration component, LoadedDeclarations ds) {
        HashMap<BijectedAttributeType, IBinaryAnnotation> as = new HashMap<BijectedAttributeType, IBinaryAnnotation>();
        ArrayList<BijectedAttributeType> types = new ArrayList<BijectedAttributeType>();
        IBinaryAnnotation main = null;
        int i = 0;
        while (i < BijectedAttributeType.values().length) {
            IBinaryAnnotation a = map.get(BijectedAttributeType.values()[i].getAnnotationType());
            if (a != null) {
                as.put(BijectedAttributeType.values()[i], a);
                if (main == null) {
                    main = a;
                }
                types.add(BijectedAttributeType.values()[i]);
            }
            ++i;
        }
        if (as.isEmpty()) {
            return;
        }
        boolean isDataModelSelectionType = !((BijectedAttributeType)types.get(0)).isUsingMemberName();
        BijectedAttribute att = !isDataModelSelectionType ? new BijectedAttribute() : new DataModelSelectionAttribute();
        component.addBijectedAttribute(att);
        att.setTypes(types.toArray(new BijectedAttributeType[0]));
        String name = TypeScanner.getValue(main, "value");
        att.setValue(name);
        if (name == null || name.length() == 0 || isDataModelSelectionType) {
            name = new String(m.getSelector());
        }
        att.setName(name);
        String scope = TypeScanner.getValue(main, "scope");
        if (scope != null) {
            att.setScopeAsString(scope.toString());
        }
        IMethod im = this.findIMethod(component, m);
        att.setSourceMember((IMember)im);
    }

    void processComponentMethod(IBinaryMethod m, Map<String, IBinaryAnnotation> map, SeamJavaComponentDeclaration component, LoadedDeclarations ds) {
        SeamComponentMethod cm = null;
        int i = 0;
        while (i < SeamComponentMethodType.values().length) {
            SeamComponentMethodType type = SeamComponentMethodType.values()[i];
            IBinaryAnnotation a = map.get(type.getAnnotationType());
            if (a != null) {
                if (cm == null) {
                    cm = new SeamComponentMethod();
                    component.addMethod(cm);
                    IMethod im = this.findIMethod(component, m);
                    cm.setSourceMember((IMember)im);
                    cm.setId(im);
                }
                cm.getTypes().add(type);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getValue(IBinaryAnnotation a, String method) {
        try {
            IBinaryElementValuePair[] ps = a.getElementValuePairs();
            if (ps == null) return null;
            int i = 0;
            while (true) {
                if (i >= ps.length) {
                    return null;
                }
                if (method.equals(new String(ps[i].getName()))) {
                    Object v = ps[i].getValue();
                    if (v == null) {
                        return null;
                    }
                    if (v instanceof EnumConstantSignature) {
                        EnumConstantSignature cs = (EnumConstantSignature)v;
                        char[] cv = cs.getEnumConstantName();
                        if (cv == null) {
                            return null;
                        }
                        String string = new String(cv);
                        return string;
                    }
                    if (v instanceof Constant) {
                        Constant ic = (Constant)v;
                        return ic.stringValue();
                    }
                    v = v.toString();
                    return (String)v;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            SeamCorePlugin.getPluginLog().logError(e);
        }
        return null;
    }

    private IMethod findIMethod(SeamJavaComponentDeclaration component, IBinaryMethod m) {
        block7: {
            String name = new String(m.getSelector());
            IType type = (IType)component.getSourceMember();
            new String(m.getMethodDescriptor());
            IMethod[] ms = null;
            try {
                ms = type.getMethods();
            }
            catch (JavaModelException javaModelException) {}
            if (ms == null) break block7;
            int i = 0;
            while (i < ms.length) {
                block8: {
                    if (ms[i].getElementName().equals(name)) {
                        try {
                            if (ms[i].getParameterNames().length != m.getArgumentNames().length) {
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                        break block8;
                        return ms[i];
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private IField findIField(SeamJavaComponentDeclaration component, Field m) {
        IType type = (IType)component.getSourceMember();
        return type.getField(m.getName());
    }
}

