/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.pages.xml.model.refactoring;

import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.refactoring.RefactoringHelper;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jst.web.model.ReferenceObject;
import org.jboss.tools.seam.pages.xml.SeamPagesXMLMessages;
import org.jboss.tools.seam.pages.xml.model.handlers.RenameViewSupport;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramHelper;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramStructureHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamPagesRenamePageConfigChange
extends CompositeChange {
    XModelObject object;
    String newName;
    String oldText;
    String newText;
    XModelObject[] fs = new XModelObject[0];
    Properties replacements = new Properties();
    static String[] ATTRIBUTES = new String[]{"no conversation view id", "login view id"};

    public SeamPagesRenamePageConfigChange(XModelObject object, String newName) {
        super(SeamPagesXMLMessages.PAGES_CONFIG_CHANGES);
        IPath root;
        IFile file;
        this.object = object;
        this.newName = newName;
        this.replacements.clear();
        this.oldText = XModelObjectLoaderUtil.getResourcePath((XModelObject)object);
        if (!EclipseResourceUtil.hasNature((XModel)object.getModel(), (String)"org.jboss.tools.jsf.jsfnature") && (file = (IFile)object.getAdapter(IFile.class)) != null && (root = this.getRootPath(file.getProject())).isPrefixOf(file.getFullPath())) {
            this.oldText = file.getFullPath().removeFirstSegments(root.segmentCount()).toString();
            if (!this.oldText.startsWith("/")) {
                this.oldText = "/" + this.oldText;
            }
        }
        int i = this.oldText.lastIndexOf("/");
        this.newText = String.valueOf(this.oldText.substring(0, i + 1)) + newName;
        this.replacements.setProperty(this.oldText, this.newText);
        this.addChanges();
    }

    IPath getRootPath(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return null;
        }
        return component.getRootFolder().getWorkspaceRelativePath();
    }

    private void addChanges() {
        if (this.object == null) {
            return;
        }
        XModelObject fso = FileSystemsHelper.getFileSystems((XModel)this.object.getModel());
        if (fso == null) {
            return;
        }
        ArrayList<XModelObject> list = new ArrayList<XModelObject>();
        this.collectFiles(list, fso);
        this.fs = list.toArray(new XModelObject[0]);
        this.addChanges(this.fs);
    }

    private void addChanges(XModelObject[] objects) {
        int i = 0;
        while (i < objects.length) {
            XModelObject gs;
            int c = this.getChildren().length;
            RefactoringHelper.addChanges((XModelObject)objects[i], (Properties)this.replacements, (CompositeChange)this);
            if (c == this.getChildren().length && (gs = this.findGroup(objects[i])) != null) {
                this.add(new Change(){

                    public String getName() {
                        return String.valueOf(SeamPagesXMLMessages.UPDATE_REFERENCE_TO_PAGE) + gs.getAttributeValue("path");
                    }

                    public void initializeValidationData(IProgressMonitor pm) {
                    }

                    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
                        return null;
                    }

                    public Change perform(IProgressMonitor pm) throws CoreException {
                        return null;
                    }

                    public Object getModifiedElement() {
                        return null;
                    }
                });
            }
            ++i;
        }
    }

    XModelObject findGroup(XModelObject f) {
        XModelObject diagram = SeamPagesDiagramStructureHelper.instance.getDiagram(f);
        if (diagram == null) {
            return null;
        }
        XModelObject[] is = SeamPagesDiagramStructureHelper.instance.getItems(diagram);
        int i = 0;
        while (i < is.length) {
            String path = is[i].getAttributeValue("path");
            if (path != null && path.equals(this.oldText)) {
                return is[i];
            }
            ++i;
        }
        return null;
    }

    private void collectFiles(ArrayList<XModelObject> list, XModelObject object) {
        if (object.getFileType() == 3 && object.getModelEntity().getName().equals("FileSystemJar")) {
            return;
        }
        if (object.getFileType() == 1) {
            if (object.getModelEntity().getName().startsWith("FileSeamPage") && !this.isOverlapped(object)) {
                list.add(object);
            }
        } else {
            XModelObject[] cs;
            if ("true".equals(object.get("overlapped"))) {
                return;
            }
            XModelObject[] xModelObjectArray = cs = object.getChildren();
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                XModelObject o = xModelObjectArray[n2];
                this.collectFiles(list, o);
                ++n2;
            }
        }
    }

    protected boolean isOverlapped(XModelObject object) {
        XModelObject p = object.getParent();
        while (p != null && !"true".equals(p.get("overlapped"))) {
            p = p.getParent();
        }
        return p != null;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        XModelObject parent = this.object.getParent();
        if (parent instanceof FolderImpl) {
            ((FolderImpl)parent).update();
        }
        int i = 0;
        while (i < this.fs.length) {
            this.performChangeInFile(this.fs[i]);
            ++i;
        }
        i = 0;
        while (i < this.fs.length) {
            if (this.fs[i].isModified()) {
                XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)this.fs[i], null);
            }
            ++i;
        }
        return null;
    }

    private void performChangeInFile(XModelObject f) throws XModelException {
        SeamPagesRenamePageConfigChange.replaceViewIDs(f, this.oldText, this.newText);
        XModelObject g = this.findGroup(f);
        if (g != null) {
            SeamPagesDiagramHelper h = SeamPagesDiagramHelper.getHelper(SeamPagesDiagramStructureHelper.instance.getDiagram(f));
            h.addUpdateLock((Object)this);
            try {
                RenameViewSupport.replace((ReferenceObject)g, this.oldText, this.newText);
            }
            finally {
                h.removeUpdateLock((Object)this);
                h.updateDiagram();
            }
        }
    }

    static void replaceViewIDs(XModelObject f, String oldText, String newText) throws XModelException {
        if (oldText == null || oldText.length() == 0) {
            return;
        }
        int i = 0;
        while (i < ATTRIBUTES.length) {
            String v;
            if (f.getModelEntity().getAttribute(ATTRIBUTES[i]) != null && oldText.equals(v = f.getAttributeValue(ATTRIBUTES[i]))) {
                f.getModel().editObjectAttribute(f, ATTRIBUTES[i], newText);
            }
            ++i;
        }
        if (f.getModelEntity().getName().startsWith("FileSeamPages")) {
            XModelObject[] cs = f.getChildrenForSave();
            int i2 = 0;
            while (i2 < cs.length) {
                SeamPagesRenamePageConfigChange.replaceViewIDs(cs[i2], oldText, newText);
                ++i2;
            }
        }
    }
}

