/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.pages.xml.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileAuxiliary;
import org.jboss.tools.common.model.filesystems.impl.AbstractXMLFileImpl;
import org.jboss.tools.common.model.loaders.AuxiliaryLoader;
import org.jboss.tools.common.model.loaders.impl.SimpleWebFileLoader;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EntityXMLRegistration;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jst.web.model.AbstractWebDiagramLoader;
import org.jboss.tools.jst.web.model.WebProcessLoader;
import org.jboss.tools.seam.pages.xml.model.SeamPagesConstants;
import org.jboss.tools.seam.pages.xml.model.SeamPagesLoaderUtil;
import org.jboss.tools.seam.pages.xml.model.impl.SeamPagesDiagramImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SeamPagesFileLoader
extends AbstractWebDiagramLoader
implements WebProcessLoader,
SeamPagesConstants,
AuxiliaryLoader {
    public static String AUXILIARY_FILE_EXTENSION = "spdia";

    protected FileAuxiliary createFileAuxiliary() {
        return new FileAuxiliary(AUXILIARY_FILE_EXTENSION, false);
    }

    public void load(XModelObject object) {
        boolean hasErrors;
        String body = XModelObjectLoaderUtil.getTempBody((XModelObject)object);
        int resolution = EntityXMLRegistration.getInstance().resolve(object.getModelEntity());
        if (EntityXMLRegistration.isSystemId((String)body)) {
            resolution = EntityXMLRegistration.UNRESOLVED;
        }
        String[] errors = XMLUtil.getXMLErrors((Reader)new StringReader(body), (resolution == EntityXMLRegistration.DTD ? 1 : 0) != 0, (resolution == EntityXMLRegistration.SCHEMA ? 1 : 0) != 0);
        boolean bl = hasErrors = errors != null && errors.length > 0;
        if (hasErrors) {
            object.setAttributeValue("isIncorrect", "yes");
            object.setAttributeValue("incorrectBody", body);
            object.set("actualBodyTimeStamp", "-1");
        } else {
            object.setAttributeValue("isIncorrect", "no");
            object.set("correctBody", body);
            object.set("actualBodyTimeStamp", "0");
            object.setAttributeValue("incorrectBody", "");
        }
        Document doc = XMLUtil.getDocument((Reader)new StringReader(body));
        if (doc == null) {
            XModelObjectLoaderUtil.addRequiredChildren((XModelObject)object);
            return;
        }
        Element element = doc.getDocumentElement();
        this.util.load(element, object);
        this.setEncoding(object, body);
        if (object.getModelEntity().getAttribute("systemId") != null) {
            NodeList nl = doc.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node n = nl.item(i);
                if (n instanceof DocumentType) {
                    DocumentType dt = (DocumentType)n;
                    object.setAttributeValue("systemId", dt.getSystemId());
                    if (dt.getPublicId() == null) {
                        object.setAttributeValue("publicId", "null");
                    }
                }
                ++i;
            }
        }
        String loadingError = this.util.getError();
        this.reloadProcess(object);
        object.set("actualBodyTimeStamp", "" + object.getTimeStamp());
        ((AbstractXMLFileImpl)object).setLoaderError(loadingError);
        if (!hasErrors && loadingError != null) {
            object.setAttributeValue("isIncorrect", "yes");
            object.setAttributeValue("incorrectBody", body);
            object.set("actualBodyTimeStamp", "" + object.getTimeStamp());
        }
    }

    public void reloadProcess(XModelObject object) {
        Document doc2;
        String bodyAux;
        SeamPagesDiagramImpl diagram = (SeamPagesDiagramImpl)object.getChildByPath("process");
        if (diagram == null) {
            return;
        }
        diagram.setReference(object);
        if (!object.isActive()) {
            return;
        }
        String string = bodyAux = object.getParent() == null ? null : this.aux.read(object.getParent(), object);
        if (bodyAux != null && (doc2 = XMLUtil.getDocument((Reader)new StringReader(bodyAux))) != null) {
            this.util.load(doc2.getDocumentElement(), (XModelObject)diagram);
        }
        diagram.setReference(null);
        diagram.firePrepared();
    }

    public boolean saveLayout(XModelObject object) {
        XModelObject diagram;
        XModelObjectLoaderUtil util;
        block4: {
            if (object == null || !object.isActive()) {
                return false;
            }
            util = new XModelObjectLoaderUtil();
            try {
                diagram = object.getChildByPath("process");
                if (diagram != null) break block4;
                return true;
            }
            catch (IOException exc) {
                ModelPlugin.getPluginLog().logError((Throwable)exc);
                return false;
            }
        }
        diagram.setModified(true);
        Element element = XMLUtil.createDocumentElement((String)"diagram");
        util.saveAttributes(element, diagram);
        util.saveChildren(element, diagram);
        StringWriter sw = new StringWriter();
        XModelObjectLoaderUtil.serialize((Element)element, (Writer)sw);
        XModelObjectLoaderUtil.setTempBody((XModelObject)diagram, (String)sw.toString());
        this.aux.write(object.getParent(), object, diagram);
        return true;
    }

    public String serializeMainObject(XModelObject object) {
        String systemId = object.getAttributeValue("systemId");
        String publicId = object.getAttributeValue("publicId");
        if ("null".equals(publicId)) {
            publicId = null;
        }
        if (systemId != null) {
            if (systemId != null && systemId.length() == 0) {
                systemId = "http://jboss.com/products/seam/pages-1.2.dtd";
            }
            if (publicId != null && publicId.length() == 0) {
                publicId = "-//JBoss/Seam Pages Configuration DTD 1.2//EN";
            }
        }
        Element element = systemId == null && publicId == null ? XMLUtil.createDocumentElement((String)object.getModelEntity().getXMLSubPath()) : XMLUtil.createDocumentElement((String)object.getModelEntity().getXMLSubPath(), (String)"pages", (String)publicId, (String)systemId, null);
        this.util.setup(null, false);
        this.util.saveAttributes(element, object);
        this.util.saveChildren(element, object);
        this.util.saveFinalComment(element, object);
        element.removeAttribute("NAME");
        element.removeAttribute("EXTENSION");
        try {
            return SimpleWebFileLoader.serialize((Element)element, (XModelObject)object);
        }
        catch (IOException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
            return null;
        }
        catch (XModelException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
            return null;
        }
    }

    protected XModelObjectLoaderUtil createUtil() {
        return new SeamPagesLoaderUtil();
    }
}

