/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.pages.xml.model.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.jst.web.model.ReferenceObject;
import org.jboss.tools.jst.web.model.helpers.autolayout.AutoLayout;
import org.jboss.tools.jst.web.model.helpers.autolayout.Items;
import org.jboss.tools.seam.pages.xml.model.SeamPagesConstants;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesDiagramStructureHelper;
import org.jboss.tools.seam.pages.xml.model.helpers.SeamPagesPageRefUpdateManager;
import org.jboss.tools.seam.pages.xml.model.helpers.autolayout.SeamPagesItems;
import org.jboss.tools.seam.pages.xml.model.impl.ReferenceObjectImpl;
import org.jboss.tools.seam.pages.xml.model.impl.SeamPagesDiagramImpl;

public class SeamPagesDiagramHelper
implements SeamPagesConstants {
    private XModelObject diagram;
    private static XModelObject TEMPLATE;
    private XModelObject config;
    private Map<String, XModelObject> pageItems = new HashMap<String, XModelObject>();
    private Set<String> pageViewIds = new HashSet<String>();
    private Map<String, XModelObject> exceptionItems = new HashMap<String, XModelObject>();
    private Map<String, XModelObject> targets = new HashMap<String, XModelObject>();
    Set<Object> updateLocks = new HashSet<Object>();

    public SeamPagesDiagramHelper(XModelObject diagram) {
        this.diagram = diagram;
    }

    public static SeamPagesDiagramHelper getHelper(XModelObject diagram) {
        return ((SeamPagesDiagramImpl)diagram).getHelper();
    }

    private synchronized void reset() {
        this.pageItems.clear();
        this.pageViewIds.clear();
        this.exceptionItems.clear();
        this.targets.clear();
        this.config = this.diagram.getParent();
    }

    public void restoreRefs() {
        ((SeamPagesDiagramImpl)this.diagram).setReference(this.diagram.getParent());
    }

    public boolean isUpdateLocked() {
        return !this.updateLocks.isEmpty();
    }

    public void addUpdateLock(Object lock) {
        this.updateLocks.add(lock);
    }

    public void removeUpdateLock(Object lock) {
        this.updateLocks.remove(lock);
    }

    public void updateDiagram() {
        if (this.isUpdateLocked()) {
            return;
        }
        this.addUpdateLock(this);
        try {
            this.updateDiagram0();
        }
        finally {
            this.removeUpdateLock(this);
        }
    }

    private void updateDiagram0() {
        this.reset();
        XModelObject[] sourcePages = this.config.getChildByPath("Pages").getChildren();
        XModelObject[] cs = this.diagram.getChildren();
        HashMap<XModelObject, XModelObject> old = new HashMap<XModelObject, XModelObject>();
        int i = 0;
        while (i < cs.length) {
            XModelObject k;
            if (cs[i] instanceof ReferenceObject && (k = ((ReferenceObject)cs[i]).getReference()) != null) {
                old.put(k, cs[i]);
            }
            ++i;
        }
        i = 0;
        while (i < sourcePages.length) {
            block12: {
                String opp;
                String view = sourcePages[i].getAttributeValue("view id");
                if (view == null) break block12;
                String pp = SeamPagesDiagramHelper.toNavigationRulePathPart(view);
                XModelObject og = (XModelObject)old.get(sourcePages[i]);
                if (og != null && !pp.equals(opp = og.getPathPart())) {
                    this.pageItems.remove(opp);
                    og.setAttributeValue("name", pp);
                }
                XModelObject g = og != null ? og : this.findOrCreateItem(view, pp, "page");
                ((ReferenceObjectImpl)g).setReference(sourcePages[i]);
                this.pageItems.put(pp, g);
                this.pageViewIds.add(view);
                XModelObject[] ns = sourcePages[i].getChildren();
                int j = 0;
                while (j < ns.length) {
                    block13: {
                        block14: {
                            String entity = ns[j].getModelEntity().getName();
                            if (!entity.startsWith("SeamPageNavigation")) break block13;
                            if (!entity.startsWith("SeamPageNavigationRule")) break block14;
                            this.addTarget(ns[j], true);
                            if (!entity.endsWith("21") && !entity.endsWith("22")) break block13;
                        }
                        XModelObject[] rs = ns[j].getChildren();
                        int k = 0;
                        while (k < rs.length) {
                            this.addTarget(rs[k], true);
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        XModelObject[] sourceExceptions = this.config.getChildByPath("Exceptions").getChildren();
        int i2 = 0;
        while (i2 < sourceExceptions.length) {
            String opp;
            String code = sourceExceptions[i2].getAttributeValue("class");
            String pp = "exception:" + code;
            XModelObject og = (XModelObject)old.get(sourceExceptions[i2]);
            if (og != null && !pp.equals(opp = og.getPathPart())) {
                this.exceptionItems.remove(opp);
                og.setAttributeValue("name", pp);
                ((ReferenceObjectImpl)og).setReference(null);
            }
            XModelObject g = og != null ? og : this.findOrCreateItem(code, pp, "exception");
            ((ReferenceObjectImpl)g).setReference(sourceExceptions[i2]);
            this.exceptionItems.put(pp, g);
            this.addTarget(sourceExceptions[i2], false);
            ++i2;
        }
        Iterator<String> it = this.pageItems.keySet().iterator();
        while (it.hasNext()) {
            this.targets.remove(it.next());
        }
        this.removeObsoleteExceptionItems();
        this.createPageItems();
        this.removeObsoletePageItems();
        this.updatePageItems();
        this.updateExceptionItems();
        this.updatePages();
    }

    private void addTarget(XModelObject rule, boolean addEmpty) {
        XModelObject target = rule.getChildByPath("target");
        if (target == null) {
            return;
        }
        String tvi = target.getAttributeValue("view id");
        if (tvi == null) {
            return;
        }
        if (!addEmpty && tvi.length() == 0) {
            return;
        }
        this.targets.put(SeamPagesDiagramHelper.toNavigationRulePathPart(tvi), this.getTemplate());
    }

    private XModelObject getTemplate() {
        if (TEMPLATE == null && this.diagram != null) {
            TEMPLATE = this.diagram.getModel().createModelObject("SeamPagesDiagramItem", null);
        }
        return TEMPLATE;
    }

    public XModelObject findOrCreateItem(String path, String pp, String type) {
        XModelObject g;
        if (pp == null) {
            pp = SeamPagesDiagramHelper.toNavigationRulePathPart(path);
        }
        if ((g = this.diagram.getChildByPath(pp)) == null) {
            g = this.diagram.getModel().createModelObject("SeamPagesDiagramItem", null);
            g.setAttributeValue("name", pp);
            g.setAttributeValue("path", path);
            g.setAttributeValue("type", type);
            this.diagram.addChild(g);
        }
        return g;
    }

    private void removeObsoletePageItems() {
        XModelObject[] ps = this.diagram.getChildren("SeamPagesDiagramItem");
        int i = 0;
        while (i < ps.length) {
            String path = ps[i].getPathPart();
            String type = ps[i].getAttributeValue("type");
            if ("page".equals(type) && !this.pageItems.containsKey(path) && this.targets.get(path) != ps[i]) {
                ps[i].removeFromParent();
            }
            ++i;
        }
    }

    private void removeObsoleteExceptionItems() {
        XModelObject[] ps = this.diagram.getChildren("SeamPagesDiagramItem");
        int i = 0;
        while (i < ps.length) {
            String path = ps[i].getPathPart();
            String type = ps[i].getAttributeValue("type");
            if ("exception".equals(type) && !this.exceptionItems.containsKey(path)) {
                ps[i].removeFromParent();
            }
            ++i;
        }
    }

    private void createPageItems() {
        String[] paths = this.targets.keySet().toArray(new String[0]);
        int i = 0;
        while (i < paths.length) {
            String fvi = SeamPagesDiagramHelper.toFromViewId(paths[i]);
            XModelObject g = this.findOrCreateItem(fvi, SeamPagesDiagramHelper.toNavigationRulePathPart(fvi), "page");
            this.targets.put(paths[i], g);
            ++i;
        }
    }

    private void updatePageItems() {
        ReferenceObjectImpl[] gs = this.pageItems.values().toArray(new ReferenceObjectImpl[0]);
        int i = 0;
        while (i < gs.length) {
            this.updatePageItem(gs[i]);
            ++i;
        }
        gs = this.targets.values().toArray(new ReferenceObjectImpl[0]);
        i = 0;
        while (i < gs.length) {
            long ts = gs[i].getTimeStamp();
            boolean hadReference = gs[i].getReference() != null;
            gs[i].setReference(null);
            gs[i].setAttributeValue("params", "");
            XModelObject[] os = gs[i].getChildren("SeamPagesDiagramItemOutput");
            int j = 0;
            while (j < os.length) {
                if (!"custom".equals(os[j].getAttributeValue("subtype"))) {
                    gs[i].removeChild(os[j]);
                }
                ++j;
            }
            this.updatePageItem(gs[i]);
            if (hadReference && ts == gs[i].getTimeStamp()) {
                gs[i].fireReferenceChanged();
            }
            ++i;
        }
    }

    private void updateExceptionItems() {
        ReferenceObjectImpl[] gs = this.exceptionItems.values().toArray(new ReferenceObjectImpl[0]);
        int i = 0;
        while (i < gs.length) {
            this.updateExceptionItem(gs[i]);
            ++i;
        }
    }

    private void updatePageItem(ReferenceObjectImpl item) {
        if (item.getReference() == null) {
            this.updateUndeclaredPageItem(item);
            return;
        }
        boolean iud = item.isUpToDate();
        long ts = item.getTimeStamp();
        item.notifyUpdate();
        XModelObject sourcePage = item.getReference();
        item.setAttributeValue("id", sourcePage.getPathPart());
        item.setAttributeValue("path", sourcePage.getAttributeValue("view id"));
        String[][] params = SeamPagesDiagramStructureHelper.getInstance().getParams((XModelObject)item);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < params.length) {
            sb.append(params[i][0]).append('=').append(params[i][1]).append(';');
            ++i;
        }
        item.setAttributeValue("params", sb.toString());
        XModelObject[] cs = this.getPageTargets(sourcePage);
        this.updateOutputs(item, cs);
        if (!iud && ts == item.getTimeStamp()) {
            item.fireReferenceChanged();
        }
    }

    private void updateUndeclaredPageItem(ReferenceObjectImpl item) {
        item.getChildren();
        String path = item.getAttributeValue("path");
        String fvi = this.findBestMatch(path);
        XModelObject g = this.getPage(fvi);
        if (g != null && item != g) {
            XModelObject output = item.getModel().createModelObject("SeamPagesDiagramItemOutput", null);
            output.setAttributeValue("id", fvi);
            output.setAttributeValue("path", fvi);
            String name = XModelObjectUtil.createNewChildName((String)"output", (XModelObject)item);
            output.setAttributeValue("name", name);
            ReferenceObjectImpl r = (ReferenceObjectImpl)output;
            r.setReference(null);
            String target = g == null ? "" : g.getPathPart();
            output.setAttributeValue("target", target);
            item.addChild(output);
        }
    }

    private XModelObject[] getPageTargets(XModelObject o) {
        XModelObject[] ns = o.getChildren();
        ArrayList<XModelObject> result = null;
        int i = 0;
        while (i < ns.length) {
            block9: {
                block10: {
                    String entity = ns[i].getModelEntity().getName();
                    if (!entity.startsWith("SeamPageNavigation")) break block9;
                    if (!entity.startsWith("SeamPageNavigationRule")) break block10;
                    XModelObject t = this.getTargetChild(ns[i]);
                    if (t != null) {
                        if (result == null) {
                            result = new ArrayList<XModelObject>();
                        }
                        result.add(t);
                    }
                    if (!entity.endsWith("21") && !entity.endsWith("22")) break block9;
                }
                XModelObject[] rs = ns[i].getChildren();
                int k = 0;
                while (k < rs.length) {
                    XModelObject t = this.getTargetChild(rs[k]);
                    if (t != null) {
                        if (result == null) {
                            result = new ArrayList();
                        }
                        result.add(t);
                    }
                    ++k;
                }
            }
            ++i;
        }
        return result == null ? new XModelObject[]{} : result.toArray(new XModelObject[0]);
    }

    private void updateExceptionItem(ReferenceObjectImpl item) {
        String path;
        XModelObject[] xModelObjectArray;
        if (item.isUpToDate()) {
            return;
        }
        item.notifyUpdate();
        XModelObject exc = item.getReference();
        item.setAttributeValue("id", exc.getPathPart());
        item.setAttributeValue("path", exc.getAttributeValue("class"));
        XModelObject t = this.getTargetChild(exc);
        if (t == null) {
            xModelObjectArray = new XModelObject[]{};
        } else {
            XModelObject[] xModelObjectArray2 = new XModelObject[1];
            xModelObjectArray = xModelObjectArray2;
            xModelObjectArray2[0] = t;
        }
        XModelObject[] cs = xModelObjectArray;
        if (cs.length == 1 && ((path = t.getAttributeValue("view id")) == null || path.length() == 0)) {
            cs = new XModelObject[]{};
        }
        this.updateOutputs(item, cs);
    }

    private XModelObject getTargetChild(XModelObject o) {
        XModelObject t = o.getChildByPath("target");
        if (t == null || t.getModelEntity().getAttribute("view id") == null) {
            return null;
        }
        return t;
    }

    private void updateOutputs(ReferenceObjectImpl item, XModelObject[] cases) {
        XModelObject[] os = item.getChildren();
        if (this.isOutputOrderUpToDate(cases, os)) {
            this.updateOutputs_1(item, cases, os);
        } else {
            this.updateOutputs_2(item, cases, os);
        }
    }

    private void updateOutputs_1(ReferenceObjectImpl item, XModelObject[] cases, XModelObject[] outputs) {
        int c = 0;
        int i = 0;
        while (i < cases.length) {
            XModelObject output = null;
            output = c < outputs.length ? outputs[c] : this.createOutput((XModelObject)item, cases[i]);
            ReferenceObjectImpl r = (ReferenceObjectImpl)output;
            r.setReference(cases[i]);
            this.updateOutput(r);
            ++c;
            ++i;
        }
        i = c;
        while (i < outputs.length) {
            outputs[i].removeFromParent();
            ++i;
        }
    }

    private void updateOutputs_2(ReferenceObjectImpl item, XModelObject[] cases, XModelObject[] outputs) {
        XModelObject output;
        HashMap<String, XModelObject> map = new HashMap<String, XModelObject>();
        int i = 0;
        while (i < outputs.length) {
            output = outputs[i];
            output.removeFromParent();
            map.put(output.getAttributeValue("id"), output);
            ++i;
        }
        i = 0;
        while (i < cases.length) {
            output = (XModelObject)map.get(cases[i].getPathPart());
            if (output == null) {
                output = this.createOutput((XModelObject)item, cases[i]);
            } else {
                item.addChild(output);
            }
            ReferenceObjectImpl r = (ReferenceObjectImpl)output;
            r.setReference(cases[i]);
            this.updateOutput(r);
            ++i;
        }
    }

    private boolean isOutputOrderUpToDate(XModelObject[] cases, XModelObject[] outputs) {
        int i = 0;
        while (i < cases.length && i < outputs.length) {
            String id;
            String pp;
            ReferenceObject r = (ReferenceObject)outputs[i];
            if (r.getReference() != cases[i] && !(pp = cases[i].getAttributeValue("view id")).equals(id = outputs[i].getAttributeValue("id"))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private XModelObject createOutput(XModelObject item, XModelObject rulecase) {
        XModelObject output = item.getModel().createModelObject("SeamPagesDiagramItemOutput", null);
        output.setAttributeValue("id", rulecase.getAttributeValue("view id"));
        output.setAttributeValue("path", rulecase.getAttributeValue("view id"));
        String name = XModelObjectUtil.createNewChildName((String)"output", (XModelObject)item);
        output.setAttributeValue("name", name);
        ReferenceObjectImpl r = (ReferenceObjectImpl)output;
        r.setReference(rulecase);
        this.updateOutput(r);
        item.addChild(output);
        return output;
    }

    private void updateOutput(ReferenceObjectImpl output) {
        if (output.getReference() == null) {
            return;
        }
        output.notifyUpdate();
        XModelObject rulecase = output.getReference();
        output.setAttributeValue("id", rulecase.getAttributeValue("view id"));
        String path = rulecase.getAttributeValue("view id");
        output.setAttributeValue("path", path);
        XModelObject g = this.getPage(path);
        String target = g == null ? "" : g.getPathPart();
        output.setAttributeValue("target", target);
    }

    public void autolayout() {
        AutoLayout auto = new AutoLayout();
        auto.setItems((Items)new SeamPagesItems());
        auto.setProcess(this.diagram);
    }

    public XModelObject getPage(String path) {
        XModelObject g = this.pageItems.get(path = SeamPagesDiagramHelper.toNavigationRulePathPart(path));
        if (g == null) {
            g = this.targets.get(path);
        }
        return g;
    }

    public void updatePages() {
        SeamPagesPageRefUpdateManager pu = SeamPagesPageRefUpdateManager.getInstance(this.diagram.getModel());
        pu.lock();
        XModelObject[] items = this.diagram.getChildren();
        int i = 0;
        while (i < items.length) {
            pu.updatePage(this, items[i]);
            ++i;
        }
        pu.unlock();
    }

    public String findBestMatch(String viewId) {
        if (viewId == null || this.pageViewIds.contains(viewId)) {
            return viewId;
        }
        String best = viewId;
        int match = 0;
        for (String v : this.pageViewIds) {
            int i = v.indexOf(42);
            if (i < 0) continue;
            String head = v.substring(0, i);
            String tail = v.substring(i + 1);
            int m = head.length() + tail.length();
            if (m > viewId.length() || m <= match || head.length() > 0 && !viewId.startsWith(head) || tail.length() > 0 && !viewId.endsWith(tail)) continue;
            best = v;
            match = m;
        }
        return best;
    }

    public static String toNavigationRulePathPart(String path) {
        return SeamPagesDiagramHelper.encode(path);
    }

    public static String toFromViewId(String pathpart) {
        if (!pathpart.startsWith("rules:")) {
            return SeamPagesDiagramHelper.decode(pathpart);
        }
        int i = (pathpart = SeamPagesDiagramHelper.decode(pathpart.substring(6))).lastIndexOf(58);
        return i < 0 ? pathpart : pathpart.substring(0, i);
    }

    public static boolean isPattern(String path) {
        return path != null && (path.length() == 0 || path.indexOf(42) >= 0);
    }

    static String encode(String s) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '/') {
                result.append("#x");
            } else if (c == '#') {
                result.append("##");
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    static String decode(String s) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '#') {
                char c1;
                char c2 = c1 = i + 1 < s.length() ? s.charAt(i + 1) : (char)'\u0000';
                if (c1 == 'x') {
                    result.append('/');
                    ++i;
                } else if (c1 == '#') {
                    result.append("#");
                    ++i;
                } else {
                    result.append("#");
                }
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }
}

