/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.text.ext.hyperlink;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.seam.core.SeamProjectsSet;
import org.jboss.tools.seam.text.ext.SeamExtPlugin;
import org.jboss.tools.seam.text.ext.hyperlink.ComponentsHyperlinkPartitioner;
import org.w3c.dom.Node;

public class ComponentsHyperlink
extends AbstractHyperlink {
    private String hyperlinkText = "";
    private String partitionType = null;

    protected IRegion doGetHyperlinkRegion(int offset) {
        Node node = ComponentsHyperlinkPartitioner.getNode(this.getDocument(), offset);
        this.partitionType = ComponentsHyperlinkPartitioner.getType(node);
        if (this.partitionType == null) {
            return null;
        }
        IndexedRegion text = (IndexedRegion)node;
        int regLength = text.getLength();
        int regOffset = text.getStartOffset();
        Region region = new Region(regOffset, regLength);
        return region;
    }

    protected void doHyperlink(IRegion region) {
        if (region == null) {
            return;
        }
        try {
            IDocument document = this.getDocument();
            this.hyperlinkText = document.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException ex) {
            SeamExtPlugin.getPluginLog().logError((Throwable)ex);
        }
        if (this.partitionType == "org.jboss.tools.seam.text.ext.BPM_DEFINITION") {
            this.doBpmDefinitionHyperlink(region);
        } else if (this.partitionType == "org.jboss.tools.seam.text.ext.DROOLS_RULE_DEFINITION") {
            this.doDroolsRuleHyperlink(region);
        }
    }

    private void doDroolsRuleHyperlink(IRegion region) {
        IFile file = this.findDroolsRuleFile();
        IEditorPart part = null;
        if (file != null) {
            part = this.openFileInEditor(file);
        }
        if (part == null) {
            this.openFileFailed();
        }
    }

    private IFile findDroolsRuleFile() {
        IResource[] sources;
        IProject project = this.getProject();
        IResource[] iResourceArray = sources = EclipseResourceUtil.getJavaSourceRoots((IProject)project);
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            String path = resource.getFullPath().removeFirstSegments(1) + this.hyperlinkText;
            IFile file = project.getFile(path);
            if (file != null && file.exists()) {
                return file;
            }
            ++n2;
        }
        return this.findDefinitionFile();
    }

    private void doBpmDefinitionHyperlink(IRegion region) {
        IFile file = this.findDefinitionFile();
        IEditorPart part = null;
        if (file != null) {
            part = this.openFileInEditor(file);
        }
        if (part == null) {
            this.openFileFailed();
        }
    }

    private IFile findDefinitionFile() {
        IFile file;
        SeamProjectsSet projectsSet = SeamProjectsSet.create((IProject)this.getProject());
        IContainer webContent = projectsSet.getDefaultViewsFolder();
        if (webContent != null && (file = webContent.getFile((IPath)new Path(this.hyperlinkText))) != null && file.exists()) {
            return file;
        }
        IContainer earContent = projectsSet.getDefaultEarViewsFolder();
        if (earContent != null && (file = earContent.getFile((IPath)new Path(this.hyperlinkText))) != null && file.exists()) {
            return file;
        }
        IContainer ejbSource = projectsSet.getDefaultEjbSourceFolder();
        if (ejbSource != null && (file = ejbSource.getFile((IPath)new Path(this.hyperlinkText))) != null && file.exists()) {
            return file;
        }
        return null;
    }

    private IProject getProject() {
        IFile documentFile = this.getFile();
        if (documentFile == null || !documentFile.isAccessible()) {
            return null;
        }
        IProject project = documentFile.getProject();
        return project;
    }

    public String getHyperlinkText() {
        return this.hyperlinkText;
    }
}

