/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.jboss.tools.common.el.core.model.ELArgumentInvocation;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELPropertyInvocation;
import org.jboss.tools.common.el.core.parser.ELParserFactory;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELCompletionEngine;
import org.jboss.tools.common.el.core.resolver.ElVarSearcher;
import org.jboss.tools.common.el.core.resolver.Var;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlinkPartitioner;
import org.jboss.tools.common.text.ext.hyperlink.HyperlinkRegion;
import org.jboss.tools.common.text.ext.hyperlink.IHyperLinkPartitionPriority;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkPartitionRecognizer;
import org.jboss.tools.common.text.ext.hyperlink.IHyperlinkRegion;
import org.jboss.tools.common.text.ext.util.StructuredModelWrapper;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.jst.text.ext.hyperlink.jsp.JSPRootHyperlinkPartitioner;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamMessages;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ScopeType;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.el.SeamELCompletionEngine;
import org.jboss.tools.seam.text.ext.SeamExtPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamBeanHyperlinkPartitioner
extends AbstractHyperlinkPartitioner
implements IHyperlinkPartitionRecognizer,
IHyperLinkPartitionPriority {
    public static final String SEAM_MESSAGES_BEAN_PARTITION = "org.jboss.tools.seam.text.ext.SEAM_MESSAGES_BEAN";
    private ELParserFactory factory = ELParserUtil.getJbossFactory();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IHyperlinkRegion parse(IDocument document, IHyperlinkRegion superRegion) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Utils.findNodeForOffset((Node)xmlDocument, (int)superRegion.getOffset());
            if (!this.recognize(document, superRegion)) {
                return null;
            }
            IHyperlinkRegion r = SeamBeanHyperlinkPartitioner.getRegion(document, superRegion.getOffset());
            if (r == null) {
                return null;
            }
            r = SeamBeanHyperlinkPartitioner.getWordRegion(document, superRegion.getOffset());
            if (r == null) {
                return null;
            }
            Map<String, ISeamMessages> messages = SeamBeanHyperlinkPartitioner.findMessagesComponents(document, (IRegion)superRegion);
            if (messages == null) return null;
            if (messages.isEmpty()) return null;
            String axis = this.getAxis(document, superRegion);
            String contentType = superRegion.getContentType();
            String type = SEAM_MESSAGES_BEAN_PARTITION;
            int length = r.getLength() - (superRegion.getOffset() - r.getOffset());
            int offset = superRegion.getOffset();
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(offset, length, axis, contentType, type);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    protected String getAxis(IDocument document, IHyperlinkRegion superRegion) {
        if (superRegion.getAxis() == null || superRegion.getAxis().length() == 0) {
            return String.valueOf(JSPRootHyperlinkPartitioner.computeAxis((IDocument)document, (int)superRegion.getOffset())) + "/";
        }
        return superRegion.getAxis();
    }

    public static IHyperlinkRegion getWordRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start < 0 || start > end || start > offset) {
                return null;
            }
            String attrText = document.get(start, end - start);
            StringBuffer sb = new StringBuffer(attrText);
            int bStart = offset - start;
            while (bStart >= 0) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bStart))) {
                    ++bStart;
                    break;
                }
                if (bStart == 0) break;
                --bStart;
            }
            int bEnd = offset - start;
            while (bEnd < sb.length()) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bEnd))) break;
                ++bEnd;
            }
            int propStart = bStart + start;
            int propLength = bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(propStart, propLength, null, null, null);
            return hyperlinkRegion;
        }
        catch (BadLocationException x) {
            SeamExtPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public static IHyperlinkRegion getRegionPart(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = Utils.getValueStart((Node)n);
            int end = Utils.getValueEnd((Node)n);
            if (start < 0 || start > end || start > offset) {
                return null;
            }
            String attrText = document.get(start, end - start);
            StringBuffer sb = new StringBuffer(attrText);
            int bStart = offset - start;
            while (bStart >= 0) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bStart)) && sb.charAt(bStart) != '.' && sb.charAt(bStart) != '[' && sb.charAt(bStart) != ']') {
                    ++bStart;
                    break;
                }
                if (bStart == 0) break;
                --bStart;
            }
            int bEnd = offset - start;
            while (bEnd < sb.length()) {
                if (!Character.isJavaIdentifierPart(sb.charAt(bEnd))) break;
                ++bEnd;
            }
            int propStart = bStart + start;
            int propLength = bEnd - bStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(propStart, propLength, null, null, null);
            return hyperlinkRegion;
        }
        catch (BadLocationException x) {
            SeamExtPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public static IHyperlinkRegion getRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            HyperlinkRegion region;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            Node n = Utils.findNodeForOffset((Node)xmlDocument, (int)offset);
            if (n == null || !(n instanceof Attr) && !(n instanceof Text)) {
                return null;
            }
            int start = 0;
            int end = document.getLength();
            if (n instanceof IDOMNode) {
                start = ((IDOMNode)n).getStartOffset();
                end = ((IDOMNode)n).getEndOffset();
            }
            SeamELCompletionEngine engine = new SeamELCompletionEngine();
            ELInvocationExpression tokens = SeamELCompletionEngine.findExpressionAtOffset((IDocument)document, (int)offset, (int)start, (int)end);
            if (tokens == null) {
                return null;
            }
            int propStart = tokens.getStartPosition();
            int propLength = tokens.getEndPosition() - propStart;
            if (propStart > offset || propStart + propLength < offset) {
                return null;
            }
            HyperlinkRegion hyperlinkRegion = region = new HyperlinkRegion(propStart, propLength);
            return hyperlinkRegion;
        }
        finally {
            smw.dispose();
        }
    }

    public boolean recognize(IDocument document, IHyperlinkRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return false;
            }
            Utils.findNodeForOffset((Node)xmlDocument, (int)region.getOffset());
            Map<String, ISeamMessages> messages = SeamBeanHyperlinkPartitioner.findMessagesComponents(document, (IRegion)region);
            if (messages != null && !messages.isEmpty()) {
                return true;
            }
            List<IJavaElement> javaElements = SeamBeanHyperlinkPartitioner.findJavaElements(document, (IRegion)region);
            return javaElements != null && !javaElements.isEmpty();
            {
            }
        }
        finally {
            smw.dispose();
        }
    }

    /*
     * Loose catch block
     */
    public static List<IJavaElement> findJavaElements(IDocument document, IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            IHyperlinkRegion r = SeamBeanHyperlinkPartitioner.getRegion(document, region.getOffset());
            if (r == null) {
                return null;
            }
            String propText = document.get(r.getOffset(), r.getLength());
            IFile file = smw.getFile();
            IProject project = file == null ? null : file.getProject();
            ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
            if (seamProject == null) {
                return null;
            }
            SeamELCompletionEngine engine = new SeamELCompletionEngine();
            String prefix = propText;
            ELExpression expr = engine.parseOperand(prefix);
            if (!(expr instanceof ELInvocationExpression)) {
                return null;
            }
            expr.getModel().shift(r.getOffset() - expr.getFirstToken().getStart());
            List javaElements = null;
            try {
                javaElements = engine.getJavaElementsForELOperandTokens(seamProject, file, (ELInvocationExpression)expr);
            }
            catch (StringIndexOutOfBoundsException e) {
                SeamExtPlugin.getPluginLog().logError((Throwable)e);
                smw.dispose();
                return null;
            }
            catch (BadLocationException e) {
                SeamExtPlugin.getPluginLog().logError((Throwable)e);
                smw.dispose();
                return null;
            }
            if (javaElements == null || javaElements.isEmpty()) {
                ElVarSearcher varSearcher = new ElVarSearcher(file, (ELCompletionEngine)engine);
                int start = expr.getStartPosition();
                expr.getEndPosition();
                if (expr.getText().length() == 0) {
                    return null;
                }
                List allVars = varSearcher.findAllVars(file, start);
                Var var = varSearcher.findVarForEl(expr.getText(), allVars, true);
                if (var == null) {
                    var = varSearcher.findVar(file, start);
                }
                if (var == null) {
                    return null;
                }
                String resolvedValue = var.getValue();
                if (resolvedValue == null || resolvedValue.length() == 0) {
                    return null;
                }
                if (resolvedValue.startsWith("#{") || resolvedValue.startsWith("${")) {
                    resolvedValue = resolvedValue.substring(2);
                }
                if (resolvedValue.endsWith("}")) {
                    resolvedValue = resolvedValue.substring(0, resolvedValue.lastIndexOf("}"));
                }
                StringBuffer elText = new StringBuffer();
                elText.append(resolvedValue);
                String app = expr.getText();
                int i = app.indexOf(46);
                app = app.substring(i + 1);
                elText.append('.').append(app);
                javaElements = engine.getJavaElementsForExpression(seamProject, file, elText.toString());
            }
            List list = javaElements;
            return list;
            {
                catch (BadLocationException x) {
                    SeamExtPlugin.getPluginLog().logError((Throwable)x);
                    return null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            smw.dispose();
        }
    }

    public static Map<String, ISeamMessages> findMessagesComponents(IDocument document, IRegion region) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            ELInvocationExpression expr;
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            IHyperlinkRegion r = SeamBeanHyperlinkPartitioner.getRegion(document, region.getOffset());
            if (r == null) {
                return null;
            }
            String propText = document.get(r.getOffset(), r.getLength());
            IFile file = smw.getFile();
            IProject project = file == null ? null : file.getProject();
            ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
            if (seamProject == null) {
                return null;
            }
            SeamELCompletionEngine engine = new SeamELCompletionEngine();
            String prefix = propText;
            ELExpression exp = engine.parseOperand(prefix);
            if (exp == null) {
                return null;
            }
            HashMap map = new HashMap();
            exp.getModel().shift(r.getOffset() - exp.getFirstToken().getStart());
            if (!(exp instanceof ELInvocationExpression || exp instanceof ELPropertyInvocation || exp instanceof ELArgumentInvocation)) {
                return null;
            }
            String propertyName = null;
            if (exp instanceof ELPropertyInvocation) {
                propertyName = ((ELPropertyInvocation)exp).getMemberName();
            } else if (exp instanceof ELArgumentInvocation) {
                propertyName = Utils.trimQuotes((String)((ELArgumentInvocation)exp).getArgument().getArgument().getText());
            }
            if (propertyName == null) {
                return null;
            }
            ScopeType scope = SeamELCompletionEngine.getScope((ISeamProject)seamProject, (IResource)file);
            ELInvocationExpression left = expr = (ELInvocationExpression)exp;
            if (expr.getLeft() != null) {
                while (left != null) {
                    List resolvedVars = new ArrayList();
                    resolvedVars = engine.resolveVariables(seamProject, scope, left, left == expr, true);
                    if (resolvedVars != null && !resolvedVars.isEmpty()) {
                        map.put(left, resolvedVars);
                        break;
                    }
                    left = left.getLeft();
                }
            }
            HashMap<String, ISeamMessages> messages = new HashMap<String, ISeamMessages>();
            if (map != null && !map.isEmpty()) {
                for (ELInvocationExpression l : map.keySet()) {
                    List variables = (List)map.get(l);
                    for (ISeamContextVariable variable : variables) {
                        ISeamMessages messagesVariable = SeamELCompletionEngine.getSeamMessagesComponentVariable((ISeamContextVariable)variable);
                        if (messagesVariable == null) continue;
                        messages.put(propertyName, messagesVariable);
                    }
                }
            }
            HashMap<String, ISeamMessages> hashMap = messages;
            return hashMap;
        }
        catch (BadLocationException x) {
            SeamExtPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public static IHyperlinkRegion getMessagesPropertyRegion(IDocument document, int offset) {
        StructuredModelWrapper smw = new StructuredModelWrapper();
        try {
            smw.init(document);
            Document xmlDocument = smw.getDocument();
            if (xmlDocument == null) {
                return null;
            }
            IHyperlinkRegion r = SeamBeanHyperlinkPartitioner.getRegion(document, offset);
            if (r == null) {
                return null;
            }
            String propText = document.get(r.getOffset(), r.getLength());
            IFile file = smw.getFile();
            IProject project = file == null ? null : file.getProject();
            ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
            if (seamProject == null) {
                return null;
            }
            SeamELCompletionEngine engine = new SeamELCompletionEngine();
            String prefix = propText;
            ELExpression exp = engine.parseOperand(prefix);
            if (exp == null) {
                return null;
            }
            new HashMap();
            exp.getModel().shift(r.getOffset() - exp.getFirstToken().getStart());
            if (!(exp instanceof ELInvocationExpression || exp instanceof ELPropertyInvocation || exp instanceof ELArgumentInvocation)) {
                return null;
            }
            if (exp instanceof ELPropertyInvocation) {
                ((ELPropertyInvocation)exp).getMemberName();
                int start = ((ELPropertyInvocation)exp).getLastToken().getStart();
                int length = ((ELPropertyInvocation)exp).getLastToken().getLength();
                HyperlinkRegion hyperlinkRegion = new HyperlinkRegion(start, length);
                return hyperlinkRegion;
            }
            if (exp instanceof ELArgumentInvocation) {
                Utils.trimQuotes((String)((ELArgumentInvocation)exp).getArgument().getArgument().getText());
                int start = ((ELArgumentInvocation)exp).getArgument().getArgument().getStartPosition();
                int length = ((ELArgumentInvocation)exp).getArgument().getArgument().getEndPosition() - ((ELArgumentInvocation)exp).getArgument().getArgument().getStartPosition();
                HyperlinkRegion hyperlinkRegion = new HyperlinkRegion(start, length);
                return hyperlinkRegion;
            }
            return null;
        }
        catch (BadLocationException x) {
            SeamExtPlugin.getPluginLog().logError((Throwable)x);
            return null;
        }
        finally {
            smw.dispose();
        }
    }

    public int getPriority() {
        return 0;
    }
}

