/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.seam.core.ISeamMessages;
import org.jboss.tools.seam.text.ext.SeamExtPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamELInJavaStringHyperlink
implements IHyperlink {
    private final IRegion fRegion;
    private final IJavaElement[] fElements;
    private final Map<String, ISeamMessages> fMessages;

    SeamELInJavaStringHyperlink(IRegion region, IJavaElement[] elements) {
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)elements);
        this.fRegion = region;
        this.fElements = elements;
        this.fMessages = null;
    }

    SeamELInJavaStringHyperlink(IRegion region, Map<String, ISeamMessages> messages) {
        Assert.isNotNull((Object)region);
        Assert.isNotNull(messages);
        this.fRegion = region;
        this.fElements = null;
        this.fMessages = messages;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        if (this.fMessages != null && this.fElements == null) {
            this.openMessages();
        } else if (this.fElements != null && this.fMessages == null) {
            try {
                IEditorPart part = null;
                int i = 0;
                while (this.fElements != null && i < this.fElements.length) {
                    part = JavaUI.openInEditor((IJavaElement)this.fElements[i]);
                    if (part != null) {
                        if (this.fElements[i] != null) {
                            JavaUI.revealInEditor((IEditorPart)part, (IJavaElement)this.fElements[i]);
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (PartInitException e) {
                SeamExtPlugin.getPluginLog().logError((Throwable)e);
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    private void openMessages() {
        Map<String, ISeamMessages> messages = this.fMessages;
        if (messages == null || messages.isEmpty()) {
            return;
        }
        for (String property : messages.keySet()) {
            ISeamMessages messagesComponent = messages.get(property);
            Map resources = messagesComponent.getResourcesMap();
            if (resources == null || resources.isEmpty()) continue;
            for (String bundle : resources.keySet()) {
                int result;
                XModelObject xmoChild;
                IResource resource = (IResource)resources.get(bundle);
                XModelObject xmo = EclipseResourceUtil.getObjectByResource((IResource)resource);
                if (xmo == null || (xmoChild = xmo.getChildByPath(property)) == null || (result = FindObjectHelper.findModelObject((XModelObject)xmoChild, (int)FindObjectHelper.IN_EDITOR_ONLY)) != 0) continue;
                return;
            }
        }
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        if (this.fElements == null || this.fElements.length == 0) {
            return MessageFormat.format(Messages.OpenA, Messages.Bean);
        }
        return MessageFormat.format(Messages.Open, this.fElements[0].getElementName());
    }
}

