/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.text.ext.hyperlink;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.FastJavaPartitionScanner;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.jboss.tools.common.el.core.model.ELArgumentInvocation;
import org.jboss.tools.common.el.core.model.ELExpression;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELPropertyInvocation;
import org.jboss.tools.common.text.ext.util.Utils;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamMessages;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.ScopeType;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.el.SeamELCompletionEngine;
import org.jboss.tools.seam.text.ext.SeamExtPlugin;
import org.jboss.tools.seam.text.ext.hyperlink.SeamELInJavaStringHyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamELInJavaStringHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        Map<String, ISeamMessages> messages;
        IToken token;
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || !(textEditor instanceof JavaEditor)) {
            return null;
        }
        int offset = region.getOffset();
        ITypeRoot input = EditorUtility.getEditorInputJavaElement((IEditorPart)textEditor, (boolean)false);
        if (input == null) {
            return null;
        }
        IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
        IRegion wordRegion = JavaWordFinder.findWord((IDocument)document, (int)offset);
        if (wordRegion == null) {
            return null;
        }
        int[] range = null;
        FastJavaPartitionScanner scanner = new FastJavaPartitionScanner();
        scanner.setRange(document, 0, document.getLength());
        while ((token = scanner.nextToken()) != null && !token.isEOF()) {
            int start = scanner.getTokenOffset();
            int end = start + scanner.getTokenLength();
            if (start <= offset && end >= offset) {
                range = new int[]{start, end};
                break;
            }
            if (start <= offset) continue;
        }
        if (!this.checkStartPosition(document, offset)) {
            return null;
        }
        IFile file = null;
        try {
            IResource resource = input.getCorrespondingResource();
            if (resource instanceof IFile) {
                file = (IFile)resource;
            }
        }
        catch (JavaModelException javaModelException) {}
        if (range == null) {
            int[] nArray = new int[2];
            nArray[1] = document.getLength();
            range = nArray;
        }
        if ((messages = SeamELInJavaStringHyperlinkDetector.findMessagesComponents(document, file, wordRegion, range[0], range[1])) != null && !messages.isEmpty()) {
            return new IHyperlink[]{new SeamELInJavaStringHyperlink(wordRegion, messages)};
        }
        IJavaElement[] elements = SeamELInJavaStringHyperlinkDetector.findJavaElements(document, file, wordRegion, range[0], range[1]);
        if (elements != null && elements.length > 0) {
            return new IHyperlink[]{new SeamELInJavaStringHyperlink(wordRegion, elements)};
        }
        return null;
    }

    public static IJavaElement[] findJavaElements(IDocument document, IFile file, IRegion region, int start, int end) {
        IProject project = file == null ? null : file.getProject();
        ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
        if (seamProject == null) {
            return null;
        }
        SeamELCompletionEngine engine = new SeamELCompletionEngine();
        String prefix = engine.getJavaElementExpression(document, region.getOffset(), region, start, end);
        prefix = prefix == null ? "" : prefix;
        List javaElements = null;
        try {
            javaElements = engine.getJavaElementsForExpression(seamProject, file, prefix);
        }
        catch (StringIndexOutOfBoundsException e) {
            SeamExtPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (BadLocationException e) {
            SeamExtPlugin.getPluginLog().logError((Throwable)e);
        }
        return javaElements == null ? new IJavaElement[]{} : javaElements.toArray(new IJavaElement[0]);
    }

    public static Map<String, ISeamMessages> findMessagesComponents(IDocument document, IFile file, IRegion region, int start, int end) {
        ELInvocationExpression expr;
        SeamELCompletionEngine engine;
        IProject project = file == null ? null : file.getProject();
        ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
        if (seamProject == null) {
            return null;
        }
        String prefix = (engine = new SeamELCompletionEngine()).getJavaElementExpression(document, region.getOffset(), region, start, end);
        prefix = prefix == null ? "" : prefix;
        ELExpression exp = engine.parseOperand(prefix);
        if (exp == null) {
            return null;
        }
        HashMap map = new HashMap();
        exp.getModel().shift(region.getOffset() - exp.getFirstToken().getStart());
        if (!(exp instanceof ELInvocationExpression || exp instanceof ELPropertyInvocation || exp instanceof ELArgumentInvocation)) {
            return null;
        }
        String propertyName = null;
        if (exp instanceof ELPropertyInvocation) {
            propertyName = ((ELPropertyInvocation)exp).getMemberName();
        } else if (exp instanceof ELArgumentInvocation) {
            propertyName = Utils.trimQuotes((String)((ELArgumentInvocation)exp).getArgument().getArgument().getText());
        }
        if (propertyName == null) {
            return null;
        }
        ScopeType scope = SeamELCompletionEngine.getScope((ISeamProject)seamProject, (IResource)file);
        ELInvocationExpression left = expr = (ELInvocationExpression)exp;
        if (expr.getLeft() != null) {
            while (left != null) {
                List resolvedVars = new ArrayList();
                resolvedVars = engine.resolveVariables(seamProject, scope, left, left == expr, true);
                if (resolvedVars != null && !resolvedVars.isEmpty()) {
                    map.put(left, resolvedVars);
                    break;
                }
                left = left.getLeft();
            }
        }
        HashMap<String, ISeamMessages> messages = new HashMap<String, ISeamMessages>();
        if (map != null && !map.isEmpty()) {
            for (ELInvocationExpression l : map.keySet()) {
                List variables = (List)map.get(l);
                for (ISeamContextVariable variable : variables) {
                    ISeamMessages messagesVariable = SeamELCompletionEngine.getSeamMessagesComponentVariable((ISeamContextVariable)variable);
                    if (messagesVariable == null) continue;
                    messages.put(propertyName, messagesVariable);
                }
            }
        }
        return messages;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkStartPosition(IDocument document, int offset) {
        try {
            while (true) {
                if (--offset < 0) {
                    return false;
                }
                if ('}' == document.getChar(offset)) {
                    return false;
                }
                if ('\"' == document.getChar(offset) && offset - 1 >= 0 && '\\' != document.getChar(offset - 1)) {
                    return false;
                }
                if ('{' != document.getChar(offset) || offset - 1 < 0) continue;
                if ('#' == document.getChar(offset - 1)) return true;
                if ('$' == document.getChar(offset - 1)) break;
            }
            return true;
        }
        catch (BadLocationException e) {
            SeamExtPlugin.getPluginLog().logError((Throwable)e);
        }
        return false;
    }
}

