/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.text.ext.hyperlink;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.text.ext.hyperlink.AbstractHyperlink;
import org.jboss.tools.common.text.ext.hyperlink.xpl.Messages;
import org.jboss.tools.seam.core.ISeamMessages;
import org.jboss.tools.seam.text.ext.hyperlink.SeamBeanHyperlinkPartitioner;

public class SeamMessagesBeanHyperlink
extends AbstractHyperlink {
    IRegion fLastRegion = null;

    protected void doHyperlink(IRegion region) {
        Map<String, ISeamMessages> messages = SeamBeanHyperlinkPartitioner.findMessagesComponents(this.getDocument(), region);
        if (messages == null || messages.isEmpty()) {
            this.openFileFailed();
            return;
        }
        for (String property : messages.keySet()) {
            ISeamMessages messagesComponent = messages.get(property);
            Map resources = messagesComponent.getResourcesMap();
            if (resources == null || resources.isEmpty()) continue;
            for (String bundle : resources.keySet()) {
                int result;
                XModelObject xmoChild;
                IResource resource = (IResource)resources.get(bundle);
                XModelObject xmo = EclipseResourceUtil.getObjectByResource((IResource)resource);
                if (xmo == null || (xmoChild = xmo.getChildByPath(property)) == null || (result = FindObjectHelper.findModelObject((XModelObject)xmoChild, (int)FindObjectHelper.IN_EDITOR_ONLY)) != 0) continue;
                return;
            }
        }
        this.openFileFailed();
    }

    protected IRegion doGetHyperlinkRegion(int offset) {
        this.fLastRegion = SeamBeanHyperlinkPartitioner.getMessagesPropertyRegion(this.getDocument(), offset);
        return this.fLastRegion;
    }

    public String getHyperlinkText() {
        String beanName;
        try {
            beanName = this.getDocument().get(this.fLastRegion.getOffset(), this.fLastRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            beanName = null;
        }
        if (beanName == null) {
            return MessageFormat.format(Messages.NotFound, Messages.Bean);
        }
        return MessageFormat.format(Messages.OpenBean, beanName);
    }
}

