/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.dialog;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamRuntimeManager;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.ui.dialog.EarFileSetProvider;
import org.jboss.tools.seam.ui.dialog.FileSetLabelProvider;
import org.jboss.tools.seam.ui.dialog.Messages;
import org.jboss.tools.seam.ui.dialog.RemovedFileSetProvider;
import org.jboss.tools.seam.ui.dialog.WarFileSetProvider;
import org.jboss.tools.seam.ui.widget.editor.SeamRuntimeListFieldEditor;
import org.jboss.tools.seam.ui.wizard.SeamFormWizard;
import org.jboss.tools.seam.ui.wizard.SeamWizardUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamFacetVersionChangeDialog
extends TitleAreaDialog {
    private IProjectFacetVersion fv;
    private IEclipsePreferences preferences;
    private IProject warProject;
    private Image _dlgTitleImage;
    private Combo seamRuntimeCombo;
    private Text seamRuntimeNameText;
    private CheckboxTableViewer removed;
    private ListViewer added;
    private ListViewer addedEar;
    private CheckboxTableViewer removedEar;
    private Button updateLibs;
    private static IOverwriteQuery OVERWRITE_ALL = new IOverwriteQuery(){

        public String queryOverwrite(String file) {
            return "ALL";
        }
    };
    private static String[] filePattern = new String[]{"jboss-seam", "antlr-", "commons-beanutils", "commons-digester", "commons-jci", "commons-collections", "core.", "drools-", "ajax4jsf", "jboss-el", "jbpm", "jsf-facelets", "jxl.jar", "mvel", "richfaces", "janino", "el-ri", "stringtemplate", "oscache-"};

    public SeamFacetVersionChangeDialog(Shell parentShell, IFacetedProject facetedProject, IProjectFacetVersion fv) {
        super(parentShell);
        Assert.isNotNull((Object)facetedProject);
        this.setShellStyle(0x10C70 | SeamFacetVersionChangeDialog.getDefaultOrientation());
        this.fv = fv;
        this.warProject = SeamWizardUtils.getRootSeamProject(facetedProject.getProject());
        Assert.isNotNull((Object)this.warProject);
        this.preferences = SeamCorePlugin.getSeamPreferences((IProject)this.warProject);
        this._dlgTitleImage = ImageDescriptor.createFromFile(SeamFormWizard.class, (String)"SeamWebProjectWizBan.png").createImage();
        this.setTitleImage(this._dlgTitleImage);
    }

    protected Control createDialogArea(Composite parent) {
        Font mainFont = parent.getFont();
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        GridData gd = new GridData(1808);
        contents.setLayoutData((Object)gd);
        contents.setLayout((Layout)new GridLayout(3, false));
        this.setTitle(Messages.SeamFacetVersionChangeDialog_Seam_Runtime_Settings);
        this.setMessage(Messages.SeamFacetVersionChangeDialog_Set_Seam_Runtime);
        this.getShell().setText(Messages.SeamFacetVersionChangeDialog_Seam_Runtime_Settings);
        SeamFacetVersionChangeDialog.applyDialogFont((Control)contents);
        this.initializeDialogUnits((Control)area);
        Label oldSeamRuntimeLabel = new Label(contents, 0);
        oldSeamRuntimeLabel.setText(Messages.SeamFacetVersionChangeDialog_Old_Seam_Runtime);
        String seamRuntimeName = "";
        if (this.preferences != null) {
            seamRuntimeName = this.preferences.get("seam.runtime.name", "");
        }
        this.seamRuntimeNameText = new Text(contents, 2048);
        this.seamRuntimeNameText.setText(seamRuntimeName);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.seamRuntimeNameText.setEnabled(false);
        this.seamRuntimeNameText.setLayoutData((Object)gd);
        Label seamRuntimeLabel = new Label(contents, 0);
        seamRuntimeLabel.setText(Messages.SeamFacetVersionChangeDialog_New_Seam_Runtime);
        this.seamRuntimeCombo = new Combo(contents, 8);
        gd = new GridData(768);
        this.seamRuntimeCombo.setLayoutData((Object)gd);
        final SeamVersion version = this.refreshSeamRuntimeCombo();
        Button addSeamRuntime = new Button(contents, 8);
        addSeamRuntime.setText(Messages.SeamFacetVersionChangeDialog_Add);
        addSeamRuntime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<SeamRuntime> added = new ArrayList<SeamRuntime>();
                ArrayList<SeamVersion> versions = new ArrayList<SeamVersion>();
                versions.add(version);
                SeamRuntimeListFieldEditor.SeamRuntimeNewWizard wiz = new SeamRuntimeListFieldEditor.SeamRuntimeNewWizard(new ArrayList<SeamRuntime>(Arrays.asList(SeamRuntimeManager.getInstance().getRuntimes())), added, versions);
                WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
                int ok = dialog.open();
                if (ok == 0 && !added.isEmpty()) {
                    SeamRuntimeManager.getInstance().addRuntime((SeamRuntime)added.get(0));
                    SeamFacetVersionChangeDialog.this.refreshSeamRuntimeCombo();
                }
                SeamFacetVersionChangeDialog.this.refresh();
            }
        });
        Group libraryGroup = new Group(contents, 0);
        libraryGroup.setText(Messages.SeamFacetVersionChangeDialog_Libraries);
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        libraryGroup.setLayoutData((Object)gd);
        libraryGroup.setLayout((Layout)new GridLayout(2, false));
        this.updateLibs = new Button((Composite)libraryGroup, 32);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.updateLibs.setLayoutData((Object)gd);
        this.updateLibs.setText(Messages.SeamFacetVersionChangeDialog_Update_libraries);
        this.updateLibs.setSelection(false);
        Label warProjectLabel = new Label((Composite)libraryGroup, 0);
        warProjectLabel.setText(NLS.bind((String)Messages.SeamFacetVersionChangeDialog_Project, (Object)this.warProject.getName()));
        gd = new GridData(770);
        gd.horizontalSpan = 2;
        warProjectLabel.setLayoutData((Object)gd);
        this.addLabels((Composite)libraryGroup);
        this.removed = CheckboxTableViewer.newCheckList((Composite)libraryGroup, (int)2180);
        gd = new GridData(1808);
        gd.heightHint = 150;
        this.removed.getTable().setLayoutData((Object)gd);
        this.removed.getTable().setFont(mainFont);
        FileSetLabelProvider labelProvider = new FileSetLabelProvider();
        this.removed.setLabelProvider((IBaseLabelProvider)labelProvider);
        File webLibFolder = this.getWebLibFolder();
        RemovedFileSetProvider rContentProvider = new RemovedFileSetProvider();
        this.removed.setContentProvider((IContentProvider)rContentProvider);
        this.removed.setInput((Object)webLibFolder);
        this.removed.getTable().setEnabled(false);
        this.removed.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SeamFacetVersionChangeDialog.this.removed.setSelection((ISelection)new StructuredSelection(event.getElement()));
            }
        });
        this.check(this.removed, rContentProvider);
        this.added = new ListViewer((Composite)libraryGroup, 2816);
        gd = new GridData(1808);
        gd.heightHint = 150;
        this.added.getList().setLayoutData((Object)gd);
        this.added.getList().setFont(mainFont);
        this.added.setLabelProvider((IBaseLabelProvider)labelProvider);
        SeamVersion newVersion = null;
        newVersion = this.seamRuntimeCombo.getText().trim().length() > 0 ? SeamRuntimeManager.getInstance().findRuntimeByName(this.seamRuntimeCombo.getText()).getVersion() : SeamVersion.findByString((String)this.fv.getVersionString());
        WarFileSetProvider aContentProvider = new WarFileSetProvider(this.isWarConfiguration(), newVersion);
        this.added.setContentProvider((IContentProvider)aContentProvider);
        this.added.getList().setEnabled(false);
        File earContentsFolder = this.getEarContentsFolder();
        if (earContentsFolder != null && earContentsFolder.isDirectory()) {
            Label earProjectLabel = new Label((Composite)libraryGroup, 0);
            String earProjectName = this.preferences.get("seam.ear.project", "");
            earProjectLabel.setText(NLS.bind((String)Messages.SeamFacetVersionChangeDialog_Project, (Object)earProjectName));
            gd = new GridData(770);
            gd.horizontalSpan = 2;
            earProjectLabel.setLayoutData((Object)gd);
            this.addLabels((Composite)libraryGroup);
            this.removedEar = CheckboxTableViewer.newCheckList((Composite)libraryGroup, (int)2180);
            gd = new GridData(1808);
            gd.heightHint = 150;
            this.removedEar.getTable().setLayoutData((Object)gd);
            this.removedEar.getTable().setFont(mainFont);
            this.removedEar.setLabelProvider((IBaseLabelProvider)labelProvider);
            RemovedFileSetProvider rEarContentProvider = new RemovedFileSetProvider();
            this.removedEar.setContentProvider((IContentProvider)rEarContentProvider);
            this.removedEar.setInput((Object)earContentsFolder);
            this.removedEar.getTable().setEnabled(false);
            this.removedEar.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    SeamFacetVersionChangeDialog.this.removedEar.setSelection((ISelection)new StructuredSelection(event.getElement()));
                }
            });
            this.check(this.removedEar, rEarContentProvider);
            this.addedEar = new ListViewer((Composite)libraryGroup, 2816);
            gd = new GridData(1808);
            gd.heightHint = 150;
            this.addedEar.getList().setLayoutData((Object)gd);
            this.addedEar.getList().setFont(mainFont);
            this.addedEar.setLabelProvider((IBaseLabelProvider)labelProvider);
            EarFileSetProvider aEarContentProvider = new EarFileSetProvider(newVersion);
            this.addedEar.setContentProvider((IContentProvider)aEarContentProvider);
            this.addedEar.getList().setEnabled(false);
        }
        this.updateLibs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SeamFacetVersionChangeDialog.this.added.getList().setEnabled(SeamFacetVersionChangeDialog.this.updateLibs.getSelection());
                SeamFacetVersionChangeDialog.this.removed.getTable().setEnabled(SeamFacetVersionChangeDialog.this.updateLibs.getSelection());
                if (SeamFacetVersionChangeDialog.this.addedEar != null) {
                    SeamFacetVersionChangeDialog.this.removedEar.getTable().setEnabled(SeamFacetVersionChangeDialog.this.updateLibs.getSelection());
                    SeamFacetVersionChangeDialog.this.addedEar.getList().setEnabled(SeamFacetVersionChangeDialog.this.updateLibs.getSelection());
                }
            }
        });
        Group noteGroup = new Group(contents, 0);
        noteGroup.setText(Messages.SeamFacetVersionChangeDialog_Note);
        noteGroup.setLayout((Layout)new GridLayout(2, false));
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        noteGroup.setLayoutData((Object)gd);
        Label noteImage = new Label((Composite)noteGroup, 0);
        Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        noteImage.setImage(image);
        Label noteLabel = new Label((Composite)noteGroup, 0);
        noteLabel.setText(Messages.SeamFacetVersionChangeDialog_Note_description);
        this.seamRuntimeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SeamFacetVersionChangeDialog.this.refresh();
            }
        });
        this.refresh();
        return area;
    }

    private SeamVersion refreshSeamRuntimeCombo() {
        SeamVersion version = SeamVersion.findByString((String)this.fv.getVersionString());
        String[] runtimeNames = this.getRuntimeNames(version);
        this.seamRuntimeCombo.setItems(runtimeNames);
        if (runtimeNames.length > 0 && this.seamRuntimeCombo.getText().trim().length() <= 0) {
            this.seamRuntimeCombo.select(0);
        }
        return version;
    }

    private void refresh() {
        this.updateButton();
        File seamHomePath = this.getSeamHomePath();
        this.added.setInput((Object)seamHomePath);
        if (this.addedEar != null) {
            this.addedEar.setInput((Object)seamHomePath);
        }
    }

    private void updateButton() {
        Button okButton = this.getButton(0);
        if (okButton != null) {
            boolean ok = this.seamRuntimeCombo.getText().trim().length() > 0;
            okButton.setEnabled(ok);
        }
    }

    private void addLabels(Composite composite) {
        Label removedLibs = new Label(composite, 0);
        GridData gd = new GridData(768);
        removedLibs.setLayoutData((Object)gd);
        removedLibs.setText(Messages.SeamFacetVersionChangeDialog_Libraries_to_be_removed);
        Label addedLibs = new Label(composite, 0);
        addedLibs.setText(Messages.SeamFacetVersionChangeDialog_Libraries_to_be_added);
        gd = new GridData(768);
        addedLibs.setLayoutData((Object)gd);
    }

    private File getEarContentsFolder() {
        IContainer earContentsFolder = this.getEarContentsEclipseFolder();
        if (earContentsFolder == null) {
            return null;
        }
        return earContentsFolder.getLocation().toFile();
    }

    private IContainer getEarContentsEclipseFolder() {
        IProject earProject;
        String earProjectName = this.preferences.get("seam.ear.project", "");
        if (earProjectName != null && earProjectName.trim().length() > 0 && (earProject = ResourcesPlugin.getWorkspace().getRoot().getProject(earProjectName)) != null && earProject.isOpen()) {
            IVirtualComponent component = ComponentCore.createComponent((IProject)earProject);
            IVirtualFolder rootVirtFolder = component.getRootFolder().getFolder((IPath)new Path("/"));
            return rootVirtFolder.getUnderlyingFolder();
        }
        return null;
    }

    private void check(CheckboxTableViewer removed, IStructuredContentProvider rContentProvider) {
        Object[] elements = rContentProvider.getElements(null);
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof File) {
                File file = (File)elements[i];
                removed.setChecked(elements[i], this.getChecked(file));
            }
            ++i;
        }
    }

    private boolean getChecked(File file) {
        int i = 0;
        while (i < filePattern.length) {
            if (file.getName().startsWith(filePattern[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private File getSeamHomePath() {
        SeamRuntime selectedSeamRuntime;
        String selectedSeamName = this.seamRuntimeCombo.getText();
        if (selectedSeamName != null && selectedSeamName.trim().length() > 0 && (selectedSeamRuntime = SeamRuntimeManager.getInstance().findRuntimeByName(selectedSeamName)) != null) {
            return new File(selectedSeamRuntime.getHomeDir());
        }
        return null;
    }

    private File getWebLibFolder() {
        IContainer webLibFolder = this.getWebLibEclipseFolder();
        return webLibFolder.getLocation().toFile();
    }

    private IContainer getWebLibEclipseFolder() {
        IVirtualComponent component = ComponentCore.createComponent((IProject)this.warProject);
        IVirtualFolder libFolder = component.getRootFolder().getFolder((IPath)new Path("/WEB-INF/lib"));
        IContainer webLibFolder = libFolder.getUnderlyingFolder();
        return webLibFolder;
    }

    private String[] getRuntimeNames(SeamVersion seamVersion) {
        SeamRuntime[] rts = SeamRuntimeManager.getInstance().getRuntimes(seamVersion);
        String[] names = new String[rts.length];
        int i = 0;
        while (i < names.length) {
            names[i] = rts[i].getName();
            ++i;
        }
        return names;
    }

    public boolean close() {
        if (this._dlgTitleImage != null) {
            this._dlgTitleImage.dispose();
        }
        return super.close();
    }

    private boolean isWarConfiguration() {
        if (this.preferences == null) {
            return false;
        }
        return this.preferences.get("seam.project.deployment.type", "war").equals("war");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateButton();
    }

    protected void okPressed() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    SeamFacetVersionChangeDialog.this.setSeamSettings();
                    SeamFacetVersionChangeDialog.this.updateLibraries();
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        super.okPressed();
    }

    protected void setSeamSettings() {
        IEclipsePreferences prefs = this.preferences;
        if (prefs == null) {
            ProjectScope projectScope = new ProjectScope(this.warProject);
            prefs = projectScope.getNode("org.jboss.tools.seam.core");
        }
        prefs.put("seam.project.settings.version", "1.1");
        prefs.put("seam.runtime.name", this.seamRuntimeCombo.getText());
    }

    private void updateLibraries() throws CoreException {
        if (this.updateLibs.getSelection()) {
            IContainer webLibContainer = this.getWebLibEclipseFolder();
            this.processProject(webLibContainer, this.removed, this.added);
            if (this.removedEar != null) {
                IContainer earContentsFolder = this.getEarContentsEclipseFolder();
                this.processProject(earContentsFolder, this.removedEar, this.addedEar);
            }
        }
    }

    private void processProject(IContainer container, CheckboxTableViewer cbtViewer, ListViewer listViewer) throws CoreException {
        if (container != null) {
            this.removeFiles(container, cbtViewer.getCheckedElements());
            IStructuredContentProvider structuredProvider = (IStructuredContentProvider)listViewer.getContentProvider();
            Object[] addedElements = structuredProvider.getElements(null);
            Map<File, List<File>> parentMaps = this.getImportMaps(addedElements);
            IPath containerPath = container.getFullPath();
            FileSystemStructureProvider provider = FileSystemStructureProvider.INSTANCE;
            for (File parent : parentMaps.keySet()) {
                try {
                    ImportOperation op = new ImportOperation(containerPath, (Object)parent, (IImportStructureProvider)provider, OVERWRITE_ALL, parentMaps.get(parent));
                    op.setCreateContainerStructure(false);
                    op.run((IProgressMonitor)new NullProgressMonitor());
                }
                catch (InvocationTargetException e) {
                    SeamCorePlugin.getPluginLog().logError((Throwable)e);
                }
                catch (InterruptedException e) {
                    SeamCorePlugin.getPluginLog().logError((Throwable)e);
                }
            }
        }
    }

    private void removeFiles(IContainer container, Object[] elements) throws CoreException {
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof File) {
                File file = (File)elements[i];
                String name = file.getName();
                IResource resource = container.findMember(name);
                resource.delete(true, null);
            }
            ++i;
        }
    }

    private Map<File, List<File>> getImportMaps(Object[] elements) {
        HashMap<File, List<File>> parentMaps = new HashMap<File, List<File>>();
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof File) {
                List<File> files;
                File file = (File)elements[i];
                File parent = file.getParentFile();
                Set parents = parentMaps.keySet();
                if (parents.contains(parent)) {
                    files = (List)parentMaps.get(parent);
                    files.add(file);
                } else {
                    files = new ArrayList();
                    files.add(file);
                    parentMaps.put(parent, files);
                }
            }
            ++i;
        }
        return parentMaps;
    }
}

