/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.dialog;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.viewers.Viewer;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.internal.core.project.facet.AntCopyUtils;
import org.jboss.tools.seam.internal.core.project.facet.Seam2FacetInstallDelegate;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetAbstractInstallDelegate;
import org.jboss.tools.seam.internal.core.project.facet.SeamFacetInstallDelegate;
import org.jboss.tools.seam.ui.dialog.AbstractFileSetContentProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WarFileSetProvider
extends AbstractFileSetContentProvider {
    private boolean isWarConfiguration;
    private SeamVersion version;

    public WarFileSetProvider(boolean isWarConfiguration, SeamVersion version) {
        this.isWarConfiguration = isWarConfiguration;
        this.version = version;
    }

    private AntCopyUtils.FileSet getFileSet() {
        if (this.isWarConfiguration) {
            if (SeamVersion.SEAM_1_2.equals((Object)this.version)) {
                return SeamFacetInstallDelegate.JBOSS_WAR_LIB_FILESET_WAR_CONFIG;
            }
            return Seam2FacetInstallDelegate.JBOSS_WAR_LIB_FILESET_WAR_CONFIG;
        }
        if (SeamVersion.SEAM_1_2.equals((Object)this.version)) {
            return SeamFacetInstallDelegate.JBOSS_WAR_LIB_FILESET_EAR_CONFIG;
        }
        return Seam2FacetInstallDelegate.JBOSS_WAR_LIB_FILESET_EAR_CONFIG;
    }

    private String getDroolsLibPath() {
        if (SeamVersion.SEAM_1_2.equals((Object)this.version)) {
            return SeamFacetInstallDelegate.DROOLS_LIB_SEAM_RELATED_PATH;
        }
        return Seam2FacetInstallDelegate.DROOLS_LIB_SEAM_RELATED_PATH;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof File) {
            TreeSet<File> set = new TreeSet<File>();
            File seamHomePath = (File)newInput;
            set.addAll(this.getFiles(seamHomePath));
            File seamLibFolder = new File(seamHomePath, SeamFacetAbstractInstallDelegate.SEAM_LIB_RELATED_PATH);
            set.addAll(this.getFiles(seamLibFolder));
            File droolsLibFolder = new File(seamHomePath, this.getDroolsLibPath());
            set.addAll(this.getFiles(droolsLibFolder));
            this.elements = set.toArray(new File[0]);
        } else {
            this.elements = ZERO_ARRAY;
        }
        this.sort();
    }

    private List<File> getFiles(File dir) {
        ArrayList<File> list = new ArrayList<File>();
        if (dir == null || !dir.isDirectory()) {
            return list;
        }
        AntCopyUtils.FileSet set = this.getFileSet().dir(dir);
        AntCopyUtils.FileSetFileFilter filter = new AntCopyUtils.FileSetFileFilter(set);
        File[] files = dir.listFiles((FileFilter)filter);
        int i = 0;
        while (i < files.length) {
            list.add(files[i]);
            ++i;
        }
        return list;
    }
}

