/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.handlers;

import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.seam.internal.core.SeamComponentDeclaration;
import org.jboss.tools.seam.internal.core.SeamJavaComponentDeclaration;
import org.jboss.tools.seam.ui.SeamUIMessages;
import org.jboss.tools.seam.ui.wizard.OpenSeamComponentDialog;

public class OpenSeamComponentHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        OpenSeamComponentDialog dialog = new OpenSeamComponentDialog(parent);
        dialog.setTitle(SeamUIMessages.OPEN_SEAM_COMPONENT_ACTION_ACTION_NAME);
        dialog.setMessage(SeamUIMessages.OPEN_SEAM_COMPONENT_ACTION_MESSAGE);
        int result = dialog.open();
        if (result != 0) {
            return null;
        }
        Object[] components = dialog.getResult();
        if (components != null && components.length > 0) {
            OpenSeamComponentDialog.SeamComponentWrapper wrapper = null;
            int i = 0;
            while (i < components.length) {
                wrapper = (OpenSeamComponentDialog.SeamComponentWrapper)components[i];
                SeamJavaComponentDeclaration javaDeclaration = (SeamJavaComponentDeclaration)wrapper.getComponent().getJavaDeclaration();
                if (javaDeclaration != null) {
                    javaDeclaration.open();
                } else {
                    Set declarations = wrapper.getComponent().getAllDeclarations();
                    if (declarations.iterator().hasNext()) {
                        ((SeamComponentDeclaration)declarations.iterator().next()).open();
                    }
                }
                ++i;
            }
        }
        return null;
    }
}

