/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.search;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchConstants;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jface.text.BadLocationException;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.resolver.ELCompletionEngine;
import org.jboss.tools.common.el.core.resolver.ElVarSearcher;
import org.jboss.tools.common.el.core.resolver.Var;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.el.SeamELCompletionEngine;
import org.jboss.tools.seam.ui.SeamGuiPlugin;
import org.jboss.tools.seam.ui.SeamUIMessages;
import org.jboss.tools.seam.ui.search.SeamSearchRequestor;
import org.jboss.tools.seam.ui.search.SeamSearchScope;
import org.jboss.tools.seam.ui.search.SeamSearchVisitor;

public abstract class SeamSearchEngine {
    private static SeamSearchEngine fInstance = null;
    private final IProgressMonitor fMonitor = new NullProgressMonitor();
    private SearchParticipant fParticipant = null;
    private IPath fSeamUIPluginLocation = null;
    private final CRC32 fChecksumCalculator = new CRC32();

    public static SeamSearchEngine getInstance() {
        if (fInstance == null) {
            fInstance = SeamSearchEngine.createDefault();
        }
        return fInstance;
    }

    private static SeamSearchEngine createDefault() {
        return new SeamSearchEngine(){

            public IStatus search(SeamSearchScope javaScope, SeamSearchRequestor requestor, IFile sourceFile, ELInvocationExpression tokens, IProgressMonitor monitor) {
                if (tokens == null) {
                    return Status.OK_STATUS;
                }
                IProject project = sourceFile == null ? null : sourceFile.getProject();
                ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)true);
                if (seamProject == null) {
                    return Status.OK_STATUS;
                }
                SeamELCompletionEngine engine = new SeamELCompletionEngine();
                String variableName = tokens.getText();
                Set variables = seamProject.getVariablesByName(variableName);
                if (variables != null && !variables.isEmpty()) {
                    return this.search(javaScope, requestor, sourceFile, variables.toArray(new ISeamContextVariable[0]), monitor);
                }
                List elements = null;
                try {
                    elements = engine.getJavaElementsForELOperandTokens(seamProject, sourceFile, tokens);
                }
                catch (StringIndexOutOfBoundsException e) {
                    SeamGuiPlugin.getPluginLog().logError((Throwable)e);
                    return Status.OK_STATUS;
                }
                catch (BadLocationException e) {
                    SeamGuiPlugin.getPluginLog().logError((Throwable)e);
                    return Status.OK_STATUS;
                }
                if (elements != null && !elements.isEmpty()) {
                    return this.search(javaScope, requestor, sourceFile, elements.toArray(new IJavaElement[0]), monitor);
                }
                ElVarSearcher varSearcher = new ElVarSearcher(sourceFile, (ELCompletionEngine)engine);
                tokens.getStartPosition();
                tokens.getEndPosition();
                StringBuffer elText = new StringBuffer();
                elText.append(tokens.toString());
                if (elText == null || elText.length() == 0) {
                    return Status.OK_STATUS;
                }
                List allVars = varSearcher.findAllVars(sourceFile, tokens.getStartPosition());
                Var var = varSearcher.findVarForEl(elText.toString(), allVars, true);
                if (var == null) {
                    var = varSearcher.findVar(sourceFile, tokens.getStartPosition());
                }
                if (var == null) {
                    return Status.OK_STATUS;
                }
                if (tokens.getLeft() == null) {
                    if (1.isSearchForDeclarations(javaScope.getLimitTo())) {
                        boolean res = SeamSearchVisitor.acceptPaternMatch(requestor, sourceFile, var.getDeclarationOffset(), var.getDeclarationLength());
                        if (!res) {
                            return Status.OK_STATUS;
                        }
                    } else {
                        return this.search(javaScope, requestor, sourceFile, new Var[]{var}, monitor);
                    }
                    return Status.OK_STATUS;
                }
                return Status.OK_STATUS;
            }

            public IStatus search(SeamSearchScope scope, SeamSearchRequestor requestor, IFile sourceFile, IJavaElement[] elements, IProgressMonitor monitor) {
                IProject project = sourceFile == null ? null : sourceFile.getProject();
                return new SeamSearchVisitor(requestor, elements, project).search(scope, monitor);
            }

            public IStatus search(SeamSearchScope scope, SeamSearchRequestor requestor, IFile sourceFile, Var[] vars, IProgressMonitor monitor) {
                if (sourceFile != null) {
                    sourceFile.getProject();
                }
                return new SeamSearchVisitor(requestor, vars, sourceFile).search(scope, monitor);
            }

            public IStatus search(String searchText, SeamSearchScope scope, int searchFor, int limitTo, int matchMode, boolean isCaseSensitive, SearchRequestor requestor) {
                SeamJavaSearchJob job = new SeamJavaSearchJob(searchText, scope, searchFor, limitTo, matchMode, isCaseSensitive, requestor);
                this.setCanceled(false);
                job.setUser(true);
                job.schedule();
                return Status.OK_STATUS;
            }

            public IStatus search(SeamSearchScope scope, SeamSearchRequestor requestor, IFile sourceFile, ISeamContextVariable[] variables, IProgressMonitor monitor) {
                IProject project = sourceFile == null ? null : sourceFile.getProject();
                return new SeamSearchVisitor(requestor, variables, project).search(scope, monitor);
            }
        };
    }

    public abstract IStatus search(SeamSearchScope var1, SeamSearchRequestor var2, IFile var3, ELInvocationExpression var4, IProgressMonitor var5);

    public abstract IStatus search(SeamSearchScope var1, SeamSearchRequestor var2, IFile var3, IJavaElement[] var4, IProgressMonitor var5);

    public abstract IStatus search(SeamSearchScope var1, SeamSearchRequestor var2, IFile var3, ISeamContextVariable[] var4, IProgressMonitor var5);

    public abstract IStatus search(SeamSearchScope var1, SeamSearchRequestor var2, IFile var3, Var[] var4, IProgressMonitor var5);

    public abstract IStatus search(String var1, SeamSearchScope var2, int var3, int var4, int var5, boolean var6, SearchRequestor var7);

    public final synchronized void setCanceled(boolean cancel) {
        this.fMonitor.setCanceled(cancel);
    }

    public final synchronized boolean isCanceled() {
        return this.fMonitor.isCanceled();
    }

    public final IPath computeIndexLocation(IPath containerPath) {
        IPath indexLocation = null;
        String pathString = containerPath.toOSString();
        this.fChecksumCalculator.reset();
        this.fChecksumCalculator.update(pathString.getBytes());
        String fileName = String.valueOf(Long.toString(this.fChecksumCalculator.getValue())) + ".index";
        indexLocation = this.getSeamUIPluginWorkingLocation().append(fileName);
        JavaModelManager.getJavaModelManager();
        JavaModelManager.getIndexManager().indexLocations.put((Object)containerPath, (Object)indexLocation);
        return indexLocation;
    }

    public IPath getSeamUIPluginWorkingLocation() {
        File folder;
        if (this.fSeamUIPluginLocation != null) {
            return this.fSeamUIPluginLocation;
        }
        IPath stateLocation = SeamGuiPlugin.getDefault().getStateLocation().append("seamsearch");
        String device = stateLocation.getDevice();
        if (device != null && device.charAt(0) == '/') {
            stateLocation = stateLocation.setDevice(device.substring(1));
        }
        if (!(folder = new File(stateLocation.toOSString())).isDirectory()) {
            try {
                folder.mkdir();
            }
            catch (SecurityException securityException) {}
        }
        this.fSeamUIPluginLocation = stateLocation;
        return this.fSeamUIPluginLocation;
    }

    public static boolean isSearchForDeclarations(int limitTo) {
        int maskedLimitTo = limitTo & 0xFFFFFFCF;
        return maskedLimitTo == 0 || maskedLimitTo == 3;
    }

    public static boolean isSearchForReferences(int limitTo) {
        int maskedLimitTo = limitTo & 0xFFFFFFCF;
        return maskedLimitTo == 2 || maskedLimitTo == 3;
    }

    public static boolean isField(IJavaElement element) {
        if (element == null) {
            return false;
        }
        return element.getElementType() == 8;
    }

    public static boolean isMethod(IJavaElement element) {
        if (element == null) {
            return false;
        }
        return element.getElementType() == 9;
    }

    public static boolean isType(IJavaElement element) {
        if (element == null) {
            return false;
        }
        return element.getElementType() == 7;
    }

    private class SeamJavaSearchJob
    extends Job
    implements IJavaSearchConstants {
        String fSearchText;
        IJavaSearchScope fScope;
        int fSearchFor;
        int fLimitTo;
        int fMatchMode;
        boolean fIsCaseSensitive;
        SearchRequestor fRequestor;
        IJavaElement fElement;

        public SeamJavaSearchJob(IJavaElement element, IJavaSearchScope scope, SearchRequestor requestor) {
            super(String.valueOf(SeamUIMessages.SeamSearch) + element.getElementName());
            this.fSearchText = "";
            this.fScope = null;
            this.fSearchFor = 4;
            this.fLimitTo = 3;
            this.fMatchMode = 2;
            this.fIsCaseSensitive = false;
            this.fRequestor = null;
            this.fElement = null;
            this.fElement = element;
            this.fScope = scope;
            this.fRequestor = requestor;
        }

        public SeamJavaSearchJob(String searchText, IJavaSearchScope scope, int searchFor, int limitTo, int matchMode, boolean isCaseSensitive, SearchRequestor requestor) {
            super(String.valueOf(SeamUIMessages.SeamSearch) + searchText);
            this.fSearchText = "";
            this.fScope = null;
            this.fSearchFor = 4;
            this.fLimitTo = 3;
            this.fMatchMode = 2;
            this.fIsCaseSensitive = false;
            this.fRequestor = null;
            this.fElement = null;
            this.fSearchText = searchText;
            this.fScope = scope;
            this.fSearchFor = searchFor;
            this.fLimitTo = limitTo;
            this.fMatchMode = matchMode;
            this.fIsCaseSensitive = isCaseSensitive;
            this.fRequestor = requestor;
        }

        public IStatus run(IProgressMonitor jobMonitor) {
            if (jobMonitor != null && jobMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (SeamSearchEngine.getInstance().isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            SearchPattern javaSearchPattern = null;
            SeamSearchEngine.isSearchForDeclarations(this.fLimitTo);
            SeamSearchEngine.isSearchForDeclarations(this.fLimitTo);
            javaSearchPattern = this.fElement != null ? SearchPattern.createPattern((IJavaElement)this.fElement, (int)this.fLimitTo) : SearchPattern.createPattern((String)this.fSearchText, (int)this.fSearchFor, (int)this.fLimitTo, (int)this.fMatchMode);
            if (SeamSearchEngine.isSearchForDeclarations(this.fLimitTo)) {
                javaSearchPattern = this.fElement != null ? SearchPattern.createPattern((IJavaElement)this.fElement, (int)this.fLimitTo) : SearchPattern.createPattern((String)this.fSearchText, (int)this.fSearchFor, (int)this.fLimitTo, (int)this.fMatchMode);
            }
            if (SeamSearchEngine.isSearchForReferences(this.fLimitTo)) {
                javaSearchPattern = this.fElement != null ? SearchPattern.createPattern((IJavaElement)this.fElement, (int)this.fLimitTo) : SearchPattern.createPattern((String)this.fSearchText, (int)this.fSearchFor, (int)this.fLimitTo, (int)this.fMatchMode);
            }
            return Status.OK_STATUS;
        }
    }
}

