/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.internal.ui.text.FileLabelProvider;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.java.IJavaSourceReference;
import org.jboss.tools.seam.core.ISeamContextVariable;
import org.jboss.tools.seam.core.ISeamElement;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.ui.views.SeamLabelProvider;

public class SeamSearchViewLabelProvider
extends LabelProvider {
    private FileLabelProvider fFileLabelProvider;
    private SeamLabelProvider fSeamLabelProvider;
    private JavaUILabelProvider fJavaLabelProvider;
    private AbstractTextSearchViewPage fPage;
    private int fOrderFlag;

    public SeamSearchViewLabelProvider(AbstractTextSearchViewPage page, int orderFlag) {
        this.fPage = page;
        this.fOrderFlag = orderFlag;
        this.fFileLabelProvider = new FileLabelProvider(page, orderFlag);
        this.fSeamLabelProvider = new SeamLabelProvider();
        this.fJavaLabelProvider = new JavaUILabelProvider();
    }

    public Image getImage(Object element) {
        if (element instanceof ISeamContextVariable || element instanceof IJavaSourceReference) {
            return this.fSeamLabelProvider.getImage(element);
        }
        if (element instanceof ISeamElement) {
            return this.fSeamLabelProvider.getImage(element);
        }
        if (element instanceof IProject) {
            ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)((IProject)element), (boolean)false);
            if (seamProject != null) {
                return this.fSeamLabelProvider.getImage(seamProject);
            }
            return this.fFileLabelProvider.getImage(element);
        }
        if (element instanceof IFolder) {
            return this.fFileLabelProvider.getImage(element);
        }
        if (element instanceof IFile) {
            return this.fFileLabelProvider.getImage(element);
        }
        if (element instanceof IJavaElement) {
            return this.fJavaLabelProvider.getImage(element);
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof ISeamContextVariable || element instanceof IJavaSourceReference) {
            return this.fSeamLabelProvider.getText(element);
        }
        if (element instanceof ISeamElement) {
            return this.fSeamLabelProvider.getText(element);
        }
        if (element instanceof IProject) {
            ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)((IProject)element), (boolean)false);
            if (seamProject != null) {
                return this.fSeamLabelProvider.getText(seamProject);
            }
            return this.fFileLabelProvider.getText(element);
        }
        if (element instanceof IFile) {
            return this.fFileLabelProvider.getText(element);
        }
        if (element instanceof IFolder) {
            return this.fFileLabelProvider.getText(element);
        }
        if (element instanceof IJavaElement) {
            return this.fJavaLabelProvider.getText(element);
        }
        return null;
    }
}

