/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.views.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.jboss.tools.common.el.core.ca.AbstractELCompletionEngine;
import org.jboss.tools.common.el.core.model.ELInstance;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.model.ELModel;
import org.jboss.tools.common.el.core.model.ELUtil;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.SimpleELContext;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.AttributeContentProposalProviderFactory;
import org.jboss.tools.common.model.ui.attribute.IAttributeContentProposalProvider;
import org.jboss.tools.common.text.TextProposal;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.internal.core.el.SeamELCompletionEngine;

public class SeamELAttributeContentProposalProvider
implements IAttributeContentProposalProvider {
    XModelObject object;
    XAttribute attribute;
    IFile file;
    SeamELCompletionEngine engine;
    static IContentProposal[] EMPTY = new IContentProposal[0];

    public boolean isRelevant(XModelObject object, XAttribute attribute) {
        if (attribute == null) {
            return false;
        }
        String module = attribute.getModelEntity().getModule();
        if (module == null || !module.startsWith("Seam")) {
            return false;
        }
        String entity = attribute.getModelEntity().getName();
        return !entity.startsWith("File");
    }

    public IContentProposalProvider getContentProposalProvider() {
        if (this.file == null || this.engine == null) {
            return null;
        }
        return new ContentProposalProvider();
    }

    public int getProposalAcceptanceStyle() {
        return 1;
    }

    public void init(XModelObject object, XEntityData data, XAttribute attribute) {
        IProject project;
        ISeamProject seamProject;
        IResource r;
        this.object = object;
        this.attribute = attribute;
        while (object != null && object.getFileType() != 1) {
            object = object.getParent();
        }
        if (object != null && (r = (IResource)object.getAdapter(IResource.class)) instanceof IFile) {
            this.file = (IFile)r;
        }
        if (this.file != null && (seamProject = SeamCorePlugin.getSeamProject((IProject)(project = this.file.getProject()), (boolean)true)) != null) {
            this.engine = new SeamELCompletionEngine();
        }
    }

    public String getPrefix(String content, int offset, int start, int end) throws StringIndexOutOfBoundsException {
        if (content == null || offset > content.length()) {
            return null;
        }
        ELInvocationExpression expr = SeamELCompletionEngine.findExpressionAtOffset((String)content, (int)offset, (int)start, (int)end);
        if (expr == null) {
            return null;
        }
        return content.substring(expr.getStartPosition(), offset);
    }

    private boolean isExpressionAllowed(String contents, int position) {
        String el = String.valueOf(contents.substring(0, position)) + "a";
        ELModel model1 = this.engine.getParserFactory().createParser().parse(el);
        ELInvocationExpression expr = ELUtil.findExpression((ELModel)model1, (int)el.length());
        return expr != null;
    }

    public void dispose() {
        this.object = null;
        this.attribute = null;
        this.file = null;
        this.engine = null;
    }

    public LabelProvider getCustomLabelProbider() {
        return null;
    }

    class ContentProposalProvider
    implements IContentProposalProvider {
        ContentProposalProvider() {
        }

        public IContentProposal[] getProposals(String contents, int position) {
            ELModel model = SeamELAttributeContentProposalProvider.this.engine.getParserFactory().createParser().parse(contents);
            ELInstance is = ELUtil.findInstance((ELModel)model, (int)position);
            if (is == null) {
                return EMPTY;
            }
            String prefix = SeamELAttributeContentProposalProvider.this.getPrefix(contents, position, 0, contents.length());
            if (!(prefix != null && prefix.length() != 0 || SeamELAttributeContentProposalProvider.this.isExpressionAllowed(contents, position))) {
                return EMPTY;
            }
            if (prefix == null) {
                prefix = "";
            }
            List suggestions = null;
            SimpleELContext context = new SimpleELContext();
            context.setResource(SeamELAttributeContentProposalProvider.this.file);
            suggestions = SeamELAttributeContentProposalProvider.this.engine.getProposals((ELContext)context, prefix, -1);
            if (suggestions == null) {
                return EMPTY;
            }
            List uniqueSuggestions = AbstractELCompletionEngine.makeProposalsUnique((List)suggestions);
            ArrayList<IContentProposal> list = new ArrayList<IContentProposal>();
            for (TextProposal p : uniqueSuggestions) {
                String label = String.valueOf(prefix) + p.getReplacementString();
                IContentProposal cp = AttributeContentProposalProviderFactory.makeContentProposal((String)p.getReplacementString(), (String)label, null);
                list.add(cp);
            }
            return list.toArray(new IContentProposal[0]);
        }
    }
}

