/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.widget.editor;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.jboss.tools.common.ui.widget.editor.BaseFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.IFieldEditorFactory;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamUtil;
import org.jboss.tools.seam.core.project.facet.SeamRuntime;
import org.jboss.tools.seam.core.project.facet.SeamVersion;
import org.jboss.tools.seam.ui.SeamUIMessages;
import org.jboss.tools.seam.ui.internal.project.facet.SeamValidatorFactory;
import org.jboss.tools.seam.ui.wizard.SeamFormWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamRuntimeListFieldEditor
extends BaseFieldEditor {
    static final int GL_COLUMNS = 2;
    static final int GL_HINT_HEIGHT = 200;
    static final int TC_DEFAULT_WIDTH = 21;
    static final int TC_NAME_WIDTH = 100;
    static final int TC_VERSION_WIDTH = 50;
    static final int TC_PATH_WIDTH = 100;
    private CheckboxTableViewer tableView = null;
    private Composite root = null;
    private ActionPanel actionPanel;
    private Map<SeamRuntime, SeamRuntime> changed = new HashMap<SeamRuntime, SeamRuntime>();
    private List<SeamRuntime> checkedElements = new ArrayList<SeamRuntime>();
    private List<SeamRuntime> added = new ArrayList<SeamRuntime>();
    private List<SeamRuntime> removed = new ArrayList<SeamRuntime>();

    public SeamRuntimeListFieldEditor(String name, String label, Object defaultValue) {
        super(name, label, defaultValue);
    }

    public List<SeamRuntime> getDefaultSeamRuntimes() {
        return this.checkedElements;
    }

    public List<SeamRuntime> getAddedSeamRuntimes() {
        return this.added;
    }

    public Map<SeamRuntime, SeamRuntime> getChangedSeamRuntimes() {
        return this.changed;
    }

    public List<SeamRuntime> getRemoved() {
        return this.removed;
    }

    public Object[] getEditorControls(Object composite) {
        this.root = new Composite((Composite)composite, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.root.setLayoutData((Object)gd);
        this.root.setLayout((Layout)new FormLayout());
        this.createTableView();
        this.createActionBar();
        FormData tableData = new FormData();
        tableData.left = new FormAttachment(0, 5);
        tableData.right = new FormAttachment((Control)this.actionPanel, -5);
        tableData.top = new FormAttachment(0, 5);
        tableData.bottom = new FormAttachment(100, -5);
        this.tableView.getControl().setLayoutData((Object)tableData);
        FormData actionsData = new FormData();
        actionsData.top = new FormAttachment(0, 5);
        actionsData.bottom = new FormAttachment(100, -5);
        actionsData.right = new FormAttachment(100, -5);
        this.actionPanel.setLayoutData(actionsData);
        return new Control[]{this.root};
    }

    protected void createTableView() {
        this.tableView = CheckboxTableViewer.newCheckList((Composite)this.root, (int)68100);
        TableColumn tc1 = new TableColumn(this.tableView.getTable(), 0x1000000);
        tc1.setWidth(21);
        tc1.setResizable(false);
        TableColumn tc2 = new TableColumn(this.tableView.getTable(), 16384);
        tc2.setWidth(100);
        tc2.setText(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_NAME);
        TableColumn tc3 = new TableColumn(this.tableView.getTable(), 16384);
        tc3.setWidth(50);
        tc3.setText(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_VERSION);
        TableColumn tc4 = new TableColumn(this.tableView.getTable(), 16384);
        tc4.setWidth(100);
        tc4.setText(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_PATH);
        this.tableView.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                throw new IllegalArgumentException(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_INPUTELEMENT_MUST_BE_LIST);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                viewer.refresh();
            }
        });
        this.tableView.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){
            private static final int TC_DEFAULT_NUMBER = 0;
            private static final int TC_NAME_NUMBER = 1;
            private static final int TC_VERSION_NUMBER = 2;
            private static final int TC_PATH_NUMBER = 3;

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                SeamRuntime rt = (SeamRuntime)element;
                if (columnIndex == 0) {
                    return "";
                }
                if (columnIndex == 1) {
                    return rt.getName();
                }
                if (columnIndex == 2) {
                    return rt.getVersion().toString();
                }
                if (columnIndex == 3) {
                    return rt.getHomeDir();
                }
                return "";
            }
        });
        this.tableView.setInput(this.getValue());
        this.tableView.getTable().setLinesVisible(true);
        this.tableView.getTable().setHeaderVisible(true);
        this.tableView.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                SeamRuntime selRt = (SeamRuntime)event.getElement();
                if (event.getChecked()) {
                    SeamRuntime deselRt = null;
                    Object[] selRts = SeamRuntimeListFieldEditor.this.tableView.getCheckedElements();
                    int i = 0;
                    while (i < selRts.length) {
                        SeamRuntime rt = (SeamRuntime)selRts[i];
                        if (rt.getVersion() == selRt.getVersion() && rt != selRt) {
                            deselRt = rt;
                            break;
                        }
                        ++i;
                    }
                    if (deselRt != null) {
                        Object[] newChecked = new Object[selRts.length - 1];
                        SeamRuntimeListFieldEditor.this.checkedElements.clear();
                        int i2 = 0;
                        Object[] objectArray = selRts;
                        int n = selRts.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object object = objectArray[n2];
                            SeamRuntime rt = (SeamRuntime)object;
                            if (rt.getVersion() != selRt.getVersion() || rt == selRt) {
                                newChecked[i2] = rt;
                                SeamRuntimeListFieldEditor.this.checkedElements.add(rt);
                                ++i2;
                            }
                            ++n2;
                        }
                        SeamRuntimeListFieldEditor.this.tableView.setCheckedElements(newChecked);
                    } else {
                        SeamRuntimeListFieldEditor.this.checkedElements.add((SeamRuntime)event.getElement());
                    }
                } else {
                    SeamRuntimeListFieldEditor.this.checkedElements.remove(selRt);
                }
                SeamRuntimeListFieldEditor.this.pcs.firePropertyChange(SeamRuntimeListFieldEditor.this.getName(), null, SeamRuntimeListFieldEditor.this.getValue());
            }
        });
        for (SeamRuntime rt : (List)this.getValue()) {
            if (!rt.isDefault()) continue;
            this.tableView.setChecked((Object)rt, true);
            this.checkedElements.add(rt);
        }
    }

    protected void createActionBar() {
        this.actionPanel = new ActionPanel(this.root, new BaseAction[]{new AddAction(), new EditAction(), new RemoveAction()});
        this.tableView.addSelectionChangedListener((ISelectionChangedListener)this.actionPanel);
    }

    private void setDefaultRuntimes() {
        List runtimes = (List)this.getValue();
        for (SeamRuntime seamRuntime : runtimes) {
            boolean checked = false;
            for (SeamRuntime checkedElement : this.checkedElements) {
                if (checkedElement.getVersion() != seamRuntime.getVersion()) continue;
                checked = true;
                break;
            }
            if (checked) continue;
            this.tableView.setChecked((Object)seamRuntime, true);
            this.checkedElements.add(seamRuntime);
        }
    }

    public Object[] getEditorControls() {
        return new Control[]{this.root};
    }

    public int getNumberOfControls() {
        return 1;
    }

    public void doFillIntoGrid(Object parent) {
        Assert.isTrue((boolean)(parent instanceof Composite), (String)SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_PARENT_CONTROL_SHOULD_BE_COMPOSITE);
        Assert.isTrue((boolean)(((Composite)parent).getLayout() instanceof GridLayout), (String)SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_EDITOR_SUPPORTS_ONLY_GRID_LAYOUT);
        Composite aComposite = (Composite)parent;
        Control[] cfr_ignored_0 = (Control[])this.getEditorControls(aComposite);
        GridLayout gl = (GridLayout)((Composite)parent).getLayout();
        GridData gd = new GridData();
        gd.horizontalSpan = gl.numColumns;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        ((Control)this.getEditorControls()[0]).setLayoutData((Object)gd);
    }

    public static class ActionButton
    implements IPropertyChangeListener {
        private Button button;
        private BaseAction action;

        public ActionButton(Composite parent, int style, BaseAction action) {
            this.button = new Button(parent, style);
            this.action = action;
            GridData gd = new GridData(768, 2, false, false);
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 2;
            this.button.setLayoutData((Object)gd);
            this.action.addPropertyChangeListener(this);
            this.button.setText(action.getText());
            this.button.setEnabled(action.isEnabled());
            this.button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ActionButton.this.action.run();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        public Control getControl() {
            return this.button;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("enabled")) {
                this.button.setEnabled(((Boolean)event.getNewValue()).booleanValue());
            }
        }
    }

    public static class ActionPanel
    extends Composite
    implements ISelectionChangedListener {
        private BaseAction[] actions = null;

        public ActionPanel(Composite parent, int style, BaseAction[] actions) {
            super(parent, style);
            this.actions = actions;
            this.setLayout((Layout)new GridLayout(1, false));
            BaseAction[] baseActionArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                BaseAction action = baseActionArray[n2];
                new ActionButton(this, 8, action);
                ++n2;
            }
        }

        public ActionPanel(Composite parent, BaseAction[] actions) {
            this(parent, 0, actions);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            BaseAction[] baseActionArray = this.actions;
            int n = this.actions.length;
            int n2 = 0;
            while (n2 < n) {
                BaseAction action = baseActionArray[n2];
                action.setSelection(event.getSelection());
                ++n2;
            }
        }
    }

    public class AddAction
    extends BaseAction {
        public AddAction() {
            super(SeamUIMessages.SeamRuntimeListFieldEditor_ActionAdd);
            this.setEnabled(true);
        }

        protected void updateEnablement() {
        }

        public void run() {
            SeamRuntimeNewWizard wiz = new SeamRuntimeNewWizard((List)SeamRuntimeListFieldEditor.this.getValue(), SeamRuntimeListFieldEditor.this.added);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
            dialog.open();
            SeamRuntimeListFieldEditor.this.tableView.refresh();
            SeamRuntimeListFieldEditor.this.setDefaultRuntimes();
        }
    }

    public abstract class BaseAction
    extends Action {
        SeamRuntime[] runtimes;

        public BaseAction(String name) {
            super(name);
            this.runtimes = new SeamRuntime[0];
            this.updateEnablement();
        }

        public void setSelection(ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                ArrayList<SeamRuntime> rts = new ArrayList<SeamRuntime>();
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object rt = objectArray[n2];
                    rts.add((SeamRuntime)rt);
                    ++n2;
                }
                this.runtimes = rts.toArray(new SeamRuntime[0]);
            } else {
                this.runtimes = new SeamRuntime[0];
            }
            this.updateEnablement();
        }

        protected abstract void updateEnablement();
    }

    public class EditAction
    extends BaseAction {
        public EditAction() {
            super(SeamUIMessages.SeamRuntimeListFieldEditor_ActionEdit);
        }

        protected void updateEnablement() {
            this.setEnabled(this.runtimes.length == 1);
        }

        public void run() {
            SeamRuntime c;
            SeamRuntime selected = this.runtimes[0];
            SeamRuntimeEditWizard wiz = new SeamRuntimeEditWizard((List)SeamRuntimeListFieldEditor.this.getValue(), this.runtimes[0], SeamRuntimeListFieldEditor.this.added, SeamRuntimeListFieldEditor.this.changed);
            WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wiz);
            dialog.open();
            SeamRuntimeListFieldEditor.this.tableView.refresh();
            if (SeamRuntimeListFieldEditor.this.changed.containsValue(selected) && (c = this.findChangedRuntime(selected)) != null) {
                SeamRuntimeListFieldEditor.this.tableView.setSelection((ISelection)new StructuredSelection((Object)c));
            }
        }

        private SeamRuntime findChangedRuntime(SeamRuntime source) {
            for (SeamRuntime r : SeamRuntimeListFieldEditor.this.changed.keySet()) {
                if (source != SeamRuntimeListFieldEditor.this.changed.get(r)) continue;
                return r;
            }
            return null;
        }
    }

    public class RemoveAction
    extends BaseAction {
        public RemoveAction() {
            super(SeamUIMessages.SeamRuntimeListFieldEditor_ActionRemove);
        }

        protected void updateEnablement() {
            this.setEnabled(this.runtimes.length > 0);
        }

        public void run() {
            SeamRuntime[] seamRuntimeArray = this.runtimes;
            int n = this.runtimes.length;
            int n2 = 0;
            while (n2 < n) {
                SeamRuntime rt = seamRuntimeArray[n2];
                this.removeRuntime(rt);
                ++n2;
            }
            SeamRuntimeListFieldEditor.this.tableView.refresh();
            SeamRuntimeListFieldEditor.this.setDefaultRuntimes();
        }

        private void removeRuntime(SeamRuntime r) {
            boolean used = this.isRuntimeUsed(r.getName());
            String title = SeamUIMessages.RUNTIME_DELETE_CONFIRM_TITLE;
            String message = used ? NLS.bind((String)SeamUIMessages.RUNTIME_DELETE_USED_CONFIRM, (Object)r.getName()) : NLS.bind((String)SeamUIMessages.RUNTIME_DELETE_NOT_USED_CONFIRM, (Object)r.getName());
            boolean b = MessageDialog.openConfirm((Shell)SeamRuntimeListFieldEditor.this.tableView.getControl().getShell(), (String)title, (String)message);
            if (b) {
                if (SeamRuntimeListFieldEditor.this.changed.containsKey(r)) {
                    r = (SeamRuntime)SeamRuntimeListFieldEditor.this.changed.remove(r);
                }
                SeamRuntimeListFieldEditor.this.removed.add(r);
                if (SeamRuntimeListFieldEditor.this.added.contains(r)) {
                    SeamRuntimeListFieldEditor.this.added.remove(r);
                }
                ((List)SeamRuntimeListFieldEditor.this.getValue()).remove(r);
            }
            SeamRuntimeListFieldEditor.this.checkedElements.remove(r);
        }

        private boolean isRuntimeUsed(String runtimeName) {
            IProject[] ps = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < ps.length) {
                ISeamProject sp = SeamCorePlugin.getSeamProject((IProject)ps[i], (boolean)false);
                if (sp != null && runtimeName.equals(sp.getRuntimeName())) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SeamRuntimeEditWizard
    extends Wizard {
        SeamRuntimeWizardPage page1 = null;
        List<SeamRuntime> added = null;
        Map<SeamRuntime, SeamRuntime> changed = null;
        List<SeamRuntime> value = null;
        SeamRuntime source = null;

        public SeamRuntimeEditWizard(List<SeamRuntime> existing, SeamRuntime source, List<SeamRuntime> added, Map<SeamRuntime, SeamRuntime> changed) {
            this.setWindowTitle(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_EDIT_SEAM_RUNTIME);
            this.page1 = new SeamRuntimeWizardPage(existing);
            this.page1.setMessage(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_MODIFY_SEAM_RUNTIME);
            this.page1.setTitle(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_EDIT_SEAM_RUNTIME);
            this.addPage((IWizardPage)this.page1);
            this.value = existing;
            this.added = added;
            this.changed = changed;
            this.source = source;
            this.page1.name.setValue((Object)source.getName());
            this.page1.homeDir.setValue((Object)source.getHomeDir());
            this.page1.version.setValue((Object)source.getVersion().toString());
            this.page1.current = source;
        }

        public boolean performFinish() {
            SeamRuntime rt = this.page1.getRuntime();
            if (rt.getName().equals(this.source.getName()) && rt.getVersion().toString().equals(this.source.getVersion().toString()) && rt.getHomeDir().equals(this.source.getHomeDir())) {
                return true;
            }
            if (this.added.contains(this.source) || this.changed.containsKey(this.source)) {
                this.source.setName(rt.getName());
                this.source.setHomeDir(rt.getName());
                this.source.setVersion(rt.getVersion());
            } else {
                this.changed.put(rt, this.source);
                int i = this.value.indexOf(this.source);
                if (i >= 0) {
                    this.value.set(i, rt);
                } else {
                    this.value.remove(this.source);
                    this.value.add(rt);
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SeamRuntimeNewWizard
    extends Wizard {
        SeamRuntimeWizardPage page1 = null;
        List<SeamRuntime> added = null;
        List<SeamRuntime> value = null;

        public SeamRuntimeNewWizard(List<SeamRuntime> exist, List<SeamRuntime> added, List<SeamVersion> validSeamVersions) {
            this.setWindowTitle(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_NEW_SEAM_RUNTIME);
            this.page1 = new SeamRuntimeWizardPage(exist, validSeamVersions);
            this.addPage((IWizardPage)this.page1);
            this.value = exist;
            this.added = added;
        }

        public SeamRuntimeNewWizard(List<SeamRuntime> existing, List<SeamRuntime> added) {
            this(existing, added, null);
        }

        public boolean performFinish() {
            SeamRuntime rt = this.page1.getRuntime();
            this.added.add(rt);
            this.value.add(rt);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SeamRuntimeWizardPage
    extends WizardPage
    implements PropertyChangeListener {
        private static final String SRT_NAME = "name";
        private static final String SRT_HOMEDIR = "homeDir";
        private static final String SRT_VERSION = "version";
        private static final int GL_PARENT_COLUMNS = 1;
        private static final int GL_CONTENT_COLUMNS = 3;
        List<SeamRuntime> value = null;
        IFieldEditor name = IFieldEditorFactory.INSTANCE.createTextEditor("name", SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_NAME2, "");
        IFieldEditor version = null;
        IFieldEditor homeDir = IFieldEditorFactory.INSTANCE.createBrowseFolderEditor("homeDir", SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_HOME_FOLDER, "");
        SeamRuntime current = null;
        List<SeamVersion> validSeamVersions = null;

        public SeamRuntimeWizardPage(List<SeamRuntime> editedList) {
            this(editedList, (List<SeamVersion>)null);
        }

        public SeamRuntimeWizardPage(List<SeamRuntime> editedList, List<SeamVersion> validSeamVersions) {
            super(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_NEW_SEAM_RUNTIME);
            if (validSeamVersions == null) {
                this.version = IFieldEditorFactory.INSTANCE.createComboEditor(SRT_VERSION, SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_VERSION2, Arrays.asList(SeamVersion.SEAM_1_2.toString(), SeamVersion.SEAM_2_0.toString(), SeamVersion.SEAM_2_1.toString(), SeamVersion.SEAM_2_2.toString()), (Object)SeamVersion.SEAM_1_2.toString(), false);
                this.validSeamVersions = new ArrayList<SeamVersion>();
                this.validSeamVersions.add(SeamVersion.SEAM_1_2);
                this.validSeamVersions.add(SeamVersion.SEAM_2_0);
                this.validSeamVersions.add(SeamVersion.SEAM_2_1);
                this.validSeamVersions.add(SeamVersion.SEAM_2_2);
            } else {
                this.version = IFieldEditorFactory.INSTANCE.createComboEditor(SRT_VERSION, SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_VERSION2, validSeamVersions, (Object)SeamVersion.SEAM_1_2.toString(), false);
                this.validSeamVersions = validSeamVersions;
            }
            this.setMessage(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_CREATE_A_SEAM_RUNTIME);
            this.setTitle(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_SEAM_RUNTIME);
            this.setImageDescriptor(ImageDescriptor.createFromFile(SeamFormWizard.class, (String)"SeamWebProjectWizBan.png"));
            this.value = editedList;
        }

        public SeamRuntimeWizardPage(List<SeamRuntime> editedList, SeamVersion validVersion) {
            this(editedList, Arrays.asList(validVersion));
        }

        public void createControl(Composite parent) {
            parent.setLayout((Layout)new GridLayout(1, false));
            GridData dg = new GridData();
            dg.horizontalAlignment = 4;
            dg.grabExcessHorizontalSpace = true;
            Composite root = new Composite(parent, 0);
            root.setLayoutData((Object)dg);
            GridLayout gl = new GridLayout(3, false);
            root.setLayout((Layout)gl);
            this.homeDir.doFillIntoGrid((Object)root);
            this.homeDir.addPropertyChangeListener((PropertyChangeListener)this);
            this.name.doFillIntoGrid((Object)root);
            this.name.addPropertyChangeListener((PropertyChangeListener)this);
            this.version.doFillIntoGrid((Object)root);
            SeamVersion sv = SeamVersion.findByString((String)this.version.getValueAsString());
            if (!this.validSeamVersions.contains(sv)) {
                this.version.setValue((Object)this.validSeamVersions.get(0));
            } else {
                this.version.setValue(this.version.getValue());
            }
            this.version.addPropertyChangeListener((PropertyChangeListener)this);
            this.setPageComplete(false);
            this.setControl((Control)root);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void propertyChange(java.beans.PropertyChangeEvent evt) {
            String seamVersion;
            block16: {
                if (SRT_HOMEDIR.equals(evt.getPropertyName()) && (this.name.getValueAsString() == null || "".equals(this.name.getValueAsString().trim()))) {
                    String homeDirName = this.homeDir.getValueAsString();
                    if (homeDirName != null && !"".equals(homeDirName.trim())) {
                        File folder = new File(homeDirName);
                        homeDirName = folder.getName();
                    }
                    this.name.setValue((Object)homeDirName);
                    String seamVersion2 = SeamUtil.getSeamVersionFromManifest((String)this.homeDir.getValueAsString());
                    if (seamVersion2 == null) {
                        this.setErrorMessage(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_CANNOT_FIND_JBOSS_SEAM_JAR);
                        this.setPageComplete(false);
                        return;
                    }
                    if (this.validSeamVersions != null) {
                        for (SeamVersion ver : this.validSeamVersions) {
                            if (!SeamUtil.areSeamVersionsMatched((String)ver.toString(), (String)seamVersion2)) continue;
                            this.version.setValue((Object)ver.toString());
                            break;
                        }
                    }
                }
                if (this.name.getValueAsString() == null || "".equals(this.name.getValueAsString().toString().trim())) {
                    this.setErrorMessage(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_NAME_CANNOT_BE_EMPTY);
                    this.setPageComplete(false);
                    return;
                }
                if (!this.name.getValueAsString().matches("[a-zA-Z_][a-zA-Z0-9_\\-\\. ]*")) {
                    this.setErrorMessage(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_RUNTIME_NAME_IS_NOT_CORRECT);
                    this.setPageComplete(false);
                    return;
                }
                for (SeamRuntime rt : this.value) {
                    if (this.current != null && this.current.getName().equals(rt.getName()) || !rt.getName().equals(this.name.getValueAsString())) continue;
                    this.setErrorMessage(NLS.bind((String)SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_RUNTIME_ALREADY_EXISTS, (Object)this.name.getValueAsString()));
                    this.setPageComplete(false);
                    return;
                }
                if (this.current != null && this.current.getName().equals(this.name.getValueAsString()) && this.current.getVersion().toString().equals(this.version.getValueAsString()) && this.current.getHomeDir().equals(this.homeDir.getValueAsString())) {
                    this.setErrorMessage(null);
                    this.setPageComplete(false);
                    this.setMessage(null);
                    return;
                }
                if (this.homeDir.getValueAsString() == null || "".equals(this.homeDir.getValueAsString().trim())) {
                    this.setErrorMessage(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_PATH_TO_SEAM_HOME_DIRECTORY_CANNOT_BE_EMPTY);
                    this.setPageComplete(false);
                    return;
                }
                seamVersion = SeamUtil.getSeamVersionFromManifest((String)this.homeDir.getValueAsString());
                if (seamVersion == null) {
                    this.setErrorMessage(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_CANNOT_FIND_JBOSS_SEAM_JAR);
                    this.setPageComplete(false);
                    return;
                }
                if ("".equals(seamVersion)) {
                    this.setMessage(SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_CANNOT_OBTAIN_SEAM_VERSION_NUMBER, 2);
                    this.setPageComplete(true);
                    return;
                }
                if (!SeamUtil.areSeamVersionsMatched((String)this.version.getValueAsString(), (String)seamVersion)) {
                    String trimmedVersion = SeamUtil.trimSeamVersion((String)this.version.getValueAsString(), (int)1);
                    String trimmedSeamVersion = SeamUtil.trimSeamVersion((String)seamVersion, (int)1);
                    if (SeamVersion.findMatchingVersion((String)seamVersion) == null && SeamUtil.areSeamVersionsMatched((String)trimmedVersion, (String)trimmedSeamVersion)) {
                        this.setMessage(NLS.bind((String)SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_THE_SELECTED_SEAM_APPEARS_TO_BE_OF_INCOMATIBLE_VERSION, (Object)seamVersion), 2);
                        break block16;
                    } else {
                        this.setErrorMessage(NLS.bind((String)SeamUIMessages.SEAM_RUNTIME_LIST_FIELD_EDITOR_THE_SELECTED_SEAM_APPEARS_TO_BE_OF_INCOMATIBLE_VERSION, (Object)seamVersion));
                        this.setPageComplete(false);
                        return;
                    }
                }
                this.setMessage(null);
            }
            Map errors = SeamValidatorFactory.JBOSS_SEAM_HOME_FOLDER_VALIDATOR.validate((Object)this.homeDir.getValueAsString(), (Object)seamVersion);
            if (errors != SeamValidatorFactory.NO_ERRORS) {
                this.setErrorMessage(((IStatus)errors.get("seam.home.folder")).getMessage());
                this.setPageComplete(false);
                return;
            }
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }

        public SeamRuntime getRuntime() {
            SeamRuntime newRt = new SeamRuntime();
            newRt.setName(this.name.getValueAsString());
            newRt.setVersion(SeamVersion.parseFromString((String)this.version.getValueAsString()));
            newRt.setHomeDir(this.homeDir.getValueAsString());
            return newRt;
        }
    }
}

