/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.ui.SeamUIMessages;
import org.jboss.tools.seam.ui.wizard.SeamBaseOperation;

public abstract class SeamBaseWizard
extends Wizard {
    private IUndoableOperation operation;
    private IWorkbench workbench;
    private IStructuredSelection selection;

    public SeamBaseWizard(IUndoableOperation operation) {
        this.operation = operation;
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    IStatus result;
                    IUndoableOperation operation = SeamBaseWizard.this.getOperation();
                    IOperationHistory operationHistory = SeamBaseWizard.this.workbench.getOperationSupport().getOperationHistory();
                    IUndoContext undoContext = SeamBaseWizard.this.workbench.getOperationSupport().getUndoContext();
                    operation.addContext(undoContext);
                    try {
                        result = operationHistory.execute(operation, monitor, (IAdaptable)SeamBaseWizard.this.getPages()[0]);
                        if (operation instanceof SeamBaseOperation) {
                            SeamBaseOperation seamOperation = (SeamBaseOperation)operation;
                            seamOperation.openResultInEditor((IAdaptable)SeamBaseWizard.this.getPages()[0]);
                        }
                    }
                    catch (ExecutionException e) {
                        result = new Status(4, "org.jboss.tools.seam.ui", e.getMessage(), (Throwable)e);
                        SeamCorePlugin.getPluginLog().logError((Throwable)e);
                    }
                    if (result.getSeverity() == 4) {
                        ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)MessageFormat.format("Error occur during creating {0}. Please, check Error Log View for details.", SeamBaseWizard.this.getWindowTitle()), (IStatus)result);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        catch (InterruptedException e) {
            SeamCorePlugin.getPluginLog().logError((Throwable)e);
        }
        return true;
    }

    public IUndoableOperation getOperation() {
        if (this.operation != null) {
            return this.operation;
        }
        throw new IllegalStateException(SeamUIMessages.SEAM_BASE_WIZARD_OPERATION_IS_NOT_DEFINED_FOR_WIZARD);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setSelection(selection);
    }

    protected IFacetedProjectTemplate getTemplate() {
        return ProjectFacetsManager.getTemplate((String)"template.jst.seam");
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    protected IStructuredSelection getInitialSelection() {
        return this.selection;
    }
}

