/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.jboss.tools.common.ui.CommonUIMessages;
import org.jboss.tools.common.ui.widget.editor.IFieldEditor;
import org.jboss.tools.common.ui.widget.editor.INamedElement;
import org.jboss.tools.common.ui.widget.field.RadioField;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamProjectsSet;
import org.jboss.tools.seam.internal.core.validation.SeamProjectPropertyValidator;
import org.jboss.tools.seam.ui.SeamUIMessages;
import org.jboss.tools.seam.ui.internal.project.facet.SeamValidatorFactory;
import org.jboss.tools.seam.ui.wizard.SeamGenerateEntitiesTablesWizardPage;
import org.jboss.tools.seam.ui.wizard.SeamWizardFactory;
import org.jboss.tools.seam.ui.wizard.SeamWizardUtils;

public class SeamGenerateEntitiesWizardPage
extends WizardPage
implements PropertyChangeListener,
IAdaptable {
    private IFieldEditor projectEditor;
    private IFieldEditor configEditor;
    private RadioField radios;
    IProject rootSeamProject;

    public SeamGenerateEntitiesWizardPage() {
        super("seam.generate.entities.page", SeamUIMessages.GENERATE_SEAM_ENTITIES_WIZARD_TITLE, null);
        this.setMessage(SeamUIMessages.GENERATE_SEAM_ENTITIES_WIZARD_PAGE_MESSAGE);
    }

    public void createControl(Composite parent) {
        this.rootSeamProject = SeamWizardUtils.getCurrentSelectedRootSeamProject();
        String projectName = this.rootSeamProject == null ? "" : this.rootSeamProject.getName();
        this.projectEditor = SeamWizardFactory.createSeamProjectSelectionFieldEditor(projectName);
        this.projectEditor.addPropertyChangeListener((PropertyChangeListener)this);
        if (projectName != null && projectName.length() > 0) {
            Map errors = SeamValidatorFactory.SEAM_PROJECT_NAME_VALIDATOR.validate(this.projectEditor.getValue(), null);
            if (!errors.isEmpty()) {
                IStatus message = (IStatus)errors.get("default.error");
                if (message.getSeverity() == 4) {
                    this.setErrorMessage(message.getMessage());
                    this.setPageComplete(false);
                } else {
                    this.setMessage(message.getMessage());
                }
            } else {
                this.setMessage(null);
            }
        } else {
            this.setMessage(SeamUIMessages.GENERATE_SEAM_ENTITIES_WIZARD_PAGE_MESSAGE);
            this.setPageComplete(false);
        }
        GridLayoutComposite top = new GridLayoutComposite(parent);
        GridLayoutComposite projectComposite = new GridLayoutComposite(top, 0, 4);
        this.projectEditor.doFillIntoGrid((Object)projectComposite);
        this.configEditor = SeamWizardFactory.createHibernateConsoleConfigurationSelectionFieldEditor(SeamGenerateEntitiesWizardPage.getConsoleConfigurationName(projectName));
        this.configEditor.addPropertyChangeListener((PropertyChangeListener)this);
        this.configEditor.doFillIntoGrid((Object)projectComposite);
        this.configEditor.setEditable(false);
        this.configEditor.addPropertyChangeListener((PropertyChangeListener)this);
        String config = (String)this.configEditor.getValue();
        if (config == null || config.length() == 0) {
            this.setMessage(SeamUIMessages.GENERATE_SEAM_ENTITIES_WIZARD_HIBERNATE_CONFIGURATION_MESSAGE);
            this.setPageComplete(false);
        }
        GridLayoutComposite groupComposite = new GridLayoutComposite(top);
        Group group = new Group((Composite)groupComposite, 0);
        group.setText(SeamUIMessages.GENERATE_SEAM_ENTITIES_WIZARD_GROUP_LABEL);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        GridLayoutComposite radioComposite = new GridLayoutComposite((Composite)group, 0, 2);
        ArrayList<String> values = new ArrayList<String>();
        values.add("reverse");
        values.add("existing");
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(SeamUIMessages.GENERATE_SEAM_ENTITIES_WIZARD_REVERSE_ENGINEER_LABEL);
        labels.add(SeamUIMessages.GENERATE_SEAM_ENTITIES_WIZARD_EXISTING_ENTITIES_LABEL);
        this.radios = new RadioField((Composite)radioComposite, labels, values, null, true);
        this.radios.addPropertyChangeListener((PropertyChangeListener)this);
        this.setControl((Control)top);
        this.validate();
    }

    private static String getConsoleConfigurationName(String seamWebProjectName) {
        if (seamWebProjectName == null || seamWebProjectName.trim().length() == 0) {
            return null;
        }
        String seamProjectName = seamWebProjectName;
        IProject webProject = ResourcesPlugin.getWorkspace().getRoot().getProject(seamWebProjectName);
        if (webProject == null) {
            return null;
        }
        SeamProjectsSet projectSet = SeamProjectsSet.create((IProject)webProject);
        if (!projectSet.isWarConfiguration()) {
            IProject ejbProject = projectSet.getEjbProject();
            if (ejbProject == null) {
                return null;
            }
            seamProjectName = ejbProject.getName();
        }
        ConsoleConfiguration[] configs = KnownConfigurations.getInstance().getConfigurations();
        int i = 0;
        while (i < configs.length) {
            IJavaProject javaProject = ProjectUtils.findJavaProject((ConsoleConfiguration)configs[i]);
            if (javaProject != null && javaProject.getProject().getName().equals(seamProjectName)) {
                return configs[i].getName();
            }
            ++i;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        String consoleConfigName;
        if ("seam.project.name".equals(event.getPropertyName()) && event.getNewValue() != null && !event.getNewValue().equals(event.getOldValue()) && (consoleConfigName = SeamGenerateEntitiesWizardPage.getConsoleConfigurationName(event.getNewValue().toString())) != null) {
            this.configEditor.setValue((Object)consoleConfigName);
        }
        this.validate();
    }

    protected boolean isProjectSettingsOk() {
        if (this.rootSeamProject != null) {
            if (!this.isValidRuntimeConfigured(this.rootSeamProject)) {
                return false;
            }
            IEclipsePreferences prefs = SeamCorePlugin.getSeamPreferences((IProject)this.rootSeamProject);
            return SeamProjectPropertyValidator.isFolderPathValid((String)prefs.get("model.sources", ""), (boolean)false) && SeamProjectPropertyValidator.isFolderPathValid((String)prefs.get("action.sources", ""), (boolean)false) && SeamProjectPropertyValidator.isFolderPathValid((String)prefs.get("seam.project.web.root.folder", ""), (boolean)false) && ("war".equals(prefs.get("seam.project.deployment.type", "war").trim()) || SeamProjectPropertyValidator.isProjectNameValid((String)prefs.get("seam.ejb.project", ""), (boolean)false));
        }
        return true;
    }

    protected boolean isValidRuntimeConfigured(IProject project) {
        String seamRt = SeamCorePlugin.getSeamPreferences((IProject)project).get("seam.runtime.name", "");
        Map errors = SeamValidatorFactory.SEAM_RUNTIME_VALIDATOR.validate((Object)seamRt, null);
        if (!errors.isEmpty()) {
            this.setErrorMessage(((IStatus)errors.get("default.error")).getMessage());
            this.setPageComplete(false);
            return false;
        }
        return true;
    }

    private void validate() {
        String projectName = this.projectEditor.getValue().toString();
        Map errors = SeamValidatorFactory.SEAM_PROJECT_NAME_VALIDATOR.validate((Object)projectName, null);
        if (!errors.isEmpty() || !this.isProjectSettingsOk()) {
            IStatus errorMessage = (IStatus)errors.get("default.error");
            if (errorMessage == null) {
                this.setErrorMessage(SeamUIMessages.VALIDATOR_INVALID_SETTINGS);
                this.setPageComplete(false);
            } else if (errorMessage.getSeverity() == 4) {
                this.setErrorMessage(errorMessage.getMessage());
                this.setPageComplete(false);
            } else {
                this.setMessage(errorMessage.getMessage());
            }
            return;
        }
        String config = (String)this.configEditor.getValue();
        if (config == null || config.length() == 0) {
            this.setErrorMessage(SeamUIMessages.GENERATE_SEAM_ENTITIES_WIZARD_HIBERNATE_CONFIGURATION_ERROR);
            this.setPageComplete(false);
            return;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        SeamProjectsSet seamProjectsSet = SeamProjectsSet.create((IProject)project);
        IContainer viewsFolder = seamProjectsSet.getViewsFolder();
        if (viewsFolder != null && !viewsFolder.getFolder((IPath)new Path("layout")).exists()) {
            this.setErrorMessage(CommonUIMessages.bind((String)CommonUIMessages.VALIDATOR_FACTORY_FOLDER_DOES_NOT_EXIST, (Object)(String.valueOf(viewsFolder.getName()) + "/layout")));
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setPageComplete(true);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Map.class) {
            SeamGenerateEntitiesTablesWizardPage page;
            String filters;
            HashMap<String, NamedElementImpl> values = new HashMap<String, NamedElementImpl>();
            values.put(this.projectEditor.getName(), new NamedElementImpl(this.projectEditor.getName(), this.projectEditor.getValueAsString()));
            values.put(this.configEditor.getName(), new NamedElementImpl(this.configEditor.getName(), this.configEditor.getValueAsString()));
            String mode = this.radios.getValue().toString();
            String value = "reverse".equals(mode) ? "true" : "false";
            values.put("org.hibernate.tools.schema2hbm", new NamedElementImpl("reverse", value));
            IWizardPage page2 = this.getWizard().getPage("seam.generate.entities.tablesPage");
            if (page2 instanceof SeamGenerateEntitiesTablesWizardPage && (filters = (page = (SeamGenerateEntitiesTablesWizardPage)page2).getFilters()).length() > 0) {
                values.put("org.hibernate.tools.reveng.tables", new NamedElementImpl("filters", filters));
            }
            return values;
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        return "reverse".equals(this.radios.getValue()) && this.getErrorMessage() == null;
    }

    public String getConsoleCongigurationName() {
        return this.configEditor.getValueAsString();
    }

    public static class GridLayoutComposite
    extends Composite {
        public GridLayoutComposite(Composite parent, int style, int columnNumber) {
            super(parent, style);
            GridLayout gl = new GridLayout(columnNumber, false);
            this.setLayout((Layout)gl);
            this.setLayoutData(new GridData(768));
        }

        public GridLayoutComposite(Composite parent) {
            this(parent, 0, 1);
        }
    }

    class NamedElementImpl
    implements INamedElement {
        private String name;
        private Object value;

        public NamedElementImpl(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public String getValueAsString() {
            return this.value.toString();
        }

        public void setValue(Object newValue) {
            this.value = newValue;
        }

        public void setValueAsString(String value) {
            this.value = value;
        }

        public String toString() {
            return this.getValueAsString();
        }
    }
}

