/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.seam.ui.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.seam.core.ISeamProject;
import org.jboss.tools.seam.core.SeamCorePlugin;
import org.jboss.tools.seam.core.SeamUtil;

public class SeamWizardUtils {
    public static String getCurrentSelectedRootSeamProjectName() {
        ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        return SeamWizardUtils.getRootSeamProjectName(sel);
    }

    public static IProject getCurrentSelectedRootSeamProject() {
        ISelection sel = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        return SeamWizardUtils.getRootSeamProject(sel);
    }

    public static IProject getRootSeamProject(IProject project) {
        if (project != null) {
            ISeamProject seamProject = SeamCorePlugin.getSeamProject((IProject)project, (boolean)false);
            if (seamProject == null && EclipseResourceUtil.getJavaProject((IProject)project) == null) {
                ISeamProject warProject = SeamUtil.findReferencingSeamWarProjectForProject((IProject)project);
                return warProject != null ? warProject.getProject() : null;
            }
            if (seamProject == null) {
                return null;
            }
            String parentProjectName = seamProject.getParentProjectName();
            IProject targetProject = null;
            targetProject = parentProjectName == null || parentProjectName.trim().length() == 0 ? project : ResourcesPlugin.getWorkspace().getRoot().getProject(parentProjectName);
            if (targetProject.exists()) {
                if ("".equals(SeamCorePlugin.getSeamPreferences((IProject)targetProject).get("seam.project.deployment.type", ""))) {
                    return null;
                }
                return targetProject;
            }
        }
        return null;
    }

    public static String getRootSeamProjectName(ISelection sel) {
        IProject project = SeamWizardUtils.getRootSeamProject(sel);
        return project == null ? "" : project.getName();
    }

    public static IProject getRootSeamProject(ISelection sel) {
        IProject initial = SeamWizardUtils.getInitialProject(sel);
        IProject project = SeamWizardUtils.getRootSeamProject(initial);
        if (project == null) {
            project = initial;
        }
        return project == null ? null : project;
    }

    public static IProject getInitialProject(ISelection simpleSelection) {
        IEditorInput input;
        IEditorPart activeEditor;
        IAdaptable adaptable;
        IResource resource;
        IStructuredSelection selection;
        Object selectedElement;
        IProject project = null;
        if (simpleSelection != null && !simpleSelection.isEmpty() && simpleSelection instanceof IStructuredSelection && (selectedElement = (selection = (IStructuredSelection)simpleSelection).getFirstElement()) instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)selectedElement).getAdapter(IResource.class)) != null) {
            project = resource.getProject();
        }
        if (project == null && (activeEditor = SeamWizardUtils.getActivePage().getActiveEditor()) != null && (input = activeEditor.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            return fileInput.getFile().getProject();
        }
        return project;
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = SeamWizardUtils.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return SeamWizardUtils.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    private static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }
}

