/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Messages;
import org.osgi.framework.Bundle;

public class XULRunnerInitializer {
    private static final String XULRUNNER_PATH = "org.eclipse.swt.browser.XULRunnerPath";
    private static final String XULRUNNER_ENTRY = "/xulrunner";

    static {
        File xulrunnerFile;
        String xulrunnerPath = System.getProperty(XULRUNNER_PATH);
        if (xulrunnerPath != null && !(xulrunnerFile = new File(xulrunnerPath)).exists()) {
            xulrunnerPath = null;
        }
        if (xulrunnerPath == null) {
            String XULRUNNER_BUNDLE = new StringBuffer("org.mozilla.xulrunner").append(".").append(Platform.getWS()).append(".").append(Platform.getOS()).append("macosx".equals(Platform.getOS()) ? "" : new StringBuffer(".").append(Platform.getOSArch()).toString()).toString();
            Bundle xulRunnerBundle = Platform.getBundle((String)XULRUNNER_BUNDLE);
            if (xulRunnerBundle == null) {
                System.out.println(NLS.bind((String)Messages.XULRunnerInitializer_Bundle_is_not_found, (Object)XULRUNNER_BUNDLE));
            } else {
                URL url = xulRunnerBundle.getEntry(XULRUNNER_ENTRY);
                if (url == null) {
                    System.out.println(NLS.bind((String)Messages.XULRunnerInitializer_Bundle_doesnt_contain, (Object[])new Object[]{XULRUNNER_BUNDLE, XULRUNNER_ENTRY}));
                } else {
                    try {
                        URL url1 = FileLocator.resolve((URL)url);
                        File xulrunnerFile2 = new File(FileLocator.toFileURL((URL)url1).getFile());
                        xulrunnerPath = xulrunnerFile2.getAbsolutePath();
                        System.setProperty(XULRUNNER_PATH, xulrunnerPath);
                    }
                    catch (IOException ioe) {
                        System.out.println(NLS.bind((String)Messages.XULRunnerInitializer_Cannot_get_path_to_XULRunner_from_bundle, (Object)XULRUNNER_BUNDLE));
                        ioe.printStackTrace();
                    }
                }
            }
        }
    }
}

