/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.xom;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eigenbase.xom.MetaGenerator;
import org.eigenbase.xom.XOMException;

public class XOMGenTask
extends Task {
    String modelFileName;
    String destDir;
    String dtdFileName;
    String className;

    public void execute() throws BuildException {
        try {
            if (this.modelFileName == null) {
                throw new BuildException("You must specify model.");
            }
            if (this.className == null) {
                throw new BuildException("You must specify className.");
            }
            File file = this.getProject().getBaseDir();
            File file2 = this.destDir == null ? file : new File(file, this.destDir);
            if (!file2.exists()) {
                throw new BuildException("Destination directory doesn't exist: " + file2.toString());
            }
            File file3 = new File(file, this.modelFileName);
            File file4 = XOMGenTask.classNameToFile(file2, this.className);
            File file5 = file4.getParentFile();
            File file6 = new File(file5, this.dtdFileName);
            if (file3.exists() && file4.exists() && file6.exists()) {
                long l = file3.lastModified();
                long l2 = file4.lastModified();
                long l3 = file6.lastModified();
                if (l2 > l && l3 > l) {
                    return;
                }
            }
            MetaGenerator metaGenerator = new MetaGenerator(file3.toString(), false, this.className);
            metaGenerator.writeFiles(file2.toString(), this.dtdFileName);
            metaGenerator.writeOutputs();
        }
        catch (XOMException xOMException) {
            throw new BuildException("Generation of model failed: " + xOMException);
        }
        catch (IOException iOException) {
            throw new BuildException("Generation of model failed: " + iOException);
        }
    }

    public void setModel(String string) {
        this.modelFileName = string;
    }

    public void setDestdir(String string) {
        this.destDir = string;
    }

    public void setClassname(String string) {
        this.className = string;
    }

    public void setDtdname(String string) {
        this.dtdFileName = string;
    }

    static File classNameToFile(File file, String string) {
        char c = System.getProperty("file.separator").charAt(0);
        String string2 = string.replace('.', c) + ".java";
        if (file == null) {
            return new File(string2);
        }
        return new File(file, string2);
    }
}

