/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.DataSource;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.DialectFactory;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;
import mondrian.util.ServiceDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DialectManager {
    private static final DialectManagerImpl IMPL = new DialectManagerImpl();

    private DialectManager() {
        throw new IllegalArgumentException();
    }

    public static void register(DialectFactory factory) {
        IMPL.register(factory);
    }

    public static void register(Class<? extends Dialect> dialectClass) {
        IMPL.register(dialectClass);
    }

    public static Dialect createDialect(DataSource dataSource, Connection connection) {
        return IMPL.createDialect(dataSource, connection);
    }

    static DialectFactory createFactoryForDialect(Class<? extends Dialect> dialectClass) {
        for (Field field : dialectClass.getFields()) {
            if (!Modifier.isPublic(field.getModifiers()) || !Modifier.isStatic(field.getModifiers()) || !field.getName().equals("FACTORY") || !DialectFactory.class.isAssignableFrom(field.getType())) continue;
            try {
                DialectFactory factory = (DialectFactory)field.get(null);
                if (factory == null) continue;
                return factory;
            }
            catch (IllegalAccessException e) {
                throw Util.newError(e, "Error while accessing field " + field);
            }
        }
        try {
            Constructor<? extends Dialect> constructor = dialectClass.getConstructor(Connection.class);
            if (Modifier.isPublic(constructor.getModifiers())) {
                return new ConstructorDialectFactory(constructor);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    static class CachingDialectFactory
    implements DialectFactory {
        private final DialectFactory factory;
        private final Map<DataSource, Dialect> dataSourceDialectMap = new WeakHashMap<DataSource, Dialect>();

        CachingDialectFactory(DialectFactory factory) {
            this.factory = factory;
        }

        public Dialect createDialect(DataSource dataSource, Connection connection) {
            Dialect dialect;
            if (dataSource != null && (dialect = this.dataSourceDialectMap.get(dataSource)) != null) {
                return dialect;
            }
            dialect = this.factory.createDialect(dataSource, connection);
            if (dialect != null && dataSource != null && dialect.allowsDialectSharing()) {
                this.dataSourceDialectMap.put(dataSource, dialect);
            }
            return dialect;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstructorDialectFactory
    implements DialectFactory {
        private final Constructor<? extends Dialect> constructor;

        ConstructorDialectFactory(Constructor<? extends Dialect> constructor) {
            assert (constructor != null);
            assert (constructor.getParameterTypes().length == 1);
            assert (constructor.getParameterTypes()[0] == Connection.class);
            this.constructor = constructor;
        }

        @Override
        public Dialect createDialect(DataSource dataSource, Connection connection) {
            if (connection == null) {
                return JdbcDialectFactory.createDialectHelper(this, dataSource);
            }
            try {
                return this.constructor.newInstance(connection);
            }
            catch (InstantiationException e) {
                throw Util.newError(e, "Error while instantiating dialect of class " + this.constructor.getClass());
            }
            catch (IllegalAccessException e) {
                throw Util.newError(e, "Error while instantiating dialect of class " + this.constructor.getClass());
            }
            catch (InvocationTargetException e) {
                throw Util.newError(e, "Error while instantiating dialect of class " + this.constructor.getClass());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChainDialectFactory
    implements DialectFactory {
        private final List<DialectFactory> dialectFactoryList;

        ChainDialectFactory(List<DialectFactory> dialectFactoryList) {
            this.dialectFactoryList = dialectFactoryList;
        }

        @Override
        public Dialect createDialect(DataSource dataSource, Connection connection) {
            if (connection == null) {
                return JdbcDialectFactory.createDialectHelper(this, dataSource);
            }
            for (DialectFactory factory : this.dialectFactoryList) {
                Dialect dialect = factory.createDialect(dataSource, connection);
                if (dialect == null) continue;
                return dialect;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DialectManagerImpl {
        private final ChainDialectFactory registeredFactory;
        private final DialectFactory factory;

        DialectManagerImpl() {
            ArrayList<DialectFactory> list = new ArrayList<DialectFactory>();
            List<Class<Dialect>> dialectClasses = ServiceDiscovery.forClass(Dialect.class).getImplementor();
            for (Class<Dialect> dialectClass : dialectClasses) {
                DialectFactory factory = DialectManager.createFactoryForDialect(dialectClass);
                if (factory == null) continue;
                list.add(factory);
            }
            this.registeredFactory = new ChainDialectFactory(list);
            DialectFactory fallbackFactory = new DialectFactory(){

                public Dialect createDialect(DataSource dataSource, Connection connection) {
                    if (connection == null) {
                        return JdbcDialectFactory.createDialectHelper(this, dataSource);
                    }
                    try {
                        return new JdbcDialectImpl(connection);
                    }
                    catch (SQLException e) {
                        throw Util.newError(e, "Error while creating a generic dialect for JDBC connection" + connection);
                    }
                }
            };
            this.factory = new CachingDialectFactory(new ChainDialectFactory(Arrays.asList(this.registeredFactory, fallbackFactory)));
        }

        synchronized void register(DialectFactory factory) {
            if (factory == null) {
                throw new IllegalArgumentException();
            }
            this.registeredFactory.dialectFactoryList.add(factory);
        }

        synchronized void register(Class<? extends Dialect> dialectClass) {
            if (dialectClass == null) {
                throw new IllegalArgumentException();
            }
            this.register(DialectManager.createFactoryForDialect(dialectClass));
        }

        synchronized Dialect createDialect(DataSource dataSource, Connection connection) {
            if (dataSource == null && connection == null) {
                throw new IllegalArgumentException();
            }
            Dialect dialect = this.factory.createDialect(dataSource, connection);
            if (dialect == null) {
                throw Util.newError("Cannot create dialect for JDBC connection" + connection);
            }
            return dialect;
        }
    }
}

