/*
 * Decompiled with CFR 0.152.
 */
package mondrian.web.taglib;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Property;
import mondrian.olap.Result;
import mondrian.olap.Util;
import org.apache.log4j.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMBuilder {
    private static final Logger LOGGER = Logger.getLogger(DOMBuilder.class);
    Document factory;
    Result result;
    int dimCount;
    private static final String PRETTY_PRINTER = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\n<xsl:output method=\"xml\" indent=\"yes\"/>\n<xsl:template match=\"*|@*\">\n  <xsl:copy>\n    <xsl:apply-templates select=\"*|@*\"/>\n  </xsl:copy>\n</xsl:template>\n</xsl:stylesheet>\n";

    protected DOMBuilder(Document factory, Result result) {
        this.factory = factory;
        this.result = result;
    }

    public static Document build(Result result) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setExpandEntityReferences(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element table = DOMBuilder.build(doc, result);
        doc.appendChild(table);
        return doc;
    }

    public static Element build(Document factory, Result result) {
        return new DOMBuilder(factory, result).build();
    }

    private Element build() {
        this.dimCount = this.result.getAxes().length;
        Element mdxtable = this.factory.createElement("mdxtable");
        Element query = this.elem("query", mdxtable);
        this.cdata(Util.unparse(this.result.getQuery()), query);
        Element head = this.elem("head", mdxtable);
        Element body = this.elem("body", mdxtable);
        switch (this.dimCount) {
            case 0: {
                this.buildRows0Dim(body);
                break;
            }
            case 1: {
                this.buildColumns(head, this.result.getAxes()[0]);
                this.buildRows1Dim(body);
                break;
            }
            case 2: {
                this.buildColumns(head, this.result.getAxes()[0]);
                this.buildRows2Dim(body, this.result.getAxes()[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException("DOMBuilder requires 0, 1 or 2 dimensional result");
            }
        }
        Element slicers = this.elem("slicers", mdxtable);
        this.buildSlicer(slicers);
        return mdxtable;
    }

    private void buildRows2Dim(Element parent, Axis axis) {
        RowBuilder rb = new RowBuilder(parent, axis);
        int N = rb.getRowCount();
        int[] cellIndex = new int[2];
        int i = 0;
        while (i < N) {
            Element row = rb.build(i);
            boolean even = i % 2 != 0;
            cellIndex[1] = i++;
            this.buildCells(row, cellIndex, even);
        }
    }

    private void buildRows1Dim(Element parent) {
        int[] cellIndex = new int[1];
        Element row = this.elem("row", parent);
        this.buildCells(row, cellIndex, false);
    }

    private void buildColumns(Element parent, Axis axis) {
        ColumnBuilder cb = new ColumnBuilder(parent, axis);
        int N = cb.getRowCount();
        for (int i = 0; i < N; ++i) {
            Element row = cb.build(i);
        }
    }

    private void buildCells(Element row, int[] cellIndex, boolean even) {
        int columns = this.result.getAxes()[0].getPositions().size();
        int i = 0;
        while (i < columns) {
            cellIndex[0] = i++;
            Cell cell = this.result.getCell(cellIndex);
            this.buildCell(cell, row, even);
        }
    }

    private void buildCell(Cell cell, Element row, boolean even) {
        Element cellElem = this.elem("cell", row);
        String s = cell.getFormattedValue();
        if (s == null || s.length() == 0 || s.equals("(null)")) {
            s = "\u00a0";
        }
        cellElem.setAttribute("value", s);
        cellElem.setAttribute("style", even ? "even" : "odd");
    }

    private void buildRows0Dim(Element parent) {
        int[] cellIndex = new int[]{};
        Element row = this.elem("row", parent);
        Cell cell = this.result.getCell(cellIndex);
        this.buildCell(cell, row, false);
    }

    private void buildSlicer(Element parent) {
        List<Position> positions = this.result.getSlicerAxis().getPositions();
        for (int i = 0; i < positions.size(); ++i) {
            Position position = positions.get(i);
            if (position.size() <= 0) continue;
            Element el = this.elem("position", parent);
            for (int j = 0; j < position.size(); ++j) {
                this.createMemberElem("member", el, (Member)position.get(j));
            }
        }
    }

    private Element createMemberElem(String name, Element parent, Member m) {
        Element e = this.elem(name, parent);
        e.setAttribute("caption", m.getCaption());
        e.setAttribute("depth", Integer.toString(m.getLevel().getDepth()));
        e.setAttribute("uname", m.getUniqueName());
        e.setAttribute("colspan", "1");
        e.setAttribute("rowspan", "1");
        this.addMemberProperties(m, e);
        return e;
    }

    private void addMemberProperties(Member m, Element e) {
        Property[] props = m.getLevel().getProperties();
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                String propName = props[i].getName();
                String propValue = "" + m.getPropertyValue(propName);
                Element propElem = this.elem("property", e);
                propElem.setAttribute("name", propName);
                propElem.setAttribute("value", propValue);
            }
        }
    }

    private Element elem(String name, Element parent) {
        Element elem = this.factory.createElement(name);
        parent.appendChild(elem);
        return elem;
    }

    private Object cdata(String content, Element parent) {
        CDATASection section = this.factory.createCDATASection(content);
        parent.appendChild(section);
        return section;
    }

    public static void debug(Document doc) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            StringReader input = new StringReader(PRETTY_PRINTER);
            Templates templates = tf.newTemplates(new StreamSource(input));
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            templates.newTransformer().transform(new DOMSource(doc), new StreamResult(result));
            LOGGER.debug((Object)((Object)result).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class ColumnBuilder
    extends AxisBuilder {
        ColumnBuilder(Element parent, Axis axis) {
            super(parent, axis);
        }

        int getRowCount() {
            return this.levels;
        }

        Element build(int rowIndex) {
            Element row = DOMBuilder.this.elem("row", this.parent);
            if (DOMBuilder.this.dimCount > 1 && rowIndex == 0) {
                this.buildCornerElement(row);
            }
            this.build(row, rowIndex);
            return row;
        }

        private void build(Element row, int rowIndex) {
            int i;
            for (i = 0; i < this.levels; ++i) {
                this.prevMembers[i] = null;
            }
            for (i = 0; i < this.positions.size(); ++i) {
                Position position = (Position)this.positions.get(i);
                for (int j = 0; j < rowIndex - 1; ++j) {
                    Member currentMember = (Member)position.get(j);
                    if (this.prevMembers[j] != null && this.prevMembers[j].equals(currentMember)) continue;
                    this.prevMembers[j] = currentMember;
                    for (int k = j + 1; k < this.levels; ++k) {
                        this.prevMembers[j] = null;
                    }
                }
                Member currentMember = (Member)position.get(rowIndex);
                Member prevMember = this.prevMembers[rowIndex];
                if (prevMember == null || !prevMember.equals(currentMember)) {
                    Element currentElem = DOMBuilder.this.createMemberElem("column-heading", row, currentMember);
                    this.prevMembers[rowIndex] = currentMember;
                    this.prevElems[rowIndex] = currentElem;
                    this.prevSpan[rowIndex] = 1;
                    for (int j = rowIndex + 1; j < this.levels; ++j) {
                        this.prevMembers[j] = null;
                    }
                    continue;
                }
                Element prevElem = this.prevElems[rowIndex];
                prevElem.setAttribute("style", "span");
                int n = rowIndex;
                this.prevSpan[n] = this.prevSpan[n] + 1;
                prevElem.setAttribute("colspan", Integer.toString(this.prevSpan[rowIndex]));
            }
        }

        void buildCornerElement(Element row) {
            Element corner = DOMBuilder.this.elem("corner", row);
            corner.setAttribute("rowspan", Integer.toString(DOMBuilder.this.result.getAxes()[0].getPositions().get(0).size()));
            corner.setAttribute("colspan", Integer.toString(DOMBuilder.this.result.getAxes()[1].getPositions().get(0).size()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RowBuilder
    extends AxisBuilder {
        RowBuilder(Element parent, Axis axis) {
            super(parent, axis);
        }

        @Override
        Element build(int rowIndex) {
            boolean even = rowIndex % 2 != 0;
            Element row = DOMBuilder.this.elem("row", this.parent);
            this.build(row, (List)this.positions.get(rowIndex), even);
            return row;
        }

        @Override
        int getRowCount() {
            return this.positions.size();
        }

        private void build(Element row, List<Member> currentMembers, boolean even) {
            for (int i = 0; i < this.levels; ++i) {
                Member currentMember = currentMembers.get(i);
                Member prevMember = this.prevMembers[i];
                if (prevMember == null || !prevMember.equals(currentMember)) {
                    Element currentElem = DOMBuilder.this.createMemberElem("row-heading", row, currentMember);
                    if (even) {
                        currentElem.setAttribute("style", "even");
                    } else {
                        currentElem.setAttribute("style", "odd");
                    }
                    this.prevMembers[i] = currentMember;
                    this.prevElems[i] = currentElem;
                    this.prevSpan[i] = 1;
                    for (int j = i + 1; j < this.levels; ++j) {
                        this.prevMembers[j] = null;
                    }
                    continue;
                }
                Element prevElem = this.prevElems[i];
                prevElem.setAttribute("style", "span");
                int n = i;
                this.prevSpan[n] = this.prevSpan[n] + 1;
                prevElem.setAttribute("rowspan", Integer.toString(this.prevSpan[i]));
            }
        }
    }

    abstract class AxisBuilder {
        Member[] prevMembers;
        Element[] prevElems;
        int[] prevSpan;
        Element parent;
        List<Position> positions;
        int levels;

        AxisBuilder(Element parent, Axis axis) {
            this.parent = parent;
            this.positions = axis.getPositions();
            this.levels = this.positions.get(0).size();
            this.prevMembers = new Member[this.levels];
            this.prevElems = new Element[this.levels];
            this.prevSpan = new int[this.levels];
        }

        abstract int getRowCount();

        abstract Element build(int var1);
    }
}

