/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.queryframework;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.queryframework.CollectionContainerPolicy;
import oracle.toplink.essentials.internal.queryframework.ListContainerPolicy;
import oracle.toplink.essentials.internal.queryframework.MapContainerPolicy;
import oracle.toplink.essentials.internal.queryframework.OrderedListContainerPolicy;
import oracle.toplink.essentials.internal.queryframework.SortedCollectionContainerPolicy;
import oracle.toplink.essentials.internal.security.PrivilegedAccessController;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.CollectionChangeRecord;
import oracle.toplink.essentials.internal.sessions.MergeManager;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.DataReadQuery;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ReadQuery;

public abstract class ContainerPolicy
implements Cloneable,
Serializable {
    protected transient ClassDescriptor elementDescriptor;
    protected transient Constructor constructor;

    protected boolean addInto(Object key, Object element, Object container) {
        throw QueryException.cannotAddToContainer(element, container, this);
    }

    public boolean addInto(Object element, Object container, AbstractSession session) {
        return this.addInto(null, element, container, session);
    }

    public boolean addInto(Object key, Object element, Object container, AbstractSession session) {
        Object elementToAdd = element;
        if (this.hasElementDescriptor()) {
            elementToAdd = this.getElementDescriptor().getObjectBuilder().wrapObject(element, session);
        }
        return this.addInto(key, elementToAdd, container);
    }

    public void addIntoWithOrder(Integer index, Object element, Object container) {
        throw QueryException.methodDoesNotExistInContainerClass("set", this.getContainerClass());
    }

    public void addIntoWithOrder(Integer index, Object element, Object container, AbstractSession session) {
        Object elementToAdd = element;
        if (this.hasElementDescriptor()) {
            elementToAdd = this.getElementDescriptor().getObjectBuilder().wrapObject(element, session);
        }
        this.addIntoWithOrder(index, elementToAdd, container);
    }

    public void addIntoWithOrder(Vector indexes, Hashtable elements, Object container, AbstractSession session) {
        throw QueryException.methodDoesNotExistInContainerClass("set", this.getContainerClass());
    }

    public Object buildContainerFromVector(Vector vector, AbstractSession session) {
        Object container = this.containerInstance(vector.size());
        Enumeration e = vector.elements();
        while (e.hasMoreElements()) {
            this.addInto(e.nextElement(), container, session);
        }
        return container;
    }

    public static ContainerPolicy buildPolicyFor(Class concreteContainerClass) {
        return ContainerPolicy.buildPolicyFor(concreteContainerClass, false);
    }

    public static ContainerPolicy buildPolicyFor(Class concreteContainerClass, boolean hasOrdering) {
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.List_Class)) {
            if (hasOrdering) {
                return new OrderedListContainerPolicy(concreteContainerClass);
            }
            return new ListContainerPolicy(concreteContainerClass);
        }
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.SortedSet_Class)) {
            return new SortedCollectionContainerPolicy(concreteContainerClass);
        }
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.Collection_Class)) {
            return new CollectionContainerPolicy(concreteContainerClass);
        }
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.Map_Class)) {
            return new MapContainerPolicy(concreteContainerClass);
        }
        throw ValidationException.illegalContainerClass(concreteContainerClass);
    }

    public void clear(Object container) {
        throw QueryException.methodNotValid(this, "clear(Object container)");
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public ContainerPolicy clone(ReadQuery query) {
        return (ContainerPolicy)this.clone();
    }

    public Object cloneFor(Object container) {
        throw QueryException.cannotCreateClone(this, container);
    }

    public void compareCollectionsForChange(Object oldCollection, Object newCollection, CollectionChangeRecord changeRecord, AbstractSession session, ClassDescriptor referenceDescriptor) {
        IdentityHashMap<Object, Object> originalKeyValues = new IdentityHashMap<Object, Object>();
        IdentityHashMap<Object, Object> cloneKeyValues = new IdentityHashMap<Object, Object>();
        if (oldCollection != null) {
            Object backUpIter = this.iteratorFor(oldCollection);
            while (this.hasNext(backUpIter)) {
                Object secondObject = this.next(backUpIter, session);
                if (secondObject == null) continue;
                originalKeyValues.put(secondObject, secondObject);
            }
        }
        if (newCollection != null) {
            Object cloneIter = this.iteratorFor(newCollection);
            while (this.hasNext(cloneIter)) {
                Object firstObject = this.next(cloneIter, session);
                if (firstObject == null) continue;
                if (originalKeyValues.containsKey(firstObject)) {
                    if (this.compareKeys(firstObject, session)) {
                        originalKeyValues.remove(firstObject);
                        continue;
                    }
                    Object backUpVersion = null;
                    backUpVersion = ((UnitOfWorkImpl)session).isClassReadOnly(firstObject.getClass()) ? ((UnitOfWorkImpl)session).getOriginalVersionOfObject(firstObject) : ((UnitOfWorkImpl)session).getBackupClone(firstObject);
                    ObjectChangeSet changeSet = referenceDescriptor.getObjectBuilder().createObjectChangeSet(firstObject, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
                    changeSet.setOldKey(this.keyFrom(backUpVersion, session));
                    changeSet.setNewKey(this.keyFrom(firstObject, session));
                    cloneKeyValues.put(firstObject, firstObject);
                    continue;
                }
                cloneKeyValues.put(firstObject, firstObject);
            }
        }
        changeRecord.addAdditionChange(cloneKeyValues, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addRemoveChange(originalKeyValues, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
    }

    public boolean compareKeys(Object sourceKey, AbstractSession session) {
        return true;
    }

    public Object concatenateContainers(Object firstContainer, Object secondContainer) {
        Object container = this.containerInstance(this.sizeFor(firstContainer) + this.sizeFor(secondContainer));
        Object firstIter = this.iteratorFor(firstContainer);
        while (this.hasNext(firstIter)) {
            this.addInto(null, this.next(firstIter), container);
        }
        Object secondIter = this.iteratorFor(secondContainer);
        while (this.hasNext(secondIter)) {
            this.addInto(null, this.next(secondIter), container);
        }
        return container;
    }

    public Object containerInstance() {
        try {
            return PrivilegedAccessController.newInstanceFromClass(this.getContainerClass());
        }
        catch (Exception ex) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), ex);
        }
    }

    public Object containerInstance(int initialCapacity) {
        if (this.getConstructor() == null) {
            return this.containerInstance();
        }
        try {
            Object[] arguments = new Object[]{new Integer(initialCapacity)};
            return PrivilegedAccessController.invokeConstructor(this.getConstructor(), arguments);
        }
        catch (Exception ex) {
            throw QueryException.couldNotInstantiateContainerClass(this.getContainerClass(), ex);
        }
    }

    protected boolean contains(Object element, Object container) {
        throw QueryException.methodNotValid(this, "contains(Object element, Object container)");
    }

    public boolean contains(Object element, Object container, AbstractSession session) {
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            Object iterator = this.iteratorFor(container);
            while (this.hasNext(iterator)) {
                Object next = this.next(iterator);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(next, session).equals(element)) continue;
                return true;
            }
            return false;
        }
        return this.contains(element, container);
    }

    protected boolean containsKey(Object element, Object container) {
        throw QueryException.methodNotValid(this, "containsKey(Object element, Object container)");
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public Object execute() {
        throw QueryException.methodNotValid(this, "execute()");
    }

    protected Constructor getConstructor() {
        return this.constructor;
    }

    public Class getContainerClass() {
        throw QueryException.methodNotValid(this, "getContainerClass()");
    }

    public String getContainerClassName() {
        throw QueryException.methodNotValid(this, "getContainerClassName()");
    }

    public ClassDescriptor getElementDescriptor() {
        return this.elementDescriptor;
    }

    public boolean hasElementDescriptor() {
        return this.getElementDescriptor() != null;
    }

    public abstract boolean hasNext(Object var1);

    public boolean hasOrder() {
        return false;
    }

    public void initializeConstructor() {
        try {
            this.setConstructor(PrivilegedAccessController.getConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.PINT}, false));
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean isCollectionPolicy() {
        return false;
    }

    public boolean isCursoredStreamPolicy() {
        return false;
    }

    public boolean isCursorPolicy() {
        return false;
    }

    public boolean isCursorStreamPolicy() {
        return false;
    }

    public boolean isDirectMapPolicy() {
        return false;
    }

    public boolean isEmpty(Object container) {
        return this.sizeFor(container) == 0;
    }

    public boolean isListPolicy() {
        return false;
    }

    public boolean isMapPolicy() {
        return false;
    }

    public boolean isScrollableCursorPolicy() {
        return false;
    }

    public boolean isValidContainer(Object container) {
        throw QueryException.methodNotValid(this, "isValidContainer(Object container)");
    }

    public boolean isValidContainerType(Class containerType) {
        throw QueryException.methodNotValid(this, "isValidContainerType(Class containerType)");
    }

    public abstract Object iteratorFor(Object var1);

    public Object keyFrom(Object element, AbstractSession session) {
        return null;
    }

    public Object mergeCascadeParts(ObjectChangeSet objectChanges, MergeManager mergeManager, AbstractSession parentSession) {
        Object object = null;
        if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
            object = objectChanges.getTargetVersionOfSourceObject(parentSession);
            if (object == null && (objectChanges.isNew() || objectChanges.isAggregate()) && objectChanges.containsChangesFromSynchronization()) {
                if (!mergeManager.getObjectsAlreadyMerged().containsKey(objectChanges)) {
                    Class objectClass = objectChanges.getClassType(mergeManager.getSession());
                    object = mergeManager.getSession().getDescriptor(objectClass).getObjectBuilder().buildNewInstance();
                    mergeManager.getObjectsAlreadyMerged().put(objectChanges, object);
                } else {
                    object = mergeManager.getObjectsAlreadyMerged().get(objectChanges);
                }
            } else {
                object = objectChanges.getTargetVersionOfSourceObject(parentSession, true);
            }
            if (objectChanges.containsChangesFromSynchronization()) {
                mergeManager.mergeChanges(object, objectChanges);
            }
        } else {
            mergeManager.mergeChanges(objectChanges.getUnitOfWorkClone(), objectChanges);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChanges(CollectionChangeRecord changeRecord, Object valueOfTarget, boolean shouldMergeCascadeParts, MergeManager mergeManager, AbstractSession parentSession) {
        ObjectChangeSet objectChanges;
        Enumeration removeObjects = changeRecord.getRemoveObjectList().keys();
        while (removeObjects.hasMoreElements()) {
            objectChanges = (ObjectChangeSet)removeObjects.nextElement();
            Object object = valueOfTarget;
            synchronized (object) {
                this.removeFrom(objectChanges.getOldKey(), objectChanges.getTargetVersionOfSourceObject(mergeManager.getSession()), valueOfTarget, parentSession);
            }
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) continue;
            mergeManager.registerRemovedNewObjectIfRequired(objectChanges.getUnitOfWorkClone());
        }
        Enumeration addObjects = changeRecord.getAddObjectList().keys();
        while (addObjects.hasMoreElements()) {
            objectChanges = (ObjectChangeSet)addObjects.nextElement();
            Object object = null;
            if (shouldMergeCascadeParts) {
                object = this.mergeCascadeParts(objectChanges, mergeManager, parentSession);
            }
            if (object == null) {
                object = objectChanges.getTargetVersionOfSourceObject(mergeManager.getSession(), false);
            }
            Object object2 = valueOfTarget;
            synchronized (object2) {
                if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                    if (!this.contains(object, valueOfTarget, mergeManager.getSession())) {
                        this.addInto(objectChanges.getNewKey(), object, valueOfTarget, mergeManager.getSession());
                    }
                } else {
                    this.addInto(objectChanges.getNewKey(), object, valueOfTarget, mergeManager.getSession());
                }
            }
        }
    }

    protected abstract Object next(Object var1);

    public Object next(Object iterator, AbstractSession session) {
        Object next = this.next(iterator);
        if (this.hasElementDescriptor()) {
            next = this.getElementDescriptor().getObjectBuilder().unwrapObject(next, session);
        }
        return next;
    }

    public boolean overridesRead() {
        return false;
    }

    public void prepare(DatabaseQuery query, AbstractSession session) throws QueryException {
        if (query.isReadAllQuery() && !query.isReportQuery() && query.shouldUseWrapperPolicy()) {
            this.setElementDescriptor(query.getDescriptor());
        } else if (query.isDataReadQuery()) {
            ((DataReadQuery)query).setContainerPolicy(this);
        }
    }

    public void prepareForExecution() throws QueryException {
    }

    public void recordAddToCollectionInChangeRecord(ObjectChangeSet changeSetToAdd, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getRemoveObjectList().containsKey(changeSetToAdd)) {
            collectionChangeRecord.getRemoveObjectList().remove(changeSetToAdd);
        } else {
            collectionChangeRecord.getAddObjectList().put(changeSetToAdd, changeSetToAdd);
        }
    }

    public void recordRemoveFromCollectionInChangeRecord(ObjectChangeSet changeSetToRemove, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getAddObjectList().containsKey(changeSetToRemove)) {
            collectionChangeRecord.getAddObjectList().remove(changeSetToRemove);
        } else {
            collectionChangeRecord.getRemoveObjectList().put(changeSetToRemove, changeSetToRemove);
        }
    }

    public Object remoteExecute() {
        return null;
    }

    public void removeAllElements(Object container) {
        this.clear(container);
    }

    protected boolean removeFrom(Object key, Object element, Object container) {
        throw QueryException.cannotRemoveFromContainer(element, container, this);
    }

    public boolean removeFrom(Object key, Object element, Object container, AbstractSession session) {
        Object objectToRemove = element;
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            Object iterator = this.iteratorFor(container);
            while (this.hasNext(iterator)) {
                Object next = this.next(iterator);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(next, session).equals(element)) continue;
                objectToRemove = next;
                break;
            }
        }
        return this.removeFrom(key, objectToRemove, container);
    }

    public boolean removeFrom(Object element, Object container, AbstractSession session) {
        return this.removeFrom(null, element, container, session);
    }

    public void removeFromWithOrder(int beginIndex, Object container) {
        throw QueryException.methodDoesNotExistInContainerClass("remove(index)", this.getContainerClass());
    }

    protected void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public void setContainerClass(Class containerClass) {
        throw QueryException.methodNotValid(this, "getContainerClass()");
    }

    public void setContainerClassName(String containerClassName) {
        throw QueryException.methodNotValid(this, "getContainerClassName()");
    }

    public void setElementDescriptor(ClassDescriptor elementDescriptor) {
        this.elementDescriptor = elementDescriptor;
    }

    public void setKeyName(String instanceVariableName, String elementClassName) {
        throw ValidationException.containerPolicyDoesNotUseKeys(this, instanceVariableName);
    }

    public int sizeFor(Object container) {
        throw QueryException.methodNotValid(this, "sizeFor(Object container)");
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.toStringInfo() + ")";
    }

    protected Object toStringInfo() {
        return "";
    }

    public void validateElementAndRehashIfRequired(Object sourceValue, Object target, AbstractSession session, Object targetVersionOfSource) {
    }

    public Vector vectorFor(Object container, AbstractSession session) {
        Vector<Object> result = new Vector<Object>(this.sizeFor(container));
        Object iter = this.iteratorFor(container);
        while (this.hasNext(iter)) {
            result.addElement(this.next(iter, session));
        }
        return result;
    }
}

