/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.lang.reflect.Field;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.HTMLTestable;

abstract class Axis
implements HTMLTestable,
Serializable {
    static final transient AffineTransform VERTICAL_LABEL_ROTATION = AffineTransform.getRotateInstance(-1.5707963267948966);
    private AxisChart axisChart;
    private float scalePixelWidth;
    private float pixelLength;
    private float origin;
    private float widestLabel;
    private float tallestLabel;
    private float titleHeight;
    private float titleWidth;
    private float minimumWidthNeeded;
    private float minimumHeightNeeded;

    public Axis(AxisChart axisChart) {
        this.axisChart = axisChart;
    }

    final AxisChart getAxisChart() {
        return this.axisChart;
    }

    final float getWidestLabel() {
        return this.widestLabel;
    }

    final void setWidestLabel(float f) {
        this.widestLabel = f;
    }

    final float getTallestLabel() {
        return this.tallestLabel;
    }

    final void setTallestLabel(float f) {
        this.tallestLabel = f;
    }

    final float getTitleWidth() {
        return this.titleWidth;
    }

    final float getTitleHeight() {
        return this.titleHeight;
    }

    final float getPixelLength() {
        return this.pixelLength;
    }

    final void setPixelLength(float f) {
        this.pixelLength = f;
    }

    final float getOrigin() {
        return this.origin;
    }

    final void setOrigin(float f) {
        this.origin = f;
    }

    final float getMinimumWidthNeeded() {
        return this.minimumWidthNeeded;
    }

    final void setMinimumWidthNeeded(float f) {
        this.minimumWidthNeeded = f;
    }

    final float getMinimumHeightNeeded() {
        return this.minimumHeightNeeded;
    }

    final void setMinimumHeightNeeded(float f) {
        this.minimumHeightNeeded = f;
    }

    final float getScalePixelWidth() {
        return this.scalePixelWidth;
    }

    final void setScalePixelWidth(float f) {
        this.scalePixelWidth = f;
    }

    final void computeAxisTitleDimensions(String string) {
        TextLayout textLayout = new TextLayout(string, this.getAxisChart().getAxisProperties().getAxisTitleFont(), this.getAxisChart().getGraphics2D().getFontRenderContext());
        this.titleWidth = textLayout.getAdvance();
        this.titleHeight = textLayout.getAscent() + textLayout.getDescent();
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        String string = this.getClass().getSuperclass().getName() + "->";
        Field[] fieldArray = this.getClass().getSuperclass().getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            try {
                hTMLGenerator.addField(string + fieldArray[n].getName(), fieldArray[n].get(this));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            ++n;
        }
    }
}

