/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.Hibernate;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.sql.JoinFragment;
import org.hibernate.sql.OracleJoinFragment;

public class TimesTenDialect
extends Dialect {
    public TimesTenDialect() {
        this.registerColumnType(-7, "TINYINT");
        this.registerColumnType(-5, "BIGINT");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(-6, "TINYINT");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(1, "CHAR(1)");
        this.registerColumnType(12, "VARCHAR($l)");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(8, "DOUBLE");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(-3, "VARBINARY($l)");
        this.registerColumnType(2, "DECIMAL($p, $s)");
        this.registerColumnType(2004, "VARBINARY(4000000)");
        this.registerColumnType(2005, "VARCHAR(4000000)");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim"));
        this.registerFunction("concat", new StandardSQLFunction("concat", Hibernate.STRING));
        this.registerFunction("mod", new StandardSQLFunction("mod"));
        this.registerFunction("to_char", new StandardSQLFunction("to_char", Hibernate.STRING));
        this.registerFunction("to_date", new StandardSQLFunction("to_date", Hibernate.TIMESTAMP));
        this.registerFunction("sysdate", new NoArgSQLFunction("sysdate", Hibernate.DATE, false));
        this.registerFunction("getdate", new NoArgSQLFunction("getdate", Hibernate.DATE, false));
        this.registerFunction("nvl", new StandardSQLFunction("nvl"));
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public boolean supportsUnique() {
        return false;
    }

    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return false;
    }

    public String getAddColumnString() {
        return "add";
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select first 1 " + sequenceName + ".nextval from sys.tables";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getQuerySequencesString() {
        return "select NAME from sys.sequences";
    }

    public JoinFragment createOuterJoinFragment() {
        return new OracleJoinFragment();
    }

    public String getForUpdateString() {
        return "";
    }

    public boolean supportsColumnCheck() {
        return false;
    }

    public boolean supportsTableCheck() {
        return false;
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    private static int getAfterSelectInsertPoint(String sql) {
        return 6;
    }

    public String getLimitString(String querySelect, int offset, int limit) {
        if (offset > 0) {
            throw new UnsupportedOperationException("sql server has no offset");
        }
        return new StringBuffer(querySelect.length() + 8).append(querySelect).insert(TimesTenDialect.getAfterSelectInsertPoint(querySelect), " first " + limit).toString();
    }
}

