/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.CollectionEntry;
import org.hibernate.engine.EntityEntry;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.Status;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public final class Collections {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$engine$Collections == null ? (class$org$hibernate$engine$Collections = Collections.class$("org.hibernate.engine.Collections")) : class$org$hibernate$engine$Collections));
    static /* synthetic */ Class class$org$hibernate$engine$Collections;

    private Collections() {
    }

    public static void processUnreachableCollection(PersistentCollection coll, SessionImplementor session) throws HibernateException {
        if (coll.getOwner() == null) {
            Collections.processNeverReferencedCollection(coll, session);
        } else {
            Collections.processDereferencedCollection(coll, session);
        }
    }

    private static void processDereferencedCollection(PersistentCollection coll, SessionImplementor session) throws HibernateException {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        CollectionEntry entry = persistenceContext.getCollectionEntry(coll);
        if (log.isDebugEnabled() && entry.getLoadedPersister() != null) {
            log.debug((Object)("Collection dereferenced: " + MessageHelper.collectionInfoString(entry.getLoadedPersister(), entry.getLoadedKey(), session.getFactory())));
        }
        if (entry.getLoadedPersister() != null && entry.getLoadedPersister().hasOrphanDelete()) {
            EntityKey key = new EntityKey(entry.getLoadedKey(), entry.getLoadedPersister().getOwnerEntityPersister(), session.getEntityMode());
            Object owner = persistenceContext.getEntity(key);
            if (owner == null) {
                throw new AssertionFailure("owner not associated with session");
            }
            EntityEntry e = persistenceContext.getEntry(owner);
            if (e != null && e.getStatus() != Status.DELETED && e.getStatus() != Status.GONE) {
                throw new HibernateException("Don't dereference a collection with cascade=\"all-delete-orphan\": " + coll.getCollectionSnapshot().getRole());
            }
        }
        entry.setCurrentPersister(null);
        entry.setCurrentKey(null);
        Collections.prepareCollectionForUpdate(coll, entry, session.getEntityMode(), session.getFactory());
    }

    private static void processNeverReferencedCollection(PersistentCollection coll, SessionImplementor session) throws HibernateException {
        PersistenceContext persistenceContext = session.getPersistenceContext();
        CollectionEntry entry = persistenceContext.getCollectionEntry(coll);
        log.debug((Object)("Found collection with unloaded owner: " + MessageHelper.collectionInfoString(entry.getLoadedPersister(), entry.getLoadedKey(), session.getFactory())));
        entry.setCurrentPersister(entry.getLoadedPersister());
        entry.setCurrentKey(entry.getLoadedKey());
        Collections.prepareCollectionForUpdate(coll, entry, session.getEntityMode(), session.getFactory());
    }

    public static void processReachableCollection(PersistentCollection coll, Type type, Object entity, SessionImplementor session) throws HibernateException {
        coll.setOwner(entity);
        CollectionEntry ce = session.getPersistenceContext().getCollectionEntry(coll);
        if (ce == null) {
            throw new HibernateException("Found two representations of same collection");
        }
        if (ce.isReached()) {
            throw new HibernateException("Found shared references to a collection");
        }
        ce.setReached(true);
        CollectionType pctype = (CollectionType)type;
        CollectionPersister persister = session.getFactory().getCollectionPersister(pctype.getRole());
        ce.setCurrentPersister(persister);
        ce.setCurrentKey(pctype.getKeyOfOwner(entity, session));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Collection found: " + MessageHelper.collectionInfoString(persister, ce.getCurrentKey(), session.getFactory()) + ", was: " + MessageHelper.collectionInfoString(ce.getLoadedPersister(), ce.getLoadedKey(), session.getFactory()) + (ce.isInitialized() ? " (initialized)" : " (uninitialized)")));
        }
        Collections.prepareCollectionForUpdate(coll, ce, session.getEntityMode(), session.getFactory());
    }

    private static void prepareCollectionForUpdate(PersistentCollection coll, CollectionEntry entry, EntityMode entityMode, SessionFactoryImplementor factory) throws HibernateException {
        if (entry.isProcessed()) {
            throw new AssertionFailure("collection was processed twice by flush()");
        }
        entry.setProcessed(true);
        if (entry.getLoadedPersister() != null || entry.getCurrentPersister() != null) {
            boolean ownerChanged;
            boolean bl = ownerChanged = entry.getLoadedPersister() != entry.getCurrentPersister() || !entry.getCurrentPersister().getKeyType().isEqual(entry.getLoadedKey(), entry.getCurrentKey(), entityMode, factory);
            if (ownerChanged) {
                if (entry.getLoadedPersister() != null && entry.getCurrentPersister() != null && entry.getLoadedPersister().hasOrphanDelete()) {
                    throw new HibernateException("Don't change the reference to a collection with cascade=\"all-delete-orphan\": " + coll.getCollectionSnapshot().getRole());
                }
                if (entry.getCurrentPersister() != null) {
                    entry.setDorecreate(true);
                }
                if (entry.getLoadedPersister() != null) {
                    entry.setDoremove(true);
                    if (entry.isDorecreate()) {
                        log.trace((Object)"Forcing collection initialization");
                        coll.forceInitialization();
                    }
                }
            } else if (entry.isDirty()) {
                entry.setDoupdate(true);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

