/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import net.sf.cglib.reflect.FastClass;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.InstantiationException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.tuple.Instantiator;
import org.hibernate.util.ReflectHelper;

public class PojoInstantiator
implements Instantiator,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$hibernate$tuple$PojoInstantiator == null ? (class$org$hibernate$tuple$PojoInstantiator = PojoInstantiator.class$("org.hibernate.tuple.PojoInstantiator")) : class$org$hibernate$tuple$PojoInstantiator));
    private transient Constructor constructor;
    private final Class mappedClass;
    private final transient FastClass fastClass;
    private final boolean embeddedIdentifier;
    private final Class proxyInterface;
    static /* synthetic */ Class class$org$hibernate$tuple$PojoInstantiator;

    public PojoInstantiator(Class mappedClass, Class proxyInterface, FastClass fastClass, boolean embedded) {
        this.mappedClass = mappedClass;
        this.proxyInterface = proxyInterface;
        this.fastClass = fastClass;
        this.embeddedIdentifier = embedded;
        try {
            this.constructor = ReflectHelper.getDefaultConstructor(mappedClass);
        }
        catch (PropertyNotFoundException pnfe) {
            log.info((Object)("no default (no-argument) constructor for class: " + mappedClass.getName() + " (class must be instantiated by Interceptor)"));
            this.constructor = null;
        }
    }

    private void readObject(ObjectInputStream stream) throws ClassNotFoundException, IOException {
        stream.defaultReadObject();
        this.constructor = ReflectHelper.getDefaultConstructor(this.mappedClass);
    }

    public Object instantiate() {
        if (ReflectHelper.isAbstractClass(this.mappedClass)) {
            throw new InstantiationException("Cannot instantiate abstract class or interface: ", this.mappedClass);
        }
        if (this.fastClass != null) {
            try {
                return this.fastClass.newInstance();
            }
            catch (Throwable t) {
                throw new InstantiationException("Could not instantiate entity with CGLIB: ", this.mappedClass, t);
            }
        }
        if (this.constructor == null) {
            throw new InstantiationException("No default constructor for entity: ", this.mappedClass);
        }
        try {
            return this.constructor.newInstance(null);
        }
        catch (Exception e) {
            throw new InstantiationException("Could not instantiate entity: ", this.mappedClass, e);
        }
    }

    public Object instantiate(Serializable id) {
        if (this.embeddedIdentifier && id != null && id.getClass().equals(this.mappedClass)) {
            return id;
        }
        return this.instantiate();
    }

    public boolean isInstance(Object object) {
        return this.mappedClass.isInstance(object) || this.proxyInterface != null && this.proxyInterface.isInstance(object);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

