/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.ASTFactory;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.collections.AST;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.QueryException;
import org.hibernate.engine.JoinSequence;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.hql.antlr.HqlSqlBaseWalker;
import org.hibernate.hql.ast.ASTPrinter;
import org.hibernate.hql.ast.ASTUtil;
import org.hibernate.hql.ast.AliasGenerator;
import org.hibernate.hql.ast.CollectionFunction;
import org.hibernate.hql.ast.ConstructorNode;
import org.hibernate.hql.ast.DotNode;
import org.hibernate.hql.ast.ErrorCounter;
import org.hibernate.hql.ast.ErrorReporter;
import org.hibernate.hql.ast.FromClause;
import org.hibernate.hql.ast.FromElement;
import org.hibernate.hql.ast.FromReferenceNode;
import org.hibernate.hql.ast.HqlParser;
import org.hibernate.hql.ast.IndexNode;
import org.hibernate.hql.ast.JoinProcessor;
import org.hibernate.hql.ast.LiteralProcessor;
import org.hibernate.hql.ast.MethodNode;
import org.hibernate.hql.ast.ParseErrorHandler;
import org.hibernate.hql.ast.QueryNode;
import org.hibernate.hql.ast.QueryTranslatorImpl;
import org.hibernate.hql.ast.ResolvableNode;
import org.hibernate.hql.ast.SelectClause;
import org.hibernate.hql.ast.SessionFactoryHelper;
import org.hibernate.hql.ast.SqlASTFactory;
import org.hibernate.hql.ast.SyntheticAndFactory;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.type.AssociationType;
import org.hibernate.type.Type;
import org.hibernate.util.ArrayHelper;

public class HqlSqlWalker
extends HqlSqlBaseWalker
implements ErrorReporter {
    private static Log log = LogFactory.getLog((Class)(class$org$hibernate$hql$ast$HqlSqlWalker == null ? (class$org$hibernate$hql$ast$HqlSqlWalker = HqlSqlWalker.class$("org.hibernate.hql.ast.HqlSqlWalker")) : class$org$hibernate$hql$ast$HqlSqlWalker));
    private SessionFactoryHelper sessionFactoryHelper;
    private LiteralProcessor literalProcessor;
    private ParseErrorHandler parseErrorHandler;
    private FromClause currentFromClause = null;
    private SelectClause selectClause;
    private AliasGenerator aliasGenerator = new AliasGenerator();
    private Set querySpaces = new HashSet();
    private Map tokenReplacements;
    private QueryTranslatorImpl queryTranslatorImpl;
    private int parameterCount;
    private Map namedParameters = new HashMap();
    private boolean useThetaStyleImplicitJoins = true;
    private String filterCollectionRole;
    private HqlParser hqlParser;
    private ASTPrinter printer;
    private int impliedJoinType;
    static /* synthetic */ Class class$org$hibernate$hql$ast$HqlSqlWalker;
    static /* synthetic */ Class class$org$hibernate$hql$antlr$SqlTokenTypes;

    public HqlSqlWalker(QueryTranslatorImpl qti, SessionFactoryImplementor sfi, HqlParser parser, Map tokenReplacements, String collectionRole) {
        this.setASTFactory(new SqlASTFactory(this));
        this.parseErrorHandler = new ErrorCounter();
        this.queryTranslatorImpl = qti;
        this.sessionFactoryHelper = new SessionFactoryHelper(sfi);
        this.literalProcessor = new LiteralProcessor(this);
        this.tokenReplacements = tokenReplacements;
        this.filterCollectionRole = collectionRole;
        this.hqlParser = parser;
        this.printer = new ASTPrinter(class$org$hibernate$hql$antlr$SqlTokenTypes == null ? (class$org$hibernate$hql$antlr$SqlTokenTypes = HqlSqlWalker.class$("org.hibernate.hql.antlr.SqlTokenTypes")) : class$org$hibernate$hql$antlr$SqlTokenTypes);
    }

    protected void prepareFromClauseInputTree(AST fromClauseInput) {
        if (this.isFilter() && !this.isSubQuery()) {
            QueryableCollection persister = this.sessionFactoryHelper.getCollectionPersister(this.filterCollectionRole);
            Type collectionElementType = persister.getElementType();
            if (!collectionElementType.isEntityType()) {
                throw new QueryException("collection of values in filter: this");
            }
            String collectionElementEntityName = persister.getElementPersister().getEntityName();
            ASTFactory inputAstFactory = this.hqlParser.getASTFactory();
            AST fromElement = ASTUtil.create(inputAstFactory, 69, collectionElementEntityName);
            ASTUtil.createSibling(inputAstFactory, 65, "this", fromElement);
            fromClauseInput.addChild(fromElement);
            if (log.isDebugEnabled()) {
                log.debug((Object)"prepareFromClauseInputTree() : Filter - Added 'this' as a from element...");
            }
            this.queryTranslatorImpl.showHqlAst(this.hqlParser.getAST());
        }
    }

    private boolean isFilter() {
        return this.filterCollectionRole != null;
    }

    public SessionFactoryHelper getSessionFactoryHelper() {
        return this.sessionFactoryHelper;
    }

    public Map getTokenReplacements() {
        return this.tokenReplacements;
    }

    public AliasGenerator getAliasGenerator() {
        return this.aliasGenerator;
    }

    FromClause getCurrentFromClause() {
        return this.currentFromClause;
    }

    public ParseErrorHandler getParseErrorHandler() {
        return this.parseErrorHandler;
    }

    public void reportError(RecognitionException e) {
        this.parseErrorHandler.reportError(e);
    }

    public void reportError(String s) {
        this.parseErrorHandler.reportError(s);
    }

    public void reportWarning(String s) {
        this.parseErrorHandler.reportWarning(s);
    }

    Set getQuerySpaces() {
        return this.querySpaces;
    }

    protected AST createFromElement(String path, AST alias, AST propertyFetch) throws SemanticException {
        FromElement fromElement = this.currentFromClause.addFromElement(path, alias);
        fromElement.setAllPropertyFetch(propertyFetch != null);
        return fromElement;
    }

    protected AST createFromFilterElement(AST filterEntity, AST alias) throws SemanticException {
        FromElement fromElement = this.currentFromClause.addFromElement(filterEntity.getText(), alias);
        FromClause fromClause = fromElement.getFromClause();
        QueryableCollection persister = this.sessionFactoryHelper.getCollectionPersister(this.filterCollectionRole);
        String[] keyColumnNames = persister.getKeyColumnNames();
        String fkTableAlias = persister.isOneToMany() ? fromElement.getTableAlias() : fromClause.getAliasGenerator().createName(this.filterCollectionRole);
        JoinSequence join = this.sessionFactoryHelper.createJoinSequence();
        join.setRoot(persister, fkTableAlias);
        if (!persister.isOneToMany()) {
            join.addJoin((AssociationType)persister.getElementType(), fromElement.getTableAlias(), 0, persister.getElementColumnNames(fkTableAlias));
        }
        join.addCondition(fkTableAlias, keyColumnNames, " = ?");
        fromElement.setJoinSequence(join);
        fromElement.setFilter(true);
        if (log.isDebugEnabled()) {
            log.debug((Object)"createFromFilterElement() : processed filter FROM element.");
        }
        return fromElement;
    }

    protected void createFromJoinElement(AST path, AST alias, int joinType, AST fetchNode, AST propertyFetch) throws SemanticException {
        boolean fetch;
        boolean bl = fetch = fetchNode != null;
        if (path.getType() != 15) {
            throw new SemanticException("Path expected for join!");
        }
        DotNode dot = (DotNode)path;
        int hibernateJoinType = JoinProcessor.toHibernateJoinType(joinType);
        dot.setJoinType(hibernateJoinType);
        dot.setFetch(fetch);
        dot.resolve(true, false, alias == null ? null : alias.getText());
        FromElement fromElement = dot.getImpliedJoin();
        fromElement.setAllPropertyFetch(propertyFetch != null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("createFromJoinElement() : " + this.getASTPrinter().showAsString((AST)fromElement, "-- join tree --")));
        }
    }

    protected void pushFromClause(AST fromNode, AST inputFromNode) {
        FromClause newFromClause = (FromClause)fromNode;
        newFromClause.setParentFromClause(this.currentFromClause);
        this.currentFromClause = newFromClause;
    }

    private void popFromClause() {
        this.currentFromClause = this.currentFromClause.getParentFromClause();
    }

    protected void lookupAlias(AST aliasRef) throws SemanticException {
        FromElement alias = this.currentFromClause.getFromElement(aliasRef.getText());
        FromReferenceNode aliasRefNode = (FromReferenceNode)aliasRef;
        aliasRefNode.setFromElement(alias);
    }

    protected void setImpliedJoinType(int joinType) {
        this.impliedJoinType = JoinProcessor.toHibernateJoinType(joinType);
    }

    int getImpliedJoinType() {
        return this.impliedJoinType;
    }

    protected AST lookupProperty(AST dot, boolean root, boolean inSelect) throws SemanticException {
        DotNode dotNode = (DotNode)dot;
        FromReferenceNode lhs = dotNode.getLhs();
        AST rhs = lhs.getNextSibling();
        switch (rhs.getType()) {
            case 17: 
            case 27: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("lookupProperty() " + dotNode.getPath() + " => " + rhs.getText() + "(" + lhs.getPath() + ")"));
                }
                CollectionFunction f = (CollectionFunction)rhs;
                f.setFirstChild((AST)lhs);
                lhs.setNextSibling(null);
                dotNode.setFirstChild((AST)f);
                this.resolve((AST)lhs);
                f.resolve(inSelect);
                return f;
            }
        }
        dotNode.resolveFirstChild();
        return dotNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processQuery(AST select, AST query) throws SemanticException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("processQuery() : " + query.toStringTree()));
        }
        try {
            boolean explicitSelect;
            QueryNode qn = (QueryNode)query;
            boolean bl = explicitSelect = select != null && select.getNumberOfChildren() > 0;
            if (!explicitSelect) {
                this.createSelectClauseFromFromClause(qn);
            } else {
                this.useSelectClause(select);
            }
            JoinProcessor joinProcessor = new JoinProcessor(this.astFactory, this.queryTranslatorImpl);
            joinProcessor.processJoins(qn);
            Iterator itr = qn.getFromClause().getProjectionList().iterator();
            while (itr.hasNext()) {
                FromElement fromElement = (FromElement)itr.next();
                if (!fromElement.isFetch() || fromElement.getQueryableCollection() == null || !fromElement.getQueryableCollection().hasOrdering()) continue;
                String orderByFragment = fromElement.getQueryableCollection().getSQLOrderByString(fromElement.getCollectionTableAlias());
                qn.getOrderByClause().addOrderFragment(orderByFragment);
            }
        }
        finally {
            this.popFromClause();
        }
    }

    protected void postProcessUpdate(AST update) throws SemanticException {
        QueryNode qn = (QueryNode)update;
        FromClause fromClause = qn.getFromClause();
        fromClause.resolve();
        FromElement fromElement = (FromElement)fromClause.getFromElements().get(0);
        Queryable persister = fromElement.getQueryable();
        fromElement.setText(persister.getTableName());
        if (persister instanceof SingleTableEntityPersister) {
            SingleTableEntityPersister step = (SingleTableEntityPersister)persister;
            new SyntheticAndFactory(this.getASTFactory()).addDiscriminatorWhereFragment(qn, step, fromElement.getTableAlias());
        } else if (persister.getMappedSuperclass() != null) {
            throw new QueryException("Update statements against joined or union subclasses not yet supported!");
        }
    }

    protected void postProcessDelete(AST delete) throws SemanticException {
        QueryNode qn = (QueryNode)delete;
        FromClause fromClause = qn.getFromClause();
        fromClause.resolve();
        FromElement fromElement = (FromElement)fromClause.getFromElements().get(0);
        Queryable persister = fromElement.getQueryable();
        fromElement.setText(persister.getTableName());
        if (persister instanceof SingleTableEntityPersister) {
            SingleTableEntityPersister step = (SingleTableEntityPersister)persister;
            new SyntheticAndFactory(this.getASTFactory()).addDiscriminatorWhereFragment(qn, step, fromElement.getTableAlias());
        } else if (persister.getMappedSuperclass() != null) {
            throw new QueryException("Delete statements against joined or union subclasses not yet supported!");
        }
    }

    private void useSelectClause(AST select) throws SemanticException {
        this.selectClause = (SelectClause)select;
        this.selectClause.initializeExplicitSelectClause(this.currentFromClause);
    }

    private void createSelectClauseFromFromClause(QueryNode qn) throws SemanticException {
        AST select = this.astFactory.create(124, "{derived select clause}");
        FromClause sibling = qn.getFromClause();
        qn.setFirstChild(select);
        select.setNextSibling((AST)sibling);
        this.selectClause = (SelectClause)select;
        this.selectClause.initializeDerivedSelectClause(this.currentFromClause);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Derived SELECT clause created.");
        }
    }

    protected void resolve(AST node) throws SemanticException {
        if (node != null) {
            ResolvableNode r = (ResolvableNode)node;
            if (this.isInFunctionCall()) {
                r.resolveInFunctionCall(false, true);
            } else {
                r.resolve(false, true);
            }
        }
    }

    protected void resolveSelectExpression(AST node) throws SemanticException {
        int type = node.getType();
        switch (type) {
            case 15: {
                DotNode dot = (DotNode)node;
                dot.resolveSelectExpression(this.useThetaStyleImplicitJoins);
                break;
            }
            case 127: {
                FromReferenceNode aliasRefNode = (FromReferenceNode)node;
                aliasRefNode.resolve(false, false);
                FromElement fromElement = aliasRefNode.getFromElement();
                if (fromElement == null) break;
                fromElement.setIncludeSubclasses(true);
            }
        }
    }

    protected void beforeSelectClause() throws SemanticException {
        FromClause from = this.getCurrentFromClause();
        List fromElements = from.getFromElements();
        Iterator iterator = fromElements.iterator();
        while (iterator.hasNext()) {
            FromElement fromElement = (FromElement)iterator.next();
            fromElement.setIncludeSubclasses(false);
        }
    }

    protected void positionalParameter(AST parameter) throws SemanticException {
        if (this.namedParameters.size() > 0) {
            throw new SemanticException("");
        }
    }

    private void addNamedParameter(String name) {
        Integer loc = new Integer(this.parameterCount++);
        Object o = this.namedParameters.get(name);
        if (o == null) {
            this.namedParameters.put(name, loc);
        } else if (o instanceof Integer) {
            ArrayList<Object> list = new ArrayList<Object>(4);
            list.add(o);
            list.add(loc);
            this.namedParameters.put(name, list);
        } else {
            ((ArrayList)o).add(loc);
        }
    }

    protected void processConstant(AST constant) throws SemanticException {
        this.literalProcessor.processConstant(constant);
    }

    protected void processBoolean(AST constant) throws SemanticException {
        this.literalProcessor.processBoolean(constant);
    }

    protected void processIndex(AST indexOp) throws SemanticException {
        IndexNode indexNode = (IndexNode)indexOp;
        indexNode.resolve(true, true);
    }

    protected void processFunction(AST functionCall, boolean inSelect) throws SemanticException {
        MethodNode methodNode = (MethodNode)functionCall;
        methodNode.resolve(inSelect);
    }

    protected void processConstructor(AST constructor) throws SemanticException {
        ConstructorNode constructorNode = (ConstructorNode)constructor;
        constructorNode.prepare();
    }

    protected void namedParameter(AST namedParameter) throws SemanticException {
        this.addNamedParameter(namedParameter.getText());
        namedParameter.setText("?");
    }

    int[] getNamedParameterLocs(String name) throws QueryException {
        Object o = this.namedParameters.get(name);
        if (o == null) {
            QueryException qe = new QueryException("Named parameter does not appear in Query: " + name);
            qe.setQueryString(this.queryTranslatorImpl.getQueryString());
            throw qe;
        }
        if (o instanceof Integer) {
            return new int[]{(Integer)o};
        }
        return ArrayHelper.toIntArray((ArrayList)o);
    }

    void addQuerySpaces(Serializable[] spaces) {
        for (int i = 0; i < spaces.length; ++i) {
            this.querySpaces.add(spaces[i]);
        }
    }

    public Type[] getReturnTypes() {
        return this.selectClause.getQueryReturnTypes();
    }

    public String[] getReturnAliases() {
        return this.selectClause.getQueryReturnAliases();
    }

    public boolean isSubQuery() {
        return this.currentFromClause != null ? this.currentFromClause.isSubQuery() : false;
    }

    public SelectClause getSelectClause() {
        return this.selectClause;
    }

    public FromClause getFinalFromClause() {
        return this.currentFromClause;
    }

    public boolean isShallowQuery() {
        return this.queryTranslatorImpl.isShallowQuery();
    }

    public Map getEnabledFilters() {
        return this.queryTranslatorImpl.getEnabledFilters();
    }

    LiteralProcessor getLiteralProcessor() {
        return this.literalProcessor;
    }

    ASTPrinter getASTPrinter() {
        return this.printer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

