/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.helper.TopLinkIdentityHashSet;
import oracle.toplink.essentials.internal.queryframework.ContainerPolicy;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.ComplexQueryResult;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;

public class ReadAllQuery
extends ObjectLevelReadQuery {
    protected Vector orderByExpressions;
    protected ContainerPolicy containerPolicy;

    public ReadAllQuery() {
        this.useCollectionClass(ClassConstants.Vector_class);
    }

    public ReadAllQuery(Class classToRead) {
        this();
        this.setReferenceClass(classToRead);
    }

    public ReadAllQuery(Class classToRead, Expression selectionCriteria) {
        this();
        this.setReferenceClass(classToRead);
        this.setSelectionCriteria(selectionCriteria);
    }

    public ReadAllQuery(Class classToRead, ExpressionBuilder builder) {
        this();
        this.defaultBuilder = builder;
        this.setReferenceClass(classToRead);
    }

    public ReadAllQuery(Class classToRead, Call call) {
        this();
        this.setReferenceClass(classToRead);
        this.setCall(call);
    }

    public ReadAllQuery(ExpressionBuilder builder) {
        this();
        this.defaultBuilder = builder;
    }

    public ReadAllQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void addAscendingOrdering(String queryKeyName) {
        this.addOrdering(this.getExpressionBuilder().get(queryKeyName).ascending());
    }

    public void addDescendingOrdering(String queryKeyName) {
        this.addOrdering(this.getExpressionBuilder().get(queryKeyName).descending());
    }

    public void addOrdering(Expression orderingExpression) {
        this.getOrderByExpressions().addElement(orderingExpression);
        this.setIsPrepared(false);
    }

    protected Object checkEarlyReturnImpl(AbstractSession session, AbstractRecord translationRow) {
        if (this.shouldCheckCacheOnly()) {
            if (this.shouldUseWrapperPolicy()) {
                this.getContainerPolicy().setElementDescriptor(this.getDescriptor());
            }
            AbstractSession rootSession = session;
            while (rootSession.isUnitOfWork()) {
                rootSession = ((UnitOfWorkImpl)rootSession).getParent();
            }
            Vector allCachedVector = rootSession.getIdentityMapAccessor().getAllFromIdentityMap(this.getSelectionCriteria(), this.getReferenceClass(), translationRow, this.getInMemoryQueryIndirectionPolicy(), false);
            if (session.isUnitOfWork()) {
                allCachedVector = ((UnitOfWorkImpl)session).registerAllObjects(allCachedVector);
            }
            return this.getContainerPolicy().buildContainerFromVector(allCachedVector, session);
        }
        return null;
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession session, AbstractRecord translationRow) {
        this.checkDescriptor(session);
        if (!this.isUserDefined() && this.isExpressionQuery() && this.getSelectionCriteria() == null && !this.hasOrderByExpressions() && this.getDescriptor().getQueryManager().hasReadAllQuery()) {
            return this.getDescriptor().getQueryManager().getReadAllQuery();
        }
        return null;
    }

    public Object clone() {
        ReadAllQuery cloneQuery = (ReadAllQuery)super.clone();
        if (this.hasOrderByExpressions()) {
            cloneQuery.orderByExpressions = (Vector)this.getOrderByExpressions().clone();
        }
        cloneQuery.containerPolicy = this.getContainerPolicy().clone(cloneQuery);
        return cloneQuery;
    }

    protected Object conformResult(Object result, UnitOfWorkImpl unitOfWork, AbstractRecord arguments, boolean buildDirectlyFromRows) {
        Object eachClone;
        IdentityHashtable indexedInterimResult = null;
        Expression selectionCriteriaClone = null;
        if (this.getSelectionCriteria() != null) {
            selectionCriteriaClone = (Expression)this.getSelectionCriteria().clone();
            selectionCriteriaClone.getBuilder().setSession(unitOfWork);
            selectionCriteriaClone.getBuilder().setQueryClass(this.getReferenceClass());
        }
        ContainerPolicy cp = this.getContainerPolicy();
        indexedInterimResult = unitOfWork.scanForConformingInstances(selectionCriteriaClone, this.getReferenceClass(), arguments, this);
        Vector<Object> fromDatabase = null;
        if (buildDirectlyFromRows) {
            Vector rows = (Vector)result;
            Set identitySet = null;
            fromDatabase = new Vector(rows.size());
            for (int i = 0; i < rows.size(); ++i) {
                Object clone;
                Object object = rows.elementAt(i);
                if (object == null || (clone = this.conformIndividualResult(object, unitOfWork, arguments, selectionCriteriaClone, indexedInterimResult, buildDirectlyFromRows)) == null) continue;
                if (this.getJoinedAttributeManager().isToManyJoin()) {
                    if (identitySet == null) {
                        identitySet = new TopLinkIdentityHashSet(rows.size());
                    }
                    if (identitySet.contains(clone)) continue;
                    identitySet.add(clone);
                    fromDatabase.addElement(clone);
                    continue;
                }
                fromDatabase.addElement(clone);
            }
        } else {
            fromDatabase = new Vector<Object>(cp.sizeFor(result));
            AbstractSession sessionToUse = unitOfWork.getParent();
            Object iter = cp.iteratorFor(result);
            while (cp.hasNext(iter)) {
                Object object = cp.next(iter, sessionToUse);
                Object clone = this.conformIndividualResult(object, unitOfWork, arguments, selectionCriteriaClone, indexedInterimResult, buildDirectlyFromRows);
                if (clone == null) continue;
                fromDatabase.addElement(clone);
            }
        }
        Object conformedResult = cp.containerInstance(indexedInterimResult.size() + fromDatabase.size());
        Enumeration enumtr = indexedInterimResult.elements();
        while (enumtr.hasMoreElements()) {
            eachClone = enumtr.nextElement();
            cp.addInto(eachClone, conformedResult, unitOfWork);
        }
        enumtr = fromDatabase.elements();
        while (enumtr.hasMoreElements()) {
            eachClone = enumtr.nextElement();
            cp.addInto(eachClone, conformedResult, unitOfWork);
        }
        return conformedResult;
    }

    protected Object executeObjectLevelReadQuery() throws DatabaseException {
        Object result = null;
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().execute();
        }
        Vector rows = this.getQueryMechanism().selectAllRows();
        this.setExecutionTime(System.currentTimeMillis());
        if (this.getJoinedAttributeManager().isToManyJoin()) {
            this.getJoinedAttributeManager().setDataResults(rows, this.getSession());
        }
        result = this.getSession().isUnitOfWork() ? this.registerResultInUnitOfWork(rows, (UnitOfWorkImpl)this.getSession(), this.getTranslationRow(), true) : this.getQueryMechanism().buildObjectsFromRows(rows);
        if (this.shouldIncludeData()) {
            ComplexQueryResult complexResult = new ComplexQueryResult();
            complexResult.setResult(result);
            complexResult.setData(rows);
            return complexResult;
        }
        return result;
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public Vector getOrderByExpressions() {
        if (this.orderByExpressions == null) {
            this.orderByExpressions = new Vector();
        }
        return this.orderByExpressions;
    }

    public boolean hasOrderByExpressions() {
        return this.orderByExpressions != null;
    }

    public boolean hasHierarchicalExpressions() {
        return false;
    }

    public boolean hasBatchReadAttributes() {
        return false;
    }

    public boolean isAttributeBatchRead(String attributeName) {
        return false;
    }

    public boolean isReadAllQuery() {
        return true;
    }

    protected void prepare() throws QueryException {
        super.prepare();
        this.getContainerPolicy().prepare(this, this.getSession());
        if (this.getContainerPolicy().overridesRead()) {
            return;
        }
        this.prepareSelectAllRows();
    }

    protected void prepareCustomQuery(DatabaseQuery customQuery) {
        ReadAllQuery customReadQuery = (ReadAllQuery)customQuery;
        customReadQuery.setContainerPolicy(this.getContainerPolicy());
        customReadQuery.setCascadePolicy(this.getCascadePolicy());
        customReadQuery.setShouldRefreshIdentityMapResult(this.shouldRefreshIdentityMapResult());
        customReadQuery.setShouldMaintainCache(this.shouldMaintainCache());
        customReadQuery.setShouldUseWrapperPolicy(this.shouldUseWrapperPolicy());
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        this.getContainerPolicy().prepareForExecution();
    }

    protected void prepareSelectAllRows() {
        this.getQueryMechanism().prepareSelectAllRows();
    }

    public Object registerResultInUnitOfWork(Object result, UnitOfWorkImpl unitOfWork, AbstractRecord arguments, boolean buildDirectlyFromRows) {
        if (this.shouldConformResultsInUnitOfWork() || this.getDescriptor().shouldAlwaysConformResultsInUnitOfWork()) {
            return this.conformResult(result, unitOfWork, arguments, buildDirectlyFromRows);
        }
        if (buildDirectlyFromRows) {
            Vector rows = (Vector)result;
            Set identitySet = null;
            ContainerPolicy cp = this.getContainerPolicy();
            Object clones = cp.containerInstance(rows.size());
            Enumeration enumtr = rows.elements();
            while (enumtr.hasMoreElements()) {
                Object row = enumtr.nextElement();
                if (row == null) continue;
                Object clone = this.registerIndividualResult(row, unitOfWork, buildDirectlyFromRows);
                if (this.getJoinedAttributeManager().isToManyJoin()) {
                    if (identitySet == null) {
                        identitySet = new TopLinkIdentityHashSet(rows.size());
                    }
                    if (identitySet.contains(clone)) continue;
                    identitySet.add(clone);
                    cp.addInto(clone, clones, unitOfWork);
                    continue;
                }
                cp.addInto(clone, clones, unitOfWork);
            }
            return clones;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        Object clones = cp.containerInstance(cp.sizeFor(result));
        AbstractSession sessionToUse = unitOfWork.getParent();
        Object iter = cp.iteratorFor(result);
        while (cp.hasNext(iter)) {
            Object object = cp.next(iter, sessionToUse);
            Object clone = this.registerIndividualResult(object, unitOfWork, buildDirectlyFromRows);
            cp.addInto(clone, clones, unitOfWork);
        }
        return clones;
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        if (containerPolicy == null) {
            return;
        }
        this.containerPolicy = containerPolicy;
        this.setIsPrepared(false);
    }

    public void setOrderByExpressions(Vector orderByExpressions) {
        this.orderByExpressions = orderByExpressions;
    }

    public void useCollectionClass(Class concreteClass) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(concreteClass));
    }

    public void useMapClass(Class concreteClass, String methodName) {
        if (this.getReferenceClass() == null) {
            throw QueryException.referenceClassMissing(this);
        }
        ContainerPolicy policy = ContainerPolicy.buildPolicyFor(concreteClass);
        policy.setKeyName(methodName, this.getReferenceClass().getName());
        this.setContainerPolicy(policy);
    }
}

