/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.plugins;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.plugins.PluginSkeleton;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.Thresholdable;

public abstract class Receiver
extends PluginSkeleton
implements Thresholdable {
    protected Level thresholdLevel;

    protected Receiver() {
    }

    public void setThreshold(Level level) {
        Level oldValue = this.thresholdLevel;
        this.thresholdLevel = level;
        this.firePropertyChange("threshold", oldValue, this.thresholdLevel);
    }

    public Level getThreshold() {
        return this.thresholdLevel;
    }

    public boolean isAsSevereAsThreshold(Level level) {
        return this.thresholdLevel == null || level.isGreaterOrEqual((Priority)this.thresholdLevel);
    }

    public void doPost(LoggingEvent event) {
        if (!this.isAsSevereAsThreshold(event.getLevel())) {
            return;
        }
        Logger localLogger = this.getLoggerRepository().getLogger(event.getLoggerName());
        if (event.getLevel().isGreaterOrEqual((Priority)localLogger.getEffectiveLevel())) {
            localLogger.callAppenders(event);
        }
    }
}

