/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi;

import org.apache.log4j.ULogger;
import org.apache.log4j.helpers.MessageFormatter;

public final class SimpleULogger
implements ULogger {
    private final String loggerName;
    private static long startTime = System.currentTimeMillis();
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String INFO_STR = "INFO";
    private static final String WARN_STR = "WARN";
    private static final String ERROR_STR = "ERROR";

    private SimpleULogger(String name) {
        this.loggerName = name;
    }

    public static SimpleULogger getLogger(String name) {
        return new SimpleULogger(name);
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public void debug(Object msg) {
    }

    public void debug(Object parameterizedMsg, Object param1) {
    }

    public void debug(String parameterizedMsg, Object param1, Object param2) {
    }

    public void debug(Object msg, Throwable t) {
    }

    private void log(String level, String message, Throwable t) {
        StringBuffer buf = new StringBuffer();
        long millis = System.currentTimeMillis();
        buf.append(millis - startTime);
        buf.append(" [");
        buf.append(Thread.currentThread().getName());
        buf.append("] ");
        buf.append(level);
        buf.append(" ");
        buf.append(this.loggerName);
        buf.append(" - ");
        buf.append(message);
        buf.append(LINE_SEPARATOR);
        System.out.print(buf.toString());
        if (t != null) {
            t.printStackTrace(System.out);
        }
        System.out.flush();
    }

    private void parameterizedLog(String level, Object parameterizedMsg, Object param1, Object param2) {
        if (parameterizedMsg instanceof String) {
            String msgStr = (String)parameterizedMsg;
            msgStr = MessageFormatter.format(msgStr, param1, param2);
            this.log(level, msgStr, null);
        } else {
            this.log(level, parameterizedMsg.toString(), null);
        }
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public void info(Object msg) {
        this.log(INFO_STR, msg.toString(), null);
    }

    public void info(Object parameterizedMsg, Object param1) {
        this.parameterizedLog(INFO_STR, parameterizedMsg, param1, null);
    }

    public void info(String parameterizedMsg, Object param1, Object param2) {
        this.parameterizedLog(INFO_STR, parameterizedMsg, param1, param2);
    }

    public void info(Object msg, Throwable t) {
        this.log(INFO_STR, msg.toString(), t);
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public void warn(Object msg) {
        this.log(WARN_STR, msg.toString(), null);
    }

    public void warn(Object parameterizedMsg, Object param1) {
        this.parameterizedLog(WARN_STR, parameterizedMsg, param1, null);
    }

    public void warn(String parameterizedMsg, Object param1, Object param2) {
        this.parameterizedLog(WARN_STR, parameterizedMsg, param1, param2);
    }

    public void warn(Object msg, Throwable t) {
        this.log(WARN_STR, msg.toString(), t);
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public void error(Object msg) {
        this.log(ERROR_STR, msg.toString(), null);
    }

    public void error(Object parameterizedMsg, Object param1) {
        this.parameterizedLog(ERROR_STR, parameterizedMsg, param1, null);
    }

    public void error(String parameterizedMsg, Object param1, Object param2) {
        this.parameterizedLog(ERROR_STR, parameterizedMsg, param1, param2);
    }

    public void error(Object msg, Throwable t) {
        this.log(ERROR_STR, msg.toString(), t);
    }
}

