/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.FileInputStream;
import java.util.Properties;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.spi.LoggingEvent;

public class JMSReceiver
extends Receiver
implements MessageListener {
    private boolean active = false;
    protected String topicFactoryName;
    protected String topicName;
    protected String userId;
    protected String password;
    protected TopicConnection topicConnection;
    protected String jndiPath;
    private String remoteInfo;
    private String providerUrl;

    public JMSReceiver() {
    }

    public JMSReceiver(String _topicFactoryName, String _topicName, String _userId, String _password, String _jndiPath) {
        this.topicFactoryName = _topicFactoryName;
        this.topicName = _topicName;
        this.userId = _userId;
        this.password = _password;
        this.jndiPath = _jndiPath;
    }

    public void setJndiPath(String _jndiPath) {
        this.jndiPath = _jndiPath;
    }

    public String getJndiPath() {
        return this.jndiPath;
    }

    public void setTopicFactoryName(String _topicFactoryName) {
        this.topicFactoryName = _topicFactoryName;
    }

    public String getTopicFactoryName() {
        return this.topicFactoryName;
    }

    public void setTopicName(String _topicName) {
        this.topicName = _topicName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void setUserId(String _userId) {
        this.userId = _userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setPassword(String _password) {
        this.password = _password;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isEquivalent(Plugin testPlugin) {
        if (testPlugin instanceof JMSReceiver) {
            JMSReceiver receiver = (JMSReceiver)testPlugin;
            return this.topicFactoryName.equals(receiver.getTopicFactoryName()) && (this.jndiPath == null || this.jndiPath.equals(receiver.getJndiPath())) && super.isEquivalent(testPlugin);
        }
        return false;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    protected synchronized void setActive(boolean _active) {
        this.active = _active;
    }

    public void activateOptions() {
        if (!this.isActive()) {
            try {
                this.remoteInfo = this.topicFactoryName + ":" + this.topicName;
                InitialContext ctx = null;
                if (this.jndiPath == null || this.jndiPath.equals("")) {
                    ctx = new InitialContext();
                } else {
                    FileInputStream is = new FileInputStream(this.jndiPath);
                    Properties p = new Properties();
                    p.load(is);
                    is.close();
                    ctx = new InitialContext(p);
                }
                this.providerUrl = (String)ctx.getEnvironment().get("java.naming.provider.url");
                TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)this.lookup(ctx, this.topicFactoryName);
                this.topicConnection = this.userId != null && this.password != null ? topicConnectionFactory.createTopicConnection(this.userId, this.password) : topicConnectionFactory.createTopicConnection();
                TopicSession topicSession = this.topicConnection.createTopicSession(false, 1);
                Topic topic = (Topic)ctx.lookup(this.topicName);
                TopicSubscriber topicSubscriber = topicSession.createSubscriber(topic);
                topicSubscriber.setMessageListener((MessageListener)this);
                this.topicConnection.start();
                this.setActive(true);
            }
            catch (Exception e) {
                this.setActive(false);
                if (this.topicConnection != null) {
                    try {
                        this.topicConnection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.topicConnection = null;
                }
                this.getLogger().error((Object)"Could not start JMSReceiver.", (Throwable)e);
            }
        }
    }

    public synchronized void shutdown() {
        if (this.isActive()) {
            this.setActive(false);
            if (this.topicConnection != null) {
                try {
                    this.topicConnection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.topicConnection = null;
            }
        }
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof ObjectMessage) {
                ObjectMessage objectMessage = (ObjectMessage)message;
                LoggingEvent event = (LoggingEvent)objectMessage.getObject();
                event.setProperty("log4j.remoteSourceInfo", this.remoteInfo);
                event.setProperty("log4j.jmsProviderUrl", this.providerUrl);
                this.doPost(event);
            } else {
                this.getLogger().warn((Object)("Received message is of type " + message.getJMSType() + ", was expecting ObjectMessage."));
            }
        }
        catch (Exception e) {
            this.getLogger().error((Object)"Exception thrown while processing incoming message.", (Throwable)e);
        }
    }

    protected Object lookup(Context ctx, String name) throws NamingException {
        try {
            return ctx.lookup(name);
        }
        catch (NameNotFoundException e) {
            this.getLogger().error((Object)("Could not find name [" + name + "]."));
            throw e;
        }
    }
}

