/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.log4j.chainsaw.ApplicationPreferenceModel;
import org.apache.log4j.chainsaw.prefs.LoadSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SaveSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SettingsListener;
import org.apache.log4j.chainsaw.prefs.SettingsManager;

public class ApplicationPreferenceModelSaver
implements SettingsListener {
    private final ApplicationPreferenceModel model;

    public ApplicationPreferenceModelSaver(ApplicationPreferenceModel model) {
        this.model = model;
    }

    public void loadSettings(LoadSettingsEvent event) {
        XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
        File file = this.getApplicationPreferenceXMLFile(SettingsManager.getInstance().getSettingsDirectory());
        try {
            if (file.exists()) {
                FileReader reader = new FileReader(file);
                ApplicationPreferenceModel loadedModel = (ApplicationPreferenceModel)stream.fromXML((Reader)reader);
                this.model.apply(loadedModel);
                reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            file.delete();
        }
    }

    public void saveSettings(SaveSettingsEvent event) {
        XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
        try {
            File file = this.getApplicationPreferenceXMLFile(event.getSettingsLocation());
            FileWriter writer = new FileWriter(file);
            stream.toXML((Object)this.model, (Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File getApplicationPreferenceXMLFile(File settingsLocation) {
        return new File(settingsLocation, "chainsaw.settings.xml");
    }
}

