/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ProgressMonitor;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.ChainsawColumns;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.ColumnComparator;
import org.apache.log4j.chainsaw.CyclicBufferList;
import org.apache.log4j.chainsaw.EventContainer;
import org.apache.log4j.chainsaw.EventCountListener;
import org.apache.log4j.chainsaw.ExtendedLoggingEvent;
import org.apache.log4j.chainsaw.LoggerNameListener;
import org.apache.log4j.chainsaw.LoggerNameModel;
import org.apache.log4j.chainsaw.LoggerNameModelSupport;
import org.apache.log4j.chainsaw.NewKeyEvent;
import org.apache.log4j.chainsaw.NewKeyListener;
import org.apache.log4j.chainsaw.color.RuleColorizer;
import org.apache.log4j.chainsaw.helper.SwingHelper;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;

class ChainsawCyclicBufferTableModel
extends AbstractTableModel
implements EventContainer,
PropertyChangeListener {
    private static final int DEFAULT_CAPACITY = 5000;
    private boolean cyclic = true;
    private int cyclicBufferSize = 5000;
    List unfilteredList;
    List filteredList;
    private boolean currentSortAscending;
    private int currentSortColumn;
    private final EventListenerList eventListenerList = new EventListenerList();
    private final List columnNames = new ArrayList(ChainsawColumns.getColumnsNames());
    private boolean sortEnabled = false;
    private boolean reachedCapacity = false;
    private final Logger logger = LogManager.getLogger((Class)(class$org$apache$log4j$chainsaw$ChainsawCyclicBufferTableModel == null ? (class$org$apache$log4j$chainsaw$ChainsawCyclicBufferTableModel = ChainsawCyclicBufferTableModel.class$("org.apache.log4j.chainsaw.ChainsawCyclicBufferTableModel")) : class$org$apache$log4j$chainsaw$ChainsawCyclicBufferTableModel));
    private final LoggerNameModel loggerNameModelDelegate = new LoggerNameModelSupport();
    private final Object mutex = new Object();
    int uniqueRow;
    private final Set uniquePropertyKeys = new HashSet();
    private Rule displayRule;
    private final PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private RuleColorizer colorizer;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$ChainsawCyclicBufferTableModel;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$EventCountListener;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$NewKeyListener;

    public ChainsawCyclicBufferTableModel(int cyclicBufferSize, RuleColorizer colorizer) {
        this.propertySupport.addPropertyChangeListener("cyclic", new ModelChanger());
        this.cyclicBufferSize = cyclicBufferSize;
        this.colorizer = colorizer;
        this.unfilteredList = new CyclicBufferList(cyclicBufferSize);
        this.filteredList = new CyclicBufferList(cyclicBufferSize);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof Rule) {
            this.reFilter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMatchingEvents(Rule rule) {
        ArrayList unfilteredCopy;
        ArrayList<LoggingEvent> list = new ArrayList<LoggingEvent>();
        Object object = this.mutex;
        synchronized (object) {
            unfilteredCopy = new ArrayList(this.unfilteredList);
        }
        Iterator iter = unfilteredCopy.iterator();
        while (iter.hasNext()) {
            LoggingEvent event = (LoggingEvent)iter.next();
            if (!rule.evaluate(event, null)) continue;
            list.add(event);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reFilter() {
        int newSize;
        int previousSize;
        Object object = this.mutex;
        synchronized (object) {
            previousSize = this.filteredList.size();
            this.filteredList.clear();
            if (this.displayRule == null) {
                Iterator iter = this.unfilteredList.iterator();
                while (iter.hasNext()) {
                    ExtendedLoggingEvent e = (ExtendedLoggingEvent)((Object)iter.next());
                    e.setDisplayed(true);
                    this.filteredList.add(e);
                }
            } else {
                Iterator iter = this.unfilteredList.iterator();
                while (iter.hasNext()) {
                    ExtendedLoggingEvent e = (ExtendedLoggingEvent)((Object)iter.next());
                    if (this.displayRule.evaluate((LoggingEvent)e, null)) {
                        e.setDisplayed(true);
                        this.filteredList.add(e);
                        continue;
                    }
                    e.setDisplayed(false);
                }
            }
            newSize = this.filteredList.size();
        }
        SwingHelper.invokeOnEDT(new Runnable(){

            public void run() {
                if (newSize > 0) {
                    if (previousSize == newSize) {
                        ChainsawCyclicBufferTableModel.this.fireTableRowsUpdated(0, newSize - 1);
                    } else if (previousSize > newSize) {
                        ChainsawCyclicBufferTableModel.this.fireTableRowsUpdated(0, newSize - 1);
                        ChainsawCyclicBufferTableModel.this.fireTableDataChanged();
                    } else if (previousSize < newSize) {
                        if (previousSize > 0) {
                            ChainsawCyclicBufferTableModel.this.fireTableRowsUpdated(0, previousSize - 1);
                        }
                        ChainsawCyclicBufferTableModel.this.fireTableRowsInserted(Math.max(0, previousSize), newSize - 1);
                    }
                } else {
                    ChainsawCyclicBufferTableModel.this.fireTableDataChanged();
                }
                ChainsawCyclicBufferTableModel.this.notifyCountListeners();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int locate(Rule rule, int startLocation, boolean searchForward) {
        ArrayList filteredListCopy;
        Object object = this.mutex;
        synchronized (object) {
            filteredListCopy = new ArrayList(this.filteredList);
        }
        if (searchForward) {
            int i;
            for (i = startLocation; i < filteredListCopy.size(); ++i) {
                if (!rule.evaluate((LoggingEvent)filteredListCopy.get(i), null)) continue;
                return i;
            }
            for (i = 0; i < startLocation; ++i) {
                if (!rule.evaluate((LoggingEvent)filteredListCopy.get(i), null)) continue;
                return i;
            }
        } else {
            int i;
            for (i = startLocation; i > -1; --i) {
                if (!rule.evaluate((LoggingEvent)filteredListCopy.get(i), null)) continue;
                return i;
            }
            for (i = filteredListCopy.size() - 1; i > startLocation; --i) {
                if (!rule.evaluate((LoggingEvent)filteredListCopy.get(i), null)) continue;
                return i;
            }
        }
        return -1;
    }

    public void removeLoggerNameListener(LoggerNameListener l) {
        this.loggerNameModelDelegate.removeLoggerNameListener(l);
    }

    public boolean addLoggerName(String loggerName) {
        return this.loggerNameModelDelegate.addLoggerName(loggerName);
    }

    public void addLoggerNameListener(LoggerNameListener l) {
        this.loggerNameModelDelegate.addLoggerNameListener(l);
    }

    public Collection getLoggerNames() {
        return this.loggerNameModelDelegate.getLoggerNames();
    }

    public void addEventCountListener(EventCountListener listener) {
        this.eventListenerList.add(class$org$apache$log4j$chainsaw$EventCountListener == null ? (class$org$apache$log4j$chainsaw$EventCountListener = ChainsawCyclicBufferTableModel.class$("org.apache.log4j.chainsaw.EventCountListener")) : class$org$apache$log4j$chainsaw$EventCountListener, listener);
    }

    public boolean isSortable(int col) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCountListeners() {
        int unfilteredListSize;
        int filteredListSize;
        EventCountListener[] listeners = (EventCountListener[])this.eventListenerList.getListeners(class$org$apache$log4j$chainsaw$EventCountListener == null ? (class$org$apache$log4j$chainsaw$EventCountListener = ChainsawCyclicBufferTableModel.class$("org.apache.log4j.chainsaw.EventCountListener")) : class$org$apache$log4j$chainsaw$EventCountListener);
        Object object = this.mutex;
        synchronized (object) {
            filteredListSize = this.filteredList.size();
            unfilteredListSize = this.unfilteredList.size();
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].eventCountChanged(filteredListSize, unfilteredListSize);
        }
    }

    public void setDisplayRule(Rule displayRule) {
        if (this.displayRule != null) {
            this.displayRule.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.displayRule = displayRule;
        if (this.displayRule != null) {
            this.displayRule.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.reFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort() {
        boolean sort;
        int filteredListSize;
        Object object = this.mutex;
        synchronized (object) {
            filteredListSize = this.filteredList.size();
            boolean bl = sort = this.sortEnabled && filteredListSize > 0;
            if (sort) {
                Iterator iter = this.filteredList.iterator();
                while (iter.hasNext()) {
                    ExtendedLoggingEvent e = (ExtendedLoggingEvent)((Object)iter.next());
                    e.setDisplayed(true);
                }
                Collections.sort(this.filteredList, new ColumnComparator(this.getColumnName(this.currentSortColumn), this.currentSortColumn, this.currentSortAscending));
            }
        }
        if (sort) {
            SwingHelper.invokeOnEDT(new Runnable(){

                public void run() {
                    ChainsawCyclicBufferTableModel.this.fireTableRowsUpdated(0, Math.max(filteredListSize - 1, 0));
                }
            });
        }
    }

    public boolean isSortEnabled() {
        return this.sortEnabled;
    }

    public void sortColumn(int col, boolean ascending) {
        this.logger.debug((Object)("request to sort col=" + col));
        this.currentSortAscending = ascending;
        this.currentSortColumn = col;
        this.sortEnabled = true;
        this.sort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearModel() {
        this.reachedCapacity = false;
        Object object = this.mutex;
        synchronized (object) {
            this.unfilteredList.clear();
            this.filteredList.clear();
            this.uniqueRow = 0;
        }
        SwingHelper.invokeOnEDT(new Runnable(){

            public void run() {
                ChainsawCyclicBufferTableModel.this.fireTableDataChanged();
            }
        });
        this.notifyCountListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllEvents() {
        Object object = this.mutex;
        synchronized (object) {
            return new ArrayList(this.unfilteredList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFilteredEvents() {
        Object object = this.mutex;
        synchronized (object) {
            return new ArrayList(this.filteredList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowIndex(LoggingEvent e) {
        Object object = this.mutex;
        synchronized (object) {
            return this.filteredList.indexOf(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyFromEvents(String propName) {
        LoggingEvent event;
        ArrayList unfilteredListCopy;
        ArrayList filteredListCopy;
        Object object = this.mutex;
        synchronized (object) {
            filteredListCopy = new ArrayList(this.filteredList);
            unfilteredListCopy = new ArrayList(this.unfilteredList);
        }
        for (int i = 0; i < filteredListCopy.size(); ++i) {
            event = (LoggingEvent)filteredListCopy.get(i);
            Object result = event.removeProperty(propName);
            if (result == null) continue;
            this.fireRowUpdated(i, false);
        }
        Iterator iter = unfilteredListCopy.iterator();
        while (iter.hasNext()) {
            event = (LoggingEvent)iter.next();
            event.removeProperty(propName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateEventsWithFindRule(Rule findRule) {
        ArrayList unfilteredListCopy;
        int count = 0;
        Object object = this.mutex;
        synchronized (object) {
            unfilteredListCopy = new ArrayList(this.unfilteredList);
        }
        Iterator iter = unfilteredListCopy.iterator();
        while (iter.hasNext()) {
            ExtendedLoggingEvent extendedLoggingEvent = (ExtendedLoggingEvent)((Object)iter.next());
            extendedLoggingEvent.evaluateSearchRule(findRule);
            if (!extendedLoggingEvent.isSearchMatch()) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findColoredRow(int startLocation, boolean searchForward) {
        ArrayList filteredListCopy;
        Object object = this.mutex;
        synchronized (object) {
            filteredListCopy = new ArrayList(this.filteredList);
        }
        if (searchForward) {
            ExtendedLoggingEvent event;
            int i;
            for (i = startLocation; i < filteredListCopy.size(); ++i) {
                event = (ExtendedLoggingEvent)((Object)filteredListCopy.get(i));
                if (event.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND) && event.getColorRuleForeground().equals(ChainsawConstants.COLOR_DEFAULT_FOREGROUND)) continue;
                return i;
            }
            for (i = 0; i < startLocation; ++i) {
                event = (ExtendedLoggingEvent)((Object)filteredListCopy.get(i));
                if (event.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND) && event.getColorRuleForeground().equals(ChainsawConstants.COLOR_DEFAULT_FOREGROUND)) continue;
                return i;
            }
        } else {
            ExtendedLoggingEvent event;
            int i;
            for (i = startLocation; i > -1; --i) {
                event = (ExtendedLoggingEvent)((Object)filteredListCopy.get(i));
                if (event.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND) && event.getColorRuleForeground().equals(ChainsawConstants.COLOR_DEFAULT_FOREGROUND)) continue;
                return i;
            }
            for (i = filteredListCopy.size() - 1; i > startLocation; --i) {
                event = (ExtendedLoggingEvent)((Object)filteredListCopy.get(i));
                if (event.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND) && event.getColorRuleForeground().equals(ChainsawConstants.COLOR_DEFAULT_FOREGROUND)) continue;
                return i;
            }
        }
        return -1;
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public String getColumnName(int column) {
        return (String)this.columnNames.get(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtendedLoggingEvent getRow(int row) {
        Object object = this.mutex;
        synchronized (object) {
            if (row < this.filteredList.size()) {
                return (ExtendedLoggingEvent)((Object)this.filteredList.get(row));
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        Object object = this.mutex;
        synchronized (object) {
            return this.filteredList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int rowIndex, int columnIndex) {
        LoggingEvent event = null;
        Object object = this.mutex;
        synchronized (object) {
            if (rowIndex < this.filteredList.size() && rowIndex > -1) {
                event = (LoggingEvent)this.filteredList.get(rowIndex);
            }
        }
        if (event == null) {
            return null;
        }
        LocationInfo info = null;
        if (event.locationInformationExists()) {
            info = event.getLocationInformation();
        }
        switch (columnIndex + 1) {
            case 13: {
                String id = event.getProperty("log4jid");
                if (id != null) {
                    return id;
                }
                return new Integer(rowIndex);
            }
            case 4: {
                return event.getLevel();
            }
            case 2: {
                return event.getProperty("log4j.marker");
            }
            case 1: {
                return event.getLoggerName();
            }
            case 3: {
                return new Date(event.getTimeStamp());
            }
            case 6: {
                return event.getRenderedMessage();
            }
            case 7: {
                return event.getNDC();
            }
            case 5: {
                return event.getThreadName();
            }
            case 8: {
                return event.getThrowableStrRep();
            }
            case 9: {
                return info == null || "?".equals(info.getClassName()) ? "" : info.getClassName();
            }
            case 11: {
                return info == null || "?".equals(info.getFileName()) ? "" : info.getFileName();
            }
            case 12: {
                return info == null || "?".equals(info.getLineNumber()) ? "" : info.getLineNumber();
            }
            case 10: {
                return info == null || "?".equals(info.getMethodName()) ? "" : info.getMethodName();
            }
        }
        if (columnIndex < this.columnNames.size()) {
            String result = event.getProperty(this.columnNames.get(columnIndex).toString());
            if (result == null) {
                String lowerColName = this.columnNames.get(columnIndex).toString().toLowerCase();
                Set entrySet = event.getProperties().entrySet();
                Iterator iter = entrySet.iterator();
                while (iter.hasNext()) {
                    Map.Entry thisEntry = iter.next();
                    if (!thisEntry.getKey().toString().toLowerCase().equals(lowerColName)) continue;
                    result = thisEntry.getValue().toString();
                }
            }
            if (result != null) {
                return result;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAddRow(ExtendedLoggingEvent e) {
        e.updateColorRuleColors(this.colorizer.getBackgroundColor(e), this.colorizer.getForegroundColor(e));
        Rule findRule = this.colorizer.getFindRule();
        if (findRule != null) {
            e.evaluateSearchRule(this.colorizer.getFindRule());
        }
        boolean rowAdded = false;
        Object id = e.getProperty("log4jid");
        if (id == null) {
            id = new Integer(++this.uniqueRow);
            e.setProperty("log4jid", id.toString());
        }
        Object object = this.mutex;
        synchronized (object) {
            CyclicBufferList bufferList;
            if (this.isCyclic() && (bufferList = (CyclicBufferList)this.unfilteredList).size() == bufferList.getMaxSize()) {
                this.reachedCapacity = true;
            }
            this.unfilteredList.add(e);
            if (this.displayRule == null || this.displayRule.evaluate((LoggingEvent)e, null)) {
                e.setDisplayed(true);
                this.filteredList.add(e);
                rowAdded = true;
            } else {
                e.setDisplayed(false);
            }
        }
        this.checkForNewColumn(e);
        return rowAdded;
    }

    private void checkForNewColumn(ExtendedLoggingEvent e) {
        boolean newColumn = this.uniquePropertyKeys.addAll(e.getPropertyKeySet());
        if (newColumn) {
            Iterator iter = e.getPropertyKeySet().iterator();
            while (iter.hasNext()) {
                String key = iter.next().toString().toUpperCase();
                if (this.columnNames.contains(key) || "log4jid".equalsIgnoreCase(key)) continue;
                this.columnNames.add(key);
                this.logger.debug((Object)("Adding col '" + key + "', columnNames=" + this.columnNames));
                this.fireNewKeyColumnAdded(new NewKeyEvent(this, this.columnNames.indexOf(key), key, e.getProperty(key)));
            }
        }
    }

    public void fireTableEvent(final int begin, final int end, final int count) {
        SwingHelper.invokeOnEDT(new Runnable(){

            public void run() {
                if (ChainsawCyclicBufferTableModel.this.cyclic) {
                    if (!ChainsawCyclicBufferTableModel.this.reachedCapacity) {
                        if (begin + count < ChainsawCyclicBufferTableModel.this.cyclicBufferSize) {
                            ChainsawCyclicBufferTableModel.this.fireTableRowsInserted(begin, end);
                        } else {
                            ChainsawCyclicBufferTableModel.this.fireTableRowsInserted(begin, ChainsawCyclicBufferTableModel.this.cyclicBufferSize - 1);
                            ChainsawCyclicBufferTableModel.this.fireTableRowsUpdated(0, ChainsawCyclicBufferTableModel.this.cyclicBufferSize - 1);
                            ChainsawCyclicBufferTableModel.this.reachedCapacity = true;
                        }
                    } else {
                        ChainsawCyclicBufferTableModel.this.fireTableRowsUpdated(0, ChainsawCyclicBufferTableModel.this.cyclicBufferSize - 1);
                    }
                } else {
                    ChainsawCyclicBufferTableModel.this.fireTableRowsInserted(begin, end);
                }
            }
        });
    }

    public void fireRowUpdated(int row, boolean checkForNewColumns) {
        ExtendedLoggingEvent event = this.getRow(row);
        if (event != null) {
            event.updateColorRuleColors(this.colorizer.getBackgroundColor(event), this.colorizer.getForegroundColor(event));
            Rule findRule = this.colorizer.getFindRule();
            if (findRule != null) {
                event.evaluateSearchRule(this.colorizer.getFindRule());
            }
            this.fireTableRowsUpdated(row, row);
            if (checkForNewColumns) {
                this.checkForNewColumn(event);
            }
        }
    }

    private void fireNewKeyColumnAdded(NewKeyEvent e) {
        NewKeyListener[] listeners = (NewKeyListener[])this.eventListenerList.getListeners(class$org$apache$log4j$chainsaw$NewKeyListener == null ? (class$org$apache$log4j$chainsaw$NewKeyListener = ChainsawCyclicBufferTableModel.class$("org.apache.log4j.chainsaw.NewKeyListener")) : class$org$apache$log4j$chainsaw$NewKeyListener);
        for (int i = 0; i < listeners.length; ++i) {
            NewKeyListener listener = listeners[i];
            listener.newKeyAdded(e);
        }
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public int getMaxSize() {
        return this.cyclicBufferSize;
    }

    public void addNewKeyListener(NewKeyListener l) {
        this.eventListenerList.add(class$org$apache$log4j$chainsaw$NewKeyListener == null ? (class$org$apache$log4j$chainsaw$NewKeyListener = ChainsawCyclicBufferTableModel.class$("org.apache.log4j.chainsaw.NewKeyListener")) : class$org$apache$log4j$chainsaw$NewKeyListener, l);
    }

    public void removeNewKeyListener(NewKeyListener l) {
        this.eventListenerList.remove(class$org$apache$log4j$chainsaw$NewKeyListener == null ? (class$org$apache$log4j$chainsaw$NewKeyListener = ChainsawCyclicBufferTableModel.class$("org.apache.log4j.chainsaw.NewKeyListener")) : class$org$apache$log4j$chainsaw$NewKeyListener, l);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex + 1) {
            case 8: {
                return true;
            }
        }
        if (this.getColumnName(columnIndex).toLowerCase().equals("log4j.marker")) {
            return true;
        }
        if (columnIndex >= this.columnNames.size()) {
            return false;
        }
        return super.isCellEditable(rowIndex, columnIndex);
    }

    public void setCyclic(boolean cyclic) {
        if (this.cyclic == cyclic) {
            return;
        }
        boolean old = this.cyclic;
        this.cyclic = cyclic;
        this.propertySupport.firePropertyChange("cyclic", old, cyclic);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(propertyName, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mutex;
        synchronized (object) {
            return this.unfilteredList.size();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ModelChanger
    implements PropertyChangeListener {
        private ModelChanger() {
        }

        public void propertyChange(PropertyChangeEvent arg0) {
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ProgressMonitor monitor = null;
                    int index = 0;
                    try {
                        Object object = ChainsawCyclicBufferTableModel.this.mutex;
                        synchronized (object) {
                            monitor = new ProgressMonitor(null, "Switching models...", "Transferring between data structures, please wait...", 0, ((ModelChanger)ModelChanger.this).ChainsawCyclicBufferTableModel.this.unfilteredList.size() + 1);
                            monitor.setMillisToDecideToPopup(250);
                            monitor.setMillisToPopup(100);
                            ChainsawCyclicBufferTableModel.this.logger.debug((Object)("Changing Model, isCyclic is now " + ChainsawCyclicBufferTableModel.this.isCyclic()));
                            AbstractList newUnfilteredList = null;
                            AbstractList newFilteredList = null;
                            if (ChainsawCyclicBufferTableModel.this.isCyclic()) {
                                newUnfilteredList = new CyclicBufferList(ChainsawCyclicBufferTableModel.this.cyclicBufferSize);
                                newFilteredList = new CyclicBufferList(ChainsawCyclicBufferTableModel.this.cyclicBufferSize);
                            } else {
                                newUnfilteredList = new ArrayList(ChainsawCyclicBufferTableModel.this.cyclicBufferSize);
                                newFilteredList = new ArrayList(ChainsawCyclicBufferTableModel.this.cyclicBufferSize);
                            }
                            boolean increment = false;
                            Iterator iter = ((ModelChanger)ModelChanger.this).ChainsawCyclicBufferTableModel.this.unfilteredList.iterator();
                            while (iter.hasNext()) {
                                LoggingEvent e = (LoggingEvent)iter.next();
                                newUnfilteredList.add(e);
                                String o = e.getProperty(e.getProperty("log4jid"));
                                monitor.setProgress(index++);
                            }
                            ((ModelChanger)ModelChanger.this).ChainsawCyclicBufferTableModel.this.unfilteredList = newUnfilteredList;
                            ((ModelChanger)ModelChanger.this).ChainsawCyclicBufferTableModel.this.filteredList = newFilteredList;
                        }
                        monitor.setNote("Refiltering...");
                        ChainsawCyclicBufferTableModel.this.reFilter();
                        monitor.setProgress(index++);
                    }
                    finally {
                        monitor.close();
                    }
                    ChainsawCyclicBufferTableModel.this.logger.debug((Object)"Model Change completed");
                }
            });
            thread.setPriority(2);
            thread.start();
        }
    }
}

