/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.text.JTextComponent;
import org.apache.log4j.chainsaw.filter.FilterModel;
import org.apache.log4j.rule.RuleFactory;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class ExpressionRuleContext
extends KeyAdapter {
    RuleFactory factory = RuleFactory.getInstance();
    LoggingEventFieldResolver resolver = LoggingEventFieldResolver.getInstance();
    JPopupMenu contextMenu = new JPopupMenu();
    JList list = new JList();
    FilterModel filterModel;
    JScrollPane scrollPane = new JScrollPane(this.list);
    final JTextComponent textComponent;
    private DefaultListModel fieldModel = new DefaultListModel();
    private DefaultListModel operatorModel = new DefaultListModel();

    public ExpressionRuleContext(FilterModel filterModel, JTextComponent textComponent) {
        this.filterModel = filterModel;
        this.textComponent = textComponent;
        this.fieldModel.addElement("LOGGER");
        this.fieldModel.addElement("LEVEL");
        this.fieldModel.addElement("CLASS");
        this.fieldModel.addElement("FILE");
        this.fieldModel.addElement("LINE");
        this.fieldModel.addElement("METHOD");
        this.fieldModel.addElement("MSG");
        this.fieldModel.addElement("NDC");
        this.fieldModel.addElement("EXCEPTION");
        this.fieldModel.addElement("TIMESTAMP");
        this.fieldModel.addElement("THREAD");
        this.fieldModel.addElement("PROP.");
        this.operatorModel.addElement("&&");
        this.operatorModel.addElement("||");
        this.operatorModel.addElement("!");
        this.operatorModel.addElement("!=");
        this.operatorModel.addElement("==");
        this.operatorModel.addElement("~=");
        this.operatorModel.addElement("LIKE");
        this.operatorModel.addElement("EXISTS");
        this.operatorModel.addElement("<");
        this.operatorModel.addElement(">");
        this.operatorModel.addElement("<=");
        this.operatorModel.addElement(">=");
        this.list.setVisibleRowCount(13);
        PopupListener popupListener = new PopupListener();
        textComponent.addMouseListener(popupListener);
        this.list.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    String value = ExpressionRuleContext.this.list.getSelectedValue().toString();
                    String contextKey = ExpressionRuleContext.this.getContextKey();
                    if (contextKey != null && !contextKey.endsWith(".")) {
                        value = "'" + value + "'";
                    }
                    ExpressionRuleContext.this.updateField(value);
                    ExpressionRuleContext.this.contextMenu.setVisible(false);
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    String value = ExpressionRuleContext.this.list.getSelectedValue().toString();
                    String contextKey = ExpressionRuleContext.this.getContextKey();
                    if (contextKey != null && !contextKey.endsWith(".")) {
                        value = "'" + value + "'";
                    }
                    ExpressionRuleContext.this.updateField(value);
                    ExpressionRuleContext.this.contextMenu.setVisible(false);
                }
            }
        });
        this.contextMenu.insert(this.scrollPane, 0);
    }

    private void updateField(String value) {
        if (this.textComponent.getSelectedText() == null && !value.endsWith(".")) {
            value = value + " ";
        }
        this.textComponent.replaceSelection(value);
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32 && e.getModifiers() == 2) {
            this.displayContext();
        }
    }

    public void displayContext() {
        String lastField = this.getContextKey();
        if (lastField != null) {
            ListModel model = this.filterModel.getContainer().getModel(lastField);
            if (model == null) {
                return;
            }
            this.list.setModel(model);
            this.list.setSelectedIndex(0);
            Point p = this.textComponent.getCaret().getMagicCaretPosition();
            this.contextMenu.doLayout();
            this.contextMenu.show(this.textComponent, p.x, p.y + (this.textComponent.getHeight() - 5));
            this.list.requestFocus();
        } else if (this.isOperatorContextValid()) {
            this.list.setModel(this.operatorModel);
            this.list.setSelectedIndex(0);
            Point p = this.textComponent.getCaret().getMagicCaretPosition();
            this.contextMenu.doLayout();
            this.contextMenu.show(this.textComponent, p.x, p.y + (this.textComponent.getHeight() - 5));
            this.list.requestFocus();
        } else if (this.isFieldContextValid()) {
            this.list.setModel(this.fieldModel);
            this.list.setSelectedIndex(0);
            Point p = this.textComponent.getCaret().getMagicCaretPosition();
            if (p == null) {
                p = new Point(this.textComponent.getLocation().x, this.textComponent.getLocation().y - this.textComponent.getHeight() + 5);
            }
            this.contextMenu.doLayout();
            this.contextMenu.show(this.textComponent, p.x, p.y + (this.textComponent.getHeight() - 5));
            this.list.requestFocus();
        }
    }

    private boolean isFieldContextValid() {
        String text = this.textComponent.getText();
        int currentPosition = this.textComponent.getSelectionStart();
        return currentPosition == 0 || text.charAt(currentPosition - 1) == ' ';
    }

    private String getContextKey() {
        String field = this.getField();
        if (field == null) {
            field = this.getSubField();
        }
        return field;
    }

    private boolean isOperatorContextValid() {
        String text = this.textComponent.getText();
        int currentPosition = this.textComponent.getSelectionStart();
        if (currentPosition < 1 || text.charAt(currentPosition - 1) != ' ') {
            return false;
        }
        int lastFieldPosition = text.lastIndexOf(" ", currentPosition - 1);
        if (lastFieldPosition == -1) {
            return false;
        }
        int lastFieldStartPosition = Math.max(0, text.lastIndexOf(" ", lastFieldPosition - 1));
        String field = text.substring(lastFieldStartPosition, lastFieldPosition).toUpperCase().trim();
        return this.resolver.isField(field);
    }

    private String getField() {
        String text = this.textComponent.getText();
        int currentPosition = this.textComponent.getSelectionStart();
        if (currentPosition < 1 || text.charAt(currentPosition - 1) != ' ') {
            return null;
        }
        int symbolPosition = text.lastIndexOf(" ", currentPosition - 1);
        if (symbolPosition < 0) {
            return null;
        }
        int lastFieldPosition = text.lastIndexOf(" ", symbolPosition - 1);
        if (lastFieldPosition < 0) {
            return null;
        }
        int lastFieldStartPosition = Math.max(0, text.lastIndexOf(" ", lastFieldPosition - 1));
        String lastSymbol = text.substring(lastFieldPosition + 1, symbolPosition).trim();
        String lastField = text.substring(lastFieldStartPosition, lastFieldPosition).trim();
        if (this.factory.isRule(lastSymbol) && this.filterModel.getContainer().modelExists(lastField)) {
            return lastField;
        }
        return null;
    }

    private String getSubField() {
        int currentPosition = this.textComponent.getSelectionStart();
        String text = this.textComponent.getText();
        if (text.substring(0, currentPosition).toUpperCase().endsWith("PROP.")) {
            return "PROP.";
        }
        return null;
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                ExpressionRuleContext.this.displayContext();
            }
        }
    }
}

