/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.ChainsawAppenderHandler;
import org.apache.log4j.chainsaw.LogUI;
import org.apache.log4j.chainsaw.prefs.MRUFileList;
import org.apache.log4j.spi.Decoder;
import org.apache.log4j.spi.LoggingEvent;

class FileLoadAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger((Class)(class$org$apache$log4j$chainsaw$FileLoadAction == null ? (class$org$apache$log4j$chainsaw$FileLoadAction = FileLoadAction.class$("org.apache.log4j.chainsaw.FileLoadAction")) : class$org$apache$log4j$chainsaw$FileLoadAction));
    Decoder decoder = null;
    private LogUI parent;
    private JFileChooser chooser = null;
    private boolean remoteURL = false;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$FileLoadAction;

    public FileLoadAction(LogUI parent, Decoder decoder, String title, boolean isRemoteURL) {
        super(title);
        this.remoteURL = isRemoteURL;
        this.decoder = decoder;
        this.parent = parent;
    }

    public void actionPerformed(ActionEvent e) {
        String name = "";
        URL url = null;
        if (!this.remoteURL) {
            int i;
            if (this.chooser == null) {
                this.chooser = new JFileChooser();
                this.chooser.setDialogTitle("Load Events from XML file...");
                this.chooser.setAcceptAllFileFilterUsed(true);
                this.chooser.setFileFilter(new FileFilter(){

                    public boolean accept(File f) {
                        return f.getName().toLowerCase().endsWith(".xml") || f.getName().toLowerCase().endsWith(".zip") || f.isDirectory();
                    }

                    public String getDescription() {
                        return "XML files (*.xml), ZIP files (*.zip)";
                    }
                });
            }
            if ((i = this.chooser.showOpenDialog(this.parent)) != 0) {
                return;
            }
            File selectedFile = this.chooser.getSelectedFile();
            try {
                url = selectedFile.toURI().toURL();
                name = selectedFile.getName();
            }
            catch (Exception ex) {}
        } else {
            String urltext = JOptionPane.showInputDialog(this.parent, (Object)"<html>Please type in the <b>complete</b> URL to the remote XML source.</html>");
            if (urltext != null) {
                try {
                    url = new URL(urltext);
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this.parent, "'" + urltext + "' is not a valid URL.");
                }
            }
        }
        if (url != null) {
            FileLoadAction.importURL(this.parent.handler, this.decoder, name, url);
            MRUFileList.log4jMRU().opened(url);
        }
    }

    public static void importURL(final ChainsawAppenderHandler handler, final Decoder decoder, String name, URL url) {
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        additionalProperties.put("hostname", "file");
        additionalProperties.put("application", name);
        decoder.setAdditionalProperties(additionalProperties);
        final URL urlToUse = url;
        new Thread(new Runnable(){

            public void run() {
                try {
                    Vector events = decoder.decode(urlToUse);
                    Iterator iter = ((AbstractList)events).iterator();
                    while (iter.hasNext()) {
                        handler.append((LoggingEvent)iter.next());
                    }
                }
                catch (IOException e1) {
                    LOG.error((Object)e1);
                }
                MRUFileList.log4jMRU().opened(urlToUse);
            }
        }).start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

