/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import org.apache.log4j.chainsaw.LogUI;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.xml.XMLLayout;

class FileSaveAction
extends AbstractAction {
    private LogUI parent;
    private JFileChooser chooser = null;

    public FileSaveAction(LogUI parent) {
        super("\u8868\u793a\u3055\u308c\u3066\u3044\u308b\u30a4\u30d9\u30f3\u30c8\u3092\u4fdd\u5b58...");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
        this.putValue("MnemonicKey", new Integer(83));
        this.putValue("ShortDescription", "\u73fe\u5728\u30bf\u30d6\u306b\u8868\u793a\u3055\u308c\u3066\u3044\u308b\u30a4\u30d9\u30f3\u30c8\u3092\u4fdd\u5b58\u3059\u308b");
        this.putValue("SmallIcon", new ImageIcon(ChainsawIcons.FILE_SAVE_AS));
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        if (this.chooser == null) {
            this.chooser = new JFileChooser();
        }
        this.chooser.setAcceptAllFileFilterUsed(true);
        this.chooser.setDialogTitle("\u8868\u793a\u3055\u308c\u3066\u3044\u308b\u30a4\u30d9\u30f3\u30c8\u3092\u4fdd\u5b58(XML\u53c8\u306f.zipped XML)...");
        this.chooser.showSaveDialog(this.parent);
        File selectedFile = this.chooser.getSelectedFile();
        if (selectedFile != null) {
            List v = this.parent.getCurrentLogPanel().getFilteredEvents();
            if (v != null && v.size() == 0 || v == null) {
                return;
            }
            XMLLayout layout = new XMLLayout();
            layout.setProperties(true);
            boolean saveAsZip = selectedFile.getName().toLowerCase().endsWith(".zip");
            Writer writer = null;
            try {
                if (saveAsZip) {
                    ZipOutputStream zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(selectedFile)));
                    ZipEntry entry = new ZipEntry(selectedFile.getName().substring(0, selectedFile.getName().length() - ".zip".length()) + ".xml");
                    zipOutput.putNextEntry(entry);
                    writer = new OutputStreamWriter(zipOutput);
                } else {
                    writer = new BufferedWriter(new FileWriter(selectedFile));
                }
                Iterator iter = v.iterator();
                while (iter.hasNext()) {
                    LoggingEvent event = (LoggingEvent)iter.next();
                    layout.setLocationInfo(event.getThrowableInformation() != null);
                    writer.write(layout.format(event));
                }
            }
            catch (IOException ioe) {
                LogLog.warn((String)"\u30d5\u30a1\u30a4\u30eb\u306f\u4fdd\u5b58\u3067\u304d\u307e\u305b\u3093", (Throwable)ioe);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.flush();
                        writer.close();
                    }
                    catch (IOException e1) {}
                }
            }
        }
    }
}

