/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.apache.log4j.chainsaw.SortHeaderRenderer;
import org.apache.log4j.chainsaw.SortTableModel;
import org.apache.log4j.chainsaw.helper.SwingHelper;

public class JSortTable
extends JTable
implements MouseListener {
    protected int sortedColumnIndex = -1;
    protected boolean sortedColumnAscending = true;
    private String sortedColumn;

    public JSortTable() {
        this.initSortHeader();
    }

    public JSortTable(SortTableModel model) {
        super(model);
        this.initSortHeader();
    }

    public JSortTable(SortTableModel model, TableColumnModel colModel) {
        super(model, colModel);
        this.initSortHeader();
    }

    public JSortTable(SortTableModel model, TableColumnModel colModel, ListSelectionModel selModel) {
        super(model, colModel, selModel);
        this.initSortHeader();
    }

    protected void initSortHeader() {
        JTableHeader header = this.getTableHeader();
        header.setDefaultRenderer(new SortHeaderRenderer());
        header.addMouseListener(this);
    }

    public int getSortedColumnIndex() {
        return this.sortedColumnIndex;
    }

    public void updateSortedColumn() {
        if (this.sortedColumn != null) {
            try {
                this.sortedColumnIndex = this.columnModel.getColumnIndex(this.sortedColumn);
                this.getTableHeader().resizeAndRepaint();
            }
            catch (IllegalArgumentException ie) {
                this.setSortedColumnIndex(-1);
            }
        }
    }

    public void setSortedColumnIndex(int index) {
        this.sortedColumnIndex = index;
        if (this.sortedColumnIndex > -1) {
            SortTableModel model = (SortTableModel)this.getModel();
            model.sortColumn(this.sortedColumnIndex, this.sortedColumnAscending);
        }
        this.getTableHeader().resizeAndRepaint();
    }

    public void scrollTo(final int row, final int col) {
        SwingHelper.invokeOnEDT(new Runnable(){

            public void run() {
                if (row > -1 && row < JSortTable.this.getRowCount()) {
                    try {
                        int currentRow = JSortTable.this.getSelectedRow();
                        if (row > currentRow) {
                            JSortTable.this.scrollRectToVisible(JSortTable.this.getCellRect(row + 5, col, true));
                        }
                        if (row < currentRow) {
                            JSortTable.this.scrollRectToVisible(JSortTable.this.getCellRect(row - 5, col, true));
                        }
                        JSortTable.this.scrollRectToVisible(JSortTable.this.getCellRect(row, col, true));
                        JSortTable.this.setRowSelectionInterval(row, row);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void scrollToRow(int row) {
        this.scrollTo(row, this.columnAtPoint(this.getVisibleRect().getLocation()));
    }

    public boolean isSortedColumnAscending() {
        return this.sortedColumnAscending;
    }

    public void mouseClicked(MouseEvent event) {
        if (event.getClickCount() < 2 || event.isPopupTrigger()) {
            return;
        }
        if (event.getClickCount() > 1 && (event.getModifiers() & 8) > 0) {
            return;
        }
        TableColumnModel colModel = this.getColumnModel();
        int index = colModel.getColumnIndexAtX(event.getX());
        int modelIndex = colModel.getColumn(index).getModelIndex();
        SortTableModel model = (SortTableModel)this.getModel();
        if (model.isSortable(modelIndex)) {
            if (this.sortedColumnIndex == index) {
                this.sortedColumnAscending = !this.sortedColumnAscending;
            }
            this.sortedColumnIndex = index;
            this.sortedColumn = colModel.getColumn(index).getHeaderValue().toString();
            model.sortColumn(modelIndex, this.sortedColumnAscending);
            this.getTableHeader().resizeAndRepaint();
        }
    }

    public void mousePressed(MouseEvent event) {
    }

    public void mouseReleased(MouseEvent event) {
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }
}

