/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.pattern.ClassNamePatternConverter;
import org.apache.log4j.pattern.FileLocationPatternConverter;
import org.apache.log4j.pattern.FullLocationPatternConverter;
import org.apache.log4j.pattern.LevelPatternConverter;
import org.apache.log4j.pattern.LineLocationPatternConverter;
import org.apache.log4j.pattern.LineSeparatorPatternConverter;
import org.apache.log4j.pattern.LiteralPatternConverter;
import org.apache.log4j.pattern.LoggerPatternConverter;
import org.apache.log4j.pattern.LoggingEventPatternConverter;
import org.apache.log4j.pattern.MessagePatternConverter;
import org.apache.log4j.pattern.MethodLocationPatternConverter;
import org.apache.log4j.pattern.NDCPatternConverter;
import org.apache.log4j.pattern.PatternParser;
import org.apache.log4j.pattern.PropertiesPatternConverter;
import org.apache.log4j.pattern.RelativeTimePatternConverter;
import org.apache.log4j.pattern.SequenceNumberPatternConverter;
import org.apache.log4j.pattern.ThreadPatternConverter;

public class LogFilePatternLayoutBuilder {
    public static String getLogFormatFromPatternLayout(String patternLayout) {
        String input = OptionConverter.convertSpecialChars((String)patternLayout);
        ArrayList converters = new ArrayList();
        ArrayList fields = new ArrayList();
        Map converterRegistry = null;
        PatternParser.parse((String)input, converters, fields, converterRegistry, (Map)PatternParser.getPatternLayoutRules());
        return LogFilePatternLayoutBuilder.getFormatFromConverters(converters);
    }

    private static String getFormatFromConverters(List converters) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = converters.iterator();
        while (iter.hasNext()) {
            LoggingEventPatternConverter converter = (LoggingEventPatternConverter)iter.next();
            if (converter instanceof MessagePatternConverter) {
                buffer.append("MESSAGE");
                continue;
            }
            if (converter instanceof LoggerPatternConverter) {
                buffer.append("LOGGER");
                continue;
            }
            if (converter instanceof ClassNamePatternConverter) {
                buffer.append("CLASS");
                continue;
            }
            if (converter instanceof RelativeTimePatternConverter) {
                buffer.append("PROP(RELATIVETIME)");
                continue;
            }
            if (converter instanceof ThreadPatternConverter) {
                buffer.append("THREAD");
                continue;
            }
            if (converter instanceof NDCPatternConverter) {
                buffer.append("NDC");
                continue;
            }
            if (converter instanceof LiteralPatternConverter) {
                LiteralPatternConverter literal = (LiteralPatternConverter)converter;
                literal.format(null, buffer);
                continue;
            }
            if (converter instanceof SequenceNumberPatternConverter) {
                buffer.append("PROP(log4jid)");
                continue;
            }
            if (converter instanceof LevelPatternConverter) {
                buffer.append("LEVEL");
                continue;
            }
            if (converter instanceof MethodLocationPatternConverter) {
                buffer.append("METHOD");
                continue;
            }
            if (converter instanceof FullLocationPatternConverter) {
                buffer.append("PROP(locationInfo)");
                continue;
            }
            if (converter instanceof LineLocationPatternConverter) {
                buffer.append("LINE");
                continue;
            }
            if (converter instanceof FileLocationPatternConverter) {
                buffer.append("FILE");
                continue;
            }
            if (converter instanceof PropertiesPatternConverter) {
                PropertiesPatternConverter propertiesConverter = (PropertiesPatternConverter)converter;
                buffer.append("PROP(PROPERTIES)");
                continue;
            }
            if (!(converter instanceof LineSeparatorPatternConverter)) continue;
        }
        return buffer.toString();
    }
}

