/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.LoggerRepositoryExImpl;
import org.apache.log4j.chainsaw.ApplicationPreferenceModel;
import org.apache.log4j.chainsaw.ApplicationPreferenceModelPanel;
import org.apache.log4j.chainsaw.ApplicationPreferenceModelSaver;
import org.apache.log4j.chainsaw.ChainsawAbout;
import org.apache.log4j.chainsaw.ChainsawAppender;
import org.apache.log4j.chainsaw.ChainsawAppenderHandler;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.ChainsawSplash;
import org.apache.log4j.chainsaw.ChainsawStatusBar;
import org.apache.log4j.chainsaw.ChainsawTabbedPane;
import org.apache.log4j.chainsaw.ChainsawToolBarAndMenus;
import org.apache.log4j.chainsaw.ChainsawViewer;
import org.apache.log4j.chainsaw.DockablePanel;
import org.apache.log4j.chainsaw.EventBatchListener;
import org.apache.log4j.chainsaw.EventCountListener;
import org.apache.log4j.chainsaw.FileLoadAction;
import org.apache.log4j.chainsaw.JTextComponentFormatter;
import org.apache.log4j.chainsaw.LogPanel;
import org.apache.log4j.chainsaw.NoReceiversWarningPanel;
import org.apache.log4j.chainsaw.PopupListener;
import org.apache.log4j.chainsaw.ProgressPanel;
import org.apache.log4j.chainsaw.ShutdownListener;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.SmallToggleButton;
import org.apache.log4j.chainsaw.WelcomePanel;
import org.apache.log4j.chainsaw.color.RuleColorizer;
import org.apache.log4j.chainsaw.dnd.FileDnDTarget;
import org.apache.log4j.chainsaw.help.HelpManager;
import org.apache.log4j.chainsaw.help.Tutorial;
import org.apache.log4j.chainsaw.helper.SwingHelper;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.icons.LineIconFactory;
import org.apache.log4j.chainsaw.messages.MessageCenter;
import org.apache.log4j.chainsaw.osx.OSXIntegration;
import org.apache.log4j.chainsaw.plugins.PluginClassLoaderFactory;
import org.apache.log4j.chainsaw.prefs.LoadSettingsEvent;
import org.apache.log4j.chainsaw.prefs.MRUFileListPreferenceSaver;
import org.apache.log4j.chainsaw.prefs.SaveSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SettingsListener;
import org.apache.log4j.chainsaw.prefs.SettingsManager;
import org.apache.log4j.chainsaw.receivers.ReceiversPanel;
import org.apache.log4j.net.SocketNodeEventListener;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.PluginEvent;
import org.apache.log4j.plugins.PluginListener;
import org.apache.log4j.plugins.PluginRegistry;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.rewrite.PropertyRewritePolicy;
import org.apache.log4j.rewrite.RewriteAppender;
import org.apache.log4j.rewrite.RewritePolicy;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.Decoder;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggerRepositoryEx;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.RepositorySelector;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.log4j.xml.XMLDecoder;

public class LogUI
extends JFrame
implements ChainsawViewer,
SettingsListener {
    private static final String MAIN_WINDOW_HEIGHT = "main.window.height";
    private static final String MAIN_WINDOW_WIDTH = "main.window.width";
    private static final String MAIN_WINDOW_Y = "main.window.y";
    private static final String MAIN_WINDOW_X = "main.window.x";
    private static ChainsawSplash splash;
    private static final double DEFAULT_MAIN_RECEIVER_SPLIT_LOCATION = 0.85;
    private final JFrame preferencesFrame = new JFrame();
    private boolean noReceiversDefined;
    private ReceiversPanel receiversPanel;
    private ChainsawTabbedPane tabbedPane;
    private JToolBar toolbar;
    private ChainsawStatusBar statusBar;
    private ApplicationPreferenceModel applicationPreferenceModel;
    private ApplicationPreferenceModelPanel applicationPreferenceModelPanel;
    private final Map tableModelMap = new HashMap();
    private final Map tableMap = new HashMap();
    private final List filterableColumns = new ArrayList();
    private final Map panelMap = new HashMap();
    ChainsawAppenderHandler handler;
    private ChainsawToolBarAndMenus tbms;
    private ChainsawAbout aboutBox;
    private final SettingsManager sm = SettingsManager.getInstance();
    private final JFrame tutorialFrame = new JFrame("Chainsaw Tutorial");
    private JSplitPane mainReceiverSplitPane;
    private double lastMainReceiverSplitLocation = 0.85;
    private final List identifierPanels = new ArrayList();
    private int dividerSize;
    private int cyclicBufferSize;
    private static Logger logger;
    private static String configurationURLAppArg;
    private boolean isGUIFullyInitialized = false;
    private Object initializationLock = new Object();
    private Action shutdownAction = null;
    private EventListenerList shutdownListenerList = new EventListenerList();
    private WelcomePanel welcomePanel;
    private static final Object repositorySelectorGuard;
    private static final LoggerRepositoryExImpl repositoryExImpl;
    private PluginRegistry pluginRegistry;
    private Map allColorizers = new HashMap();
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$ShutdownListener;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$LogUI;
    static /* synthetic */ Class class$org$apache$log4j$plugins$Receiver;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$Generator;
    static /* synthetic */ Class class$org$apache$log4j$net$SocketNodeEventListener;

    public LogUI() {
        super("Chainsaw v2 - \u30ed\u30b0\u8868\u793a");
        this.setDefaultCloseOperation(0);
        if (ChainsawIcons.WINDOW_ICON != null) {
            this.setIconImage(new ImageIcon(ChainsawIcons.WINDOW_ICON).getImage());
        }
    }

    private static final void showSplash(Frame owner) {
        splash = new ChainsawSplash(owner);
        SwingHelper.centerOnScreen(splash);
        splash.setVisible(true);
    }

    private static final void removeSplash() {
        if (splash != null) {
            splash.setVisible(false);
            splash.dispose();
        }
    }

    public void addShutdownListener(ShutdownListener l) {
        this.shutdownListenerList.add(class$org$apache$log4j$chainsaw$ShutdownListener == null ? (class$org$apache$log4j$chainsaw$ShutdownListener = LogUI.class$("org.apache.log4j.chainsaw.ShutdownListener")) : class$org$apache$log4j$chainsaw$ShutdownListener, l);
    }

    public void removeShutdownListener(ShutdownListener l) {
        this.shutdownListenerList.remove(class$org$apache$log4j$chainsaw$ShutdownListener == null ? (class$org$apache$log4j$chainsaw$ShutdownListener = LogUI.class$("org.apache.log4j.chainsaw.ShutdownListener")) : class$org$apache$log4j$chainsaw$ShutdownListener, l);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            configurationURLAppArg = args[0];
        }
        if (OSXIntegration.IS_OSX) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        LogManager.setRepositorySelector((RepositorySelector)new RepositorySelector(){

            public LoggerRepository getLoggerRepository() {
                return repositoryExImpl;
            }
        }, (Object)repositorySelectorGuard);
        final ApplicationPreferenceModel model = new ApplicationPreferenceModel();
        SettingsManager.getInstance().configure(new ApplicationPreferenceModelSaver(model));
        if (configurationURLAppArg != null) {
            model.setBypassConfigurationURL(configurationURLAppArg);
        }
        LogUI.applyLookAndFeel(model.getLookAndFeelClassName());
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                LogUI.createChainsawGUI(model, null);
            }
        });
    }

    public static void createChainsawGUI(ApplicationPreferenceModel model, Action newShutdownAction) {
        Appender nextAppender;
        if (model.isOkToRemoveSecurityManager()) {
            MessageCenter.getInstance().addMessage("User has authorised removal of Java Security Manager via preferences");
            System.setSecurityManager(null);
            Policy.setPolicy(new Policy(){

                public void refresh() {
                }

                public PermissionCollection getPermissions(CodeSource codesource) {
                    Permissions perms = new Permissions();
                    perms.add(new AllPermission());
                    return perms;
                }
            });
        }
        final LogUI logUI = new LogUI();
        logUI.applicationPreferenceModel = model;
        if (model.isShowSplash()) {
            LogUI.showSplash(logUI);
        }
        logUI.cyclicBufferSize = model.getCyclicBufferSize();
        logUI.pluginRegistry = repositoryExImpl.getPluginRegistry();
        ChainsawAppenderHandler chainsawAppenderHandler = logUI.handler = new ChainsawAppenderHandler();
        LogUI logUI2 = logUI;
        logUI2.getClass();
        chainsawAppenderHandler.addEventBatchListener(logUI2.new NewTabEventBatchReceiver());
        logUI.ensureChainsawAppenderHandlerAdded();
        logger = LogManager.getLogger((Class)(class$org$apache$log4j$chainsaw$LogUI == null ? (class$org$apache$log4j$chainsaw$LogUI = LogUI.class$("org.apache.log4j.chainsaw.LogUI")) : class$org$apache$log4j$chainsaw$LogUI));
        PropertyRewritePolicy policy = new PropertyRewritePolicy();
        policy.setProperties("hostname=chainsaw,application=log");
        RewriteAppender rewriteAppender = new RewriteAppender();
        rewriteAppender.setRewritePolicy((RewritePolicy)policy);
        Enumeration appenders = Logger.getLogger((String)"org.apache").getAllAppenders();
        if (!appenders.hasMoreElements()) {
            appenders = Logger.getRootLogger().getAllAppenders();
        }
        while (appenders.hasMoreElements()) {
            nextAppender = (Appender)appenders.nextElement();
            rewriteAppender.addAppender(nextAppender);
        }
        Logger.getLogger((String)"org.apache").removeAllAppenders();
        Logger.getLogger((String)"org.apache").addAppender((Appender)rewriteAppender);
        Logger.getLogger((String)"org.apache").setAdditivity(false);
        appenders = Logger.getLogger((String)"httpclient").getAllAppenders();
        if (!appenders.hasMoreElements()) {
            appenders = Logger.getRootLogger().getAllAppenders();
        }
        while (appenders.hasMoreElements()) {
            nextAppender = (Appender)appenders.nextElement();
            rewriteAppender.addAppender(nextAppender);
        }
        Logger.getLogger((String)"httpclient").removeAllAppenders();
        Logger.getLogger((String)"httpclient").addAppender((Appender)rewriteAppender);
        Logger.getLogger((String)"httpclient").setAdditivity(false);
        Logger.getLogger((String)"org.apache.commons.vfs.cache").setLevel(Level.INFO);
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
                logger.error((Object)("Uncaught exception in thread " + t), e);
            }
        });
        String config = configurationURLAppArg;
        if (config != null) {
            logger.info((Object)("Command-line configuration arg provided (overriding auto-configuration URL) - using: " + config));
        } else {
            config = model.getConfigurationURL();
        }
        if (config != null && !config.trim().equals("")) {
            config = config.trim();
            try {
                URL configURL = new URL(config);
                logger.info((Object)("Using '" + config + "' for auto-configuration"));
                logUI.loadConfigurationUsingPluginClassLoader(configURL);
            }
            catch (MalformedURLException e) {
                logger.error((Object)"Initial configuration - failed to convert config string to url", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)("Unable to access auto-configuration URL: " + config));
            }
        }
        model.addPropertyChangeListener("configurationURL", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String newConfiguration = evt.getNewValue().toString();
                if (newConfiguration != null && !newConfiguration.trim().equals("")) {
                    newConfiguration = newConfiguration.trim();
                    try {
                        logger.info((Object)("loading updated configuration: " + newConfiguration));
                        URL newConfigurationURL = new URL(newConfiguration);
                        logUI.loadConfigurationUsingPluginClassLoader(newConfigurationURL);
                    }
                    catch (MalformedURLException e) {
                        logger.error((Object)"Updated configuration - failed to convert config string to URL", (Throwable)e);
                    }
                }
            }
        });
        LogManager.getRootLogger().setLevel(Level.TRACE);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                logUI.activateViewer();
            }
        });
        logger.info((Object)("SecurityManager is now: " + System.getSecurityManager()));
        if (newShutdownAction != null) {
            logUI.setShutdownAction(newShutdownAction);
        } else {
            logUI.setShutdownAction(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
    }

    public void activateViewer(ChainsawAppender appender) {
        if (OSXIntegration.IS_OSX) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        LogManager.setRepositorySelector((RepositorySelector)new RepositorySelector(){

            public LoggerRepository getLoggerRepository() {
                return repositoryExImpl;
            }
        }, (Object)repositorySelectorGuard);
        LogManager.getRootLogger().setLevel(Level.TRACE);
        final ApplicationPreferenceModel model = new ApplicationPreferenceModel();
        SettingsManager.getInstance().configure(new ApplicationPreferenceModelSaver(model));
        this.cyclicBufferSize = model.getCyclicBufferSize();
        LogUI.applyLookAndFeel(model.getLookAndFeelClassName());
        this.handler = new ChainsawAppenderHandler(appender);
        this.handler.addEventBatchListener(new NewTabEventBatchReceiver());
        logger = LogManager.getLogger((Class)(class$org$apache$log4j$chainsaw$LogUI == null ? (class$org$apache$log4j$chainsaw$LogUI = LogUI.class$("org.apache.log4j.chainsaw.LogUI")) : class$org$apache$log4j$chainsaw$LogUI));
        this.setShutdownAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        this.applicationPreferenceModel = new ApplicationPreferenceModel();
        SettingsManager.getInstance().configure(new ApplicationPreferenceModelSaver(model));
        LogUI.applyLookAndFeel(model.getLookAndFeelClassName());
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                LogUI.createChainsawGUI(model, null);
                LogUI.this.getApplicationPreferenceModel().apply(model);
                LogUI.this.activateViewer();
            }
        });
    }

    private void initGUI() {
        this.setupHelpSystem();
        this.statusBar = new ChainsawStatusBar(this);
        this.setupReceiverPanel();
        this.setToolBarAndMenus(new ChainsawToolBarAndMenus(this));
        this.toolbar = this.getToolBarAndMenus().getToolbar();
        this.setJMenuBar(this.getToolBarAndMenus().getMenubar());
        this.setTabbedPane(new ChainsawTabbedPane());
        this.getSettingsManager().addSettingsListener(this.getTabbedPane());
        this.getSettingsManager().configure(this.getTabbedPane());
        FileDnDTarget dnDTarget = new FileDnDTarget(this.tabbedPane);
        dnDTarget.addPropertyChangeListener("fileList", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                final List fileList = (List)evt.getNewValue();
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        logger.debug((Object)("\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u8fbc\u307f\u4e2d: " + fileList));
                        Iterator iter = fileList.iterator();
                        while (iter.hasNext()) {
                            File file = (File)iter.next();
                            XMLDecoder decoder = new XMLDecoder();
                            try {
                                LogUI.this.getStatusBar().setMessage("\u8aad\u8fbc\u307f\u4e2d " + file.getAbsolutePath() + "...");
                                FileLoadAction.importURL((this).LogUI.this.handler, (Decoder)decoder, file.getName(), file.toURI().toURL());
                            }
                            catch (Exception e) {
                                String errorMsg = "\u30d5\u30a1\u30a4\u30eb\u306e\u30a4\u30f3\u30dd\u30fc\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f";
                                logger.error((Object)errorMsg, (Throwable)e);
                                LogUI.this.getStatusBar().setMessage(errorMsg);
                            }
                        }
                    }
                });
                thread.setPriority(1);
                thread.start();
            }
        });
        this.applicationPreferenceModelPanel = new ApplicationPreferenceModelPanel(this.applicationPreferenceModel);
        this.applicationPreferenceModelPanel.setOkCancelActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogUI.this.preferencesFrame.setVisible(false);
            }
        });
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction closeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LogUI.this.preferencesFrame.setVisible(false);
            }
        };
        this.preferencesFrame.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.preferencesFrame.getRootPane().getActionMap().put("ESCAPE", closeAction);
        OSXIntegration.init(this);
    }

    private void initPlugins(PluginRegistry pluginRegistry) {
        pluginRegistry.addPluginListener(new PluginListener(){

            public void pluginStarted(PluginEvent e) {
                if (e.getPlugin() instanceof JComponent) {
                    JComponent plugin = (JComponent)e.getPlugin();
                    LogUI.this.getTabbedPane().addANewTab(plugin.getName(), plugin, null, null);
                    LogUI.this.getPanelMap().put(plugin.getName(), plugin);
                }
            }

            public void pluginStopped(PluginEvent e) {
            }
        });
        try {
            Class<?> pluginClass = Class.forName("org.apache.log4j.chainsaw.zeroconf.ZeroConfPlugin");
            Plugin plugin = (Plugin)pluginClass.newInstance();
            pluginRegistry.addPlugin(plugin);
            plugin.activateOptions();
            MessageCenter.getInstance().getLogger().info((Object)"ZeroConf\u304c\u5229\u7528\u53ef\u80fd\u306e\u3088\u3046\u3067\u3059... WooHoo!");
        }
        catch (Throwable e) {
            MessageCenter.getInstance().getLogger().error((Object)"ZeroConf\u304c\u5229\u7528\u53ef\u80fd\u3067\u306a\u3044\u3088\u3046\u3067\u3059", e);
        }
    }

    private void setupReceiverPanel() {
        this.receiversPanel = new ReceiversPanel();
        this.receiversPanel.addPropertyChangeListener("visible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                MessageCenter.getInstance().getLogger().debug((Object)("\u30ec\u30b7\u30fc\u30d0\u30fc\u30d1\u30cd\u30eb:" + evt.getNewValue()));
                LogUI.this.getApplicationPreferenceModel().setReceivers((Boolean)evt.getNewValue());
            }
        });
    }

    private void setupHelpSystem() {
        this.welcomePanel = new WelcomePanel();
        JToolBar tb = this.welcomePanel.getToolbar();
        tb.add(new SmallButton(new AbstractAction("\u30c1\u30e5\u30fc\u30c8\u30ea\u30a2\u30eb", new ImageIcon(ChainsawIcons.HELP)){

            public void actionPerformed(ActionEvent e) {
                LogUI.this.setupTutorial();
            }
        }));
        tb.addSeparator();
        AbstractAction exampleConfigAction = new AbstractAction("\u30ec\u30b7\u30fc\u30d0\u8a2d\u5b9a\u306e\u4f8b\u3092\u8868\u793a"){

            public void actionPerformed(ActionEvent e) {
                HelpManager.getInstance().setHelpURL(ChainsawConstants.EXAMPLE_CONFIG_URL);
            }
        };
        exampleConfigAction.putValue("ShortDescription", "\u8907\u6570\u306e\u30ec\u30b7\u30fc\u30d0\u30fc\u304c\u8a2d\u5b9a\u3055\u308c\u305fLog4j\u8a2d\u5b9a\u306e\u4f8b\u3092\u8868\u793a\u3059\u308b\u3002");
        SmallButton exampleButton = new SmallButton(exampleConfigAction);
        tb.add(exampleButton);
        tb.add(Box.createHorizontalGlue());
        HelpManager.getInstance().addPropertyChangeListener("helpURL", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                URL newURL = (URL)evt.getNewValue();
                if (newURL != null) {
                    LogUI.this.welcomePanel.setURL(newURL);
                    LogUI.this.ensureWelcomePanelVisible();
                }
            }
        });
    }

    private void ensureWelcomePanelVisible() {
        if (!this.getTabbedPane().containsWelcomePanel()) {
            this.addWelcomePanel();
        }
        this.getTabbedPane().setSelectedComponent(this.welcomePanel);
    }

    public void loadSettings(LoadSettingsEvent event) {
        ((Component)this).setLocation(event.asInt(MAIN_WINDOW_X), event.asInt(MAIN_WINDOW_Y));
        this.setSize(event.asInt(MAIN_WINDOW_WIDTH), event.asInt(MAIN_WINDOW_HEIGHT));
        this.getToolBarAndMenus().stateChange();
        RuleColorizer colorizer = new RuleColorizer();
        colorizer.loadColorSettings("\u30c7\u30d5\u30a9\u30eb\u30c8");
        this.allColorizers.put("\u30c7\u30d5\u30a9\u30eb\u30c8", colorizer);
    }

    public void saveSettings(SaveSettingsEvent event) {
        event.saveSetting(MAIN_WINDOW_X, (int)this.getLocation().getX());
        event.saveSetting(MAIN_WINDOW_Y, (int)this.getLocation().getY());
        event.saveSetting(MAIN_WINDOW_WIDTH, this.getWidth());
        event.saveSetting(MAIN_WINDOW_HEIGHT, this.getHeight());
        RuleColorizer colorizer = (RuleColorizer)this.allColorizers.get("\u30c7\u30d5\u30a9\u30eb\u30c8");
        colorizer.saveColorSettings("\u30c7\u30d5\u30a9\u30eb\u30c8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateViewer() {
        LoggerRepository repo = LogManager.getLoggerRepository();
        if (repo instanceof LoggerRepositoryEx) {
            this.pluginRegistry = ((LoggerRepositoryEx)repo).getPluginRegistry();
        }
        this.initGUI();
        this.initPrefModelListeners();
        MessageCenter.getInstance().getLogger().addAppender((Appender)new AppenderSkeleton(){

            protected void append(LoggingEvent event) {
                LogUI.this.getStatusBar().setMessage(event.getMessage().toString());
            }

            public void close() {
            }

            public boolean requiresLayout() {
                return false;
            }
        });
        this.initSocketConnectionListener();
        if (this.pluginRegistry.getPlugins(class$org$apache$log4j$plugins$Receiver == null ? (class$org$apache$log4j$plugins$Receiver = LogUI.class$("org.apache.log4j.plugins.Receiver")) : class$org$apache$log4j$plugins$Receiver).size() == 0) {
            this.noReceiversDefined = true;
        }
        this.getFilterableColumns().add("\u30ec\u30d9\u30eb");
        this.getFilterableColumns().add("\u30ed\u30b0");
        this.getFilterableColumns().add("\u30b9\u30ec\u30c3\u30c9");
        this.getFilterableColumns().add("NDC");
        this.getFilterableColumns().add("\u30d7\u30ed\u30d1\u30c6\u30a3");
        this.getFilterableColumns().add("\u30af\u30e9\u30b9");
        this.getFilterableColumns().add("\u30e1\u30bd\u30c3\u30c9");
        this.getFilterableColumns().add("\u30d5\u30a1\u30a4\u30eb");
        this.getFilterableColumns().add("\u306a\u3057");
        JPanel panePanel = new JPanel();
        panePanel.setLayout(new BorderLayout(2, 2));
        this.getContentPane().setLayout(new BorderLayout());
        this.getTabbedPane().addChangeListener(this.getToolBarAndMenus());
        this.getTabbedPane().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LogPanel thisLogPanel = LogUI.this.getCurrentLogPanel();
                if (thisLogPanel != null) {
                    thisLogPanel.updateStatusBar();
                }
            }
        });
        KeyStroke ksRight = KeyStroke.getKeyStroke(39, 2);
        KeyStroke ksLeft = KeyStroke.getKeyStroke(37, 2);
        KeyStroke ksGotoLine = KeyStroke.getKeyStroke(71, 2);
        this.getTabbedPane().getInputMap(2).put(ksRight, "MoveRight");
        this.getTabbedPane().getInputMap(2).put(ksLeft, "MoveLeft");
        this.getTabbedPane().getInputMap(2).put(ksGotoLine, "GotoLine");
        AbstractAction moveRight = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int temp = LogUI.this.getTabbedPane().getSelectedIndex();
                if (++temp != LogUI.this.getTabbedPane().getTabCount()) {
                    LogUI.this.getTabbedPane().setSelectedTab(temp);
                }
            }
        };
        AbstractAction moveLeft = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                int temp = LogUI.this.getTabbedPane().getSelectedIndex();
                if (--temp > -1) {
                    LogUI.this.getTabbedPane().setSelectedTab(temp);
                }
            }
        };
        AbstractAction gotoLine = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String inputLine = JOptionPane.showInputDialog(LogUI.this, "\u79fb\u52d5\u5148\u306e\u884c\u756a\u53f7\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\uff1a", "\u884c\u306b\u79fb\u52d5", -1);
                try {
                    int lineNumber = Integer.parseInt(inputLine);
                    int row = LogUI.this.getCurrentLogPanel().setSelectedEvent(lineNumber);
                    if (row == -1) {
                        JOptionPane.showMessageDialog(LogUI.this, "\u884c\u756a\u53f7\u304c\u4e0d\u6b63\u3067\u3059", "\u30a8\u30e9\u30fc", 0);
                    }
                }
                catch (NumberFormatException nfe) {
                    JOptionPane.showMessageDialog(LogUI.this, "\u884c\u756a\u53f7\u304c\u4e0d\u6b63\u3067\u3059", "\u30a8\u30e9\u30fc", 0);
                }
            }
        };
        this.getTabbedPane().getActionMap().put("MoveRight", moveRight);
        this.getTabbedPane().getActionMap().put("MoveLeft", moveLeft);
        this.getTabbedPane().getActionMap().put("GotoLine", gotoLine);
        this.getTabbedPane().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                LogPanel logPanel;
                int tabIndex;
                super.mouseClicked(e);
                if (e.getClickCount() > 1 && (e.getModifiers() & 0x10) > 0 && (tabIndex = LogUI.this.getTabbedPane().getSelectedIndex()) != -1 && tabIndex == LogUI.this.getTabbedPane().getSelectedIndex() && (logPanel = LogUI.this.getCurrentLogPanel()) != null) {
                    logPanel.undock();
                }
            }
        });
        panePanel.add(this.getTabbedPane());
        this.addWelcomePanel();
        this.getContentPane().add((Component)this.toolbar, "North");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.mainReceiverSplitPane = new JSplitPane(1, panePanel, this.receiversPanel);
        this.dividerSize = this.mainReceiverSplitPane.getDividerSize();
        this.mainReceiverSplitPane.setDividerLocation(-1);
        this.getContentPane().add((Component)this.mainReceiverSplitPane, "Center");
        this.initPlugins(this.pluginRegistry);
        this.mainReceiverSplitPane.setResizeWeight(1.0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                LogUI.this.exit();
            }
        });
        this.preferencesFrame.setTitle("'\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u5168\u822c\u306e\u8a2d\u5b9a");
        this.preferencesFrame.setIconImage(((ImageIcon)ChainsawIcons.ICON_PREFERENCES).getImage());
        this.preferencesFrame.getContentPane().add(this.applicationPreferenceModelPanel);
        this.preferencesFrame.setSize(750, 520);
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this.preferencesFrame).setLocation(new Point(screenDimension.width / 2 - this.preferencesFrame.getSize().width / 2, screenDimension.height / 2 - this.preferencesFrame.getSize().height / 2));
        this.pack();
        JPopupMenu tabPopup = new JPopupMenu();
        AbstractAction hideCurrentTabAction = new AbstractAction("\u96a0\u3059"){

            public void actionPerformed(ActionEvent e) {
                Component selectedComp = LogUI.this.getTabbedPane().getSelectedComponent();
                if (selectedComp instanceof LogPanel) {
                    LogUI.this.displayPanel(LogUI.this.getCurrentLogPanel().getIdentifier(), false);
                    LogUI.this.tbms.stateChange();
                } else {
                    LogUI.this.getTabbedPane().remove(selectedComp);
                }
            }
        };
        AbstractAction hideOtherTabsAction = new AbstractAction("\u305d\u306e\u4ed6\u3092\u96a0\u3059"){

            public void actionPerformed(ActionEvent e) {
                Component selectedComp = LogUI.this.getTabbedPane().getSelectedComponent();
                String currentName = selectedComp instanceof LogPanel ? LogUI.this.getCurrentLogPanel().getIdentifier() : (selectedComp instanceof WelcomePanel ? "\u306f\u3058\u3081\u306b" : "Zeroconf");
                int count = LogUI.this.getTabbedPane().getTabCount();
                int index = 0;
                for (int i = 0; i < count; ++i) {
                    String name = LogUI.this.getTabbedPane().getTitleAt(index);
                    if (LogUI.this.getPanelMap().keySet().contains(name) && !name.equals(currentName)) {
                        LogUI.this.displayPanel(name, false);
                        LogUI.this.tbms.stateChange();
                        continue;
                    }
                    ++index;
                }
            }
        };
        AbstractAction showHiddenTabsAction = new AbstractAction("\u3059\u3079\u3066\u306e\u96a0\u3057\u9805\u76ee\u3092\u8868\u793a"){

            public void actionPerformed(ActionEvent e) {
                Iterator iter = LogUI.this.getPanels().entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    Boolean docked = (Boolean)entry.getValue();
                    if (!docked.booleanValue()) continue;
                    String identifier = (String)entry.getKey();
                    int count = LogUI.this.getTabbedPane().getTabCount();
                    boolean found = false;
                    for (int i = 0; i < count; ++i) {
                        String name = LogUI.this.getTabbedPane().getTitleAt(i);
                        if (!name.equals(identifier)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    LogUI.this.displayPanel(identifier, true);
                    LogUI.this.tbms.stateChange();
                }
            }
        };
        tabPopup.add(hideCurrentTabAction);
        tabPopup.add(hideOtherTabsAction);
        tabPopup.addSeparator();
        tabPopup.add(showHiddenTabsAction);
        PopupListener tabPopupListener = new PopupListener(tabPopup);
        this.getTabbedPane().addMouseListener(tabPopupListener);
        this.handler.addPropertyChangeListener("dataRate", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                double dataRate = (Double)evt.getNewValue();
                LogUI.this.statusBar.setDataRate(dataRate);
            }
        });
        this.getSettingsManager().addSettingsListener(this);
        this.getSettingsManager().addSettingsListener(MRUFileListPreferenceSaver.getInstance());
        this.getSettingsManager().addSettingsListener(this.receiversPanel);
        this.getSettingsManager().loadSettings();
        this.getSettingsManager().addSettingsListener(new ApplicationPreferenceModelSaver(this.applicationPreferenceModel));
        this.setVisible(true);
        if (this.applicationPreferenceModel.isReceivers()) {
            this.showReceiverPanel();
        } else {
            this.hideReceiverPanel();
        }
        LogUI.removeSplash();
        Object object = this.initializationLock;
        synchronized (object) {
            this.isGUIFullyInitialized = true;
            this.initializationLock.notifyAll();
        }
        if (this.noReceiversDefined && this.applicationPreferenceModel.isShowNoReceiverWarning()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    LogUI.this.showNoReceiversWarningPanel();
                }
            });
        }
        Container container = this.tutorialFrame.getContentPane();
        final JEditorPane tutorialArea = new JEditorPane();
        tutorialArea.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        tutorialArea.setEditable(false);
        container.setLayout(new BorderLayout());
        try {
            tutorialArea.setPage(ChainsawConstants.TUTORIAL_URL);
            JTextComponentFormatter.applySystemFontAndSize(tutorialArea);
            container.add((Component)new JScrollPane(tutorialArea), "Center");
        }
        catch (Exception e) {
            MessageCenter.getInstance().getLogger().error((Object)"\u30c1\u30e5\u30fc\u30c8\u30ea\u30a2\u30eb\u306e\u8aad\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", (Throwable)e);
        }
        this.tutorialFrame.setIconImage(new ImageIcon(ChainsawIcons.HELP).getImage());
        this.tutorialFrame.setSize(new Dimension(640, 480));
        final AbstractAction startTutorial = new AbstractAction("\u30c1\u30e5\u30fc\u30c8\u30ea\u30a2\u30eb\u3092\u59cb\u3081\u308b", new ImageIcon(ChainsawIcons.ICON_RESUME_RECEIVER)){

            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(null, "\u30c1\u30e5\u30fc\u30c8\u30ea\u30a2\u30eb\u7528\u306b\uff13\u3064\u306e\u30b8\u30a7\u30cd\u30ec\u30fc\u30bf\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u8d77\u52d5\u3057\u307e\u3059\u3002\u7d99\u7d9a\u3057\u307e\u3059\u304b\uff1f", "\u78ba\u8a8d", 0) == 0) {
                    new Thread(new Tutorial()).start();
                    this.putValue("TutorialStarted", Boolean.TRUE);
                } else {
                    this.putValue("TutorialStarted", Boolean.FALSE);
                }
            }
        };
        final AbstractAction stopTutorial = new AbstractAction("Stop Tutorial", new ImageIcon(ChainsawIcons.ICON_STOP_RECEIVER)){

            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(null, "\u30c1\u30e5\u30fc\u30c8\u30ea\u30a2\u30eb\u7528\u306e\u3059\u3079\u3066\u306e\u30b8\u30a7\u30cd\u30ec\u30fc\u30bf\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u505c\u6b62\u3057\u307e\u3059\u304c\u3001\u305d\u306e\u4ed6\u306e\u30ea\u30b7\u30fc\u30d0\u30fc\u306f\u505c\u6b62\u3057\u307e\u305b\u3093\u3002\u7d99\u7d9a\u3057\u307e\u3059\u304b\uff1f", "\u78ba\u8a8d", 0) == 0) {
                    new Thread(new Runnable(){

                        public void run() {
                            LoggerRepository repo = LogManager.getLoggerRepository();
                            if (repo instanceof LoggerRepositoryEx) {
                                PluginRegistry pluginRegistry = ((LoggerRepositoryEx)repo).getPluginRegistry();
                                List list = pluginRegistry.getPlugins(class$org$apache$log4j$chainsaw$Generator == null ? (class$org$apache$log4j$chainsaw$Generator = LogUI.class$("org.apache.log4j.chainsaw.Generator")) : class$org$apache$log4j$chainsaw$Generator);
                                Iterator iter = list.iterator();
                                while (iter.hasNext()) {
                                    Plugin plugin = (Plugin)iter.next();
                                    pluginRegistry.stopPlugin(plugin.getName());
                                }
                            }
                        }
                    }).start();
                    this.setEnabled(false);
                    startTutorial.putValue("TutorialStarted", Boolean.FALSE);
                }
            }
        };
        stopTutorial.putValue("ShortDescription", "\u30c1\u30e5\u30fc\u30c8\u30ea\u30a2\u30eb\u7528\u306e\u30b8\u30a7\u30cd\u30ec\u30fc\u30bf\u30ec\u30b7\u30fc\u30d0\u3092\u3059\u3079\u3066\u524a\u9664\u3057\u307e\u3059\u3002\u4ed6\u306e\u30ec\u30b7\u30fc\u30d0\u30fc\u306f\u524a\u9664\u3057\u307e\u305b\u3093\u3002");
        startTutorial.putValue("ShortDescription", "\u30c1\u30e5\u30fc\u3068\u30ea\u30a2\u30b9\u3092\u958b\u59cb\u3057\u307e\u3059\u3002Chainsaw\u306e\u52d5\u4f5c\u304c\u8868\u793a\u3059\u308b\u305f\u3081\u306b\u30b8\u30a7\u30cd\u30ec\u30fc\u30bf\u30ec\u30b7\u30fc\u30d0\u3092\u8d77\u52d5\u3057\u307e\u3059\u3002");
        stopTutorial.setEnabled(false);
        final SmallToggleButton startButton = new SmallToggleButton(startTutorial);
        PropertyChangeListener pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                stopTutorial.setEnabled(((Boolean)startTutorial.getValue("TutorialStarted")).equals(Boolean.TRUE));
                startButton.setSelected(stopTutorial.isEnabled());
            }
        };
        startTutorial.addPropertyChangeListener(pcl);
        stopTutorial.addPropertyChangeListener(pcl);
        this.pluginRegistry.addPluginListener(new PluginListener(){

            public void pluginStarted(PluginEvent e) {
            }

            public void pluginStopped(PluginEvent e) {
                List list = LogUI.this.pluginRegistry.getPlugins(class$org$apache$log4j$chainsaw$Generator == null ? (class$org$apache$log4j$chainsaw$Generator = LogUI.class$("org.apache.log4j.chainsaw.Generator")) : class$org$apache$log4j$chainsaw$Generator);
                if (list.size() == 0) {
                    startTutorial.putValue("TutorialStarted", Boolean.FALSE);
                }
            }
        });
        SmallButton stopButton = new SmallButton(stopTutorial);
        JToolBar tutorialToolbar = new JToolBar();
        tutorialToolbar.setFloatable(false);
        tutorialToolbar.add(startButton);
        tutorialToolbar.add(stopButton);
        container.add((Component)tutorialToolbar, "North");
        tutorialArea.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (e.getDescription().equals("StartTutorial")) {
                        startTutorial.actionPerformed(null);
                    } else if (e.getDescription().equals("StopTutorial")) {
                        stopTutorial.actionPerformed(null);
                    } else {
                        try {
                            tutorialArea.setPage(e.getURL());
                        }
                        catch (IOException e1) {
                            MessageCenter.getInstance().getLogger().error((Object)"\u30c1\u30e5\u30fc\u30c8\u30ea\u30a2\u30eb\u7528\u306bURL\u3092\u5909\u3048\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3048\u3057\u305f", (Throwable)e1);
                        }
                    }
                }
            }
        });
        if (!this.getTabbedPane().tabSetting.isWelcome()) {
            this.displayPanel("\u306f\u3058\u3081\u306b", false);
        }
        if (!this.getTabbedPane().tabSetting.isZeroconf()) {
            this.displayPanel("Zeroconf", false);
        }
        this.tbms.stateChange();
    }

    private void showReceiverPanel() {
        this.mainReceiverSplitPane.setDividerSize(this.dividerSize);
        this.mainReceiverSplitPane.setDividerLocation(this.lastMainReceiverSplitLocation);
        this.receiversPanel.setVisible(true);
        this.mainReceiverSplitPane.repaint();
    }

    private void hideReceiverPanel() {
        int currentSize = this.mainReceiverSplitPane.getWidth() - this.mainReceiverSplitPane.getDividerSize();
        if (this.mainReceiverSplitPane.getDividerLocation() > -1 && this.mainReceiverSplitPane.getDividerLocation() + 1 != currentSize && this.mainReceiverSplitPane.getDividerLocation() - 1 != 0) {
            this.lastMainReceiverSplitLocation = (double)this.mainReceiverSplitPane.getDividerLocation() / (double)currentSize;
        }
        this.mainReceiverSplitPane.setDividerSize(0);
        this.receiversPanel.setVisible(false);
        this.mainReceiverSplitPane.repaint();
    }

    private void initSocketConnectionListener() {
        final SocketNodeEventListener socketListener = new SocketNodeEventListener(){

            public void socketOpened(String remoteInfo) {
                LogUI.this.statusBar.remoteConnectionReceived(remoteInfo);
            }

            public void socketClosedEvent(Exception e) {
                MessageCenter.getInstance().getLogger().info((Object)("Connection lost! :: " + e.getMessage()));
            }
        };
        PluginListener pluginListener = new PluginListener(){

            public void pluginStarted(PluginEvent e) {
                MessageCenter.getInstance().getLogger().info((Object)(e.getPlugin().getName() + " started!"));
                Method method = this.getAddListenerMethod(e.getPlugin());
                if (method != null) {
                    try {
                        method.invoke((Object)e.getPlugin(), socketListener);
                    }
                    catch (Exception ex) {
                        MessageCenter.getInstance().getLogger().error((Object)"SocketNodeEventListener\u306e\u8ffd\u52a0\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)ex);
                    }
                }
            }

            Method getRemoveListenerMethod(Plugin p) {
                try {
                    return p.getClass().getMethod("removeSocketNodeEventListener", class$org$apache$log4j$net$SocketNodeEventListener == null ? (class$org$apache$log4j$net$SocketNodeEventListener = LogUI.class$("org.apache.log4j.net.SocketNodeEventListener")) : class$org$apache$log4j$net$SocketNodeEventListener);
                }
                catch (Exception e) {
                    return null;
                }
            }

            Method getAddListenerMethod(Plugin p) {
                try {
                    return p.getClass().getMethod("addSocketNodeEventListener", class$org$apache$log4j$net$SocketNodeEventListener == null ? (class$org$apache$log4j$net$SocketNodeEventListener = LogUI.class$("org.apache.log4j.net.SocketNodeEventListener")) : class$org$apache$log4j$net$SocketNodeEventListener);
                }
                catch (Exception e) {
                    return null;
                }
            }

            public void pluginStopped(PluginEvent e) {
                Method method = this.getRemoveListenerMethod(e.getPlugin());
                if (method != null) {
                    try {
                        method.invoke((Object)e.getPlugin(), socketListener);
                    }
                    catch (Exception ex) {
                        MessageCenter.getInstance().getLogger().error((Object)"Failed to remove SocketNodeEventListener", (Throwable)ex);
                    }
                }
                MessageCenter.getInstance().getLogger().info((Object)(e.getPlugin().getName() + " stopped!"));
            }
        };
        this.pluginRegistry.addPluginListener(pluginListener);
    }

    private void initPrefModelListeners() {
        this.applicationPreferenceModel.addPropertyChangeListener("identifierExpression", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                LogUI.this.handler.setIdentifierExpression(evt.getNewValue().toString());
            }
        });
        this.handler.setIdentifierExpression(this.applicationPreferenceModel.getIdentifierExpression());
        this.applicationPreferenceModel.addPropertyChangeListener("toolTipDisplayMillis", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ToolTipManager.sharedInstance().setDismissDelay((Integer)evt.getNewValue());
            }
        });
        ToolTipManager.sharedInstance().setDismissDelay(this.applicationPreferenceModel.getToolTipDisplayMillis());
        this.applicationPreferenceModel.addPropertyChangeListener("responsiveness", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                int value = (Integer)evt.getNewValue();
                LogUI.this.handler.setQueueInterval(value * 1000 - 750);
            }
        });
        this.handler.setQueueInterval(this.applicationPreferenceModel.getResponsiveness() * 1000 - 750);
        this.applicationPreferenceModel.addPropertyChangeListener("tabPlacement", new PropertyChangeListener(){

            public void propertyChange(final PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int placement = (Integer)evt.getNewValue();
                        switch (placement) {
                            case 1: 
                            case 3: {
                                LogUI.this.tabbedPane.setTabPlacement(placement);
                                break;
                            }
                        }
                    }
                });
            }
        });
        this.applicationPreferenceModel.addPropertyChangeListener("statusBar", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean value = (Boolean)evt.getNewValue();
                LogUI.this.setStatusBarVisible(value);
            }
        });
        this.setStatusBarVisible(this.applicationPreferenceModel.isStatusBar());
        this.applicationPreferenceModel.addPropertyChangeListener("receivers", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean value = (Boolean)evt.getNewValue();
                if (value) {
                    LogUI.this.showReceiverPanel();
                } else {
                    LogUI.this.hideReceiverPanel();
                }
            }
        });
        this.applicationPreferenceModel.addPropertyChangeListener("toolbar", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean value = (Boolean)evt.getNewValue();
                LogUI.this.toolbar.setVisible(value);
            }
        });
        this.toolbar.setVisible(this.applicationPreferenceModel.isToolbar());
    }

    private void showNoReceiversWarningPanel() {
        final NoReceiversWarningPanel noReceiversWarningPanel = new NoReceiversWarningPanel();
        SettingsListener sl = new SettingsListener(){

            public void loadSettings(LoadSettingsEvent event) {
                int size = event.asInt("SavedConfigs.Size");
                Object[] configs = new Object[size];
                for (int i = 0; i < size; ++i) {
                    configs[i] = event.getSetting("SavedConfigs." + i);
                }
                noReceiversWarningPanel.getModel().setRememberedConfigs(configs);
            }

            public void saveSettings(SaveSettingsEvent event) {
                Object[] configs = noReceiversWarningPanel.getModel().getRememberedConfigs();
                event.saveSetting("SavedConfigs.Size", configs.length);
                for (int i = 0; i < configs.length; ++i) {
                    event.saveSetting("SavedConfigs." + i, configs[i].toString());
                }
            }
        };
        this.getSettingsManager().addSettingsListener(sl);
        this.getSettingsManager().configure(sl);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                URL url;
                final JDialog dialog = new JDialog((Frame)LogUI.this, true);
                dialog.setTitle("\u8b66\u544a\uff1a\u30ec\u30b7\u30fc\u30d0\u30fc\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093...");
                dialog.setDefaultCloseOperation(0);
                dialog.setResizable(false);
                noReceiversWarningPanel.setOkActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        dialog.setVisible(false);
                    }
                });
                dialog.getContentPane().add(noReceiversWarningPanel);
                dialog.pack();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                ((Component)dialog).setLocation(screenSize.width / 2 - dialog.getWidth() / 2, screenSize.height / 2 - dialog.getHeight() / 2);
                dialog.setVisible(true);
                LogUI.this.applicationPreferenceModel.setShowNoReceiverWarning(!noReceiversWarningPanel.isDontWarnMeAgain());
                if (noReceiversWarningPanel.getModel().isManualMode()) {
                    LogUI.this.applicationPreferenceModel.setReceivers(true);
                } else if (noReceiversWarningPanel.getModel().isSimpleReceiverMode()) {
                    int port = noReceiversWarningPanel.getModel().getSimplePort();
                    Class receiverClass = noReceiversWarningPanel.getModel().getSimpleReceiverClass();
                    try {
                        Receiver simpleReceiver = (Receiver)receiverClass.newInstance();
                        simpleReceiver.setName("Simple Receiver");
                        Method portMethod = simpleReceiver.getClass().getMethod("setPort", Integer.TYPE);
                        portMethod.invoke((Object)simpleReceiver, new Integer(port));
                        simpleReceiver.setThreshold(Level.TRACE);
                        LogUI.this.pluginRegistry.addPlugin((Plugin)simpleReceiver);
                        simpleReceiver.activateOptions();
                        LogUI.this.receiversPanel.updateReceiverTreeInDispatchThread();
                    }
                    catch (Exception e) {
                        MessageCenter.getInstance().getLogger().error((Object)"Error creating Receiver", (Throwable)e);
                        MessageCenter.getInstance().getLogger().info((Object)"An error occurred creating your Receiver");
                    }
                } else if ((noReceiversWarningPanel.getModel().isLoadConfig() || noReceiversWarningPanel.getModel().isLoadSavedConfigs()) && (url = noReceiversWarningPanel.getModel().isLoadSavedConfigs() ? noReceiversWarningPanel.getModel().getSavedConfigToLoad() : noReceiversWarningPanel.getModel().getConfigToLoad()) != null) {
                    MessageCenter.getInstance().getLogger().debug((Object)("Initialiazing Log4j with " + url.toExternalForm()));
                    new Thread(new Runnable(){

                        public void run() {
                            if (noReceiversWarningPanel.isDontWarnMeAgain()) {
                                LogUI.this.applicationPreferenceModel.setConfigurationURL(url.toExternalForm());
                            }
                            LogUI.this.loadConfigurationUsingPluginClassLoader(url);
                            LogUI.this.receiversPanel.updateReceiverTreeInDispatchThread();
                        }
                    }).start();
                }
            }
        });
    }

    public boolean exit() {
        this.getSettingsManager().saveSettings();
        return this.shutdown();
    }

    void addWelcomePanel() {
        this.getTabbedPane().insertTab("\u306f\u3058\u3081\u306b", new ImageIcon(ChainsawIcons.ABOUT), this.welcomePanel, "\u306f\u3058\u3081\u306b\uff0f\u30d8\u30eb\u30d7", 0);
        this.getTabbedPane().setSelectedComponent(this.welcomePanel);
        this.getPanelMap().put("\u306f\u3058\u3081\u306b", this.welcomePanel);
    }

    void removeWelcomePanel() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (LogUI.this.getTabbedPane().containsWelcomePanel()) {
                    LogUI.this.getTabbedPane().remove(LogUI.this.getTabbedPane().getComponentAt(LogUI.this.getTabbedPane().indexOfTab("\u306f\u3058\u3081\u306b")));
                }
            }
        });
    }

    ChainsawStatusBar getStatusBar() {
        return this.statusBar;
    }

    public void showApplicationPreferences() {
        this.applicationPreferenceModelPanel.updateModel();
        this.preferencesFrame.setVisible(true);
    }

    public void showApplicationPreferencesBrowse() {
        this.applicationPreferenceModelPanel.updateModel();
        this.preferencesFrame.setVisible(true);
        this.applicationPreferenceModelPanel.browseForConfiguration();
    }

    public void showAboutBox() {
        if (this.aboutBox == null) {
            this.aboutBox = new ChainsawAbout(this);
        }
        this.aboutBox.setVisible(true);
    }

    Map getPanels() {
        HashMap m = new HashMap();
        Set panelSet = this.getPanelMap().entrySet();
        Iterator iter = panelSet.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object o = entry.getValue();
            boolean valueToSend = o instanceof LogPanel ? ((DockablePanel)entry.getValue()).isDocked() : true;
            m.put(entry.getKey(), new Boolean(valueToSend));
        }
        return m;
    }

    void displayPanel(String panelName, boolean display) {
        Component p = (Component)this.getPanelMap().get(panelName);
        int index = this.getTabbedPane().indexOfTab(panelName);
        if (index == -1 && display) {
            this.getTabbedPane().addTab(panelName, p);
        }
        if (index > -1 && !display) {
            this.getTabbedPane().removeTabAt(index);
        }
    }

    public boolean shutdown() {
        if (this.getApplicationPreferenceModel().isConfirmExit() && JOptionPane.showConfirmDialog(this, "Chainsaw\u3092\u7d42\u4e86\u3057\u307e\u3059\u304b\uff1f", "\u7d42\u4e86\u3059\u308b", 0, 1) != 0) {
            return false;
        }
        final JWindow progressWindow = new JWindow();
        final ProgressPanel panel = new ProgressPanel(1, 3, "\u7d42\u4e86\u3057\u3066\u3044\u307e\u3059");
        progressWindow.getContentPane().add(panel);
        progressWindow.pack();
        Point p = new Point(this.getLocation());
        p.move((int)this.getSize().getWidth() >> 1, (int)this.getSize().getHeight() >> 1);
        ((Component)progressWindow).setLocation(p);
        progressWindow.setVisible(true);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    int progress = 1;
                    int delay = 25;
                    LogUI.this.handler.close();
                    panel.setProgress(progress++);
                    Thread.sleep(25L);
                    LogUI.this.pluginRegistry.stopAllPlugins();
                    panel.setProgress(progress++);
                    Thread.sleep(25L);
                    panel.setProgress(progress++);
                    Thread.sleep(25L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                LogUI.this.fireShutdownEvent();
                LogUI.this.performShutdownAction();
                progressWindow.setVisible(false);
            }
        };
        if (OSXIntegration.IS_OSX) {
            runnable.run();
        } else {
            new Thread(runnable).start();
        }
        return true;
    }

    private void fireShutdownEvent() {
        ShutdownListener[] listeners = (ShutdownListener[])this.shutdownListenerList.getListeners(class$org$apache$log4j$chainsaw$ShutdownListener == null ? (class$org$apache$log4j$chainsaw$ShutdownListener = LogUI.class$("org.apache.log4j.chainsaw.ShutdownListener")) : class$org$apache$log4j$chainsaw$ShutdownListener);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].shuttingDown();
        }
    }

    public final void setShutdownAction(Action shutdownAction) {
        this.shutdownAction = shutdownAction;
    }

    private void performShutdownAction() {
        MessageCenter.getInstance().getLogger().debug((Object)"\u30b7\u30e3\u30c3\u30c8\u30c0\u30a6\u30f3\u51e6\u7406\u3092\u5b9f\u884c\u3057\u3066\u3044\u307e\u3059\u3002\u307e\u305f\u306d\uff01");
        this.shutdownAction.actionPerformed(new ActionEvent(this, 1001, "Shutting Down"));
    }

    LogPanel getCurrentLogPanel() {
        Component selectedTab = this.getTabbedPane().getSelectedComponent();
        if (selectedTab instanceof LogPanel) {
            return (LogPanel)selectedTab;
        }
        return null;
    }

    private void setStatusBarVisible(final boolean visible) {
        MessageCenter.getInstance().getLogger().debug((Object)("Setting StatusBar to " + visible));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LogUI.this.statusBar.setVisible(visible);
            }
        });
    }

    boolean isStatusBarVisible() {
        return this.statusBar.isVisible();
    }

    public String getActiveTabName() {
        int index = this.getTabbedPane().getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return this.getTabbedPane().getTitleAt(index);
    }

    private static void applyLookAndFeel(String lookAndFeelClassName) {
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        if (UIManager.getLookAndFeel().getClass().getName().equals(lookAndFeelClassName)) {
            return;
        }
        if (lookAndFeelClassName == null || lookAndFeelClassName.trim().equals("")) {
            lookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
        }
        try {
            UIManager.setLookAndFeel(lookAndFeelClassName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showHelp(URL url) {
        this.ensureWelcomePanelVisible();
        this.getWelcomePanel().setURL(url);
    }

    private WelcomePanel getWelcomePanel() {
        return this.welcomePanel;
    }

    public boolean isLogTreePanelVisible() {
        if (this.getCurrentLogPanel() == null) {
            return false;
        }
        return this.getCurrentLogPanel().isLogTreeVisible();
    }

    public Map getPanelMap() {
        return this.panelMap;
    }

    public SettingsManager getSettingsManager() {
        return this.sm;
    }

    public List getFilterableColumns() {
        return this.filterableColumns;
    }

    public void setToolBarAndMenus(ChainsawToolBarAndMenus tbms) {
        this.tbms = tbms;
    }

    public ChainsawToolBarAndMenus getToolBarAndMenus() {
        return this.tbms;
    }

    public Map getTableMap() {
        return this.tableMap;
    }

    public Map getTableModelMap() {
        return this.tableModelMap;
    }

    public void setTabbedPane(ChainsawTabbedPane tabbedPane) {
        this.tabbedPane = tabbedPane;
    }

    public ChainsawTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public final ApplicationPreferenceModel getApplicationPreferenceModel() {
        return this.applicationPreferenceModel;
    }

    public void setupTutorial() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
                ((Component)LogUI.this).setLocation(0, LogUI.this.getLocation().y);
                double chainsawwidth = 0.7;
                double tutorialwidth = 1.0 - chainsawwidth;
                LogUI.this.setSize((int)((double)screen.width * chainsawwidth), LogUI.this.getSize().height);
                LogUI.this.invalidate();
                LogUI.this.validate();
                Dimension size = LogUI.this.getSize();
                Point loc = LogUI.this.getLocation();
                LogUI.this.tutorialFrame.setSize((int)((double)screen.width * tutorialwidth), size.height);
                ((Component)LogUI.this.tutorialFrame).setLocation(loc.x + size.width, loc.y);
                LogUI.this.tutorialFrame.setVisible(true);
            }
        });
    }

    private void buildLogPanel(boolean customExpression, final String ident, final List events) throws IllegalArgumentException {
        final LogPanel thisPanel = new LogPanel(this.getStatusBar(), ident, this.cyclicBufferSize, this.allColorizers, this.applicationPreferenceModel);
        this.getSettingsManager().addSettingsListener(thisPanel);
        this.getSettingsManager().configure(thisPanel);
        if (customExpression) {
            this.handler.addCustomEventBatchListener(ident, thisPanel);
        } else {
            this.identifierPanels.add(thisPanel);
            this.handler.addEventBatchListener(thisPanel);
        }
        TabIconHandler iconHandler = new TabIconHandler(ident);
        thisPanel.addEventCountListener(iconHandler);
        this.tabbedPane.addChangeListener(iconHandler);
        PropertyChangeListener toolbarMenuUpdateListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                LogUI.this.tbms.stateChange();
            }
        };
        thisPanel.addPropertyChangeListener(toolbarMenuUpdateListener);
        thisPanel.addPreferencePropertyChangeListener(toolbarMenuUpdateListener);
        thisPanel.addPropertyChangeListener("docked", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                LogPanel logPanel = (LogPanel)evt.getSource();
                if (logPanel.isDocked()) {
                    LogUI.this.getPanelMap().put(logPanel.getIdentifier(), logPanel);
                    LogUI.this.getTabbedPane().addANewTab(logPanel.getIdentifier(), logPanel, null);
                    LogUI.this.getTabbedPane().setSelectedTab(LogUI.this.getTabbedPane().indexOfTab(logPanel.getIdentifier()));
                } else {
                    LogUI.this.getTabbedPane().remove(logPanel);
                }
            }
        });
        logger.debug((Object)("adding logpanel to tabbed pane: " + ident));
        this.getTabbedPane().add(ident, thisPanel);
        this.getPanelMap().put(ident, thisPanel);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LogUI.this.getTabbedPane().addANewTab(ident, thisPanel, new ImageIcon(ChainsawIcons.ANIM_RADIO_TOWER));
                thisPanel.receiveEventBatch(ident, events);
                if (!LogUI.this.getTabbedPane().tabSetting.isChainsawLog()) {
                    LogUI.this.displayPanel("chainsaw-log", false);
                }
            }
        });
        String msg = "added tab " + ident;
        MessageCenter.getInstance().getLogger().debug((Object)msg);
    }

    public void createCustomExpressionLogPanel(String ident) {
        try {
            ArrayList<LoggingEvent> list = new ArrayList<LoggingEvent>();
            Rule rule = ExpressionRule.getRule((String)ident);
            Iterator iter = this.identifierPanels.iterator();
            while (iter.hasNext()) {
                LogPanel panel = (LogPanel)iter.next();
                Iterator iter2 = panel.getMatchingEvents(rule).iterator();
                while (iter2.hasNext()) {
                    LoggingEvent e = (LoggingEvent)iter2.next();
                    list.add(e);
                }
            }
            this.buildLogPanel(true, ident, list);
        }
        catch (IllegalArgumentException iae) {
            MessageCenter.getInstance().getLogger().info((Object)("Unable to add tab using expression: " + ident + ", reason: " + iae.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigurationUsingPluginClassLoader(URL url) {
        ClassLoader classLoader = PluginClassLoaderFactory.getInstance().getClassLoader();
        ClassLoader previousTCCL = Thread.currentThread().getContextClassLoader();
        if (url != null) {
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                DOMConfigurator.configure((URL)url);
            }
            finally {
                Thread.currentThread().setContextClassLoader(previousTCCL);
            }
        }
        this.ensureChainsawAppenderHandlerAdded();
    }

    private void ensureChainsawAppenderHandlerAdded() {
        if (!LogManager.getLoggerRepository().getRootLogger().isAttached((Appender)this.handler)) {
            LogManager.getLoggerRepository().getRootLogger().addAppender((Appender)this.handler);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        repositorySelectorGuard = new Object();
        repositoryExImpl = new LoggerRepositoryExImpl(LogManager.getLoggerRepository());
    }

    private class TabIconHandler
    implements EventCountListener,
    ChangeListener {
        private boolean newEvents = true;
        private boolean seenEvents = false;
        private final String ident;
        ImageIcon NEW_EVENTS = new ImageIcon(ChainsawIcons.ANIM_RADIO_TOWER);
        ImageIcon HAS_EVENTS = new ImageIcon(ChainsawIcons.INFO);
        Icon SELECTED = LineIconFactory.createBlankIcon();

        public TabIconHandler(String identifier) {
            this.ident = identifier;
            new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        if (LogUI.this.getTabbedPane().indexOfTab(TabIconHandler.this.ident) > -1 && LogUI.this.getTabbedPane().getSelectedIndex() == LogUI.this.getTabbedPane().indexOfTab(TabIconHandler.this.ident)) {
                            LogUI.this.getTabbedPane().setIconAt(LogUI.this.getTabbedPane().indexOfTab(TabIconHandler.this.ident), TabIconHandler.this.SELECTED);
                            TabIconHandler.this.newEvents = false;
                            TabIconHandler.this.seenEvents = true;
                        } else if (LogUI.this.getTabbedPane().indexOfTab(TabIconHandler.this.ident) > -1) {
                            if (TabIconHandler.this.newEvents) {
                                LogUI.this.getTabbedPane().setIconAt(LogUI.this.getTabbedPane().indexOfTab(TabIconHandler.this.ident), TabIconHandler.this.NEW_EVENTS);
                                TabIconHandler.this.newEvents = false;
                                TabIconHandler.this.seenEvents = false;
                            } else if (!TabIconHandler.this.seenEvents) {
                                LogUI.this.getTabbedPane().setIconAt(LogUI.this.getTabbedPane().indexOfTab(TabIconHandler.this.ident), TabIconHandler.this.HAS_EVENTS);
                            }
                        }
                        try {
                            Thread.sleep(((TabIconHandler)TabIconHandler.this).LogUI.this.handler.getQueueInterval() + 1000);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            }).start();
        }

        public void eventCountChanged(int currentCount, int totalCount) {
            this.newEvents = true;
        }

        public void stateChanged(ChangeEvent event) {
            if (LogUI.this.getTabbedPane().indexOfTab(this.ident) > -1 && LogUI.this.getTabbedPane().indexOfTab(this.ident) == LogUI.this.getTabbedPane().getSelectedIndex()) {
                LogUI.this.getTabbedPane().setIconAt(LogUI.this.getTabbedPane().indexOfTab(this.ident), this.SELECTED);
            }
        }
    }

    private class NewTabEventBatchReceiver
    implements EventBatchListener {
        private NewTabEventBatchReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveEventBatch(String ident, List events) {
            if (events.size() == 0) {
                return;
            }
            if (!LogUI.this.isGUIFullyInitialized) {
                Object object = LogUI.this.initializationLock;
                synchronized (object) {
                    while (!LogUI.this.isGUIFullyInitialized) {
                        System.out.println("Wanting to add a row, but GUI not initialized, waiting...");
                        try {
                            LogUI.this.initializationLock.wait(1000L);
                            logger.debug((Object)"waiting for initialization to complete");
                        }
                        catch (InterruptedException e) {}
                    }
                    logger.debug((Object)"out of system initialization wait loop");
                }
            }
            if (!LogUI.this.getPanelMap().containsKey(ident)) {
                logger.debug((Object)("panel " + ident + " does not exist - creating"));
                try {
                    LogUI.this.buildLogPanel(false, ident, events);
                }
                catch (IllegalArgumentException iae) {
                    logger.error((Object)"error creating log panel", (Throwable)iae);
                }
            }
        }

        public String getInterestedIdentifier() {
            return null;
        }
    }
}

