/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import org.apache.log4j.chainsaw.ApplicationPreferenceModel;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.EventContainer;
import org.apache.log4j.chainsaw.ExtendedLoggingEvent;
import org.apache.log4j.chainsaw.color.RuleColorizer;
import org.apache.log4j.chainsaw.icons.LevelIconFactory;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class TableColorizingRenderer
extends DefaultTableCellRenderer {
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("HH:mm:ss");
    private static final Map iconMap = LevelIconFactory.getInstance().getLevelToIconMap();
    private RuleColorizer colorizer;
    private boolean levelUseIcons = false;
    private boolean wrap = false;
    private boolean highlightSearchMatchText;
    private DateFormat dateFormatInUse = DATE_FORMATTER;
    private int loggerPrecision = 0;
    private boolean toolTipsVisible;
    private String dateFormatTZ;
    private boolean useRelativeTimes = false;
    private long relativeTimestampBase;
    private static int borderWidth = 2;
    private static Color borderColor = (Color)UIManager.get("Table.selectionBackground");
    private static final Border LEFT_BORDER = BorderFactory.createMatteBorder(borderWidth, borderWidth, borderWidth, 0, borderColor);
    private static final Border MIDDLE_BORDER = BorderFactory.createMatteBorder(borderWidth, 0, borderWidth, 0, borderColor);
    private static final Border RIGHT_BORDER = BorderFactory.createMatteBorder(borderWidth, 0, borderWidth, borderWidth, borderColor);
    private static final Border LEFT_EMPTY_BORDER = BorderFactory.createEmptyBorder(borderWidth, borderWidth, borderWidth, 0);
    private static final Border MIDDLE_EMPTY_BORDER = BorderFactory.createEmptyBorder(borderWidth, 0, borderWidth, 0);
    private static final Border RIGHT_EMPTY_BORDER = BorderFactory.createEmptyBorder(borderWidth, 0, borderWidth, borderWidth);
    private final JTextPane levelTextPane = new JTextPane();
    private JTextPane singleLineTextPane = new JTextPane();
    private final JPanel multiLinePanel = new JPanel();
    private final JPanel generalPanel = new JPanel();
    private final JPanel levelPanel = new JPanel();
    private ApplicationPreferenceModel applicationPreferenceModel;
    private JTextPane multiLineTextPane;
    private MutableAttributeSet boldAttributeSet;
    private TabSet tabs;
    private int maxHeight;

    public TableColorizingRenderer(RuleColorizer colorizer, ApplicationPreferenceModel applicationPreferenceModel) {
        this.applicationPreferenceModel = applicationPreferenceModel;
        this.multiLinePanel.setLayout(new BoxLayout(this.multiLinePanel, 1));
        this.generalPanel.setLayout(new BoxLayout(this.generalPanel, 1));
        this.levelPanel.setLayout(new BoxLayout(this.levelPanel, 1));
        this.maxHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.boldAttributeSet = new SimpleAttributeSet();
        StyleConstants.setBold(this.boldAttributeSet, true);
        boolean pos = false;
        int align = 0;
        int leader = 0;
        TabStop tabStop = new TabStop((float)pos, align, leader);
        this.tabs = new TabSet(new TabStop[]{tabStop});
        this.levelTextPane.setOpaque(true);
        this.levelTextPane.setText("");
        this.generalPanel.add(this.singleLineTextPane);
        this.levelPanel.add(this.levelTextPane);
        this.colorizer = colorizer;
        this.multiLineTextPane = new JTextPane();
        this.multiLineTextPane.setEditorKit(new StyledEditorKit());
        this.singleLineTextPane.setEditorKit(new OneLineEditorKit());
        this.levelTextPane.setEditorKit(new OneLineEditorKit());
        this.multiLineTextPane.setEditable(false);
        this.multiLineTextPane.setFont(this.levelTextPane.getFont());
        Insets leftRightInsets = new Insets(0, 5, 0, 5);
        this.multiLineTextPane.setMargin(leftRightInsets);
        this.singleLineTextPane.setMargin(leftRightInsets);
        this.levelTextPane.setMargin(leftRightInsets);
    }

    public void setToolTipsVisible(boolean toolTipsVisible) {
        this.toolTipsVisible = toolTipsVisible;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        Color foreground;
        Color background;
        JPanel component;
        value = this.formatField(value);
        TableColumn tableColumn = table.getColumnModel().getColumn(col);
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        int colIndex = tableColumn.getModelIndex() + 1;
        EventContainer container = (EventContainer)table.getModel();
        ExtendedLoggingEvent loggingEvent = container.getRow(row);
        if (loggingEvent == null) {
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        }
        Map matches = loggingEvent.getSearchMatches();
        switch (colIndex) {
            case 8: {
                if (value instanceof String[] && ((String[])value).length > 0) {
                    Style tabStyle = this.singleLineTextPane.getLogicalStyle();
                    StyleConstants.setTabSet(tabStyle, this.tabs);
                    this.singleLineTextPane.setLogicalStyle(tabStyle);
                    Set exceptionMatches = (Set)matches.get("EXCEPTION");
                    if (exceptionMatches != null && exceptionMatches.size() > 0) {
                        this.singleLineTextPane.setText(((String[])value)[0]);
                        this.boldAll((StyledDocument)this.singleLineTextPane.getDocument());
                    } else {
                        this.singleLineTextPane.setText(((String[])value)[0]);
                    }
                } else {
                    this.singleLineTextPane.setText("");
                }
                component = this.generalPanel;
                break;
            }
            case 1: {
                String logger = value.toString();
                int startPos = -1;
                for (int i = 0; i < this.loggerPrecision && (startPos = logger.indexOf(".", startPos + 1)) >= 0; ++i) {
                }
                this.singleLineTextPane.setText(logger.substring(startPos + 1));
                this.setHighlightAttributesInternal(matches.get("LOGGER"), (StyledDocument)this.singleLineTextPane.getDocument());
                component = this.generalPanel;
                break;
            }
            case 13: {
                this.singleLineTextPane.setText(value.toString());
                this.setHighlightAttributesInternal(matches.get("PROP.LOG4JID"), (StyledDocument)this.singleLineTextPane.getDocument());
                component = this.generalPanel;
                break;
            }
            case 9: {
                this.singleLineTextPane.setText(value.toString());
                this.setHighlightAttributesInternal(matches.get("CLASS"), (StyledDocument)this.singleLineTextPane.getDocument());
                component = this.generalPanel;
                break;
            }
            case 11: {
                this.singleLineTextPane.setText(value.toString());
                this.setHighlightAttributesInternal(matches.get("FILE"), (StyledDocument)this.singleLineTextPane.getDocument());
                component = this.generalPanel;
                break;
            }
            case 12: {
                this.singleLineTextPane.setText(value.toString());
                this.setHighlightAttributesInternal(matches.get("LINE"), (StyledDocument)this.singleLineTextPane.getDocument());
                component = this.generalPanel;
                break;
            }
            case 7: {
                this.singleLineTextPane.setText(value.toString());
                this.setHighlightAttributesInternal(matches.get("NDC"), (StyledDocument)this.singleLineTextPane.getDocument());
                component = this.generalPanel;
                break;
            }
            case 5: {
                this.singleLineTextPane.setText(value.toString());
                this.setHighlightAttributesInternal(matches.get("THREAD"), (StyledDocument)this.singleLineTextPane.getDocument());
                component = this.generalPanel;
                break;
            }
            case 3: {
                Set timestampMatches = (Set)matches.get("TIMESTAMP");
                if (timestampMatches != null && timestampMatches.size() > 0) {
                    this.singleLineTextPane.setText(value.toString());
                    this.boldAll((StyledDocument)this.singleLineTextPane.getDocument());
                } else {
                    this.singleLineTextPane.setText(value.toString());
                }
                component = this.generalPanel;
                break;
            }
            case 10: {
                this.singleLineTextPane.setText(value.toString());
                this.setHighlightAttributesInternal(matches.get("METHOD"), (StyledDocument)this.singleLineTextPane.getDocument());
                component = this.generalPanel;
                break;
            }
            case 2: 
            case 6: {
                String thisString = value.toString().trim();
                this.multiLineTextPane.setText(thisString);
                int width = tableColumn.getWidth();
                if (colIndex == 2) {
                    this.setHighlightAttributesInternal(matches.get("PROP." + "log4j.marker".toUpperCase()), (StyledDocument)this.multiLineTextPane.getDocument());
                } else {
                    this.setHighlightAttributesInternal(matches.get("MSG"), (StyledDocument)this.multiLineTextPane.getDocument());
                }
                this.multiLinePanel.removeAll();
                this.multiLinePanel.add(this.multiLineTextPane);
                if (this.wrap) {
                    this.multiLineTextPane.setSize(new Dimension(width, this.maxHeight));
                    boolean setHeight = false;
                    int multiLinePanelPrefHeight = this.multiLinePanel.getPreferredSize().height;
                    int newRowHeight = Math.max(20, multiLinePanelPrefHeight);
                    if (colIndex == 2) {
                        int currentMarkerHeight = loggingEvent.getMarkerHeight();
                        loggingEvent.setMarkerHeight(newRowHeight);
                        if (newRowHeight != currentMarkerHeight && newRowHeight >= loggingEvent.getMsgHeight()) {
                            setHeight = true;
                        }
                    }
                    if (colIndex == 6) {
                        int currentMsgHeight = loggingEvent.getMsgHeight();
                        loggingEvent.setMsgHeight(newRowHeight);
                        if (newRowHeight != currentMsgHeight && newRowHeight >= loggingEvent.getMarkerHeight()) {
                            setHeight = true;
                        }
                    }
                    if (setHeight) {
                        table.setRowHeight(row, newRowHeight);
                    }
                }
                component = this.multiLinePanel;
                break;
            }
            case 4: {
                if (this.levelUseIcons) {
                    this.levelTextPane.setText("");
                    this.levelTextPane.insertIcon((Icon)iconMap.get(value.toString()));
                    if (!this.toolTipsVisible) {
                        this.levelTextPane.setToolTipText(value.toString());
                    }
                } else {
                    this.levelTextPane.setText(value.toString());
                    this.setHighlightAttributesInternal(matches.get("LEVEL"), (StyledDocument)this.levelTextPane.getDocument());
                    if (!this.toolTipsVisible) {
                        this.levelTextPane.setToolTipText(null);
                    }
                }
                if (this.toolTipsVisible) {
                    this.levelTextPane.setToolTipText(label.getToolTipText());
                }
                this.levelTextPane.setForeground(label.getForeground());
                this.levelTextPane.setBackground(label.getBackground());
                component = this.levelPanel;
                break;
            }
            default: {
                Set propertySet = loggingEvent.getPropertyKeySet();
                String headerName = tableColumn.getHeaderValue().toString().toLowerCase();
                String thisProp = null;
                Iterator iter = propertySet.iterator();
                while (iter.hasNext()) {
                    String entry = iter.next().toString();
                    if (!entry.toLowerCase().equals(headerName)) continue;
                    thisProp = entry;
                    break;
                }
                if (thisProp != null) {
                    String propKey = "PROP." + thisProp.toUpperCase();
                    Set propKeyMatches = (Set)matches.get(propKey);
                    this.singleLineTextPane.setText(loggingEvent.getProperty(thisProp));
                    this.setHighlightAttributesInternal(propKeyMatches, (StyledDocument)this.singleLineTextPane.getDocument());
                } else {
                    this.singleLineTextPane.setText("");
                }
                component = this.generalPanel;
            }
        }
        Rule loggerRule = this.colorizer.getLoggerRule();
        if (loggerRule != null && loggerRule.evaluate((LoggingEvent)loggingEvent, null)) {
            background = this.applicationPreferenceModel.getSearchBackgroundColor();
            foreground = this.applicationPreferenceModel.getSearchForegroundColor();
        } else {
            background = loggingEvent.isSearchMatch() ? this.applicationPreferenceModel.getSearchBackgroundColor() : loggingEvent.getBackground();
            Color color = foreground = loggingEvent.isSearchMatch() ? this.applicationPreferenceModel.getSearchForegroundColor() : loggingEvent.getForeground();
        }
        if (background.equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND) && foreground.equals(ChainsawConstants.COLOR_DEFAULT_FOREGROUND) && row % 2 != 0) {
            background = this.applicationPreferenceModel.getAlternatingColorBackgroundColor();
            foreground = this.applicationPreferenceModel.getAlternatingColorForegroundColor();
        }
        component.setBackground(background);
        component.setForeground(foreground);
        if (this.multiLineTextPane != null) {
            this.updateColors(this.multiLineTextPane, background, foreground);
        }
        this.updateColors(this.levelTextPane, background, foreground);
        this.updateColors(this.singleLineTextPane, background, foreground);
        if (isSelected) {
            if (col == 0) {
                component.setBorder(LEFT_BORDER);
            } else if (col == table.getColumnCount() - 1) {
                component.setBorder(RIGHT_BORDER);
            } else {
                component.setBorder(MIDDLE_BORDER);
            }
        } else if (col == 0) {
            component.setBorder(LEFT_EMPTY_BORDER);
        } else if (col == table.getColumnCount() - 1) {
            component.setBorder(RIGHT_EMPTY_BORDER);
        } else {
            component.setBorder(MIDDLE_EMPTY_BORDER);
        }
        return component;
    }

    private void updateColors(JTextPane textPane, Color background, Color foreground) {
        StyledDocument styledDocument = textPane.getStyledDocument();
        MutableAttributeSet attributes = textPane.getInputAttributes();
        StyleConstants.setForeground(attributes, foreground);
        styledDocument.setCharacterAttributes(0, styledDocument.getLength() + 1, attributes, false);
        textPane.setBackground(background);
    }

    void setDateFormatter(DateFormat formatter) {
        this.dateFormatInUse = formatter;
        if (this.dateFormatInUse != null && this.dateFormatTZ != null && !"".equals(this.dateFormatTZ)) {
            this.dateFormatInUse.setTimeZone(TimeZone.getTimeZone(this.dateFormatTZ));
        } else {
            this.dateFormatInUse.setTimeZone(TimeZone.getDefault());
        }
    }

    void setLoggerPrecision(String loggerPrecisionText) {
        try {
            this.loggerPrecision = Integer.parseInt(loggerPrecisionText);
        }
        catch (NumberFormatException nfe) {
            this.loggerPrecision = 0;
        }
    }

    private Object formatField(Object o) {
        if (!(o instanceof Date)) {
            return o == null ? "" : o;
        }
        if (this.useRelativeTimes) {
            return "" + (((Date)o).getTime() - this.relativeTimestampBase);
        }
        return this.dateFormatInUse.format((Date)o);
    }

    public void setWrapMessage(boolean wrapMsg) {
        this.wrap = wrapMsg;
    }

    public void setLevelUseIcons(boolean levelUseIcons) {
        this.levelUseIcons = levelUseIcons;
    }

    public void setTimeZone(String dateFormatTZ) {
        this.dateFormatTZ = dateFormatTZ;
        if (this.dateFormatInUse != null && dateFormatTZ != null && !"".equals(dateFormatTZ)) {
            this.dateFormatInUse.setTimeZone(TimeZone.getTimeZone(dateFormatTZ));
        } else {
            this.dateFormatInUse.setTimeZone(TimeZone.getDefault());
        }
    }

    public void setUseRelativeTimes(long timeStamp) {
        this.useRelativeTimes = true;
        this.relativeTimestampBase = timeStamp;
    }

    public void setUseNormalTimes() {
        this.useRelativeTimes = false;
    }

    private int calculateHeight(String string, int width, Map paramMap) {
        if (string.trim().length() == 0) {
            return 20;
        }
        AttributedCharacterIterator paragraph = new AttributedString(string, paramMap).getIterator();
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, new FontRenderContext(null, true, true));
        float height = 0.0f;
        lineMeasurer.setPosition(paragraph.getBeginIndex());
        while (lineMeasurer.getPosition() < paragraph.getEndIndex()) {
            TextLayout layout = lineMeasurer.nextLayout(width);
            float layoutHeight = layout.getAscent() + layout.getDescent() + layout.getLeading();
            height += layoutHeight;
        }
        return Math.max(20, (int)height);
    }

    private void setHighlightAttributesInternal(Object matchSet, StyledDocument styledDocument) {
        if (!this.highlightSearchMatchText) {
            return;
        }
        this.setHighlightAttributes(matchSet, styledDocument);
    }

    public void setHighlightAttributes(Object matchSet, StyledDocument styledDocument) {
        if (matchSet instanceof Set) {
            Set thisSet = (Set)matchSet;
            Iterator iter = thisSet.iterator();
            while (iter.hasNext()) {
                String thisEntry = iter.next().toString();
                this.bold(thisEntry, styledDocument);
            }
        }
    }

    private void boldAll(StyledDocument styledDocument) {
        if (!this.highlightSearchMatchText) {
            return;
        }
        styledDocument.setCharacterAttributes(0, styledDocument.getLength(), this.boldAttributeSet, false);
    }

    private void bold(String textToBold, StyledDocument styledDocument) {
        try {
            int currentIndex;
            String lowerInput = styledDocument.getText(0, styledDocument.getLength()).toLowerCase();
            String lowerTextToBold = textToBold.toLowerCase();
            int textToBoldLength = textToBold.length();
            int firstIndex = 0;
            while ((currentIndex = lowerInput.indexOf(lowerTextToBold, firstIndex)) > -1) {
                styledDocument.setCharacterAttributes(currentIndex, textToBoldLength, this.boldAttributeSet, false);
                firstIndex = currentIndex + textToBoldLength;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setHighlightSearchMatchText(boolean highlightSearchMatchText) {
        this.highlightSearchMatchText = highlightSearchMatchText;
    }

    private class OneLineParagraphView
    extends ParagraphView {
        public OneLineParagraphView(Element elem) {
            super(elem);
        }

        public int getFlowSpan(int index) {
            return Integer.MAX_VALUE;
        }
    }

    private class ViewFactoryImpl
    implements ViewFactory {
        private ViewFactoryImpl() {
        }

        public View create(Element elem) {
            String elementName = elem.getName();
            if (elementName != null) {
                if (elementName.equals("paragraph")) {
                    return new OneLineParagraphView(elem);
                }
                if (elementName.equals("content")) {
                    return new LabelView(elem);
                }
                if (elementName.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (elementName.equals("component")) {
                    return new ComponentView(elem);
                }
                if (elementName.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }

    private class OneLineEditorKit
    extends StyledEditorKit {
        private ViewFactory viewFactoryImpl;

        private OneLineEditorKit() {
            this.viewFactoryImpl = new ViewFactoryImpl();
        }

        public ViewFactory getViewFactory() {
            return this.viewFactoryImpl;
        }
    }
}

