/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.help;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.messages.MessageCenter;

class HelpLocator {
    private List classLoaders = new ArrayList();
    private static Logger logger = LogManager.getLogger((Class)(class$org$apache$log4j$chainsaw$help$HelpLocator == null ? (class$org$apache$log4j$chainsaw$help$HelpLocator = HelpLocator.class$("org.apache.log4j.chainsaw.help.HelpLocator")) : class$org$apache$log4j$chainsaw$help$HelpLocator));
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$help$HelpLocator;

    HelpLocator() {
    }

    void installClassloaderLocator(ClassLoader cl) {
        this.classLoaders.add(cl);
    }

    void installLocator(URL url) {
        try {
            this.classLoaders.add(new HelpResourceLoader(url));
        }
        catch (Exception e) {
            MessageCenter.getInstance().getLogger().error((Object)"Failed to setup the resoure loaders for the Help Subsystem");
        }
    }

    URL findResource(String name) {
        ClassLoader loader;
        URL url = null;
        Iterator iter = this.classLoaders.iterator();
        while (iter.hasNext() && (url = (loader = (ClassLoader)iter.next()).getResource(name)) == null) {
        }
        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class HelpResourceLoader
    extends ClassLoader {
        private URL root;

        private HelpResourceLoader(URL root) {
            this.root = root;
        }

        protected URL findResource(String name) {
            URL url = super.findResource(name);
            if (url != null) {
                return url;
            }
            try {
                URL resourceURL = new URL(this.root, name);
                URL[] urlArray = new URL[]{this.root, resourceURL};
                logger.debug((Object)("Looking for Help resource at:" + resourceURL.toExternalForm()));
                logger.debug((Object)("urlArray=" + Arrays.asList(urlArray)));
                return new URLClassLoader(urlArray).findResource(name);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

