/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.layout;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.JTextComponentFormatter;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.layout.EventDetailLayout;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public final class LayoutEditorPane
extends JPanel {
    private final Action copyAction;
    private final Action cutAction;
    private final JToolBar editorToolbar = new JToolBar();
    private final JToolBar okCancelToolbar = new JToolBar();
    private final JButton okButton = new JButton(" OK ");
    private final JButton cancelButton = new JButton(" Cancel ");
    private final JEditorPane patternEditor = new JEditorPane("text/plain", "");
    private final JEditorPane previewer = new JEditorPane("text/html", "");
    private final JScrollPane patternEditorScroll = new JScrollPane(22, 32);
    private final JScrollPane previewEditorScroll = new JScrollPane(22, 32);
    private LoggingEvent event;
    private EventDetailLayout layout = new EventDetailLayout();

    public LayoutEditorPane() {
        this.setLayout(new BoxLayout(this, 1));
        this.createEvent();
        this.copyAction = this.createCopyAction();
        this.cutAction = this.createCutAction();
        this.initComponents();
        this.setupListeners();
    }

    private Action createCutAction() {
        AbstractAction action = new AbstractAction("Cut", ChainsawIcons.ICON_CUT){

            public void actionPerformed(ActionEvent e) {
            }
        };
        action.setEnabled(false);
        return action;
    }

    private Action createCopyAction() {
        AbstractAction action = new AbstractAction("Copy", ChainsawIcons.ICON_COPY){

            public void actionPerformed(ActionEvent e) {
            }
        };
        action.setEnabled(false);
        return action;
    }

    private void setupListeners() {
        this.patternEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                LayoutEditorPane.this.updatePreview();
            }

            public void insertUpdate(DocumentEvent e) {
                LayoutEditorPane.this.updatePreview();
            }

            public void removeUpdate(DocumentEvent e) {
                LayoutEditorPane.this.updatePreview();
            }
        });
        this.patternEditor.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                LayoutEditorPane.this.updateTextActions(e.getMark() != e.getDot());
            }
        });
    }

    private void updatePreview() {
        String pattern = this.patternEditor.getText();
        this.layout.setConversionPattern(pattern);
        this.previewer.setText(this.layout.format(this.event));
    }

    private void updateTextActions(boolean enabled) {
        this.cutAction.setEnabled(enabled);
        this.copyAction.setEnabled(enabled);
    }

    private void createEvent() {
        Hashtable<String, String> hashTable = new Hashtable<String, String>();
        hashTable.put("key1", "val1");
        hashTable.put("key2", "val2");
        hashTable.put("key3", "val3");
        LocationInfo li = new LocationInfo("myfile.java", "com.mycompany.util.MyClass", "myMethod", "321");
        ThrowableInformation tsr = new ThrowableInformation((Throwable)new Exception());
        this.event = new LoggingEvent("org.apache.log4j.Logger", (Category)Logger.getLogger((String)"com.mycompany.mylogger"), new Date().getTime(), Level.DEBUG, (Object)"The quick brown fox jumped over the lazy dog", "Thread-1", tsr, "NDC string", li, hashTable);
    }

    private void initComponents() {
        this.editorToolbar.setFloatable(false);
        this.okCancelToolbar.setFloatable(false);
        this.okButton.setToolTipText("Accepts the current Pattern layout and will apply it to the Log Panel");
        this.cancelButton.setToolTipText("Closes this dialog and discards your changes");
        JTextComponentFormatter.applySystemFontAndSize(this.previewer);
        this.previewer.setEditable(false);
        this.patternEditor.setPreferredSize(new Dimension(240, 240));
        this.patternEditor.setMaximumSize(new Dimension(320, 240));
        this.previewer.setPreferredSize(new Dimension(360, 240));
        this.patternEditorScroll.setViewportView(this.patternEditor);
        this.previewEditorScroll.setViewportView(this.previewer);
        this.patternEditor.setToolTipText("Edit the Pattern here");
        this.previewer.setToolTipText("The result of the layout of the pattern is shown here");
        this.patternEditorScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Pattern Editor"));
        this.previewEditorScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Pattern Preview"));
        this.editorToolbar.add(Box.createHorizontalGlue());
        this.okCancelToolbar.add(Box.createHorizontalGlue());
        this.okCancelToolbar.add(this.okButton);
        this.okCancelToolbar.addSeparator();
        this.okCancelToolbar.add(this.cancelButton);
        this.add(this.editorToolbar);
        this.add(this.patternEditorScroll);
        this.add(this.previewEditorScroll);
        this.add(this.okCancelToolbar);
    }

    public void setConversionPattern(String pattern) {
        this.patternEditor.setText(pattern);
    }

    public String getConversionPattern() {
        return this.patternEditor.getText();
    }

    public void addOkActionListener(ActionListener l) {
        this.okButton.addActionListener(l);
    }

    public void addCancelActionListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }

    public static void main(String[] args) {
        JDialog dialog = new JDialog((Frame)null, "Pattern Editor");
        dialog.getContentPane().add(new LayoutEditorPane());
        dialog.setResizable(true);
        dialog.setDefaultCloseOperation(2);
        dialog.setSize(new Dimension(640, 480));
        dialog.setVisible(true);
    }
}

