/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.plugins;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.prefs.SettingsManager;

public class PluginClassLoaderFactory {
    private final ClassLoader pluginClassLoader = PluginClassLoaderFactory.create(new File(SettingsManager.getInstance().getSettingsDirectory() + File.separator + "plugins"));
    private static final Logger logger = LogManager.getLogger((Class)(class$org$apache$log4j$chainsaw$plugins$PluginClassLoaderFactory == null ? (class$org$apache$log4j$chainsaw$plugins$PluginClassLoaderFactory = PluginClassLoaderFactory.class$("org.apache.log4j.chainsaw.plugins.PluginClassLoaderFactory")) : class$org$apache$log4j$chainsaw$plugins$PluginClassLoaderFactory));
    private static final PluginClassLoaderFactory instance = new PluginClassLoaderFactory();
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$plugins$PluginClassLoaderFactory;

    private PluginClassLoaderFactory() {
    }

    public static PluginClassLoaderFactory getInstance() {
        return instance;
    }

    public ClassLoader getClassLoader() {
        return this.pluginClassLoader;
    }

    private static final ClassLoader create(File pluginDirectory) {
        if (pluginDirectory == null || !pluginDirectory.exists() || !pluginDirectory.canRead()) {
            logger.error((Object)"pluginDirectory cannot be null, and it must exist and must be readable, using the normal Classloader");
            return (class$org$apache$log4j$chainsaw$plugins$PluginClassLoaderFactory == null ? (class$org$apache$log4j$chainsaw$plugins$PluginClassLoaderFactory = PluginClassLoaderFactory.class$("org.apache.log4j.chainsaw.plugins.PluginClassLoaderFactory")) : class$org$apache$log4j$chainsaw$plugins$PluginClassLoaderFactory).getClassLoader();
        }
        String[] strings = pluginDirectory.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".JAR");
            }
        });
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            list.add(pluginDirectory.toURI().toURL());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        if (strings != null) {
            for (int i = 0; i < strings.length; ++i) {
                String name = strings[i];
                File file = new File(pluginDirectory, name);
                try {
                    list.add(file.toURI().toURL());
                    logger.info((Object)("Added " + file.getAbsolutePath() + " to Plugin class loader list"));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to retrieve the URL for file: " + file.getAbsolutePath()));
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        ClassLoader parent = (class$org$apache$log4j$chainsaw$plugins$PluginClassLoaderFactory == null ? (class$org$apache$log4j$chainsaw$plugins$PluginClassLoaderFactory = PluginClassLoaderFactory.class$("org.apache.log4j.chainsaw.plugins.PluginClassLoaderFactory")) : class$org$apache$log4j$chainsaw$plugins$PluginClassLoaderFactory).getClassLoader();
        URL[] urls = list.toArray(new URL[list.size()]);
        return new URLClassLoader(urls, parent);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

