/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.prefs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.event.EventListenerList;
import org.apache.log4j.chainsaw.prefs.LoadSettingsEvent;
import org.apache.log4j.chainsaw.prefs.Profileable;
import org.apache.log4j.chainsaw.prefs.SaveSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SettingsListener;

public final class SettingsManager {
    private static final SettingsManager instance = new SettingsManager();
    private static final String GLOBAL_SETTINGS_FILE_NAME = "chainsaw.settings.properties";
    private static final String HEADER = "Chainsaws Settings Files";
    private EventListenerList listenerList = new EventListenerList();
    private Properties defaultProperties = new Properties();
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$prefs$SettingsListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SettingsManager() {
        InputStream is = null;
        try {
            is = this.getClass().getClassLoader().getResource("org/apache/log4j/chainsaw/prefs/default.properties").openStream();
            this.defaultProperties.load(is);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static final SettingsManager getInstance() {
        return instance;
    }

    public void addSettingsListener(SettingsListener listener) {
        this.listenerList.add(class$org$apache$log4j$chainsaw$prefs$SettingsListener == null ? (class$org$apache$log4j$chainsaw$prefs$SettingsListener = SettingsManager.class$("org.apache.log4j.chainsaw.prefs.SettingsListener")) : class$org$apache$log4j$chainsaw$prefs$SettingsListener, listener);
    }

    public void loadSettings() {
        File settingsDir = this.getSettingsDirectory();
        if (!settingsDir.exists()) {
            settingsDir.mkdir();
        }
        this.loadGlobalSettings();
        this.loadProfileableSettings();
    }

    private void loadProfileableSettings() {
        EventListener[] listeners = this.listenerList.getListeners(class$org$apache$log4j$chainsaw$prefs$SettingsListener == null ? (class$org$apache$log4j$chainsaw$prefs$SettingsListener = SettingsManager.class$("org.apache.log4j.chainsaw.prefs.SettingsListener")) : class$org$apache$log4j$chainsaw$prefs$SettingsListener);
        for (int i = 0; i < listeners.length; ++i) {
            SettingsListener settingsListener = (SettingsListener)listeners[i];
            if (!(settingsListener instanceof Profileable)) continue;
            Profileable p = (Profileable)settingsListener;
            this.loadProfileble(p);
        }
    }

    private void loadProfileble(Profileable p) {
        LoadSettingsEvent event = this.createProfilebleEvent(p);
        p.loadSettings(event);
    }

    private LoadSettingsEvent createProfilebleEvent(Profileable p) {
        Properties loadedProperties = new Properties();
        ((Hashtable)loadedProperties).putAll(this.getDefaultSettings());
        ((Hashtable)loadedProperties).putAll(this.loadProperties(p));
        LoadSettingsEvent event = new LoadSettingsEvent(this, loadedProperties);
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(Profileable p) {
        Properties properties = new Properties(this.defaultProperties);
        InputStream is = null;
        File f = new File(this.getSettingsDirectory(), URLEncoder.encode(p.getNamespace() + ".properties"));
        if (!f.exists()) {
            f = new File(this.getSettingsDirectory(), p.getNamespace() + ".properties");
        }
        if (f.exists()) {
            try {
                is = new BufferedInputStream(new FileInputStream(f));
                Properties toLoad = new Properties();
                toLoad.load(is);
                ((Hashtable)properties).putAll(toLoad);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return properties;
    }

    private void loadGlobalSettings() {
        EventListener[] listeners = this.listenerList.getListeners(class$org$apache$log4j$chainsaw$prefs$SettingsListener == null ? (class$org$apache$log4j$chainsaw$prefs$SettingsListener = SettingsManager.class$("org.apache.log4j.chainsaw.prefs.SettingsListener")) : class$org$apache$log4j$chainsaw$prefs$SettingsListener);
        LoadSettingsEvent event = null;
        for (int i = 0; i < listeners.length; ++i) {
            SettingsListener settingsListener = (SettingsListener)listeners[i];
            if (event == null) {
                Properties loadedProperties = this.loadGlobalProperties();
                event = new LoadSettingsEvent(this, loadedProperties);
            }
            settingsListener.loadSettings(event);
        }
    }

    public void saveSettings() {
        File settingsDir = this.getSettingsDirectory();
        if (!settingsDir.exists()) {
            settingsDir.mkdir();
        }
        this.saveGlobalSettings(settingsDir);
        this.saveProfileableSetting(settingsDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProfileableSetting(File settingsDir) {
        EventListener[] listeners = this.listenerList.getListeners(class$org$apache$log4j$chainsaw$prefs$SettingsListener == null ? (class$org$apache$log4j$chainsaw$prefs$SettingsListener = SettingsManager.class$("org.apache.log4j.chainsaw.prefs.SettingsListener")) : class$org$apache$log4j$chainsaw$prefs$SettingsListener);
        SaveSettingsEvent event = null;
        for (int i = 0; i < listeners.length; ++i) {
            SettingsListener settingsListener = (SettingsListener)listeners[i];
            if (!(settingsListener instanceof Profileable)) continue;
            Profileable profileable = (Profileable)settingsListener;
            event = new SaveSettingsEvent(this, this.getSettingsDirectory());
            profileable.saveSettings(event);
            OutputStream os = null;
            try {
                os = new BufferedOutputStream(new FileOutputStream(new File(settingsDir, URLEncoder.encode(profileable.getNamespace()) + ".properties")));
                event.getProperties().store(os, HEADER);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGlobalSettings(File settingsDir) {
        EventListener[] listeners = this.listenerList.getListeners(class$org$apache$log4j$chainsaw$prefs$SettingsListener == null ? (class$org$apache$log4j$chainsaw$prefs$SettingsListener = SettingsManager.class$("org.apache.log4j.chainsaw.prefs.SettingsListener")) : class$org$apache$log4j$chainsaw$prefs$SettingsListener);
        SaveSettingsEvent event = null;
        for (int i = 0; i < listeners.length; ++i) {
            SettingsListener settingsListener = (SettingsListener)listeners[i];
            if (settingsListener instanceof Profileable) continue;
            if (event == null) {
                event = new SaveSettingsEvent(this, this.getSettingsDirectory());
            }
            settingsListener.saveSettings(event);
        }
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(new File(settingsDir, GLOBAL_SETTINGS_FILE_NAME)));
            event.getProperties().store(os, HEADER);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public File getSettingsDirectory() {
        return new File(System.getProperty("user.home"), ".chainsaw");
    }

    public void configure(SettingsListener listener) {
        if (listener instanceof Profileable) {
            this.loadProfileble((Profileable)listener);
        } else {
            Properties loadedProperties = this.loadGlobalProperties();
            LoadSettingsEvent event = new LoadSettingsEvent(this, loadedProperties);
            listener.loadSettings(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadGlobalProperties() {
        Properties properties = new Properties(this.defaultProperties);
        InputStream is = null;
        File f = new File(this.getSettingsDirectory(), GLOBAL_SETTINGS_FILE_NAME);
        if (f.exists()) {
            try {
                is = new BufferedInputStream(new FileInputStream(f));
                Properties toLoad = new Properties();
                toLoad.load(is);
                ((Hashtable)properties).putAll(toLoad);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        return properties;
    }

    public Properties getDefaultSettings() {
        return this.defaultProperties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

