/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.receivers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.plugins.PluginClassLoaderFactory;

public class ReceiversHelper {
    private static final ReceiversHelper instance = new ReceiversHelper();
    private final Logger logger = LogManager.getLogger((Class)(class$org$apache$log4j$chainsaw$receivers$ReceiversHelper == null ? (class$org$apache$log4j$chainsaw$receivers$ReceiversHelper = ReceiversHelper.class$("org.apache.log4j.chainsaw.receivers.ReceiversHelper")) : class$org$apache$log4j$chainsaw$receivers$ReceiversHelper));
    private List receiverClassList = new ArrayList();
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$receivers$ReceiversHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReceiversHelper() {
        URL url = this.getClass().getClassLoader().getResource(this.getClass().getPackage().getName().replace('.', '/') + "/known.receivers");
        if (url == null) {
            this.logger.warn((Object)"Failed to locate known.receivers file");
            return;
        }
        BufferedReader stream = null;
        try {
            String line;
            stream = new LineNumberReader(new InputStreamReader(url.openStream()));
            ClassLoader classLoader = PluginClassLoaderFactory.getInstance().getClassLoader();
            while ((line = ((LineNumberReader)stream).readLine()) != null) {
                try {
                    if (line.startsWith("#") || line.length() == 0) continue;
                    Class<?> receiverClass = classLoader.loadClass(line);
                    this.receiverClassList.add(receiverClass);
                    this.logger.debug((Object)("Located known Receiver class " + receiverClass.getName()));
                }
                catch (ClassNotFoundException e) {
                    this.logger.warn((Object)("Failed to locate Receiver class:" + line));
                }
                catch (NoClassDefFoundError e) {
                    this.logger.error((Object)("Failed to locate Receiver class:" + line + ", looks like a dependent class is missing from the classpath"), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    public static ReceiversHelper getInstance() {
        return instance;
    }

    public List getKnownReceiverClasses() {
        return Collections.unmodifiableList(this.receiverClassList);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

