/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.receivers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.PopupListener;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.help.HelpManager;
import org.apache.log4j.chainsaw.helper.SwingHelper;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.icons.LevelIconFactory;
import org.apache.log4j.chainsaw.icons.LineIconFactory;
import org.apache.log4j.chainsaw.messages.MessageCenter;
import org.apache.log4j.chainsaw.prefs.LoadSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SaveSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SettingsListener;
import org.apache.log4j.chainsaw.prefs.SettingsManager;
import org.apache.log4j.chainsaw.receivers.NewReceiverDialogPanel;
import org.apache.log4j.chainsaw.receivers.PluginPropertyEditorPanel;
import org.apache.log4j.chainsaw.receivers.ReceiverTreeCellRenderer;
import org.apache.log4j.chainsaw.receivers.ReceiversHelper;
import org.apache.log4j.chainsaw.receivers.ReceiversTreeModel;
import org.apache.log4j.chainsaw.receivers.VisualReceiver;
import org.apache.log4j.net.SocketNodeEventListener;
import org.apache.log4j.net.SocketReceiver;
import org.apache.log4j.plugins.Pauseable;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.PluginEvent;
import org.apache.log4j.plugins.PluginListener;
import org.apache.log4j.plugins.PluginRegistry;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggerRepositoryEx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReceiversPanel
extends JPanel
implements SettingsListener {
    final Action newReceiverButtonAction;
    final Action pauseReceiverButtonAction;
    final Action playReceiverButtonAction;
    final Action shutdownReceiverButtonAction;
    final Action restartReceiverButtonAction;
    private final Action showReceiverHelpAction;
    private final Action startAllAction;
    private final JPopupMenu popupMenu = new ReceiverPopupMenu();
    private final JTree receiversTree = new JTree();
    private final NewReceiverPopupMenu newReceiverPopup = new NewReceiverPopupMenu();
    private final ReceiverToolbar buttonPanel;
    private final JSplitPane splitter = new JSplitPane();
    private final PluginPropertyEditorPanel pluginEditorPanel = new PluginPropertyEditorPanel();
    private final Logger logger = LogManager.getLogger((Class)(class$org$apache$log4j$chainsaw$receivers$ReceiversPanel == null ? (class$org$apache$log4j$chainsaw$receivers$ReceiversPanel = ReceiversPanel.class$("org.apache.log4j.chainsaw.receivers.ReceiversPanel")) : class$org$apache$log4j$chainsaw$receivers$ReceiversPanel));
    private final PluginRegistry pluginRegistry;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$receivers$ReceiversPanel;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$receivers$VisualReceiver;
    static /* synthetic */ Class class$org$apache$log4j$plugins$Receiver;
    static /* synthetic */ Class class$org$apache$log4j$net$SocketReceiver;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public ReceiversPanel() {
        super(new BorderLayout());
        LoggerRepository repo = LogManager.getLoggerRepository();
        final ReceiversTreeModel model = new ReceiversTreeModel();
        if (repo instanceof LoggerRepositoryEx) {
            this.pluginRegistry = ((LoggerRepositoryEx)repo).getPluginRegistry();
            this.pluginRegistry.addPluginListener((PluginListener)model);
            List c = this.pluginRegistry.getPlugins(class$org$apache$log4j$chainsaw$receivers$VisualReceiver == null ? (class$org$apache$log4j$chainsaw$receivers$VisualReceiver = ReceiversPanel.class$("org.apache.log4j.chainsaw.receivers.VisualReceiver")) : class$org$apache$log4j$chainsaw$receivers$VisualReceiver);
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                ((VisualReceiver)iter.next()).setContainer(this);
            }
            this.pluginRegistry.addPluginListener(new PluginListener(){

                public void pluginStarted(PluginEvent e) {
                    if (e.getPlugin() instanceof VisualReceiver) {
                        ((VisualReceiver)e.getPlugin()).setContainer(ReceiversPanel.this);
                    }
                }

                public void pluginStopped(PluginEvent e) {
                }
            });
        } else {
            this.pluginRegistry = null;
        }
        this.receiversTree.setModel(model);
        this.receiversTree.setExpandsSelectedPaths(true);
        model.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
                this.expandRoot();
            }

            public void treeNodesInserted(TreeModelEvent e) {
                this.expandRoot();
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                this.expandRoot();
            }

            public void treeStructureChanged(TreeModelEvent e) {
                this.expandRoot();
            }

            private void expandRoot() {
                ReceiversPanel.this.receiversTree.expandPath(new TreePath(model.getPathToRoot(model.RootNode)));
            }
        });
        this.receiversTree.expandPath(new TreePath(model.getPathToRoot(model.RootNode)));
        this.receiversTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                if (event.getPath().getLastPathComponent() == model.RootNode) {
                    throw new ExpandVetoException(event);
                }
            }

            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        this.receiversTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node != null && node.getUserObject() != null && node.getUserObject() instanceof Plugin) {
                        Plugin p = (Plugin)node.getUserObject();
                        ReceiversPanel.this.logger.debug((Object)("plugin=" + p));
                        ReceiversPanel.this.pluginEditorPanel.setPlugin(p);
                    } else {
                        ReceiversPanel.this.pluginEditorPanel.setPlugin(null);
                    }
                }
            }
        });
        this.receiversTree.setToolTipText("Log4j\u30ec\u30b7\u30fc\u30d0\u30fc\u306e\u7ba1\u7406");
        this.newReceiverButtonAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReceiversPanel.this.newReceiverPopup.show(((ReceiversPanel)ReceiversPanel.this).buttonPanel.newReceiverButton, 0, ((ReceiversPanel)ReceiversPanel.this).buttonPanel.newReceiverButton.getHeight());
            }
        };
        this.newReceiverButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ICON_NEW_RECEIVER));
        this.newReceiverButtonAction.putValue("ShortDescription", "\u65b0\u3057\u3044\u30ec\u30b7\u30fc\u30d0\u30fc\u306e\u4f5c\u6210\u306e\u8a2d\u5b9a");
        this.newReceiverButtonAction.putValue("Name", "\u65b0\u898f\u30ec\u30b7\u30fc\u30d0\u30fc");
        this.newReceiverButtonAction.putValue("MnemonicKey", new Integer(78));
        this.newReceiverButtonAction.setEnabled(true);
        this.playReceiverButtonAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReceiversPanel.this.playCurrentlySelectedReceiver();
            }
        };
        this.playReceiverButtonAction.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u30ce\u30fc\u30c9\u3092\u518d\u958b");
        this.playReceiverButtonAction.putValue("Name", "Resume");
        this.playReceiverButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ICON_RESUME_RECEIVER));
        this.playReceiverButtonAction.setEnabled(false);
        this.playReceiverButtonAction.putValue("MnemonicKey", new Integer(82));
        this.pauseReceiverButtonAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReceiversPanel.this.pauseCurrentlySelectedReceiver();
            }
        };
        this.pauseReceiverButtonAction.putValue("ShortDescription", "\u9078\u629e\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u505c\u6b62\u3059\u308b\u3002\u53d7\u4fe1\u3057\u305f\u3059\u3079\u3066\u306e\u30a4\u30d9\u30f3\u30c8\u306f\u653e\u68c4\u3055\u308c\u307e\u3059\u3002");
        this.pauseReceiverButtonAction.putValue("Name", "Pause");
        this.pauseReceiverButtonAction.putValue("MnemonicKey", new Integer(80));
        this.pauseReceiverButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.PAUSE));
        this.pauseReceiverButtonAction.setEnabled(false);
        this.shutdownReceiverButtonAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReceiversPanel.this.shutdownCurrentlySelectedReceiver();
            }
        };
        this.shutdownReceiverButtonAction.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u7d42\u4e86\u3057\u3001Plugin\u30ec\u30b8\u30b9\u30c8\u30ea\u304b\u3089\u524a\u9664\u3059\u308b");
        this.shutdownReceiverButtonAction.putValue("Name", "Shutdown");
        this.shutdownReceiverButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ICON_STOP_RECEIVER));
        this.shutdownReceiverButtonAction.putValue("MnemonicKey", new Integer(83));
        this.shutdownReceiverButtonAction.setEnabled(false);
        this.restartReceiverButtonAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Receiver selectedReceiver = ReceiversPanel.this.getCurrentlySelectedReceiver();
                if (selectedReceiver == null) {
                    return;
                }
                selectedReceiver.shutdown();
                selectedReceiver.activateOptions();
                if (selectedReceiver instanceof VisualReceiver) {
                    ((VisualReceiver)selectedReceiver).setContainer(ReceiversPanel.this);
                }
            }
        };
        this.restartReceiverButtonAction.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u518d\u8d77\u52d5\u3059\u308b");
        this.restartReceiverButtonAction.putValue("Name", "Restart");
        this.restartReceiverButtonAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ICON_RESTART));
        this.restartReceiverButtonAction.putValue("MnemonicKey", new Integer(82));
        this.restartReceiverButtonAction.setEnabled(false);
        this.showReceiverHelpAction = new AbstractAction("\u30d8\u30eb\u30d7"){

            public void actionPerformed(ActionEvent e) {
                Receiver receiver = ReceiversPanel.this.getCurrentlySelectedReceiver();
                if (receiver != null) {
                    HelpManager.getInstance().showHelpForClass(receiver.getClass());
                }
            }
        };
        this.showReceiverHelpAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.HELP));
        this.showReceiverHelpAction.putValue("ShortDescription", "\u3053\u306e\u30d7\u30e9\u30b0\u30a4\u30f3\u306eJavaDoc\u3092\u8868\u793a\u3059\u308b");
        this.startAllAction = new AbstractAction("(Re)start All Receivers", new ImageIcon(ChainsawIcons.ICON_RESTART_ALL)){

            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(null, "\u6a5f\u80fd\u4e2d\u306e\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u505c\u6b62\u3057\u3001\u5207\u65ad\u3057\u307e\u3059\u3002\u7d99\u7d9a\u3057\u307e\u3059\u304b\uff1f", "\u78ba\u8a8d", 2) == 0) {
                    new Thread(new Runnable(){

                        public void run() {
                            List allReceivers = ReceiversPanel.this.pluginRegistry.getPlugins(class$org$apache$log4j$plugins$Receiver == null ? (class$org$apache$log4j$plugins$Receiver = ReceiversPanel.class$("org.apache.log4j.plugins.Receiver")) : class$org$apache$log4j$plugins$Receiver);
                            Iterator iter = allReceivers.iterator();
                            while (iter.hasNext()) {
                                Receiver item = (Receiver)iter.next();
                                item.shutdown();
                                item.activateOptions();
                            }
                            ReceiversPanel.this.updateReceiverTreeInDispatchThread();
                            MessageCenter.getInstance().getLogger().info((Object)"\u3059\u3079\u3066\u306e\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u8d77\u52d5\uff0f\u518d\u8d77\u52d5\u3057\u307e\u3057\u305f\u3002");
                        }
                    }).start();
                }
            }
        };
        this.startAllAction.putValue("ShortDescription", "\u8d77\u52d5\u3057\u3066\u3044\u306a\u3044\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u8d77\u52d5\u3057\u3001\u8d77\u52d5\u3057\u305f\u51e6\u7406\u3092\u505c\u6b62\u3057\u3001\u518d\u8d77\u52d5\u3059\u308b");
        this.receiversTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.receiversTree.setCellRenderer(new ReceiverTreeCellRenderer());
        this.receiversTree.setRowHeight(19);
        this.buttonPanel = new ReceiverToolbar();
        this.receiversTree.addTreeSelectionListener(this.buttonPanel);
        PopupListener popupListener = new PopupListener(this.popupMenu);
        this.receiversTree.addMouseListener(popupListener);
        this.addMouseListener(popupListener);
        JTree component = this.receiversTree;
        JScrollPane pane = new JScrollPane(component);
        this.splitter.setOrientation(0);
        this.splitter.setTopComponent(pane);
        this.splitter.setBottomComponent(this.pluginEditorPanel);
        this.splitter.setResizeWeight(0.7);
        this.add((Component)this.buttonPanel, "North");
        this.add((Component)this.splitter, "Center");
        SocketNodeEventListener listener = new SocketNodeEventListener(){

            public void socketOpened(String remoteInfo) {
                ReceiversPanel.this.updateReceiverTreeInDispatchThread();
            }

            public void socketClosedEvent(Exception e) {
                ReceiversPanel.this.updateReceiverTreeInDispatchThread();
            }
        };
        if (this.pluginRegistry != null) {
            List socketReceivers = this.pluginRegistry.getPlugins(class$org$apache$log4j$net$SocketReceiver == null ? (class$org$apache$log4j$net$SocketReceiver = ReceiversPanel.class$("org.apache.log4j.net.SocketReceiver")) : class$org$apache$log4j$net$SocketReceiver);
            Iterator iter = socketReceivers.iterator();
            while (iter.hasNext()) {
                SocketReceiver element = (SocketReceiver)iter.next();
                element.addSocketNodeEventListener(listener);
            }
        }
    }

    protected ReceiversTreeModel getReceiverTreeModel() {
        return (ReceiversTreeModel)this.receiversTree.getModel();
    }

    protected void updateCurrentlySelectedNodeInDispatchThread() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)ReceiversPanel.this.receiversTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                ReceiversPanel.this.getReceiverTreeModel().nodeChanged(node);
                ReceiversPanel.this.updateActions();
            }
        });
    }

    private Receiver getCurrentlySelectedReceiver() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.receiversTree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        Object userObject = node.getUserObject();
        if (userObject instanceof Receiver) {
            return (Receiver)userObject;
        }
        return null;
    }

    private Receiver[] getSelectedReceivers() {
        TreePath[] paths = this.receiversTree.getSelectionPaths();
        ArrayList<Object> receivers = new ArrayList<Object>();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node == null || !(node.getUserObject() instanceof Receiver)) continue;
            receivers.add(node.getUserObject());
        }
        return receivers.toArray(new Receiver[0]);
    }

    private Object getCurrentlySelectedUserObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.receiversTree.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        return node.getUserObject();
    }

    private void pauseCurrentlySelectedReceiver() {
        new Thread(new Runnable(){

            public void run() {
                Object obj = ReceiversPanel.this.getCurrentlySelectedUserObject();
                if (obj != null && obj instanceof Pauseable) {
                    ((Pauseable)obj).setPaused(true);
                    ReceiversPanel.this.updateCurrentlySelectedNodeInDispatchThread();
                }
            }
        }).start();
    }

    private void playCurrentlySelectedReceiver() {
        new Thread(new Runnable(){

            public void run() {
                Object obj = ReceiversPanel.this.getCurrentlySelectedUserObject();
                if (obj != null && obj instanceof Pauseable) {
                    ((Pauseable)obj).setPaused(false);
                    ReceiversPanel.this.updateCurrentlySelectedNodeInDispatchThread();
                }
            }
        }).start();
    }

    private void shutdownCurrentlySelectedReceiver() {
        if (JOptionPane.showConfirmDialog(null, "\u3053\u306e\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u7d42\u4e86\u3057\u307e\u3059\u304b\uff1f\n\n\u30cd\u30c3\u30c8\u30ef\u30fc\u30af\u30ea\u30bd\u30fc\u30b9\u3092\u5207\u65ad\u3057\u3001PluginRegistry\u304b\u3089\u524a\u9664\u3059\u308b\u3002", "\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u505c\u6b62\u3059\u308b", 0) == 0) {
            new Thread(new Runnable(){

                public void run() {
                    Receiver[] receivers = ReceiversPanel.this.getSelectedReceivers();
                    if (receivers != null) {
                        for (int i = 0; i < receivers.length; ++i) {
                            ReceiversPanel.this.pluginRegistry.stopPlugin(receivers[i].getName());
                        }
                    }
                }
            }).start();
        }
    }

    private void updateActions() {
        Object object = this.getCurrentlySelectedUserObject();
        if (object != null && object instanceof Pauseable) {
            Pauseable pauseable = (Pauseable)object;
            if (!pauseable.isPaused()) {
                this.pauseReceiverButtonAction.setEnabled(true);
                this.playReceiverButtonAction.setEnabled(false);
            } else {
                this.pauseReceiverButtonAction.setEnabled(false);
                this.playReceiverButtonAction.setEnabled(true);
            }
        } else {
            this.pauseReceiverButtonAction.setEnabled(false);
            this.playReceiverButtonAction.setEnabled(false);
        }
        if (object instanceof Receiver) {
            this.newReceiverButtonAction.setEnabled(true);
            this.shutdownReceiverButtonAction.setEnabled(true);
            this.restartReceiverButtonAction.setEnabled(true);
        } else {
            this.shutdownReceiverButtonAction.setEnabled(false);
            this.restartReceiverButtonAction.setEnabled(false);
        }
    }

    public void updateReceiverTreeInDispatchThread() {
        this.logger.debug((Object)"updateReceiverTreeInDispatchThread\u306f\u3082\u3046\u4e0d\u8981\u3067\u3059");
    }

    public void setVisible(boolean aFlag) {
        boolean oldValue = this.isVisible();
        super.setVisible(aFlag);
        this.firePropertyChange("visible", oldValue, this.isVisible());
    }

    public void loadSettings(LoadSettingsEvent event) {
    }

    public void saveSettings(SaveSettingsEvent event) {
        List fullPluginList = this.pluginRegistry.getPlugins();
        ArrayList<Plugin> pluginList = new ArrayList<Plugin>();
        Iterator iter = fullPluginList.iterator();
        while (iter.hasNext()) {
            Plugin thisPlugin = (Plugin)iter.next();
            if (!(thisPlugin instanceof Receiver)) continue;
            pluginList.add(thisPlugin);
        }
        try {
            if (pluginList.size() > 0) {
                File file = new File(SettingsManager.getInstance().getSettingsDirectory(), "receiver-config.xml");
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.newDocument();
                Element rootElement = document.createElementNS("http://jakarta.apache.org/log4j/", "configuration");
                rootElement.setPrefix("log4j");
                rootElement.setAttribute("xmlns:log4j", "http://jakarta.apache.org/log4j/");
                rootElement.setAttribute("debug", "true");
                for (int i = 0; i < pluginList.size(); ++i) {
                    if (!(pluginList.get(i) instanceof Receiver)) continue;
                    Receiver receiver = (Receiver)pluginList.get(i);
                    Element pluginElement = document.createElement("plugin");
                    pluginElement.setAttribute("name", receiver.getName());
                    pluginElement.setAttribute("class", receiver.getClass().getName());
                    BeanInfo beanInfo = Introspector.getBeanInfo(receiver.getClass());
                    ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(Arrays.asList(beanInfo.getPropertyDescriptors()));
                    for (int j = 0; j < list.size(); ++j) {
                        Object o;
                        PropertyDescriptor d = (PropertyDescriptor)list.get(j);
                        if (d.getReadMethod().getName().equals("getLoggerRepository") || (o = d.getReadMethod().invoke((Object)receiver, new Object[0])) == null) continue;
                        Element paramElement = document.createElement("param");
                        paramElement.setAttribute("name", d.getName());
                        paramElement.setAttribute("value", o.toString());
                        pluginElement.appendChild(paramElement);
                    }
                    rootElement.appendChild(pluginElement);
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                DOMSource source = new DOMSource(rootElement);
                FileOutputStream stream = new FileOutputStream(file);
                StreamResult result = new StreamResult(stream);
                transformer.transform(source, result);
                stream.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306b\u30ec\u30b7\u30fc\u30d0\u30fc\u306e\u8a2d\u5b9a\u3092\u66f8\u304d\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ReceiverToolbar
    extends JToolBar
    implements TreeSelectionListener {
        final SmallButton newReceiverButton;

        private ReceiverToolbar() {
            this.setFloatable(false);
            SmallButton restartReceiverButton = new SmallButton(ReceiversPanel.this.restartReceiverButtonAction);
            restartReceiverButton.setText(null);
            SmallButton shutdownReceiverButton = new SmallButton(ReceiversPanel.this.shutdownReceiverButtonAction);
            shutdownReceiverButton.setText(null);
            SmallButton restartAllButton = new SmallButton(ReceiversPanel.this.startAllAction);
            restartAllButton.setText(null);
            this.newReceiverButton = new SmallButton(ReceiversPanel.this.newReceiverButtonAction);
            this.newReceiverButton.setText(null);
            this.newReceiverButton.addMouseListener(new PopupListener(ReceiversPanel.this.newReceiverPopup));
            this.add(this.newReceiverButton);
            this.add(restartAllButton);
            this.addSeparator();
            this.add(restartReceiverButton);
            this.add(shutdownReceiverButton);
            this.addSeparator();
            AbstractAction closeAction = new AbstractAction(null, LineIconFactory.createCloseIcon()){

                public void actionPerformed(ActionEvent e) {
                    ReceiversPanel.this.setVisible(false);
                }
            };
            closeAction.putValue("ShortDescription", "\u30ec\u30b7\u30fc\u30d0\u30fc\u30d1\u30cd\u30eb\u3092\u9589\u3058\u308b");
            this.add(Box.createHorizontalGlue());
            this.add(new SmallButton(closeAction));
            this.add(Box.createHorizontalStrut(5));
        }

        public void valueChanged(TreeSelectionEvent e) {
            ReceiversPanel.this.updateActions();
        }
    }

    class ReceiverPopupMenu
    extends JPopupMenu {
        ReceiverPopupMenu() {
        }

        public void show(Component invoker, int x, int y) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)ReceiversPanel.this.receiversTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            Object userObject = node.getUserObject();
            this.removeAll();
            if (userObject == this.getRootOfTree().getUserObject()) {
                this.buildForReceiversRoot();
            } else if (ReceiversPanel.this.getCurrentlySelectedReceiver() != null) {
                this.buildForReceiverNode();
            } else {
                return;
            }
            this.invalidate();
            this.validate();
            super.show(invoker, x, y);
        }

        private DefaultMutableTreeNode getRootOfTree() {
            return (DefaultMutableTreeNode)ReceiversPanel.this.receiversTree.getModel().getRoot();
        }

        private void buildForReceiverNode() {
            this.add(ReceiversPanel.this.playReceiverButtonAction);
            this.add(ReceiversPanel.this.pauseReceiverButtonAction);
            this.add(ReceiversPanel.this.restartReceiverButtonAction);
            this.add(ReceiversPanel.this.shutdownReceiverButtonAction);
            this.addSeparator();
            Receiver r = ReceiversPanel.this.getCurrentlySelectedReceiver();
            this.add(this.createLevelRadioButton(r, Level.TRACE));
            this.add(this.createLevelRadioButton(r, Level.DEBUG));
            this.add(this.createLevelRadioButton(r, Level.INFO));
            this.add(this.createLevelRadioButton(r, Level.WARN));
            this.add(this.createLevelRadioButton(r, Level.ERROR));
            this.addSeparator();
            this.add(this.createLevelRadioButton(r, Level.OFF));
            this.add(this.createLevelRadioButton(r, Level.ALL));
            this.addSeparator();
            this.add(ReceiversPanel.this.showReceiverHelpAction);
        }

        private JRadioButtonMenuItem createLevelRadioButton(final Receiver r, final Level l) {
            Map levelIconMap = LevelIconFactory.getInstance().getLevelToIconMap();
            AbstractAction action = new AbstractAction(l.toString(), (Icon)levelIconMap.get(l.toString())){

                public void actionPerformed(ActionEvent e) {
                    if (r != null) {
                        r.setThreshold(l);
                        ReceiversPanel.this.updateCurrentlySelectedNodeInDispatchThread();
                    }
                }
            };
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(action);
            item.setSelected(r.getThreshold() == l);
            return item;
        }

        private void buildForReceiversRoot() {
            JMenuItem startAll = new JMenuItem(ReceiversPanel.this.startAllAction);
            this.add(ReceiversPanel.this.newReceiverButtonAction);
            this.addSeparator();
            this.add(startAll);
        }
    }

    class NewReceiverPopupMenu
    extends JPopupMenu {
        NewReceiverPopupMenu() {
            try {
                List receiverList = ReceiversHelper.getInstance().getKnownReceiverClasses();
                String separatorCheck = null;
                Iterator iter = receiverList.iterator();
                while (iter.hasNext()) {
                    final Class toCreate = (Class)iter.next();
                    Package thePackage = toCreate.getPackage();
                    String name = toCreate.getName().substring(thePackage.getName().length() + 1);
                    if (separatorCheck == null) {
                        separatorCheck = name.substring(0, 1);
                    } else {
                        String current = name.substring(0, 1);
                        if (!current.equals(separatorCheck)) {
                            this.addSeparator();
                            separatorCheck = current;
                        }
                    }
                    this.add(new AbstractAction("\u65b0\u898f " + name + "..."){

                        public void actionPerformed(ActionEvent e) {
                            Container container = SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ReceiversPanel.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, ReceiversPanel.this);
                            final JDialog dialog = new JDialog((JFrame)container, "\u65b0\u898f " + toCreate.getName() + "...", true);
                            try {
                                final NewReceiverDialogPanel panel = NewReceiverDialogPanel.create(toCreate);
                                dialog.getContentPane().add(panel);
                                dialog.pack();
                                SwingHelper.centerOnScreen(dialog);
                                dialog.getRootPane().setDefaultButton(panel.getOkPanel().getOkButton());
                                SwingHelper.configureCancelForDialog(dialog, panel.getOkPanel().getCancelButton());
                                panel.getOkPanel().getOkButton().addActionListener(new ActionListener(){

                                    public void actionPerformed(ActionEvent e2) {
                                        Plugin plugin = panel.getPlugin();
                                        if (plugin.getName() != null && !plugin.getName().trim().equals("")) {
                                            dialog.dispose();
                                            ReceiversPanel.this.pluginRegistry.addPlugin(plugin);
                                            plugin.activateOptions();
                                            MessageCenter.getInstance().addMessage("\u30d7\u30e9\u30b0\u30a4\u30f3" + plugin.getName() + "\u300d\u3092\u8d77\u52d5\u3057\u307e\u3057\u305f");
                                        } else {
                                            MessageCenter.getInstance().getLogger().error((Object)"\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u4f5c\u6210\u3059\u308b\u306e\u306b\u5fc5\u8981\u306a\u540d\u524d");
                                        }
                                    }
                                });
                                dialog.setVisible(true);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                MessageCenter.getInstance().getLogger().error((Object)"\u65b0\u3057\u3044\u30ec\u30b7\u30fc\u30d0\u30fc\u30c0\u30a4\u30a2\u30ed\u30b0\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e1);
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

