/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.vfs;

import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.provider.URLFileName;
import org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs.util.RandomAccessMode;
import org.apache.log4j.chainsaw.receivers.VisualReceiver;
import org.apache.log4j.plugins.PluginSkeleton;
import org.apache.log4j.varia.LogFilePatternReceiver;

public class VFSLogFilePatternReceiver
extends LogFilePatternReceiver
implements VisualReceiver {
    private boolean promptForUserInfo = false;
    private Container container;
    private Object waitForContainerLock = new Object();
    private String password;
    private boolean autoReconnect;
    private VFSReader vfsReader;
    static /* synthetic */ Class class$java$awt$Frame;

    public void shutdown() {
        this.getLogger().info((Object)"shutdown VFSLogFilePatternReceiver");
        ((PluginSkeleton)this).active = false;
        this.container = null;
        if (this.vfsReader != null) {
            this.vfsReader.terminate();
            this.vfsReader = null;
        }
    }

    public void setPromptForUserInfo(boolean promptForUserInfo) {
        this.promptForUserInfo = promptForUserInfo;
    }

    public boolean isPromptForUserInfo() {
        return this.promptForUserInfo;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainer(Container container) {
        if (this.promptForUserInfo) {
            Object object = this.waitForContainerLock;
            synchronized (object) {
                this.container = container;
                this.waitForContainerLock.notify();
            }
        }
    }

    public void activateOptions() {
        ((PluginSkeleton)this).active = true;
        if (this.promptForUserInfo && this.getFileURL().indexOf("@") == -1) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Frame containerFrame1;
                    Object object = VFSLogFilePatternReceiver.this.waitForContainerLock;
                    synchronized (object) {
                        while (VFSLogFilePatternReceiver.this.container == null) {
                            try {
                                VFSLogFilePatternReceiver.this.waitForContainerLock.wait(1000L);
                                VFSLogFilePatternReceiver.this.getLogger().debug((Object)"waiting for setContainer call");
                            }
                            catch (InterruptedException ie) {}
                        }
                    }
                    if (VFSLogFilePatternReceiver.this.container instanceof Frame) {
                        containerFrame1 = (Frame)VFSLogFilePatternReceiver.this.container;
                    } else {
                        Object ie = VFSLogFilePatternReceiver.this.waitForContainerLock;
                        synchronized (ie) {
                            while ((containerFrame1 = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? VFSLogFilePatternReceiver.class$("java.awt.Frame") : class$java$awt$Frame, VFSLogFilePatternReceiver.this.container)) == null) {
                                try {
                                    VFSLogFilePatternReceiver.this.waitForContainerLock.wait(1000L);
                                    VFSLogFilePatternReceiver.this.getLogger().debug((Object)"waiting for container's frame to be available");
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    }
                    final Frame containerFrame = containerFrame1;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Frame owner = null;
                            if (VFSLogFilePatternReceiver.this.container != null) {
                                owner = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = VFSLogFilePatternReceiver.class$("java.awt.Frame")) : class$java$awt$Frame, containerFrame);
                            }
                            UserNamePasswordDialog f = new UserNamePasswordDialog(owner);
                            f.pack();
                            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                            ((Component)f).setLocation(d.width / 2, d.height / 2);
                            f.setVisible(true);
                            if (null == f.getUserName() || null == f.getPassword()) {
                                VFSLogFilePatternReceiver.this.getLogger().info((Object)"Username and password not both provided, not using credentials");
                            } else {
                                String oldURL = VFSLogFilePatternReceiver.this.getFileURL();
                                int index = oldURL.indexOf("://");
                                String firstPart = oldURL.substring(0, index);
                                String lastPart = oldURL.substring(index + "://".length());
                                VFSLogFilePatternReceiver.this.setFileURL(firstPart + "://" + f.getUserName() + ":" + new String(f.getPassword()) + "@" + lastPart);
                                VFSLogFilePatternReceiver.this.setHost(oldURL.substring(0, index + "://".length()));
                                VFSLogFilePatternReceiver.this.setPath(oldURL.substring(index + "://".length()));
                            }
                            VFSLogFilePatternReceiver.this.vfsReader = new VFSReader();
                            new Thread(VFSLogFilePatternReceiver.this.vfsReader).start();
                        }
                    });
                }
            }).start();
        } else {
            String oldURL = this.getFileURL();
            if (oldURL != null) {
                int index = oldURL.indexOf("://");
                String lastPart = oldURL.substring(index + "://".length());
                int passEndIndex = lastPart.indexOf("@");
                if (passEndIndex > -1) {
                    int passBeginIndex = lastPart.indexOf(":");
                    this.password = lastPart.substring(passBeginIndex + 1, passEndIndex);
                    this.setHost(oldURL.substring(0, index + "://".length()));
                    this.setPath(lastPart.substring(passEndIndex + 1));
                }
                this.vfsReader = new VFSReader();
                new Thread(this.vfsReader).start();
            } else {
                this.getLogger().info((Object)"null URL - unable to parse file");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private final String thisPassword;

        public MyUserInfo(String thisPassword) {
            this.thisPassword = thisPassword;
        }

        public String[] promptKeyboardInteractive(String destination, String loginName, String instruction, String[] prompt, boolean[] echo) {
            return new String[]{this.thisPassword};
        }

        public String getPassphrase() {
            return null;
        }

        public String getPassword() {
            return null;
        }

        public boolean promptPassphrase(String arg0) {
            return false;
        }

        public boolean promptPassword(String arg0) {
            return false;
        }

        public boolean promptYesNo(String arg0) {
            return false;
        }

        public void showMessage(String arg0) {
        }
    }

    public class UserNamePasswordDialog
    extends JDialog {
        private String userName;
        private char[] password;

        private UserNamePasswordDialog(Frame containerFrame) {
            super(containerFrame, "Login", true);
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 0;
            gc.anchor = 11;
            gc.gridx = 0;
            gc.gridy = 0;
            gc.gridwidth = 3;
            gc.insets = new Insets(7, 7, 7, 7);
            panel.add((Component)new JLabel("URI: " + VFSLogFilePatternReceiver.this.getFileURL()), gc);
            gc.gridx = 0;
            gc.gridy = 1;
            gc.gridwidth = 1;
            gc.insets = new Insets(2, 2, 2, 2);
            panel.add((Component)new JLabel("Username"), gc);
            gc.gridx = 1;
            gc.gridy = 1;
            gc.gridwidth = 2;
            gc.weightx = 1.0;
            gc.fill = 2;
            final JTextField userNameTextField = new JTextField(15);
            panel.add((Component)userNameTextField, gc);
            gc.gridx = 0;
            gc.gridy = 2;
            gc.gridwidth = 1;
            gc.fill = 0;
            panel.add((Component)new JLabel("Password"), gc);
            gc.gridx = 1;
            gc.gridy = 2;
            gc.gridwidth = 2;
            gc.fill = 2;
            final JPasswordField passwordTextField = new JPasswordField(15);
            panel.add((Component)passwordTextField, gc);
            gc.gridy = 3;
            gc.anchor = 15;
            gc.fill = 0;
            JButton submitButton = new JButton(" Submit ");
            panel.add((Component)submitButton, gc);
            this.getContentPane().add(panel);
            submitButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    UserNamePasswordDialog.this.userName = userNameTextField.getText();
                    UserNamePasswordDialog.access$3402(UserNamePasswordDialog.this, passwordTextField.getPassword());
                    UserNamePasswordDialog.this.getContentPane().setVisible(false);
                    UserNamePasswordDialog.this.dispose();
                }
            });
        }

        public String getUserName() {
            return this.userName;
        }

        public char[] getPassword() {
            return this.password;
        }

        static /* synthetic */ char[] access$3402(UserNamePasswordDialog x0, char[] x1) {
            x0.password = x1;
            return x1;
        }
    }

    private class VFSReader
    implements Runnable {
        private boolean terminated = false;
        private Reader reader;
        private FileObject fileObject;

        private VFSReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.reader == null && !this.terminated) {
                int atIndex = VFSLogFilePatternReceiver.this.getFileURL().indexOf("@");
                int protocolIndex = VFSLogFilePatternReceiver.this.getFileURL().indexOf("://");
                String loggableFileURL = atIndex > -1 ? VFSLogFilePatternReceiver.this.getFileURL().substring(0, protocolIndex + "://".length()) + "username:password" + VFSLogFilePatternReceiver.this.getFileURL().substring(atIndex) : VFSLogFilePatternReceiver.this.getFileURL();
                VFSLogFilePatternReceiver.this.getLogger().info((Object)("attempting to load file: " + loggableFileURL));
                try {
                    FileSystemManager fileSystemManager = VFS.getManager();
                    FileSystemOptions opts = new FileSystemOptions();
                    try {
                        SftpFileSystemConfigBuilder.getInstance().setStrictHostKeyChecking(opts, "no");
                        SftpFileSystemConfigBuilder.getInstance().setUserInfo(opts, (UserInfo)new MyUserInfo(VFSLogFilePatternReceiver.this.password));
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        VFSLogFilePatternReceiver.this.getLogger().warn((Object)"JSch not on classpath!", (Throwable)ncdfe);
                    }
                    this.fileObject = fileSystemManager.resolveFile(VFSLogFilePatternReceiver.this.getFileURL(), opts);
                    if (this.fileObject.exists()) {
                        this.reader = new InputStreamReader(this.fileObject.getContent().getInputStream());
                        if (this.fileObject.getName() instanceof URLFileName) {
                            URLFileName urlFileName = (URLFileName)this.fileObject.getName();
                            VFSLogFilePatternReceiver.this.setHost(urlFileName.getHostName());
                            VFSLogFilePatternReceiver.this.setPath(urlFileName.getPath());
                        }
                    } else {
                        VFSLogFilePatternReceiver.this.getLogger().info((Object)(loggableFileURL + " not available - will re-attempt to load after waiting " + 10000 + " millis"));
                    }
                }
                catch (FileSystemException fse) {
                    VFSLogFilePatternReceiver.this.getLogger().info((Object)(loggableFileURL + " not available - may be due to incorrect credentials, but will re-attempt to load after waiting " + 10000 + " millis"), (Throwable)fse);
                }
                if (this.reader != null) continue;
                VFSReader vFSReader = this;
                synchronized (vFSReader) {
                    try {
                        this.wait(10000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            }
            if (this.terminated) {
                return;
            }
            VFSLogFilePatternReceiver.this.initialize();
            VFSLogFilePatternReceiver.this.getLogger().debug((Object)(VFSLogFilePatternReceiver.this.getPath() + " exists"));
            do {
                long lastFilePointer = 0L;
                long lastFileSize = 0L;
                VFSLogFilePatternReceiver.this.createPattern();
                try {
                    do {
                        FileSystemManager fileSystemManager = VFS.getManager();
                        FileSystemOptions opts = new FileSystemOptions();
                        try {
                            SftpFileSystemConfigBuilder.getInstance().setStrictHostKeyChecking(opts, "no");
                            SftpFileSystemConfigBuilder.getInstance().setUserInfo(opts, (UserInfo)new MyUserInfo(VFSLogFilePatternReceiver.this.password));
                        }
                        catch (NoClassDefFoundError ncdfe) {
                            VFSLogFilePatternReceiver.this.getLogger().warn((Object)"JSch not on classpath!", (Throwable)ncdfe);
                        }
                        if (this.fileObject != null) {
                            this.fileObject.close();
                            this.fileObject = null;
                        }
                        this.fileObject = fileSystemManager.resolveFile(VFSLogFilePatternReceiver.this.getFileURL(), opts);
                        if (this.fileObject != null && this.fileObject.exists()) {
                            try {
                                this.fileObject.refresh();
                            }
                            catch (Error err) {
                                VFSLogFilePatternReceiver.this.getLogger().info((Object)(VFSLogFilePatternReceiver.this.getPath() + " - unable to refresh fileobject"), (Throwable)err);
                            }
                            if (lastFileSize == 0L) {
                                VFSLogFilePatternReceiver.this.getLogger().info((Object)(VFSLogFilePatternReceiver.this.getPath() + " - loading file"));
                            }
                            if (this.fileObject.getContent().getSize() < lastFileSize) {
                                this.reader = new InputStreamReader(this.fileObject.getContent().getInputStream());
                                VFSLogFilePatternReceiver.this.getLogger().debug((Object)(VFSLogFilePatternReceiver.this.getPath() + " was truncated"));
                                lastFileSize = 0L;
                                lastFilePointer = 0L;
                            } else if (this.fileObject.getContent().getSize() > lastFileSize) {
                                RandomAccessContent rac = this.fileObject.getContent().getRandomAccessContent(RandomAccessMode.READ);
                                rac.seek(lastFilePointer);
                                this.reader = new InputStreamReader(rac.getInputStream());
                                BufferedReader bufferedReader = new BufferedReader(this.reader);
                                VFSLogFilePatternReceiver.this.process(bufferedReader);
                                lastFilePointer = rac.getFilePointer();
                                lastFileSize = this.fileObject.getContent().getSize();
                                rac.close();
                            }
                            try {
                                this.fileObject.close();
                                this.fileObject = null;
                            }
                            catch (IOException e) {
                                VFSLogFilePatternReceiver.this.getLogger().debug((Object)(VFSLogFilePatternReceiver.this.getPath() + " - unable to close fileobject"), (Throwable)e);
                            }
                            try {
                                if (this.reader != null) {
                                    this.reader.close();
                                    this.reader = null;
                                }
                            }
                            catch (IOException ioe) {
                                VFSLogFilePatternReceiver.this.getLogger().debug((Object)(VFSLogFilePatternReceiver.this.getPath() + " - unable to close reader"), (Throwable)ioe);
                            }
                        } else {
                            VFSLogFilePatternReceiver.this.getLogger().info((Object)(VFSLogFilePatternReceiver.this.getPath() + " - not available - will re-attempt to load after waiting " + VFSLogFilePatternReceiver.this.getWaitMillis() + " millis"));
                        }
                        try {
                            VFSReader ioe = this;
                            synchronized (ioe) {
                                this.wait(VFSLogFilePatternReceiver.this.getWaitMillis());
                            }
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                        if (!VFSLogFilePatternReceiver.this.isTailing() || this.terminated) continue;
                        VFSLogFilePatternReceiver.this.getLogger().debug((Object)(VFSLogFilePatternReceiver.this.getPath() + " - tailing file - file size: " + lastFileSize));
                    } while (VFSLogFilePatternReceiver.this.isTailing() && !this.terminated);
                }
                catch (IOException ioe) {
                    VFSLogFilePatternReceiver.this.getLogger().info((Object)(VFSLogFilePatternReceiver.this.getPath() + " - exception processing file"), (Throwable)ioe);
                    try {
                        if (this.fileObject != null) {
                            this.fileObject.close();
                        }
                    }
                    catch (FileSystemException e) {
                        VFSLogFilePatternReceiver.this.getLogger().info((Object)(VFSLogFilePatternReceiver.this.getPath() + " - exception processing file"), (Throwable)e);
                    }
                    try {
                        VFSReader e = this;
                        synchronized (e) {
                            this.wait(VFSLogFilePatternReceiver.this.getWaitMillis());
                        }
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
            } while (VFSLogFilePatternReceiver.this.isAutoReconnect() && !this.terminated);
            VFSLogFilePatternReceiver.this.getLogger().debug((Object)(VFSLogFilePatternReceiver.this.getPath() + " - processing complete"));
        }

        public void terminate() {
            this.terminated = true;
        }
    }
}

