/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.zeroconf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.chainsaw.zeroconf.ZeroConfPlugin;
import org.apache.log4j.chainsaw.zeroconf.ZeroConfPreferenceModel;

public class ZeroConfDeviceModel
extends AbstractTableModel
implements ServiceListener {
    private List deviceList = new ArrayList();
    private ZeroConfPreferenceModel zeroConfPreferenceModel;
    private transient ZeroConfPlugin plugin;
    static /* synthetic */ Class class$java$lang$Boolean;

    public int getRowCount() {
        return this.deviceList.size();
    }

    public int getColumnCount() {
        return 4;
    }

    public ServiceInfo getServiceInfoAtRow(int row) {
        return (ServiceInfo)this.deviceList.get(row);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        ServiceInfo info = (ServiceInfo)this.deviceList.get(rowIndex);
        if (info == null) {
            return "";
        }
        switch (columnIndex) {
            case 0: {
                return this.getAutoConnectHandle(info);
            }
            case 1: {
                return info.getAddress().getHostName() + ":" + info.getPort();
            }
            case 2: {
                return this.zeroConfPreferenceModel.getAutoConnectDevices().contains(this.getAutoConnectHandle(info)) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.plugin.isConnectedTo(info) ? "\u63a5\u7d9a" : "\u5207\u65ad";
            }
        }
        return "";
    }

    private String getAutoConnectHandle(ServiceInfo info) {
        return info.getName();
    }

    public void serviceAdded(ServiceEvent event) {
    }

    public void serviceRemoved(ServiceEvent event) {
        Iterator iter = this.deviceList.iterator();
        while (iter.hasNext()) {
            ServiceInfo info = (ServiceInfo)iter.next();
            if (!info.getName().equals(event.getName())) continue;
            iter.remove();
        }
        this.fireTableDataChanged();
    }

    public void serviceResolved(ServiceEvent event) {
        this.deviceList.add(event.getInfo());
        this.fireTableDataChanged();
    }

    public void setZeroConfPreferenceModel(ZeroConfPreferenceModel zeroConfPreferenceModel) {
        this.zeroConfPreferenceModel = zeroConfPreferenceModel;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "ZeroConf\u540d";
            }
            case 1: {
                return "\u30a2\u30c9\u30ec\u30b9:\u30dd\u30fc\u30c8";
            }
            case 2: {
                return "\u81ea\u52d5\u63a5\u7d9a";
            }
            case 3: {
                return "\u63a5\u7d9a\u72b6\u6cc1";
            }
        }
        return "";
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 2;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return class$java$lang$Boolean == null ? (class$java$lang$Boolean = ZeroConfDeviceModel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        }
        return super.getColumnClass(columnIndex);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 2 || !(aValue instanceof Boolean)) {
            return;
        }
        boolean autoConnect = (Boolean)aValue;
        Object device = this.deviceList.get(rowIndex);
        String autoConnectHandle = this.getAutoConnectHandle((ServiceInfo)device);
        if (autoConnect) {
            this.zeroConfPreferenceModel.getAutoConnectDevices().add(autoConnectHandle);
        } else {
            this.zeroConfPreferenceModel.getAutoConnectDevices().remove(autoConnectHandle);
        }
        this.fireTableDataChanged();
    }

    void setZeroConfPluginParent(ZeroConfPlugin parent) {
        this.plugin = parent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

